# Welcome to audiolibrarian

`audiolibrarian` is a command-line tool for ripping audio from CDs (or taking
high-quality audio from local files), tagging them with comprehensive metadata from [MusicBrainz][],
converting them to multiple formats, and organizing them in a clean directory structure.

## Features

- 📀 **CD Ripping**: Extract audio from CDs with accurate metadata lookup.
- 🔄 **Audio Conversion**: Output multiple audio formats (FLAC, M4A, MP3).
- 📋 **Metadata Management**: Automatically fetch and apply rich metadata from [MusicBrainz][].
- 📁 **File Organization**: Intelligently organize music files into a clean directory structure.
- ⚙️ **Batch Processing**: Handle multiple files and directories efficiently.
- 🎵 **Genre Management**: Work with [MusicBrainz][] genres and tags.
- 🔧 **Flexible Configuration**: Customize behavior through config files and environment variables.

## Why audiolibrarian?

- **Consistent Quality**: Maintains audio quality through the conversion process.
- **Accurate Metadata**: Leverages [MusicBrainz][] for comprehensive music information.
- **Automated Workflow**: Reduces manual work in organizing and tagging music.
- **Open Source**: Free to use and modify under the GPL-3.0 license.

## Quick Start

1. [Install audiolibrarian](user-guide/installation.md).
2. [Get started](user-guide/getting-started.md) with basic commands.
3. Explore the [API Reference](api/audiolibrarian.md) for advanced usage.

## Get Involved

- Found a bug? [Open an issue](https://github.com/toadstule/audiolibrarian/issues).
- Want to contribute? Read our [contributing guide](development/contributing.md).

[MusicBrainz]: https://musicbrainz.org
