# Dokumentenhistorie
| Datum      | Bearbeiter     | Änderung                                                                     |
| :--------- | :------------- | :--------------------------------------------------------------------------- |
| 12.04.2022 | Oguzhan Akyol  | Initiales Dokument. Installation und Verwendung des Robot Code Generators    |
| 05.05.2022 | Henrik Schütte | Beschreibung der Konfigurationsdatei                                         |
| 10.05.2022 | Henrik Schütte | Beschreibung der Option zum Speichern der Ergebnisse in Form einer ZIP Datei |

# Installation des Robot Code Generators

Voraussetzung für die Installation der Software ist eine vorhandene Python Installation. Die minimal benötigte Version ist Python 3.7. Zum Überprüfen, ob die korrekte Python Version installiert ist, kann der folgende Kommandozeilen Befehl verwendet werden:

```powershell
python --version
```

Die Installation des Code Generators erfolgt mithilfe eines Python Wheels, welches in der Lieferung enthalten ist.
Dieses kann durch Ausführung des folgenden Kommandozeilenbefehls installiert werden, wobei ``testbench2robotframework-0.1.3-py3-none-any.whl`` für den Pfad zu der heruntergeladenen whl-Datei steht:

```powershell
python -m pip install testbench2robotframework-0.1.3-py3-none-any.whl
```

Alternativ kann die Installation direkt online aus dem Python Package Index installiert werden.
```powershell
pip install testbench2robotframework
```

Wenn die Installation durchgeführt wurde, liefert folgender Befehl die aktuell installierte Version:

```powershell
tb2robot --version
```

# Verwendung des Robot Code Generators
Nach erfolgreicher Installation des Robot Code Generators kann dieser durch den Befehl ``tb2robot`` oder ``testbench2robotframework`` ausgeführt werden.

Der Befehl ``tb2robot --help
`` zeigt, wie aus einem TestBench JSON Report, Robot Framework Testsuites generiert werden können.

Zum Generieren von Robot Framework Testsuites benötigt die Anwendung zwei Parameter:

(@) Den Pfad zu einer JSON Datei, die als Konfigurationsdatei für die Ausgabe des Generators dient. Wird diese beim Aufruf des Code Generators nicht übergeben, so wird automatisch eine Konfigurationsdatei mit dem Namen ``config.json`` generiert.

(@) Den Pfad zu den TestBech JSON Report Dateien. Diese können in einem Verzeichnis oder in einer ZIP Datei liegen.

Der folgende Aufruf demonstriert die Verwendung anhand eines Beispiels:
```powershell
tb2robot -c .\Konfigurationsdatei.json E:\TestBench\report.zip
```
Das folgende Beispiel zeigt, wie auf diese Weise der Testthemenbaum der TestBench in Robot Framework Testsuites konvertiert wird.

![](data:image/png;base64,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)
![](data:image/png;base64,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)
\begin{figure}[!h]
\caption{Beispiel für die Generierung von Robot Framework Testsuites aus dem Testthemenbaum der TestBench. Für jedes Testthema wird ein Verzeichnis erstellt. Dieses Verzeichnis enthält eine \_\_init\_\_.robot Datei mit Informationen über das Testthema. Außerdem wird für jeden Testfallsatz eine Robot Framework Testsuite erzeugt, die die eigentlichen Testfälle enthält.}
\end{figure}

# Konfiguration der Ergebnisse
Zur Konfiguration des Ergebnisses sollte beim Aufruf des Robot Code Generators der Pfad zu einer JSON Konfigurationsdatei übergeben werden. Auf diese Weise kann beispielsweise der Pfad angegeben werden, in welchem die *.robot Dateien erzeugt werden. Die Konfigurationsdatei kann die folgenden Einstellungen enthalten:

## rfLibraryRoots
Eine Liste der verschiedenen TestBench Subdivisionen, die Robotframework Bibliotheken enthalten. Bibliotheken, die nicht in einer der Root Subdivision enthalten sind, werden als ``Unknown`` Import in der Robotdatei markiert. Eine Ausnahme zu dieser Regel stellen die ``forcedImports`` dar, welche immer importiert werden.

Im folgenden Beispiel ist lediglich die ``RobotLibraries`` Subdivision als ``rfLibraryRoot`` vorgegeben.

```json
"rfLibraryRoots": ["RobotLibraries"]
```

![Robot Framework Bibliotheken werden in der TestBench als Subdivisionen dargestellt](data:image/png;base64,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)

Dies führt dazu, dass nur die in dieser Subdivision enthaltenden Bibliotheken ``BuiltIn`` und ``OperatingSystem`` importiert werden. Die ``Process`` Bibliothek ist hingegen in einer Subdivision definiert, die nicht als ``rfLibraryRoot`` angegeben ist. Aus diesem Grund wird sie nicht importiert:

```python
*** Settings ***
Library    BuiltIn
Library    OperatingSystem
# UNKNOWN    Process
```

## rfResourceRoots
Analog zu den Bibliotheken müssen auch die Root Subdivision der Robot Framework Ressourcen Dateien in der Konfigurationsdatei angegeben werden.

Das folgende Beispiel zeigt, den Import von Subdivisionen, die nicht als ``rfResourceRoots`` angegeben sind:

```json
"rfResourceRoots": ["RF-Resources"]
```

![Robot Framework Ressourcen Dateien werden in der TestBench als Subdivisionen dargestellt](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAOUAAAC+CAYAAADKgMgiAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAABWOSURBVHhe7Z0JsBXVmce7nJlMTVWqUpVJzYzJRJ0Z1CwmQoBknjpSUWM0qUSD7I8tLhdUUCLK6mMRETRyBTdA4AVZfSIIAk/Z902DIOQ5bE+2ByomzDiacmqi9U1/p7fT53b363t5t+9p+v+r+sd79tOvvv89fS+3vxif/PkzgiBIHxn//cmfCYIgfWT86eNPCIIgfWScOfsxQRCkj4z3//hfFKXTH71FY9sbZBgBaj+etn10NnBcHG2rG0/Vjy4KbJN1uq6PWK+6rvS1WlJx9w1BpchoOvMniquTCy1z9Fj4x8D2YnTywzrqwcbuXRfYLqsl1z1XFbNvCCpFxvH3P6K4Oja/tzBH9/ln/PXbxlH3dvbp2a431Wzz2jeO7U1tuV6ovRh77PQuqnH6izHjaONpsz5kHnXd5vq1re7ttretHkcvunsw1x+7y91b6DxmPff35rHGneu+ISiOjKOnzlBcvTfXCrJucz/06rbaATxmJ73XtJNmV3Nw9qbZTR96bdULRV9fW9NC6sZBbLdFziOtG6cfm2W9WV4/pr1VNtfgcuDeIvZtzbOTHhaGO7d9O38vCGpOxpGTH1BcHZ7TUwRZ1znvu3VrR7Uz69rRiM1Wndzn8Oax1IYD2Gxv02M+rbX7iH4n5lNXbjPrm51Heh2nX5tR2wva1DXi7NuZZ1YPvoaeNOuE2VbEvrkMQcXKOHjsNMXVgdnVIuC6zD7l1q2u4aDkoPWrdc1W0T5DaW/dfQytPnqKDhydR124rvu8ZueR143Tz1lb3a81th0N39DMPBvGUGv7tbiG7txWTTOK3De3Q1CxMt59r4niqqG2hwi4zrUn3br6kW3NurY0dJ1Xp6qhcQvV146mzm2sgOXxDY1zqDMHcLc5ok/UPPK6cfq1HrmlYByX5bGR86wbbZnSnmdaN953D5rWWNy+IagUGfuPnKC42jeruwjyTrOOe3VrR9GVZt2VIzaJ8ooRVpA+tPa4299r88bvOzyHOnFwd50Tex4xroj11P36+kbNo7RN7cqm7E5TD5ttJe6b2yAojoy9h45RXO2ZYQVZxxlHC+o5MLmNA1JuX6a2Dd/gtQ3nAOb67vTswaOh86jrNtfvSnsNdZy1XlsavLqZeVbXiHpnnme7cLu1R28er665/ThlCIojY/d/vkcQBOkj482GIwRBkD4yduw/RBAE6SNj694DBEGQPjI2vf0uQRCkj4z1v/8DQRCkj4w1u/YRBEH6yNi4cSNBEKSPjA8++JAgCNJHMCUEaSaYEoI0E0wJQZoJpoQgzQRTQpBmgikhSDPBlBCkmWBKCNJMMCUEaSaYEoI0E0wJQZqpKFMG/XgWgqD4CvKVqqJNCQAoDZgSAM2AKQHQDJgSAM2oqClnzF5E02a9RM9Mn0dPPj2LRj6SpycmT7dbAcgmFTXl9NqX6fTp96mx8Sj9fvfbNHj4o7T3nf30+eef2z0AyB4VNeXUmQup6dRp2v+HBnpw5AR6fnotHTlyxG4FIJtU1JTPTJtHJ5ua6B3zdBwweDTt3r2bPv30U7sVgGxSUVM+9dyLdPzESdqzZy/dfX8NNTQ02C2lUE85o4ryh+yi4BDlq9Q6k0N5qjJy5ohzQJ7jnOYL2neJxNlHVJ+W+LuAc6aipnzy6Vo6dvyE+XlyD+UGDKcDBw7YLSVQn6NcLkdVvuhOgSkD911GYErtqagpn5g8g44eO05vvbWb7rx32DmY0jGfeepU5c2Sg2xKfm2Q8e93Wf+350I5WqkGYkFg8knm9Q/sF3dMASH75vnMcj7nzGFQTp7ENLJTH7ongbwP++9g98kVzB13z6DcVNSUE5+aQa+v3UYTnqql2+8eUrop7SDmmKs3g80LYM+UXO+eRnLwqoGslOVxh/JVZDiTR8wROkaFxwXtW8wn7ZdN6JqWzeOtFbonce3SnPYcB6PmVq4DVIaKmvKxSS9Q/Zqt9Fh+FvW668GSTcmB6QsyL7qFKavM4HTbGTn41ED0ldkAzknLSIYInSNijELovovak0ToniSi5g4bAxKlYqZ8e++7wpTLV22mMROnUp9+D9GTJf1wwL4tdW+95Nsvq60qny+8PQwLRF+ZDaDO7b8NLJwjYoyPiH1H7slElJ0x0tzqnuRrdoiaW20DFaEipjzRdJqemFJLS5avownmKfnw+OfogZG/pS69BtAba+Kdsi4BwefdClonJQet71SKCkRfOfyUC58jYowMjwnbd+SeFMJuP8PGRM0dtQ5IjMRN+fH/fEpPT51LLy1+nR6f8jsaPWEqDR39FN0/bCLdObCGOvboR4ePHLV7Nw+bzb1bdXBvBT1T+l77gs9/Oyg+o0mBKX8+jGuA0DESkftWzSGX1fnC9iSuV/2c2swXW2obqAiJmvL//vIX8XvXuXXLhSHHPj6Nho2ZTIOGP053PzBOmLJz74HUrc8A+uyz/7VHRcGBFxREltEmHZRNaeIEph2wjvksI1q3g+JW1xeY8u1o4VzBwRwyxqWZfa9W5lPmZ9M7+/V9UxpnH2ofX9n/dwGVIVFT1r1STzPnLqHH8jPNE/J594Ts/5tH6I4BNdS73zCqvvNBuulXfeme34y0RwGQLRI15ZBRv6Xxk2bSyHHP0EM1k+i+oROEIW+/92HTkEOpxx2DqUufQXRbz4F0zQ0d6ezZs/ZIALJDoqbsf38N9eh7P3XudS917NaPftH5Drr51j504y960vU/60Y//mkXuvbG2+jq6zvSVT++lQ4fPmyPBCA7JGpK5syZM+LfI+OI+wKQNRI3JQAgGpgSAM2AKQHQDJgSAM2AKQHQDJgSAM2AKQHQjNSY8s1T62jEqp50x5JrqdfiKur68g/oVwsvp5vmXELXzf4aXTXr76jN8wZ97wmDvvuIQTfM/Qda9u6L9mgA0kNqTDloxS30+I6BNPHNe+jRnTkataMXjdzSlR7Y9HPqv/46un31D6n6je9Tp5WX0i+XfZNufuWf6LIhf2WPBiA9pMaUdy3rQI/vGkiD1/+SBq69kfq/cQ31WtmGblt2Kf3sla9Th5e+TO3nGNTmWfO0nGj+90mDLrrdoKamJnsGANJBYqacMnkyDR0ypEDTp02ze0Tz6yXX0Phd/ei+tTfRku1LadP2/bR+y166ZfG/0A11f0+vrdpJS+q30xNL8/TdRw1qbRrzkr4GHTx40J4hBPHokvN4k6z4jy95D1UXgfzIVMEjVxJKW0lrNUfU+iBxEjMl53QNMmVjY6PdI5qei9rTuB2/pn6rOtDmbftow7Z3aPWmt+mmRf9IHRZ8mV59fQe9smIr1b26ia4YZdCVpjG/2dsQv6GNJCQgxTOWAQ8nB1FWUyqUxZRAKxIzJaOelnFPSaZL3fdo1LZq6lv/Q9qw9R1as3EPvb5hN11X9xW6av7f0OLlW6hu2SZasGQ9fWuEeQs7xqB/7lm6KQvr5QeG/f2FUXI595T1myZonL+uIBuAjNIWuhb3q8pRTn5IWYx11gnvW7h++LWaG3DnK2gDLUKiplRPy7inJHPLglY0dHNH6vbaFdRxaSv6+eJv0PUvfZWuXvAlajvTPBknG+K2lQ35rWEGfcc8LS/q0XInJZshLMUHtwWn5IgYJ/cL2YMgYL7wOeQ3BDZWVKYExaTKGs6exd/B7chzev38baClSNSUjHNaFnNKMj+deyEN2nAz3br0Erp50YX0E/OE7DD/b6ldrWXIKx4z6NsPG3T5EIMue8A0qGnOb3SLa0rnnV+SZDo1GNWA5yCWY9MrR4wrMIncTyLAMIFrRc0hkPai9vWV/dfmG1fQBspB4qZ0TstiTknm2t99hfqt+w/6yctfoxVrdtIy8zPkEvMzZOunrW9bX1y0imrr6mnGguXU6j7LnF/vUsJJKW7PlMArCHh/7p/6nL9/uFGkcXJbQT8JpS3+Whbc7r3ZhKznK7Px5DEsaU3RN6AetBiJm5JZuWKF/So+P3rhS9R3dTu62jwdl76xXRjy5dc2C0PyraplyGU0fd6r1GqAeWo+aJqyU2m3r1YiLblOPi0Y/4nhP72s5FNWOWKcvG7AHlyUttC1CuawzOX2jVrPV1b3HIFyGw9ahoqYshT43x+7118hblcnLZsiDLnw1Q3CkPwZcubC14Qhh9QOo3+7x7qFvbBjqZ8p7axuXvQLM0R+pnT6KvOFjosyiUzAfIFrqXMElgPeEBilHLpn1YQwZVlIjSn553OdVrQSnx+//6T1pc53xlhf7FxmnoqXDjLECcmG/Nf+Vrl0U5qIeik4zR5h30hyEHvfiKq3dGHjbOObdda3n04fSWy+AMMErhVwHdaJb89lf9sq/Kz2LRgr79l/PeJNwW3zrwdahtSYsv0Lfy1+PtfOPDF/kLd+48r/FsnG5C94+LTkW1Y+IR2DXtznguZ/PACAZqTGlHX7nqPLh19AF5vv1Bffaf2Ejn8cwP8Wyd+y8pc6/BmST0fWRb0uoJqFd9OJEyfsGQBIB6kxJfPFF1/QyZMnxenHt6VR4j5sSB4DQJpIlSkByAIwJQCaAVMCoBkwJQCaAVMCoBkwJQCaAVMCoBkwJQCakRlTIkUlSAuZMSVSVIK0kBlTIkUlSAuZMWXSKSqlRzHDkR+ZivMaZILMmDLRFJWiTn2ushlgSmCTGVMmm6IyJBcP04z5Vpol+aFoX/pHfl2Vp7z0oHGsExmkisyYMtEUlbZ5xEGptqsmK/p1eFoScH6QGVNWLEWlbCom0nBFvGbUMjgvyIwpE0tRKYjIMhdmsmJfM2oZnBdkxpRJpqhkRIIrrowy0rm8ZtQyOC/IjCmTTVHJX9Y4377Kr7m7lFM2jvnCXjNqGZwXZMaU5U1RWfiZUv5WVE71WJXPmyZtznBq+smgPiZqGZwXZMaUSFEJ0kJmTIkUlSAtZMaUDFJUgjSQKVMCkAZgSgA0A6YEQDNgSgA0A6YEQDNgSgA0A6YEQDNgSgA0IzOmRIpJkBYyY0qkmARpITOmRIpJkBYyY8qypZi0kR/PUh/dSoSoR7xKRk7iZT1KVvKceMwsNpkxZdlSTJoIQ/oSWFnB7Ca4SoIWD3rrGgqeCy01URdMGZvMmLJsKSZF8AYEmy8IrT559zRVc8LKJ5I0F89RlaOc/cCzqBfzOn0d0/jHF5eWUhor1gpJjSngvla7m+6EsdcQl8QZ9pz53PFB1xdyzeIBb3ONvDePeHOT5k30za4CZMaUZUsxGZrmUUqe5QSgL3C9QOQAdwJNnEZOtNsG9EzkmUKgmi/0tRTIyn7lta19OfPb2Q8Cr83E7CuPs17z/rzrKryWGNfsrKv8DcLmOR/JjCnLlmKSA9lzjQ/vNLFM6XWzTwMRk4rRRDnAXIGE9A17zfjKfhOZjdK+bIRRrRPKf8KbY23D1ufCrkWiYN2Qay7Yg1qOWOM8ITOmLFuKyVBTWu/4nin9gaQa1gt8KfhVQ9nwWK+v3R5mRHUOtc13EgaYUkaMddqdvub+5TlEH+U63HpnHxHXXLAHmDJMqTdl2VJMiiCRgt6hIAjDAi1kPOObg7GC2X0PkNvjvGZ8ZXVtaV8hbzbemwlPVUW5nHQbq8JzOIaNXFcGpsyMKcuWYtJEfCbyBZllHi9YrbIb5HKwimLIZ75IQ5mIsh2gclvYa0YpF6ztBry1Z78vFUPI6zPKdUVdS+g1m/8LU2bElGVLMekgAtq7HQsK5pz52ct/q+Zgm1ZtUw1lYr0B2H3tb2attTh4ub7YtJTS2rl8gAHsNiF137ymf3+Bt9YCb39WXcg1w5TZMWVlU0ymJJAC3gQi4f7+dx/QAmTGlJVNMamrKZ3TK+jEisY6sc/vE6tSZMaUDFJMgjSQKVMCkAZgSgA0A6YEQDNgSgA0A6YEQDNgSgA0A6YEQDNgSgA0IzWmRIpIkBVSY0qkiARZITWmRIpIkBUSM+WUyZNp6JAhBZo+bZrdI5qypYgMezIi9hMT6qNFFSZq30qb/MByixH77wbCSMyUDQ0NgaZsbGy0e0RTthSRWTKlQllMCc6ZxEzJqKdl3FOSKVuKyDim5NdVYWkaZVPaj0KZfQ9GjmHkh3yd9a3xbj+xB8nw9hP6kXPL+1ZR2oQpc97D2b45YqW2tOulvr4HrAVB12njezA8ZM8ZJFFTqqdl3FOSKVuKyIIgspHr7YBsLn2FL8VF5Bilr9TGzyk69U6WAccAblvU3GHXwyhtvIfAcfb8rvHMWt/zoFF9A9bwXY/bkef0+vnbsk2ipmSc07KYU5IpW4pIJYhcCgJP6uMrW6asMk8K1yRM5Bh/QPqCnvvZRhGpGzkpsQhW6USOmlttk1HaxEkpdXTLUXMIpP1H7UX0k8wsjytoAw6Jm9I5LYs5JZmypYgMC0C5PjLwrFvOqnw+INViyBi1TTacWWsFrv1ft68U0EXNLaG0eflaLZozpThZzVPRd7sZtRfzf/05fljSmqJvQH3GSdyUzMoVK+xX8SlvisiAgOCACbsl9JU9Q8m3ntFjJIMJ/HsQ5jBNbuW/sed3T0yuiphbbZNR2vwnpfXmEmxKy1xu36j1fGX1OiNQbu+zTEVMWQrlTBEpTgAvOk2c0y+OweRTTnodOcZaM/AzIcNl0wS+z2JhpmDkstomE7CHQKNHzc+I8jleZ9A1w5SC1Jiy3CkiRYC6t1JSIDGRgSebkotWW8G3kGrZfBX6raToK80pTBoxl1wWr/3XIsTmU8bxNXvfvhZegzu/ifPGICSntozai0C+TmkNE//f3L9elkmNKSubIhKA5EiNKSubIhKA5EiNKRmkiARZIFWmBCALwJQAaAZMCYBmwJQAaAZMCYBmwJQAaAZMCYBmwJQAaEZmTIkUlSAtZMaUSFEJ0kJmTIkUlSAtZMaU5U1RKT+CZMn36BcARZAZUyabotKfSQCAYsiMKZNNUamk1lDTNQrTOqdqkKGdNtnYEWPsTAVFtwEtyYwpE01RKepsQ4nXUioPk9AUGbKZGalNHhM/VWNUG9CVzJiyvCkqnZPIkxv7Bab1G8UqywZWDC6Q+gjkOdQ2mag2oCuZMWXiKSod1PaC/kqyrcDkUWwu1fiS2cScAfVMVBvQksyYsmwpKgtMplDQLp9yjHSahc6ljonAdzusENUGtCEzpixbisqiTcneiPmZUhobOkY1Wtw2oC2ZMWXZUlSWYErTHdLtaFSbfLsZVs9ec+pZhW8AYW1ATzJjSqSoBGkhM6ZEikqQFjJjSgYpKkEayJQpAUgDMCUAmgFTAqAZMCUAmgFTAqAZMCUAmgFTAqAZZTMlBEGlK8hXqooyJQRB5RdMCUGaCaaEIM0EU0KQZoIpIUgzwZQQpJlgSgjSTDAlBGkmmBKCNBNMCUGaCaaEIM0EU0KQZjKCfjQLQVCltJH+HwFivPZnphcOAAAAAElFTkSuQmCC)

Da ``UnknownResources`` nicht in den ``rfResourceRoots`` enthalten ist, wird die in dieser Subdivision enthaltende Ressourcedatei ``unknownKeywords`` nicht importiert.

```python
*** Settings ***
Resource    keywords.resource
# UNKNOWN    unknownKeywords
```

## fullyQualified
Boolesche Variable, die angibt, ob die Keywords in den generierten Robot Dateien lediglich durch den Keywordnamen aufgerufen werden oder, ob zusätzlich der Bibliotheksname vorangestellt werden soll.

Die Konfiguration ``"fullyQualified": true`` führt beispielsweise zu dem folgenden Keyword Aufruf:

```python
SeleniumLibrary.Open Browser      https://robotframework.org/    firefox
```
Wird hingegen ``"fullyQualified": false`` verwendet, so wird das Keyword ohne den zugehörigen Bibliotheksnamen aufgerufen:

```python
Open Browser      https://robotframework.org/    firefox
```

## resourceDirectory
Damit der Robot Code Generator die korrekten Ressourcen in der Setting Section der Testsuites einbindet, muss in der Konfigurationsdatei der Pfad zu einem Verzeichnis angegeben werden, das sämtliche für das Projekt benötigten Ressourcen Dateien enthält. Dieser Pfad kann absolut oder relativ zu dem Verzeichnis, in dem der Robot Code Generator ausgeführt wurde, angegeben werden.
Im Falle eines relativen Pfades muss ein ``{root}`` vorangestellt werden.

```json
"resourceDirectory": "{root}/Resources",
```

```robotframework
*** Settings ***
Resource    ../Resources/myKeywords.resource
```

## generationDirectory
Der Pfad zu dem Verzeichnis mit den generierten Robot Framework Testsuites kann über den Parameter ``generationDirectory`` vorgegeben werden. Wie bereits beim ``resourceDirectory`` kann auch dieser Pfad relativ oder absolut angegeben werden:
```json
"generationDirectory": "{root}/generatedRobotFiles"
```

## createOutputZip
Für den Fall, dass die Ausgabe des Robot Code Generators auch in Form einer ZIP Datei erfolgen soll, muss die Variable createOutputZip auf true gesetzt werden. Dies hat zur Folge, dass sowohl ein Verzeichnis als auch eine ZIP Datei mit den generierten Robotframework Testsuites erstellt wird.

## logSuiteNumbering
Über die Boolesche Variable ``logSuiteNumbering`` kann angegeben werden, ob der Präfix eines Verzeichnisses in den Logs angezeigt werden soll. Der Präfix eines Verzeichnisses/einer Robot Framework Testsuite bestimmt die Reihenfolge, in der die Test Suites ausgeführt werden.

```json
"logSuiteNumbering": true
```
## clearGenerationDirectory
Wird  die Variable ``clearGenerationDirectory`` auf ``true`` gesetzt, so werden bei jeder Ausführung des Robot Code Generators die Dateien der vorherigen Läufe gelöscht.

```json
"clearGenerationDirectory": true,
```

## logCompoundInteractions
Bei der Konvertierung der TestBench Testfallsätze nach Robotframework werden lediglich die atomaren Interaktionen in Robotframework aufgerufen. Damit ein Benutzer die gesamte Hierarchie eines Testfallsatzes in Robotframework sehen kann, muss der Wert der Variablen ``logCompoundInteractions`` ``true`` sein. Dies hat zur Folge, dass auch die zusammengesetzten Interaktionen als Kommentare in den Testsuites erscheinen. Durch eine entsprechende Einrückung kann ein Benutzer erkennen, in welcher zusammengesetzten Interaktion eine atomare Interaktion aufgerufen wird.

```json
"logCompoundInteractions": true,
```

## subdivisionsMapping
Im ``subdivisionsMapping`` kann definiert werden, welche TestBench Subdivision welchem Import Statement in Robotframework entspricht. Auf diese Weise können auch Bibliotheken mit bestimmten Parametern und "Remote Libraries" eingebunden werden. Bibliotheken und Ressourcen, die an dieser Stelle definiert werden, werden nur importiert, wenn auch ein Keyword der entsprechenden Bibliothek/Ressource verwendet wird.

```json
"subdivisionsMapping": {
    "libraries": {
      "SeleniumLibrary": "SeleniumLibrary    timeout=10    implicit_wait=1    run_on_failure=Capture Page Screenshot",
      "SuperRemoteLibrary": "Remote    http://127.0.0.1:8270       WITH NAME    SuperRemoteLibrary"
    },
    "resources": {
      "MyKeywords": "{root}/../MyKeywords.resource",
      "MyOtherKeywords": "{resourceDirectory}/subdir/MyOtherKeywords.resource"
    }
  }
```


## forcedImport
Damit eine Bibliotheks-, Ressourcen- oder eine Variablendatei importiert wird, ohne dass es eine entsprechende Subdivision in der TestBench gibt, muss diese als ``forcedImport`` hinterlegt sein. Dateien, die auf diese Weise importiert werden, werden in jeder Testsuite importiert, unabhängig davon, ob ein Keyword aus dieser Datei verwendet wird.

```json
"forcedImport": {
    "libraries": [
      "SeleniumLibrary"
    ],
    "resources":
    [
      "technical_keywords.resource"
    ],
    "variables": [
      "myVars.py"
    ]
  }
```

## loggingConfiguration
Über die Einstellung ``loggingConfiguration`` kann das Log-Level gesetzt werden.
Gültige Optionen sind:

* "CRITICAL"

* "FATAL"

* "ERROR"

* "WARNING"

* "WARN"

* "INFO"

* "DEBUG"

* "NOTSET"

Das Default Log-Level ist ``INFO``.
```json
"loggingConfiguration": {
  "console": {
    "logLevel": "info"
  }
}
```

### testCaseSplitPathRegEx
Über den im Parameter ``testCaseSplitPathRegEx`` angegebenen Wert kann ein Benutzer bestimmen, ob ein Testfallsatz aus der TestBench in mehrere Robot Framework Testfälle unterteilt werden soll. Zu diesem Zweck muss der Benutzer in ``testCaseSplitPathRegEx`` den Namen einer Interaktion definieren, anhand welcher der Code Generator erkennt, dass ein Testfall an dieser Stelle unterteilt werden soll. Anschließend kann diese ``Splitting interaction`` in einem Testfallsatz zum Unterteilen von Testfällen verwendet werden.

# Dokumentenhistorie
| Version | Datum      | Feature / Bug Beschreibung                                                                  |
| :------ | :--------- | :------------------------------------------------------------------------------------------ |
| 0.1.2   | 08.04.2022 | Initiale Version des Robot Code Generator (testbench2robotframework-0.1.2-py3-none-any.whl) |
| 0.1.3   | 10.05.2022 | Generierte Robotframework Testsuites können in Form einer ZIP Datei gespeichert werden      |
