"""
Class object for AIOGitHubAPIReposCommit
Documentation: https://docs.github.com/en/rest/reference/repos#get-a-commit

Generated by generate/generate.py - 2020-08-02 15:48:55.441838
"""
from aiogithubapi.objects.base import AIOGitHubAPIBase


class CommitAuthor(AIOGitHubAPIBase):
    @property
    def name(self):
        return self.attributes.get("name", "")

    @property
    def email(self):
        return self.attributes.get("email", "")

    @property
    def date(self):
        return self.attributes.get("date", "")


class CommitCommitter(AIOGitHubAPIBase):
    @property
    def name(self):
        return self.attributes.get("name", "")

    @property
    def email(self):
        return self.attributes.get("email", "")

    @property
    def date(self):
        return self.attributes.get("date", "")


class CommitTree(AIOGitHubAPIBase):
    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def sha(self):
        return self.attributes.get("sha", "")


class CommitVerification(AIOGitHubAPIBase):
    @property
    def verified(self):
        return self.attributes.get("verified", False)

    @property
    def reason(self):
        return self.attributes.get("reason", "")

    @property
    def signature(self):
        return self.attributes.get("signature", None)

    @property
    def payload(self):
        return self.attributes.get("payload", None)


class Commit(AIOGitHubAPIBase):
    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def author(self):
        return CommitAuthor(self.attributes.get("author", {}))

    @property
    def committer(self):
        return CommitCommitter(self.attributes.get("committer", {}))

    @property
    def message(self):
        return self.attributes.get("message", "")

    @property
    def tree(self):
        return CommitTree(self.attributes.get("tree", {}))

    @property
    def comment_count(self):
        return self.attributes.get("comment_count", None)

    @property
    def verification(self):
        return CommitVerification(self.attributes.get("verification", {}))


class Author(AIOGitHubAPIBase):
    @property
    def login(self):
        return self.attributes.get("login", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def avatar_url(self):
        return self.attributes.get("avatar_url", "")

    @property
    def gravatar_id(self):
        return self.attributes.get("gravatar_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def followers_url(self):
        return self.attributes.get("followers_url", "")

    @property
    def following_url(self):
        return self.attributes.get("following_url", "")

    @property
    def gists_url(self):
        return self.attributes.get("gists_url", "")

    @property
    def starred_url(self):
        return self.attributes.get("starred_url", "")

    @property
    def subscriptions_url(self):
        return self.attributes.get("subscriptions_url", "")

    @property
    def organizations_url(self):
        return self.attributes.get("organizations_url", "")

    @property
    def repos_url(self):
        return self.attributes.get("repos_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def received_events_url(self):
        return self.attributes.get("received_events_url", "")

    @property
    def type(self):
        return self.attributes.get("type", "")

    @property
    def site_admin(self):
        return self.attributes.get("site_admin", False)


class Committer(AIOGitHubAPIBase):
    @property
    def login(self):
        return self.attributes.get("login", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def avatar_url(self):
        return self.attributes.get("avatar_url", "")

    @property
    def gravatar_id(self):
        return self.attributes.get("gravatar_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def followers_url(self):
        return self.attributes.get("followers_url", "")

    @property
    def following_url(self):
        return self.attributes.get("following_url", "")

    @property
    def gists_url(self):
        return self.attributes.get("gists_url", "")

    @property
    def starred_url(self):
        return self.attributes.get("starred_url", "")

    @property
    def subscriptions_url(self):
        return self.attributes.get("subscriptions_url", "")

    @property
    def organizations_url(self):
        return self.attributes.get("organizations_url", "")

    @property
    def repos_url(self):
        return self.attributes.get("repos_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def received_events_url(self):
        return self.attributes.get("received_events_url", "")

    @property
    def type(self):
        return self.attributes.get("type", "")

    @property
    def site_admin(self):
        return self.attributes.get("site_admin", False)


class Parents(AIOGitHubAPIBase):
    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def sha(self):
        return self.attributes.get("sha", "")


class Stats(AIOGitHubAPIBase):
    @property
    def additions(self):
        return self.attributes.get("additions", None)

    @property
    def deletions(self):
        return self.attributes.get("deletions", None)

    @property
    def total(self):
        return self.attributes.get("total", None)


class Files(AIOGitHubAPIBase):
    @property
    def filename(self):
        return self.attributes.get("filename", "")

    @property
    def additions(self):
        return self.attributes.get("additions", None)

    @property
    def deletions(self):
        return self.attributes.get("deletions", None)

    @property
    def changes(self):
        return self.attributes.get("changes", None)

    @property
    def status(self):
        return self.attributes.get("status", "")

    @property
    def raw_url(self):
        return self.attributes.get("raw_url", "")

    @property
    def blob_url(self):
        return self.attributes.get("blob_url", "")

    @property
    def patch(self):
        return self.attributes.get("patch", "")


class AIOGitHubAPIReposCommit(AIOGitHubAPIBase):
    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def sha(self):
        return self.attributes.get("sha", "")

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def comments_url(self):
        return self.attributes.get("comments_url", "")

    @property
    def commit(self):
        return Commit(self.attributes.get("commit", {}))

    @property
    def author(self):
        return Author(self.attributes.get("author", {}))

    @property
    def committer(self):
        return Committer(self.attributes.get("committer", {}))

    @property
    def parents(self):
        return [Parents(x) for x in self.attributes.get("parents", [])]

    @property
    def stats(self):
        return Stats(self.attributes.get("stats", {}))

    @property
    def files(self):
        return [Files(x) for x in self.attributes.get("files", [])]
