"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogGroupResourcePolicy = void 0;
const iam = require("@aws-cdk/aws-iam");
const cr = require("@aws-cdk/custom-resources");
/**
 * Creates LogGroup resource policies.
 */
class LogGroupResourcePolicy extends cr.AwsCustomResource {
    constructor(scope, id, props) {
        const policyDocument = new iam.PolicyDocument({
            statements: props.policyStatements,
        });
        super(scope, id, {
            resourceType: 'Custom::CloudwatchLogResourcePolicy',
            onUpdate: {
                service: 'CloudWatchLogs',
                action: 'putResourcePolicy',
                parameters: {
                    policyName: props.policyName,
                    policyDocument: JSON.stringify(policyDocument),
                },
                physicalResourceId: cr.PhysicalResourceId.of(id),
            },
            onDelete: {
                service: 'CloudWatchLogs',
                action: 'deleteResourcePolicy',
                parameters: {
                    policyName: props.policyName,
                },
                ignoreErrorCodesMatching: '400',
            },
            policy: cr.AwsCustomResourcePolicy.fromSdkCalls({ resources: ['*'] }),
        });
    }
}
exports.LogGroupResourcePolicy = LogGroupResourcePolicy;
//# sourceMappingURL=data:application/json;base64,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