% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tea.R
\name{perform_tea}
\alias{perform_tea}
\title{Perform Tissue Enrichment Analysis (TEA) on SVG genes}
\usage{
perform_tea(
  gene_list,
  organism = "Mus Musculus",
  top_n = 8,
  colors = NULL,
  fig_size = NULL
)
}
\arguments{
\item{gene_list}{A dataframe containing gene predictions with columns:
- gene: gene symbols
- pred: binary prediction status (1 = SVG, 0 = non-SVG)}

\item{organism}{Organism name (default: "Mus Musculus")}

\item{top_n}{Number of top enriched tissues to display (default: 8)}

\item{colors}{Optional vector of colors for tissues (will use default if NULL)}

\item{fig_size}{Optional vector specifying figure size (width, height) in inches}
}
\value{
A list containing:
        - enrichment_results: Full enrichment results dataframe
        - top_tissues: Vector of top enriched tissues
        - plot: ggplot object of the enrichment plot
        - tissue_colors: Colors used for each tissue
}
\description{
Perform Tissue Enrichment Analysis (TEA) on SVG genes
}
