# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.  # noqa: E501

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class EnvelopeDefinition(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_control_list_base64': 'str',
        'accessibility': 'str',
        'allow_comments': 'str',
        'allow_markup': 'str',
        'allow_reassign': 'str',
        'allow_recipient_recursion': 'str',
        'allow_view_history': 'str',
        'any_signer': 'str',
        'asynchronous': 'str',
        'attachments': 'list[Attachment]',
        'attachments_uri': 'str',
        'authoritative_copy': 'str',
        'authoritative_copy_default': 'str',
        'auto_navigation': 'str',
        'brand_id': 'str',
        'brand_lock': 'str',
        'certificate_uri': 'str',
        'completed_date_time': 'str',
        'composite_templates': 'list[CompositeTemplate]',
        'copy_recipient_data': 'str',
        'created_date_time': 'str',
        'custom_fields': 'CustomFields',
        'custom_fields_uri': 'str',
        'declined_date_time': 'str',
        'deleted_date_time': 'str',
        'delivered_date_time': 'str',
        'disable_responsive_document': 'str',
        'documents': 'list[Document]',
        'documents_combined_uri': 'str',
        'documents_uri': 'str',
        'email_blurb': 'str',
        'email_settings': 'EmailSettings',
        'email_subject': 'str',
        'enable_wet_sign': 'str',
        'enforce_signer_visibility': 'str',
        'envelope_attachments': 'list[Attachment]',
        'envelope_documents': 'list[EnvelopeDocument]',
        'envelope_id': 'str',
        'envelope_id_stamping': 'str',
        'envelope_location': 'str',
        'envelope_metadata': 'EnvelopeMetadata',
        'envelope_uri': 'str',
        'event_notification': 'EventNotification',
        'event_notifications': 'list[EventNotification]',
        'expire_after': 'str',
        'expire_date_time': 'str',
        'expire_enabled': 'str',
        'external_envelope_id': 'str',
        'folders': 'list[Folder]',
        'has_comments': 'str',
        'has_form_data_changed': 'str',
        'has_wav_file': 'str',
        'holder': 'str',
        'initial_sent_date_time': 'str',
        'is21_cfr_part11': 'str',
        'is_dynamic_envelope': 'str',
        'is_signature_provider_envelope': 'str',
        'last_modified_date_time': 'str',
        'location': 'str',
        'lock_information': 'LockInformation',
        'message_lock': 'str',
        'notification': 'Notification',
        'notification_uri': 'str',
        'password': 'str',
        'power_form': 'PowerForm',
        'purge_completed_date': 'str',
        'purge_request_date': 'str',
        'purge_state': 'str',
        'recipients': 'Recipients',
        'recipients_lock': 'str',
        'recipients_uri': 'str',
        'sender': 'UserInfo',
        'sent_date_time': 'str',
        'signer_can_sign_on_mobile': 'str',
        'signing_location': 'str',
        'status': 'str',
        'status_changed_date_time': 'str',
        'status_date_time': 'str',
        'template_id': 'str',
        'template_roles': 'list[TemplateRole]',
        'templates_uri': 'str',
        'transaction_id': 'str',
        'use_disclosure': 'str',
        'voided_date_time': 'str',
        'voided_reason': 'str'
    }

    attribute_map = {
        'access_control_list_base64': 'accessControlListBase64',
        'accessibility': 'accessibility',
        'allow_comments': 'allowComments',
        'allow_markup': 'allowMarkup',
        'allow_reassign': 'allowReassign',
        'allow_recipient_recursion': 'allowRecipientRecursion',
        'allow_view_history': 'allowViewHistory',
        'any_signer': 'anySigner',
        'asynchronous': 'asynchronous',
        'attachments': 'attachments',
        'attachments_uri': 'attachmentsUri',
        'authoritative_copy': 'authoritativeCopy',
        'authoritative_copy_default': 'authoritativeCopyDefault',
        'auto_navigation': 'autoNavigation',
        'brand_id': 'brandId',
        'brand_lock': 'brandLock',
        'certificate_uri': 'certificateUri',
        'completed_date_time': 'completedDateTime',
        'composite_templates': 'compositeTemplates',
        'copy_recipient_data': 'copyRecipientData',
        'created_date_time': 'createdDateTime',
        'custom_fields': 'customFields',
        'custom_fields_uri': 'customFieldsUri',
        'declined_date_time': 'declinedDateTime',
        'deleted_date_time': 'deletedDateTime',
        'delivered_date_time': 'deliveredDateTime',
        'disable_responsive_document': 'disableResponsiveDocument',
        'documents': 'documents',
        'documents_combined_uri': 'documentsCombinedUri',
        'documents_uri': 'documentsUri',
        'email_blurb': 'emailBlurb',
        'email_settings': 'emailSettings',
        'email_subject': 'emailSubject',
        'enable_wet_sign': 'enableWetSign',
        'enforce_signer_visibility': 'enforceSignerVisibility',
        'envelope_attachments': 'envelopeAttachments',
        'envelope_documents': 'envelopeDocuments',
        'envelope_id': 'envelopeId',
        'envelope_id_stamping': 'envelopeIdStamping',
        'envelope_location': 'envelopeLocation',
        'envelope_metadata': 'envelopeMetadata',
        'envelope_uri': 'envelopeUri',
        'event_notification': 'eventNotification',
        'event_notifications': 'eventNotifications',
        'expire_after': 'expireAfter',
        'expire_date_time': 'expireDateTime',
        'expire_enabled': 'expireEnabled',
        'external_envelope_id': 'externalEnvelopeId',
        'folders': 'folders',
        'has_comments': 'hasComments',
        'has_form_data_changed': 'hasFormDataChanged',
        'has_wav_file': 'hasWavFile',
        'holder': 'holder',
        'initial_sent_date_time': 'initialSentDateTime',
        'is21_cfr_part11': 'is21CFRPart11',
        'is_dynamic_envelope': 'isDynamicEnvelope',
        'is_signature_provider_envelope': 'isSignatureProviderEnvelope',
        'last_modified_date_time': 'lastModifiedDateTime',
        'location': 'location',
        'lock_information': 'lockInformation',
        'message_lock': 'messageLock',
        'notification': 'notification',
        'notification_uri': 'notificationUri',
        'password': 'password',
        'power_form': 'powerForm',
        'purge_completed_date': 'purgeCompletedDate',
        'purge_request_date': 'purgeRequestDate',
        'purge_state': 'purgeState',
        'recipients': 'recipients',
        'recipients_lock': 'recipientsLock',
        'recipients_uri': 'recipientsUri',
        'sender': 'sender',
        'sent_date_time': 'sentDateTime',
        'signer_can_sign_on_mobile': 'signerCanSignOnMobile',
        'signing_location': 'signingLocation',
        'status': 'status',
        'status_changed_date_time': 'statusChangedDateTime',
        'status_date_time': 'statusDateTime',
        'template_id': 'templateId',
        'template_roles': 'templateRoles',
        'templates_uri': 'templatesUri',
        'transaction_id': 'transactionId',
        'use_disclosure': 'useDisclosure',
        'voided_date_time': 'voidedDateTime',
        'voided_reason': 'voidedReason'
    }

    def __init__(self, access_control_list_base64=None, accessibility=None, allow_comments=None, allow_markup=None, allow_reassign=None, allow_recipient_recursion=None, allow_view_history=None, any_signer=None, asynchronous=None, attachments=None, attachments_uri=None, authoritative_copy=None, authoritative_copy_default=None, auto_navigation=None, brand_id=None, brand_lock=None, certificate_uri=None, completed_date_time=None, composite_templates=None, copy_recipient_data=None, created_date_time=None, custom_fields=None, custom_fields_uri=None, declined_date_time=None, deleted_date_time=None, delivered_date_time=None, disable_responsive_document=None, documents=None, documents_combined_uri=None, documents_uri=None, email_blurb=None, email_settings=None, email_subject=None, enable_wet_sign=None, enforce_signer_visibility=None, envelope_attachments=None, envelope_documents=None, envelope_id=None, envelope_id_stamping=None, envelope_location=None, envelope_metadata=None, envelope_uri=None, event_notification=None, event_notifications=None, expire_after=None, expire_date_time=None, expire_enabled=None, external_envelope_id=None, folders=None, has_comments=None, has_form_data_changed=None, has_wav_file=None, holder=None, initial_sent_date_time=None, is21_cfr_part11=None, is_dynamic_envelope=None, is_signature_provider_envelope=None, last_modified_date_time=None, location=None, lock_information=None, message_lock=None, notification=None, notification_uri=None, password=None, power_form=None, purge_completed_date=None, purge_request_date=None, purge_state=None, recipients=None, recipients_lock=None, recipients_uri=None, sender=None, sent_date_time=None, signer_can_sign_on_mobile=None, signing_location=None, status=None, status_changed_date_time=None, status_date_time=None, template_id=None, template_roles=None, templates_uri=None, transaction_id=None, use_disclosure=None, voided_date_time=None, voided_reason=None):  # noqa: E501
        """EnvelopeDefinition - a model defined in Swagger"""  # noqa: E501

        self._access_control_list_base64 = None
        self._accessibility = None
        self._allow_comments = None
        self._allow_markup = None
        self._allow_reassign = None
        self._allow_recipient_recursion = None
        self._allow_view_history = None
        self._any_signer = None
        self._asynchronous = None
        self._attachments = None
        self._attachments_uri = None
        self._authoritative_copy = None
        self._authoritative_copy_default = None
        self._auto_navigation = None
        self._brand_id = None
        self._brand_lock = None
        self._certificate_uri = None
        self._completed_date_time = None
        self._composite_templates = None
        self._copy_recipient_data = None
        self._created_date_time = None
        self._custom_fields = None
        self._custom_fields_uri = None
        self._declined_date_time = None
        self._deleted_date_time = None
        self._delivered_date_time = None
        self._disable_responsive_document = None
        self._documents = None
        self._documents_combined_uri = None
        self._documents_uri = None
        self._email_blurb = None
        self._email_settings = None
        self._email_subject = None
        self._enable_wet_sign = None
        self._enforce_signer_visibility = None
        self._envelope_attachments = None
        self._envelope_documents = None
        self._envelope_id = None
        self._envelope_id_stamping = None
        self._envelope_location = None
        self._envelope_metadata = None
        self._envelope_uri = None
        self._event_notification = None
        self._event_notifications = None
        self._expire_after = None
        self._expire_date_time = None
        self._expire_enabled = None
        self._external_envelope_id = None
        self._folders = None
        self._has_comments = None
        self._has_form_data_changed = None
        self._has_wav_file = None
        self._holder = None
        self._initial_sent_date_time = None
        self._is21_cfr_part11 = None
        self._is_dynamic_envelope = None
        self._is_signature_provider_envelope = None
        self._last_modified_date_time = None
        self._location = None
        self._lock_information = None
        self._message_lock = None
        self._notification = None
        self._notification_uri = None
        self._password = None
        self._power_form = None
        self._purge_completed_date = None
        self._purge_request_date = None
        self._purge_state = None
        self._recipients = None
        self._recipients_lock = None
        self._recipients_uri = None
        self._sender = None
        self._sent_date_time = None
        self._signer_can_sign_on_mobile = None
        self._signing_location = None
        self._status = None
        self._status_changed_date_time = None
        self._status_date_time = None
        self._template_id = None
        self._template_roles = None
        self._templates_uri = None
        self._transaction_id = None
        self._use_disclosure = None
        self._voided_date_time = None
        self._voided_reason = None
        self.discriminator = None

        if access_control_list_base64 is not None:
            self.access_control_list_base64 = access_control_list_base64
        if accessibility is not None:
            self.accessibility = accessibility
        if allow_comments is not None:
            self.allow_comments = allow_comments
        if allow_markup is not None:
            self.allow_markup = allow_markup
        if allow_reassign is not None:
            self.allow_reassign = allow_reassign
        if allow_recipient_recursion is not None:
            self.allow_recipient_recursion = allow_recipient_recursion
        if allow_view_history is not None:
            self.allow_view_history = allow_view_history
        if any_signer is not None:
            self.any_signer = any_signer
        if asynchronous is not None:
            self.asynchronous = asynchronous
        if attachments is not None:
            self.attachments = attachments
        if attachments_uri is not None:
            self.attachments_uri = attachments_uri
        if authoritative_copy is not None:
            self.authoritative_copy = authoritative_copy
        if authoritative_copy_default is not None:
            self.authoritative_copy_default = authoritative_copy_default
        if auto_navigation is not None:
            self.auto_navigation = auto_navigation
        if brand_id is not None:
            self.brand_id = brand_id
        if brand_lock is not None:
            self.brand_lock = brand_lock
        if certificate_uri is not None:
            self.certificate_uri = certificate_uri
        if completed_date_time is not None:
            self.completed_date_time = completed_date_time
        if composite_templates is not None:
            self.composite_templates = composite_templates
        if copy_recipient_data is not None:
            self.copy_recipient_data = copy_recipient_data
        if created_date_time is not None:
            self.created_date_time = created_date_time
        if custom_fields is not None:
            self.custom_fields = custom_fields
        if custom_fields_uri is not None:
            self.custom_fields_uri = custom_fields_uri
        if declined_date_time is not None:
            self.declined_date_time = declined_date_time
        if deleted_date_time is not None:
            self.deleted_date_time = deleted_date_time
        if delivered_date_time is not None:
            self.delivered_date_time = delivered_date_time
        if disable_responsive_document is not None:
            self.disable_responsive_document = disable_responsive_document
        if documents is not None:
            self.documents = documents
        if documents_combined_uri is not None:
            self.documents_combined_uri = documents_combined_uri
        if documents_uri is not None:
            self.documents_uri = documents_uri
        if email_blurb is not None:
            self.email_blurb = email_blurb
        if email_settings is not None:
            self.email_settings = email_settings
        if email_subject is not None:
            self.email_subject = email_subject
        if enable_wet_sign is not None:
            self.enable_wet_sign = enable_wet_sign
        if enforce_signer_visibility is not None:
            self.enforce_signer_visibility = enforce_signer_visibility
        if envelope_attachments is not None:
            self.envelope_attachments = envelope_attachments
        if envelope_documents is not None:
            self.envelope_documents = envelope_documents
        if envelope_id is not None:
            self.envelope_id = envelope_id
        if envelope_id_stamping is not None:
            self.envelope_id_stamping = envelope_id_stamping
        if envelope_location is not None:
            self.envelope_location = envelope_location
        if envelope_metadata is not None:
            self.envelope_metadata = envelope_metadata
        if envelope_uri is not None:
            self.envelope_uri = envelope_uri
        if event_notification is not None:
            self.event_notification = event_notification
        if event_notifications is not None:
            self.event_notifications = event_notifications
        if expire_after is not None:
            self.expire_after = expire_after
        if expire_date_time is not None:
            self.expire_date_time = expire_date_time
        if expire_enabled is not None:
            self.expire_enabled = expire_enabled
        if external_envelope_id is not None:
            self.external_envelope_id = external_envelope_id
        if folders is not None:
            self.folders = folders
        if has_comments is not None:
            self.has_comments = has_comments
        if has_form_data_changed is not None:
            self.has_form_data_changed = has_form_data_changed
        if has_wav_file is not None:
            self.has_wav_file = has_wav_file
        if holder is not None:
            self.holder = holder
        if initial_sent_date_time is not None:
            self.initial_sent_date_time = initial_sent_date_time
        if is21_cfr_part11 is not None:
            self.is21_cfr_part11 = is21_cfr_part11
        if is_dynamic_envelope is not None:
            self.is_dynamic_envelope = is_dynamic_envelope
        if is_signature_provider_envelope is not None:
            self.is_signature_provider_envelope = is_signature_provider_envelope
        if last_modified_date_time is not None:
            self.last_modified_date_time = last_modified_date_time
        if location is not None:
            self.location = location
        if lock_information is not None:
            self.lock_information = lock_information
        if message_lock is not None:
            self.message_lock = message_lock
        if notification is not None:
            self.notification = notification
        if notification_uri is not None:
            self.notification_uri = notification_uri
        if password is not None:
            self.password = password
        if power_form is not None:
            self.power_form = power_form
        if purge_completed_date is not None:
            self.purge_completed_date = purge_completed_date
        if purge_request_date is not None:
            self.purge_request_date = purge_request_date
        if purge_state is not None:
            self.purge_state = purge_state
        if recipients is not None:
            self.recipients = recipients
        if recipients_lock is not None:
            self.recipients_lock = recipients_lock
        if recipients_uri is not None:
            self.recipients_uri = recipients_uri
        if sender is not None:
            self.sender = sender
        if sent_date_time is not None:
            self.sent_date_time = sent_date_time
        if signer_can_sign_on_mobile is not None:
            self.signer_can_sign_on_mobile = signer_can_sign_on_mobile
        if signing_location is not None:
            self.signing_location = signing_location
        if status is not None:
            self.status = status
        if status_changed_date_time is not None:
            self.status_changed_date_time = status_changed_date_time
        if status_date_time is not None:
            self.status_date_time = status_date_time
        if template_id is not None:
            self.template_id = template_id
        if template_roles is not None:
            self.template_roles = template_roles
        if templates_uri is not None:
            self.templates_uri = templates_uri
        if transaction_id is not None:
            self.transaction_id = transaction_id
        if use_disclosure is not None:
            self.use_disclosure = use_disclosure
        if voided_date_time is not None:
            self.voided_date_time = voided_date_time
        if voided_reason is not None:
            self.voided_reason = voided_reason

    @property
    def access_control_list_base64(self):
        """Gets the access_control_list_base64 of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The access_control_list_base64 of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._access_control_list_base64

    @access_control_list_base64.setter
    def access_control_list_base64(self, access_control_list_base64):
        """Sets the access_control_list_base64 of this EnvelopeDefinition.

          # noqa: E501

        :param access_control_list_base64: The access_control_list_base64 of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._access_control_list_base64 = access_control_list_base64

    @property
    def accessibility(self):
        """Gets the accessibility of this EnvelopeDefinition.  # noqa: E501

        Sets the document reading zones for screen reader applications.  This element can only be used if Document Accessibility is enabled for the account.   ###### Note: This information is currently generated from the DocuSign web console by setting the reading zones when creating a template, exporting the reading zone string information, and adding it here.  # noqa: E501

        :return: The accessibility of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._accessibility

    @accessibility.setter
    def accessibility(self, accessibility):
        """Sets the accessibility of this EnvelopeDefinition.

        Sets the document reading zones for screen reader applications.  This element can only be used if Document Accessibility is enabled for the account.   ###### Note: This information is currently generated from the DocuSign web console by setting the reading zones when creating a template, exporting the reading zone string information, and adding it here.  # noqa: E501

        :param accessibility: The accessibility of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._accessibility = accessibility

    @property
    def allow_comments(self):
        """Gets the allow_comments of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The allow_comments of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._allow_comments

    @allow_comments.setter
    def allow_comments(self, allow_comments):
        """Sets the allow_comments of this EnvelopeDefinition.

          # noqa: E501

        :param allow_comments: The allow_comments of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._allow_comments = allow_comments

    @property
    def allow_markup(self):
        """Gets the allow_markup of this EnvelopeDefinition.  # noqa: E501

        When set to **true**, Document Markup is enabled for envelope. Account must have Document Markup enabled to use this  # noqa: E501

        :return: The allow_markup of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._allow_markup

    @allow_markup.setter
    def allow_markup(self, allow_markup):
        """Sets the allow_markup of this EnvelopeDefinition.

        When set to **true**, Document Markup is enabled for envelope. Account must have Document Markup enabled to use this  # noqa: E501

        :param allow_markup: The allow_markup of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._allow_markup = allow_markup

    @property
    def allow_reassign(self):
        """Gets the allow_reassign of this EnvelopeDefinition.  # noqa: E501

        When set to **true**, the recipient can redirect an envelope to a more appropriate recipient.  # noqa: E501

        :return: The allow_reassign of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._allow_reassign

    @allow_reassign.setter
    def allow_reassign(self, allow_reassign):
        """Sets the allow_reassign of this EnvelopeDefinition.

        When set to **true**, the recipient can redirect an envelope to a more appropriate recipient.  # noqa: E501

        :param allow_reassign: The allow_reassign of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._allow_reassign = allow_reassign

    @property
    def allow_recipient_recursion(self):
        """Gets the allow_recipient_recursion of this EnvelopeDefinition.  # noqa: E501

        When set to **true**, this enables the Recursive Recipients feature and allows a recipient to appear more than once in the routing order.  # noqa: E501

        :return: The allow_recipient_recursion of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._allow_recipient_recursion

    @allow_recipient_recursion.setter
    def allow_recipient_recursion(self, allow_recipient_recursion):
        """Sets the allow_recipient_recursion of this EnvelopeDefinition.

        When set to **true**, this enables the Recursive Recipients feature and allows a recipient to appear more than once in the routing order.  # noqa: E501

        :param allow_recipient_recursion: The allow_recipient_recursion of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._allow_recipient_recursion = allow_recipient_recursion

    @property
    def allow_view_history(self):
        """Gets the allow_view_history of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The allow_view_history of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._allow_view_history

    @allow_view_history.setter
    def allow_view_history(self, allow_view_history):
        """Sets the allow_view_history of this EnvelopeDefinition.

          # noqa: E501

        :param allow_view_history: The allow_view_history of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._allow_view_history = allow_view_history

    @property
    def any_signer(self):
        """Gets the any_signer of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The any_signer of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._any_signer

    @any_signer.setter
    def any_signer(self, any_signer):
        """Sets the any_signer of this EnvelopeDefinition.

          # noqa: E501

        :param any_signer: The any_signer of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._any_signer = any_signer

    @property
    def asynchronous(self):
        """Gets the asynchronous of this EnvelopeDefinition.  # noqa: E501

        When set to **true**, the envelope is queued for processing and the value of the `status` property is set to 'Processing'. Additionally, get status calls return 'Processing' until completed.  # noqa: E501

        :return: The asynchronous of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._asynchronous

    @asynchronous.setter
    def asynchronous(self, asynchronous):
        """Sets the asynchronous of this EnvelopeDefinition.

        When set to **true**, the envelope is queued for processing and the value of the `status` property is set to 'Processing'. Additionally, get status calls return 'Processing' until completed.  # noqa: E501

        :param asynchronous: The asynchronous of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._asynchronous = asynchronous

    @property
    def attachments(self):
        """Gets the attachments of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The attachments of this EnvelopeDefinition.  # noqa: E501
        :rtype: list[Attachment]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """Sets the attachments of this EnvelopeDefinition.

          # noqa: E501

        :param attachments: The attachments of this EnvelopeDefinition.  # noqa: E501
        :type: list[Attachment]
        """

        self._attachments = attachments

    @property
    def attachments_uri(self):
        """Gets the attachments_uri of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The attachments_uri of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._attachments_uri

    @attachments_uri.setter
    def attachments_uri(self, attachments_uri):
        """Sets the attachments_uri of this EnvelopeDefinition.

          # noqa: E501

        :param attachments_uri: The attachments_uri of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._attachments_uri = attachments_uri

    @property
    def authoritative_copy(self):
        """Gets the authoritative_copy of this EnvelopeDefinition.  # noqa: E501

        Specifies the Authoritative copy feature. If set to true the Authoritative copy feature is enabled.  # noqa: E501

        :return: The authoritative_copy of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._authoritative_copy

    @authoritative_copy.setter
    def authoritative_copy(self, authoritative_copy):
        """Sets the authoritative_copy of this EnvelopeDefinition.

        Specifies the Authoritative copy feature. If set to true the Authoritative copy feature is enabled.  # noqa: E501

        :param authoritative_copy: The authoritative_copy of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._authoritative_copy = authoritative_copy

    @property
    def authoritative_copy_default(self):
        """Gets the authoritative_copy_default of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The authoritative_copy_default of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._authoritative_copy_default

    @authoritative_copy_default.setter
    def authoritative_copy_default(self, authoritative_copy_default):
        """Sets the authoritative_copy_default of this EnvelopeDefinition.

          # noqa: E501

        :param authoritative_copy_default: The authoritative_copy_default of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._authoritative_copy_default = authoritative_copy_default

    @property
    def auto_navigation(self):
        """Gets the auto_navigation of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The auto_navigation of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._auto_navigation

    @auto_navigation.setter
    def auto_navigation(self, auto_navigation):
        """Sets the auto_navigation of this EnvelopeDefinition.

          # noqa: E501

        :param auto_navigation: The auto_navigation of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._auto_navigation = auto_navigation

    @property
    def brand_id(self):
        """Gets the brand_id of this EnvelopeDefinition.  # noqa: E501

        This sets the brand profile format used for the envelope. The value in the string is the brandId associated with the profile. Account branding must be enabled for the account to use this option.  # noqa: E501

        :return: The brand_id of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._brand_id

    @brand_id.setter
    def brand_id(self, brand_id):
        """Sets the brand_id of this EnvelopeDefinition.

        This sets the brand profile format used for the envelope. The value in the string is the brandId associated with the profile. Account branding must be enabled for the account to use this option.  # noqa: E501

        :param brand_id: The brand_id of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._brand_id = brand_id

    @property
    def brand_lock(self):
        """Gets the brand_lock of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The brand_lock of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._brand_lock

    @brand_lock.setter
    def brand_lock(self, brand_lock):
        """Sets the brand_lock of this EnvelopeDefinition.

          # noqa: E501

        :param brand_lock: The brand_lock of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._brand_lock = brand_lock

    @property
    def certificate_uri(self):
        """Gets the certificate_uri of this EnvelopeDefinition.  # noqa: E501

        Retrieves a URI for an endpoint that allows you to easily retrieve certificate information.  # noqa: E501

        :return: The certificate_uri of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._certificate_uri

    @certificate_uri.setter
    def certificate_uri(self, certificate_uri):
        """Sets the certificate_uri of this EnvelopeDefinition.

        Retrieves a URI for an endpoint that allows you to easily retrieve certificate information.  # noqa: E501

        :param certificate_uri: The certificate_uri of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._certificate_uri = certificate_uri

    @property
    def completed_date_time(self):
        """Gets the completed_date_time of this EnvelopeDefinition.  # noqa: E501

        Specifies the date and time this item was completed.  # noqa: E501

        :return: The completed_date_time of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._completed_date_time

    @completed_date_time.setter
    def completed_date_time(self, completed_date_time):
        """Sets the completed_date_time of this EnvelopeDefinition.

        Specifies the date and time this item was completed.  # noqa: E501

        :param completed_date_time: The completed_date_time of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._completed_date_time = completed_date_time

    @property
    def composite_templates(self):
        """Gets the composite_templates of this EnvelopeDefinition.  # noqa: E501

        A complex type that can be added to create envelopes from a combination of DocuSign templates and PDF forms. The basic envelope remains the same, while the Composite Template adds new document and template overlays into the envelope. There can be any number of Composite Template structures in the envelope.  # noqa: E501

        :return: The composite_templates of this EnvelopeDefinition.  # noqa: E501
        :rtype: list[CompositeTemplate]
        """
        return self._composite_templates

    @composite_templates.setter
    def composite_templates(self, composite_templates):
        """Sets the composite_templates of this EnvelopeDefinition.

        A complex type that can be added to create envelopes from a combination of DocuSign templates and PDF forms. The basic envelope remains the same, while the Composite Template adds new document and template overlays into the envelope. There can be any number of Composite Template structures in the envelope.  # noqa: E501

        :param composite_templates: The composite_templates of this EnvelopeDefinition.  # noqa: E501
        :type: list[CompositeTemplate]
        """

        self._composite_templates = composite_templates

    @property
    def copy_recipient_data(self):
        """Gets the copy_recipient_data of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The copy_recipient_data of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._copy_recipient_data

    @copy_recipient_data.setter
    def copy_recipient_data(self, copy_recipient_data):
        """Sets the copy_recipient_data of this EnvelopeDefinition.

          # noqa: E501

        :param copy_recipient_data: The copy_recipient_data of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._copy_recipient_data = copy_recipient_data

    @property
    def created_date_time(self):
        """Gets the created_date_time of this EnvelopeDefinition.  # noqa: E501

        Indicates the date and time the item was created.  # noqa: E501

        :return: The created_date_time of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._created_date_time

    @created_date_time.setter
    def created_date_time(self, created_date_time):
        """Sets the created_date_time of this EnvelopeDefinition.

        Indicates the date and time the item was created.  # noqa: E501

        :param created_date_time: The created_date_time of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._created_date_time = created_date_time

    @property
    def custom_fields(self):
        """Gets the custom_fields of this EnvelopeDefinition.  # noqa: E501


        :return: The custom_fields of this EnvelopeDefinition.  # noqa: E501
        :rtype: CustomFields
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """Sets the custom_fields of this EnvelopeDefinition.


        :param custom_fields: The custom_fields of this EnvelopeDefinition.  # noqa: E501
        :type: CustomFields
        """

        self._custom_fields = custom_fields

    @property
    def custom_fields_uri(self):
        """Gets the custom_fields_uri of this EnvelopeDefinition.  # noqa: E501

        Contains a URI for an endpoint that you can use to retrieve the custom fields.  # noqa: E501

        :return: The custom_fields_uri of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._custom_fields_uri

    @custom_fields_uri.setter
    def custom_fields_uri(self, custom_fields_uri):
        """Sets the custom_fields_uri of this EnvelopeDefinition.

        Contains a URI for an endpoint that you can use to retrieve the custom fields.  # noqa: E501

        :param custom_fields_uri: The custom_fields_uri of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._custom_fields_uri = custom_fields_uri

    @property
    def declined_date_time(self):
        """Gets the declined_date_time of this EnvelopeDefinition.  # noqa: E501

        The date and time the recipient declined the document.  # noqa: E501

        :return: The declined_date_time of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._declined_date_time

    @declined_date_time.setter
    def declined_date_time(self, declined_date_time):
        """Sets the declined_date_time of this EnvelopeDefinition.

        The date and time the recipient declined the document.  # noqa: E501

        :param declined_date_time: The declined_date_time of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._declined_date_time = declined_date_time

    @property
    def deleted_date_time(self):
        """Gets the deleted_date_time of this EnvelopeDefinition.  # noqa: E501

        Specifies the data and time the item was deleted.  # noqa: E501

        :return: The deleted_date_time of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._deleted_date_time

    @deleted_date_time.setter
    def deleted_date_time(self, deleted_date_time):
        """Sets the deleted_date_time of this EnvelopeDefinition.

        Specifies the data and time the item was deleted.  # noqa: E501

        :param deleted_date_time: The deleted_date_time of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._deleted_date_time = deleted_date_time

    @property
    def delivered_date_time(self):
        """Gets the delivered_date_time of this EnvelopeDefinition.  # noqa: E501

        Reserved: For DocuSign use only.  # noqa: E501

        :return: The delivered_date_time of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._delivered_date_time

    @delivered_date_time.setter
    def delivered_date_time(self, delivered_date_time):
        """Sets the delivered_date_time of this EnvelopeDefinition.

        Reserved: For DocuSign use only.  # noqa: E501

        :param delivered_date_time: The delivered_date_time of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._delivered_date_time = delivered_date_time

    @property
    def disable_responsive_document(self):
        """Gets the disable_responsive_document of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The disable_responsive_document of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._disable_responsive_document

    @disable_responsive_document.setter
    def disable_responsive_document(self, disable_responsive_document):
        """Sets the disable_responsive_document of this EnvelopeDefinition.

          # noqa: E501

        :param disable_responsive_document: The disable_responsive_document of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._disable_responsive_document = disable_responsive_document

    @property
    def documents(self):
        """Gets the documents of this EnvelopeDefinition.  # noqa: E501

        Complex element contains the details on the documents in the envelope.  # noqa: E501

        :return: The documents of this EnvelopeDefinition.  # noqa: E501
        :rtype: list[Document]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """Sets the documents of this EnvelopeDefinition.

        Complex element contains the details on the documents in the envelope.  # noqa: E501

        :param documents: The documents of this EnvelopeDefinition.  # noqa: E501
        :type: list[Document]
        """

        self._documents = documents

    @property
    def documents_combined_uri(self):
        """Gets the documents_combined_uri of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The documents_combined_uri of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._documents_combined_uri

    @documents_combined_uri.setter
    def documents_combined_uri(self, documents_combined_uri):
        """Sets the documents_combined_uri of this EnvelopeDefinition.

          # noqa: E501

        :param documents_combined_uri: The documents_combined_uri of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._documents_combined_uri = documents_combined_uri

    @property
    def documents_uri(self):
        """Gets the documents_uri of this EnvelopeDefinition.  # noqa: E501

        Contains a URI for an endpoint that you can use to retrieve the documents.  # noqa: E501

        :return: The documents_uri of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._documents_uri

    @documents_uri.setter
    def documents_uri(self, documents_uri):
        """Sets the documents_uri of this EnvelopeDefinition.

        Contains a URI for an endpoint that you can use to retrieve the documents.  # noqa: E501

        :param documents_uri: The documents_uri of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._documents_uri = documents_uri

    @property
    def email_blurb(self):
        """Gets the email_blurb of this EnvelopeDefinition.  # noqa: E501

        Optional element. This is the same as the email body. If specified it is included in email body for all envelope recipients. This can be a maximum of 10000 characters  # noqa: E501

        :return: The email_blurb of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._email_blurb

    @email_blurb.setter
    def email_blurb(self, email_blurb):
        """Sets the email_blurb of this EnvelopeDefinition.

        Optional element. This is the same as the email body. If specified it is included in email body for all envelope recipients. This can be a maximum of 10000 characters  # noqa: E501

        :param email_blurb: The email_blurb of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._email_blurb = email_blurb

    @property
    def email_settings(self):
        """Gets the email_settings of this EnvelopeDefinition.  # noqa: E501


        :return: The email_settings of this EnvelopeDefinition.  # noqa: E501
        :rtype: EmailSettings
        """
        return self._email_settings

    @email_settings.setter
    def email_settings(self, email_settings):
        """Sets the email_settings of this EnvelopeDefinition.


        :param email_settings: The email_settings of this EnvelopeDefinition.  # noqa: E501
        :type: EmailSettings
        """

        self._email_settings = email_settings

    @property
    def email_subject(self):
        """Gets the email_subject of this EnvelopeDefinition.  # noqa: E501

        Specifies the subject of the email that is sent to all recipients.  See [ML:Template Email Subject Merge Fields] for information about adding merge field information to the email subject.  # noqa: E501

        :return: The email_subject of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._email_subject

    @email_subject.setter
    def email_subject(self, email_subject):
        """Sets the email_subject of this EnvelopeDefinition.

        Specifies the subject of the email that is sent to all recipients.  See [ML:Template Email Subject Merge Fields] for information about adding merge field information to the email subject.  # noqa: E501

        :param email_subject: The email_subject of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._email_subject = email_subject

    @property
    def enable_wet_sign(self):
        """Gets the enable_wet_sign of this EnvelopeDefinition.  # noqa: E501

        When set to **true**, the signer is allowed to print the document and sign it on paper.  # noqa: E501

        :return: The enable_wet_sign of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._enable_wet_sign

    @enable_wet_sign.setter
    def enable_wet_sign(self, enable_wet_sign):
        """Sets the enable_wet_sign of this EnvelopeDefinition.

        When set to **true**, the signer is allowed to print the document and sign it on paper.  # noqa: E501

        :param enable_wet_sign: The enable_wet_sign of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._enable_wet_sign = enable_wet_sign

    @property
    def enforce_signer_visibility(self):
        """Gets the enforce_signer_visibility of this EnvelopeDefinition.  # noqa: E501

        When set to **true**, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.  Your account must have Document Visibility enabled to use this.  # noqa: E501

        :return: The enforce_signer_visibility of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._enforce_signer_visibility

    @enforce_signer_visibility.setter
    def enforce_signer_visibility(self, enforce_signer_visibility):
        """Sets the enforce_signer_visibility of this EnvelopeDefinition.

        When set to **true**, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.  Your account must have Document Visibility enabled to use this.  # noqa: E501

        :param enforce_signer_visibility: The enforce_signer_visibility of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._enforce_signer_visibility = enforce_signer_visibility

    @property
    def envelope_attachments(self):
        """Gets the envelope_attachments of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The envelope_attachments of this EnvelopeDefinition.  # noqa: E501
        :rtype: list[Attachment]
        """
        return self._envelope_attachments

    @envelope_attachments.setter
    def envelope_attachments(self, envelope_attachments):
        """Sets the envelope_attachments of this EnvelopeDefinition.

          # noqa: E501

        :param envelope_attachments: The envelope_attachments of this EnvelopeDefinition.  # noqa: E501
        :type: list[Attachment]
        """

        self._envelope_attachments = envelope_attachments

    @property
    def envelope_documents(self):
        """Gets the envelope_documents of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The envelope_documents of this EnvelopeDefinition.  # noqa: E501
        :rtype: list[EnvelopeDocument]
        """
        return self._envelope_documents

    @envelope_documents.setter
    def envelope_documents(self, envelope_documents):
        """Sets the envelope_documents of this EnvelopeDefinition.

          # noqa: E501

        :param envelope_documents: The envelope_documents of this EnvelopeDefinition.  # noqa: E501
        :type: list[EnvelopeDocument]
        """

        self._envelope_documents = envelope_documents

    @property
    def envelope_id(self):
        """Gets the envelope_id of this EnvelopeDefinition.  # noqa: E501

        The envelope ID of the envelope status that failed to post.  # noqa: E501

        :return: The envelope_id of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._envelope_id

    @envelope_id.setter
    def envelope_id(self, envelope_id):
        """Sets the envelope_id of this EnvelopeDefinition.

        The envelope ID of the envelope status that failed to post.  # noqa: E501

        :param envelope_id: The envelope_id of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._envelope_id = envelope_id

    @property
    def envelope_id_stamping(self):
        """Gets the envelope_id_stamping of this EnvelopeDefinition.  # noqa: E501

        When set to **true**, Envelope ID Stamping is enabled.  # noqa: E501

        :return: The envelope_id_stamping of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._envelope_id_stamping

    @envelope_id_stamping.setter
    def envelope_id_stamping(self, envelope_id_stamping):
        """Sets the envelope_id_stamping of this EnvelopeDefinition.

        When set to **true**, Envelope ID Stamping is enabled.  # noqa: E501

        :param envelope_id_stamping: The envelope_id_stamping of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._envelope_id_stamping = envelope_id_stamping

    @property
    def envelope_location(self):
        """Gets the envelope_location of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The envelope_location of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._envelope_location

    @envelope_location.setter
    def envelope_location(self, envelope_location):
        """Sets the envelope_location of this EnvelopeDefinition.

          # noqa: E501

        :param envelope_location: The envelope_location of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._envelope_location = envelope_location

    @property
    def envelope_metadata(self):
        """Gets the envelope_metadata of this EnvelopeDefinition.  # noqa: E501


        :return: The envelope_metadata of this EnvelopeDefinition.  # noqa: E501
        :rtype: EnvelopeMetadata
        """
        return self._envelope_metadata

    @envelope_metadata.setter
    def envelope_metadata(self, envelope_metadata):
        """Sets the envelope_metadata of this EnvelopeDefinition.


        :param envelope_metadata: The envelope_metadata of this EnvelopeDefinition.  # noqa: E501
        :type: EnvelopeMetadata
        """

        self._envelope_metadata = envelope_metadata

    @property
    def envelope_uri(self):
        """Gets the envelope_uri of this EnvelopeDefinition.  # noqa: E501

        Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.  # noqa: E501

        :return: The envelope_uri of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._envelope_uri

    @envelope_uri.setter
    def envelope_uri(self, envelope_uri):
        """Sets the envelope_uri of this EnvelopeDefinition.

        Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.  # noqa: E501

        :param envelope_uri: The envelope_uri of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._envelope_uri = envelope_uri

    @property
    def event_notification(self):
        """Gets the event_notification of this EnvelopeDefinition.  # noqa: E501


        :return: The event_notification of this EnvelopeDefinition.  # noqa: E501
        :rtype: EventNotification
        """
        return self._event_notification

    @event_notification.setter
    def event_notification(self, event_notification):
        """Sets the event_notification of this EnvelopeDefinition.


        :param event_notification: The event_notification of this EnvelopeDefinition.  # noqa: E501
        :type: EventNotification
        """

        self._event_notification = event_notification

    @property
    def event_notifications(self):
        """Gets the event_notifications of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The event_notifications of this EnvelopeDefinition.  # noqa: E501
        :rtype: list[EventNotification]
        """
        return self._event_notifications

    @event_notifications.setter
    def event_notifications(self, event_notifications):
        """Sets the event_notifications of this EnvelopeDefinition.

          # noqa: E501

        :param event_notifications: The event_notifications of this EnvelopeDefinition.  # noqa: E501
        :type: list[EventNotification]
        """

        self._event_notifications = event_notifications

    @property
    def expire_after(self):
        """Gets the expire_after of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The expire_after of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._expire_after

    @expire_after.setter
    def expire_after(self, expire_after):
        """Sets the expire_after of this EnvelopeDefinition.

          # noqa: E501

        :param expire_after: The expire_after of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._expire_after = expire_after

    @property
    def expire_date_time(self):
        """Gets the expire_date_time of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The expire_date_time of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._expire_date_time

    @expire_date_time.setter
    def expire_date_time(self, expire_date_time):
        """Sets the expire_date_time of this EnvelopeDefinition.

          # noqa: E501

        :param expire_date_time: The expire_date_time of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._expire_date_time = expire_date_time

    @property
    def expire_enabled(self):
        """Gets the expire_enabled of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The expire_enabled of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._expire_enabled

    @expire_enabled.setter
    def expire_enabled(self, expire_enabled):
        """Sets the expire_enabled of this EnvelopeDefinition.

          # noqa: E501

        :param expire_enabled: The expire_enabled of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._expire_enabled = expire_enabled

    @property
    def external_envelope_id(self):
        """Gets the external_envelope_id of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The external_envelope_id of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._external_envelope_id

    @external_envelope_id.setter
    def external_envelope_id(self, external_envelope_id):
        """Sets the external_envelope_id of this EnvelopeDefinition.

          # noqa: E501

        :param external_envelope_id: The external_envelope_id of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._external_envelope_id = external_envelope_id

    @property
    def folders(self):
        """Gets the folders of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The folders of this EnvelopeDefinition.  # noqa: E501
        :rtype: list[Folder]
        """
        return self._folders

    @folders.setter
    def folders(self, folders):
        """Sets the folders of this EnvelopeDefinition.

          # noqa: E501

        :param folders: The folders of this EnvelopeDefinition.  # noqa: E501
        :type: list[Folder]
        """

        self._folders = folders

    @property
    def has_comments(self):
        """Gets the has_comments of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The has_comments of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._has_comments

    @has_comments.setter
    def has_comments(self, has_comments):
        """Sets the has_comments of this EnvelopeDefinition.

          # noqa: E501

        :param has_comments: The has_comments of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._has_comments = has_comments

    @property
    def has_form_data_changed(self):
        """Gets the has_form_data_changed of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The has_form_data_changed of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._has_form_data_changed

    @has_form_data_changed.setter
    def has_form_data_changed(self, has_form_data_changed):
        """Sets the has_form_data_changed of this EnvelopeDefinition.

          # noqa: E501

        :param has_form_data_changed: The has_form_data_changed of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._has_form_data_changed = has_form_data_changed

    @property
    def has_wav_file(self):
        """Gets the has_wav_file of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The has_wav_file of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._has_wav_file

    @has_wav_file.setter
    def has_wav_file(self, has_wav_file):
        """Sets the has_wav_file of this EnvelopeDefinition.

          # noqa: E501

        :param has_wav_file: The has_wav_file of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._has_wav_file = has_wav_file

    @property
    def holder(self):
        """Gets the holder of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The holder of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._holder

    @holder.setter
    def holder(self, holder):
        """Sets the holder of this EnvelopeDefinition.

          # noqa: E501

        :param holder: The holder of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._holder = holder

    @property
    def initial_sent_date_time(self):
        """Gets the initial_sent_date_time of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The initial_sent_date_time of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._initial_sent_date_time

    @initial_sent_date_time.setter
    def initial_sent_date_time(self, initial_sent_date_time):
        """Sets the initial_sent_date_time of this EnvelopeDefinition.

          # noqa: E501

        :param initial_sent_date_time: The initial_sent_date_time of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._initial_sent_date_time = initial_sent_date_time

    @property
    def is21_cfr_part11(self):
        """Gets the is21_cfr_part11 of this EnvelopeDefinition.  # noqa: E501

        When set to **true**, indicates that this module is enabled on the account.  # noqa: E501

        :return: The is21_cfr_part11 of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._is21_cfr_part11

    @is21_cfr_part11.setter
    def is21_cfr_part11(self, is21_cfr_part11):
        """Sets the is21_cfr_part11 of this EnvelopeDefinition.

        When set to **true**, indicates that this module is enabled on the account.  # noqa: E501

        :param is21_cfr_part11: The is21_cfr_part11 of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._is21_cfr_part11 = is21_cfr_part11

    @property
    def is_dynamic_envelope(self):
        """Gets the is_dynamic_envelope of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The is_dynamic_envelope of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._is_dynamic_envelope

    @is_dynamic_envelope.setter
    def is_dynamic_envelope(self, is_dynamic_envelope):
        """Sets the is_dynamic_envelope of this EnvelopeDefinition.

          # noqa: E501

        :param is_dynamic_envelope: The is_dynamic_envelope of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._is_dynamic_envelope = is_dynamic_envelope

    @property
    def is_signature_provider_envelope(self):
        """Gets the is_signature_provider_envelope of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The is_signature_provider_envelope of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._is_signature_provider_envelope

    @is_signature_provider_envelope.setter
    def is_signature_provider_envelope(self, is_signature_provider_envelope):
        """Sets the is_signature_provider_envelope of this EnvelopeDefinition.

          # noqa: E501

        :param is_signature_provider_envelope: The is_signature_provider_envelope of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._is_signature_provider_envelope = is_signature_provider_envelope

    @property
    def last_modified_date_time(self):
        """Gets the last_modified_date_time of this EnvelopeDefinition.  # noqa: E501

        The date and time the item was last modified.  # noqa: E501

        :return: The last_modified_date_time of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_date_time

    @last_modified_date_time.setter
    def last_modified_date_time(self, last_modified_date_time):
        """Sets the last_modified_date_time of this EnvelopeDefinition.

        The date and time the item was last modified.  # noqa: E501

        :param last_modified_date_time: The last_modified_date_time of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._last_modified_date_time = last_modified_date_time

    @property
    def location(self):
        """Gets the location of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The location of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this EnvelopeDefinition.

          # noqa: E501

        :param location: The location of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._location = location

    @property
    def lock_information(self):
        """Gets the lock_information of this EnvelopeDefinition.  # noqa: E501


        :return: The lock_information of this EnvelopeDefinition.  # noqa: E501
        :rtype: LockInformation
        """
        return self._lock_information

    @lock_information.setter
    def lock_information(self, lock_information):
        """Sets the lock_information of this EnvelopeDefinition.


        :param lock_information: The lock_information of this EnvelopeDefinition.  # noqa: E501
        :type: LockInformation
        """

        self._lock_information = lock_information

    @property
    def message_lock(self):
        """Gets the message_lock of this EnvelopeDefinition.  # noqa: E501

        When set to **true**, prevents senders from changing the contents of `emailBlurb` and `emailSubject` properties for the envelope.   Additionally, this prevents users from making changes to the contents of `emailBlurb` and `emailSubject` properties when correcting envelopes.   However, if the `messageLock` node is set to true**** and the `emailSubject` property is empty, senders and correctors are able to add a subject to the envelope.  # noqa: E501

        :return: The message_lock of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._message_lock

    @message_lock.setter
    def message_lock(self, message_lock):
        """Sets the message_lock of this EnvelopeDefinition.

        When set to **true**, prevents senders from changing the contents of `emailBlurb` and `emailSubject` properties for the envelope.   Additionally, this prevents users from making changes to the contents of `emailBlurb` and `emailSubject` properties when correcting envelopes.   However, if the `messageLock` node is set to true**** and the `emailSubject` property is empty, senders and correctors are able to add a subject to the envelope.  # noqa: E501

        :param message_lock: The message_lock of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._message_lock = message_lock

    @property
    def notification(self):
        """Gets the notification of this EnvelopeDefinition.  # noqa: E501


        :return: The notification of this EnvelopeDefinition.  # noqa: E501
        :rtype: Notification
        """
        return self._notification

    @notification.setter
    def notification(self, notification):
        """Sets the notification of this EnvelopeDefinition.


        :param notification: The notification of this EnvelopeDefinition.  # noqa: E501
        :type: Notification
        """

        self._notification = notification

    @property
    def notification_uri(self):
        """Gets the notification_uri of this EnvelopeDefinition.  # noqa: E501

        Contains a URI for an endpoint that you can use to retrieve the notifications.  # noqa: E501

        :return: The notification_uri of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._notification_uri

    @notification_uri.setter
    def notification_uri(self, notification_uri):
        """Sets the notification_uri of this EnvelopeDefinition.

        Contains a URI for an endpoint that you can use to retrieve the notifications.  # noqa: E501

        :param notification_uri: The notification_uri of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._notification_uri = notification_uri

    @property
    def password(self):
        """Gets the password of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The password of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this EnvelopeDefinition.

          # noqa: E501

        :param password: The password of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._password = password

    @property
    def power_form(self):
        """Gets the power_form of this EnvelopeDefinition.  # noqa: E501


        :return: The power_form of this EnvelopeDefinition.  # noqa: E501
        :rtype: PowerForm
        """
        return self._power_form

    @power_form.setter
    def power_form(self, power_form):
        """Sets the power_form of this EnvelopeDefinition.


        :param power_form: The power_form of this EnvelopeDefinition.  # noqa: E501
        :type: PowerForm
        """

        self._power_form = power_form

    @property
    def purge_completed_date(self):
        """Gets the purge_completed_date of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The purge_completed_date of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._purge_completed_date

    @purge_completed_date.setter
    def purge_completed_date(self, purge_completed_date):
        """Sets the purge_completed_date of this EnvelopeDefinition.

          # noqa: E501

        :param purge_completed_date: The purge_completed_date of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._purge_completed_date = purge_completed_date

    @property
    def purge_request_date(self):
        """Gets the purge_request_date of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The purge_request_date of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._purge_request_date

    @purge_request_date.setter
    def purge_request_date(self, purge_request_date):
        """Sets the purge_request_date of this EnvelopeDefinition.

          # noqa: E501

        :param purge_request_date: The purge_request_date of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._purge_request_date = purge_request_date

    @property
    def purge_state(self):
        """Gets the purge_state of this EnvelopeDefinition.  # noqa: E501

        Initiates a purge request. Valid values are: * documents_queued: Places envelope documents in the purge queue. * documents_and_metadata_queued: Places envelope documents and metadata in the purge queue.   # noqa: E501

        :return: The purge_state of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._purge_state

    @purge_state.setter
    def purge_state(self, purge_state):
        """Sets the purge_state of this EnvelopeDefinition.

        Initiates a purge request. Valid values are: * documents_queued: Places envelope documents in the purge queue. * documents_and_metadata_queued: Places envelope documents and metadata in the purge queue.   # noqa: E501

        :param purge_state: The purge_state of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._purge_state = purge_state

    @property
    def recipients(self):
        """Gets the recipients of this EnvelopeDefinition.  # noqa: E501


        :return: The recipients of this EnvelopeDefinition.  # noqa: E501
        :rtype: Recipients
        """
        return self._recipients

    @recipients.setter
    def recipients(self, recipients):
        """Sets the recipients of this EnvelopeDefinition.


        :param recipients: The recipients of this EnvelopeDefinition.  # noqa: E501
        :type: Recipients
        """

        self._recipients = recipients

    @property
    def recipients_lock(self):
        """Gets the recipients_lock of this EnvelopeDefinition.  # noqa: E501

        When set to **true**, prevents senders from changing, correcting, or deleting the recipient information for the envelope.  # noqa: E501

        :return: The recipients_lock of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._recipients_lock

    @recipients_lock.setter
    def recipients_lock(self, recipients_lock):
        """Sets the recipients_lock of this EnvelopeDefinition.

        When set to **true**, prevents senders from changing, correcting, or deleting the recipient information for the envelope.  # noqa: E501

        :param recipients_lock: The recipients_lock of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._recipients_lock = recipients_lock

    @property
    def recipients_uri(self):
        """Gets the recipients_uri of this EnvelopeDefinition.  # noqa: E501

        Contains a URI for an endpoint that you can use to retrieve the recipients.  # noqa: E501

        :return: The recipients_uri of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._recipients_uri

    @recipients_uri.setter
    def recipients_uri(self, recipients_uri):
        """Sets the recipients_uri of this EnvelopeDefinition.

        Contains a URI for an endpoint that you can use to retrieve the recipients.  # noqa: E501

        :param recipients_uri: The recipients_uri of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._recipients_uri = recipients_uri

    @property
    def sender(self):
        """Gets the sender of this EnvelopeDefinition.  # noqa: E501


        :return: The sender of this EnvelopeDefinition.  # noqa: E501
        :rtype: UserInfo
        """
        return self._sender

    @sender.setter
    def sender(self, sender):
        """Sets the sender of this EnvelopeDefinition.


        :param sender: The sender of this EnvelopeDefinition.  # noqa: E501
        :type: UserInfo
        """

        self._sender = sender

    @property
    def sent_date_time(self):
        """Gets the sent_date_time of this EnvelopeDefinition.  # noqa: E501

        The date and time the envelope was sent.  # noqa: E501

        :return: The sent_date_time of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._sent_date_time

    @sent_date_time.setter
    def sent_date_time(self, sent_date_time):
        """Sets the sent_date_time of this EnvelopeDefinition.

        The date and time the envelope was sent.  # noqa: E501

        :param sent_date_time: The sent_date_time of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._sent_date_time = sent_date_time

    @property
    def signer_can_sign_on_mobile(self):
        """Gets the signer_can_sign_on_mobile of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The signer_can_sign_on_mobile of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._signer_can_sign_on_mobile

    @signer_can_sign_on_mobile.setter
    def signer_can_sign_on_mobile(self, signer_can_sign_on_mobile):
        """Sets the signer_can_sign_on_mobile of this EnvelopeDefinition.

          # noqa: E501

        :param signer_can_sign_on_mobile: The signer_can_sign_on_mobile of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._signer_can_sign_on_mobile = signer_can_sign_on_mobile

    @property
    def signing_location(self):
        """Gets the signing_location of this EnvelopeDefinition.  # noqa: E501

        Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.  # noqa: E501

        :return: The signing_location of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._signing_location

    @signing_location.setter
    def signing_location(self, signing_location):
        """Sets the signing_location of this EnvelopeDefinition.

        Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.  # noqa: E501

        :param signing_location: The signing_location of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._signing_location = signing_location

    @property
    def status(self):
        """Gets the status of this EnvelopeDefinition.  # noqa: E501

        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.  # noqa: E501

        :return: The status of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this EnvelopeDefinition.

        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.  # noqa: E501

        :param status: The status of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def status_changed_date_time(self):
        """Gets the status_changed_date_time of this EnvelopeDefinition.  # noqa: E501

        The data and time the status changed.  # noqa: E501

        :return: The status_changed_date_time of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._status_changed_date_time

    @status_changed_date_time.setter
    def status_changed_date_time(self, status_changed_date_time):
        """Sets the status_changed_date_time of this EnvelopeDefinition.

        The data and time the status changed.  # noqa: E501

        :param status_changed_date_time: The status_changed_date_time of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._status_changed_date_time = status_changed_date_time

    @property
    def status_date_time(self):
        """Gets the status_date_time of this EnvelopeDefinition.  # noqa: E501

          # noqa: E501

        :return: The status_date_time of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._status_date_time

    @status_date_time.setter
    def status_date_time(self, status_date_time):
        """Sets the status_date_time of this EnvelopeDefinition.

          # noqa: E501

        :param status_date_time: The status_date_time of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._status_date_time = status_date_time

    @property
    def template_id(self):
        """Gets the template_id of this EnvelopeDefinition.  # noqa: E501

        The unique identifier of the template. If this is not provided, DocuSign will generate a value.   # noqa: E501

        :return: The template_id of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._template_id

    @template_id.setter
    def template_id(self, template_id):
        """Sets the template_id of this EnvelopeDefinition.

        The unique identifier of the template. If this is not provided, DocuSign will generate a value.   # noqa: E501

        :param template_id: The template_id of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._template_id = template_id

    @property
    def template_roles(self):
        """Gets the template_roles of this EnvelopeDefinition.  # noqa: E501

        Specifies the template recipients. Each roleName in the template must have a recipient assigned to it. This is made up elements:  * email - The recipient's email address. * name - The recipient's name. * roleName - The template roleName associated with the recipient. * clientUserId - Optional, this sets if the signer is This specifies if the recipient is embedded or remote. If the clientUserId is not null then the recipient is embedded. Note that if a ClientUserId is used and the account settings SignerMustHaveAccount or SignerMustLoginToSign are true, an error is generated on sending. * defaultRecipient - Optional, When set to **true**, this recipient is the default recipient and any tabs generated by the transformPdfFields option are mapped to this recipient. * routingOrder - This specifies the routing order of the recipient in the envelope. * accessCode - This optional element specifies the access code a recipient has to enter to validate the identity. This can be a maximum of 50 characters. * inPersonSignerName - Optional, if the template role is an in person signer, this is the full legal name of the signer. This can be a maximum of 100 characters. * emailNotification - This is an optional complex element that has a role specific emailSubject, emailBody, and language. It follows the same format as the emailNotification node for Recipients. * tabs - This allows the tab values to be specified for matching to tabs in the template.   # noqa: E501

        :return: The template_roles of this EnvelopeDefinition.  # noqa: E501
        :rtype: list[TemplateRole]
        """
        return self._template_roles

    @template_roles.setter
    def template_roles(self, template_roles):
        """Sets the template_roles of this EnvelopeDefinition.

        Specifies the template recipients. Each roleName in the template must have a recipient assigned to it. This is made up elements:  * email - The recipient's email address. * name - The recipient's name. * roleName - The template roleName associated with the recipient. * clientUserId - Optional, this sets if the signer is This specifies if the recipient is embedded or remote. If the clientUserId is not null then the recipient is embedded. Note that if a ClientUserId is used and the account settings SignerMustHaveAccount or SignerMustLoginToSign are true, an error is generated on sending. * defaultRecipient - Optional, When set to **true**, this recipient is the default recipient and any tabs generated by the transformPdfFields option are mapped to this recipient. * routingOrder - This specifies the routing order of the recipient in the envelope. * accessCode - This optional element specifies the access code a recipient has to enter to validate the identity. This can be a maximum of 50 characters. * inPersonSignerName - Optional, if the template role is an in person signer, this is the full legal name of the signer. This can be a maximum of 100 characters. * emailNotification - This is an optional complex element that has a role specific emailSubject, emailBody, and language. It follows the same format as the emailNotification node for Recipients. * tabs - This allows the tab values to be specified for matching to tabs in the template.   # noqa: E501

        :param template_roles: The template_roles of this EnvelopeDefinition.  # noqa: E501
        :type: list[TemplateRole]
        """

        self._template_roles = template_roles

    @property
    def templates_uri(self):
        """Gets the templates_uri of this EnvelopeDefinition.  # noqa: E501

        Contains a URI for an endpoint which you can use to retrieve the templates.  # noqa: E501

        :return: The templates_uri of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._templates_uri

    @templates_uri.setter
    def templates_uri(self, templates_uri):
        """Sets the templates_uri of this EnvelopeDefinition.

        Contains a URI for an endpoint which you can use to retrieve the templates.  # noqa: E501

        :param templates_uri: The templates_uri of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._templates_uri = templates_uri

    @property
    def transaction_id(self):
        """Gets the transaction_id of this EnvelopeDefinition.  # noqa: E501

         Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.  # noqa: E501

        :return: The transaction_id of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this EnvelopeDefinition.

         Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.  # noqa: E501

        :param transaction_id: The transaction_id of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._transaction_id = transaction_id

    @property
    def use_disclosure(self):
        """Gets the use_disclosure of this EnvelopeDefinition.  # noqa: E501

        When set to **true**, the disclosure is shown to recipients in accordance with the account's Electronic Record and Signature Disclosure frequency setting. When set to **false**, the Electronic Record and Signature Disclosure is not shown to any envelope recipients.   If the `useDisclosure` property is not set, then the account's normal disclosure setting is used and the value of the `useDisclosure` property is not returned in responses when getting envelope information.  # noqa: E501

        :return: The use_disclosure of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._use_disclosure

    @use_disclosure.setter
    def use_disclosure(self, use_disclosure):
        """Sets the use_disclosure of this EnvelopeDefinition.

        When set to **true**, the disclosure is shown to recipients in accordance with the account's Electronic Record and Signature Disclosure frequency setting. When set to **false**, the Electronic Record and Signature Disclosure is not shown to any envelope recipients.   If the `useDisclosure` property is not set, then the account's normal disclosure setting is used and the value of the `useDisclosure` property is not returned in responses when getting envelope information.  # noqa: E501

        :param use_disclosure: The use_disclosure of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._use_disclosure = use_disclosure

    @property
    def voided_date_time(self):
        """Gets the voided_date_time of this EnvelopeDefinition.  # noqa: E501

        The date and time the envelope or template was voided.  # noqa: E501

        :return: The voided_date_time of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._voided_date_time

    @voided_date_time.setter
    def voided_date_time(self, voided_date_time):
        """Sets the voided_date_time of this EnvelopeDefinition.

        The date and time the envelope or template was voided.  # noqa: E501

        :param voided_date_time: The voided_date_time of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._voided_date_time = voided_date_time

    @property
    def voided_reason(self):
        """Gets the voided_reason of this EnvelopeDefinition.  # noqa: E501

        The reason the envelope or template was voided.  # noqa: E501

        :return: The voided_reason of this EnvelopeDefinition.  # noqa: E501
        :rtype: str
        """
        return self._voided_reason

    @voided_reason.setter
    def voided_reason(self, voided_reason):
        """Sets the voided_reason of this EnvelopeDefinition.

        The reason the envelope or template was voided.  # noqa: E501

        :param voided_reason: The voided_reason of this EnvelopeDefinition.  # noqa: E501
        :type: str
        """

        self._voided_reason = voided_reason

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EnvelopeDefinition, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EnvelopeDefinition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
