/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ThemeStyle;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingFormat;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TimingRuler {
    private final SortedSet<TimeTick> times = new TreeSet<TimeTick>();
    private final ISkinParam skinParam;
    private long tickIntervalInPixels = 50L;
    private long tickUnitary;
    private TimingFormat format = TimingFormat.DECIMAL;
    private long highestCommonFactorInternal = -1L;

    static UGraphic applyForVLines(UGraphic ug) {
        UStroke stroke = new UStroke(3.0, 5.0, 0.5);
        HColor color = HColorSet.instance().getColorOrWhite(ThemeStyle.LIGHT, "#AAA");
        return ug.apply(stroke).apply(color);
    }

    public void ensureNotEmpty() {
        if (this.times.size() == 0) {
            this.times.add(new TimeTick(BigDecimal.ZERO, TimingFormat.DECIMAL));
        }
        if (this.getMax().getTime().signum() > 0 && this.getMin().getTime().signum() < 0) {
            this.times.add(new TimeTick(BigDecimal.ZERO, TimingFormat.DECIMAL));
        }
    }

    public TimingRuler(ISkinParam skinParam) {
        this.skinParam = skinParam;
    }

    public void scaleInPixels(long tick, long pixel) {
        if (pixel <= 0L || tick <= 0L) {
            throw new IllegalArgumentException();
        }
        this.tickIntervalInPixels = pixel;
        this.tickUnitary = tick;
    }

    private long tickUnitary() {
        if (this.tickUnitary == 0L) {
            return this.highestCommonFactor();
        }
        return this.tickUnitary;
    }

    private long highestCommonFactor() {
        if (this.highestCommonFactorInternal == -1L) {
            for (long tick : this.getAbsolutesTicks()) {
                if (this.highestCommonFactorInternal == -1L) {
                    this.highestCommonFactorInternal = tick;
                    continue;
                }
                long candidate = TimingRuler.computeHighestCommonFactor(this.highestCommonFactorInternal, tick);
                double size = (this.getMax().getTime().doubleValue() - this.getMin().getTime().doubleValue()) / (double)candidate;
                if (size > 200.0) {
                    return this.highestCommonFactorInternal;
                }
                this.highestCommonFactorInternal = candidate;
            }
        }
        return this.highestCommonFactorInternal;
    }

    private Set<Long> getAbsolutesTicks() {
        TreeSet<Long> result = new TreeSet<Long>(new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return o2.compareTo(o1);
            }
        });
        for (TimeTick time : this.times) {
            long value = Math.abs(time.getTime().longValue());
            if (value <= 0L) continue;
            result.add(value);
        }
        return result;
    }

    private int getNbTick() {
        if (this.times.size() == 0) {
            return 1;
        }
        long delta = this.getMax().getTime().longValue() - this.getMin().getTime().longValue();
        return Math.min(1000, (int)(1L + delta / this.tickUnitary()));
    }

    public double getWidth() {
        double delta = this.getMax().getTime().doubleValue() - this.getMin().getTime().doubleValue();
        return (delta / (double)this.tickUnitary() + 1.0) * (double)this.tickIntervalInPixels;
    }

    public final double getPosInPixel(TimeTick when) {
        return this.getPosInPixelInternal(when.getTime().doubleValue());
    }

    private double getPosInPixelInternal(double time) {
        return (time -= this.getMin().getTime().doubleValue()) / (double)this.tickUnitary() * (double)this.tickIntervalInPixels;
    }

    private long tickToTime(int i) {
        return this.tickUnitary * (long)i + this.getMin().getTime().longValue();
    }

    public void addTime(TimeTick time) {
        this.highestCommonFactorInternal = -1L;
        this.times.add(time);
        if (time.getFormat() != TimingFormat.DECIMAL) {
            this.format = time.getFormat();
        }
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.TIMING, null);
    }

    private TextBlock getTimeTextBlock(long time) {
        Display display = Display.getWithNewlines(this.format.formatTime(time));
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    public void drawTimeAxis(UGraphic ug) {
        ug = ug.apply(new UStroke(2.0)).apply(HColorUtils.BLACK);
        double tickHeight = 5.0;
        ULine line = ULine.vline(5.0);
        double firstTickPosition = this.getPosInPixelInternal(this.getFirstPositiveOrZeroValue().doubleValue());
        int nb = 0;
        while (firstTickPosition + (double)((long)nb * this.tickIntervalInPixels) <= this.getWidth()) {
            ug.apply(UTranslate.dx(firstTickPosition + (double)((long)nb * this.tickIntervalInPixels))).draw(line);
            ++nb;
        }
        ug.apply(UTranslate.dx(firstTickPosition)).draw(ULine.hline((long)(nb - 1) * this.tickIntervalInPixels));
        for (long round : this.roundValues()) {
            TextBlock text = this.getTimeTextBlock(round);
            Dimension2D dim = text.calculateDimension(ug.getStringBounder());
            text.drawU(ug.apply(new UTranslate(this.getPosInPixelInternal(round) - dim.getWidth() / 2.0, 6.0)));
        }
    }

    private BigDecimal getFirstPositiveOrZeroValue() {
        for (TimeTick time : this.times) {
            if (time.getTime().signum() < 0) continue;
            return time.getTime();
        }
        throw new IllegalStateException();
    }

    private Collection<Long> roundValues() {
        TreeSet<Long> result = new TreeSet<Long>();
        if (this.tickUnitary == 0L) {
            for (TimeTick tick : this.times) {
                long round = tick.getTime().longValue();
                result.add(round);
            }
        } else {
            int nb = this.getNbTick();
            for (int i = 0; i <= nb; ++i) {
                long round = this.tickToTime(i);
                result.add(round);
            }
        }
        if ((Long)result.first() < 0L && (Long)result.last() > 0L) {
            result.add(0L);
        }
        return result;
    }

    public void drawVlines(UGraphic ug, double height) {
        ug = TimingRuler.applyForVLines(ug);
        ULine line = ULine.vline(height);
        int nb = this.getNbTick();
        for (int i = 0; i <= nb; ++i) {
            ug.apply(UTranslate.dx(this.tickIntervalInPixels * (long)i)).draw(line);
        }
    }

    public double getHeight(StringBounder stringBounder) {
        return this.getTimeTextBlock(0L).calculateDimension(stringBounder).getHeight();
    }

    private TimeTick getMax() {
        return this.times.last();
    }

    private TimeTick getMin() {
        return this.times.first();
    }

    private static long computeHighestCommonFactor(long a, long b) {
        long r = a;
        while (r != 0L) {
            r = a % b;
            a = b;
            b = r;
        }
        return Math.abs(a);
    }
}

