/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.image.AbstractEntityImageBorder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImagePort
extends AbstractEntityImageBorder {
    public EntityImagePort(ILeaf leaf, ISkinParam skinParam, Cluster parent, Bibliotekon bibliotekon) {
        super(leaf, skinParam, parent, bibliotekon, FontParam.BOUNDARY);
    }

    private boolean upPosition() {
        Point2D clusterCenter = this.parent.getClusterPosition().getPointCenter();
        SvekNode node = this.bibliotekon.getNode(this.getEntity());
        return node.getMinY() < clusterCenter.getY();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double sp = 12.0;
        return new Dimension2DDouble(sp, sp);
    }

    @Override
    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        return dimDesc.getWidth();
    }

    private void drawSymbol(UGraphic ug) {
        URectangle rect = new URectangle(12.0, 12.0);
        ug.draw(rect);
    }

    @Override
    public final void drawU(UGraphic ug) {
        double y = 0.0;
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double x = 0.0 - (dimDesc.getWidth() - 12.0) / 2.0;
        y = this.upPosition() ? (y -= 12.0 + dimDesc.getHeight()) : (y += 12.0);
        this.desc.drawU(ug.apply(new UTranslate(x, y)));
        ug = ug.apply(new UStroke(1.5)).apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBorder).bg());
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBackground);
        }
        ug = ug.apply(backcolor);
        this.drawSymbol(ug);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

