/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositioned;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.entity.EntityImpl;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageEmptyPackage
extends AbstractEntityImage {
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final Stereotype stereotype;
    private final TextBlock stereoBlock;
    private final Url url;
    private final SName styleName;
    private final double shadowing;
    private final HColor borderColor;
    private final UStroke stroke;
    private final double roundCorner;
    private final HColor back;

    private Style getStyle() {
        return this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private StyleSignature getDefaultStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, this.styleName, SName.package_).with(this.stereotype);
    }

    public EntityImageEmptyPackage(ILeaf entity, ISkinParam skinParam, PortionShower portionShower, SName styleName) {
        super(entity, skinParam);
        TextBlock legendBlock;
        HorizontalAlignment titleHorizontalAlignment;
        FontConfiguration titleFontConfiguration;
        this.styleName = styleName;
        Colors colors = entity.getColors();
        HColor specificBackColor = colors.getColor(ColorType.BACK);
        this.stereotype = entity.getStereotype();
        this.url = entity.getUrl99();
        if (UseStyle.useBetaStyle()) {
            Style style = this.getStyle();
            style = style.eventuallyOverride(colors);
            this.borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            this.shadowing = style.value(PName.Shadowing).asDouble();
            this.stroke = style.getStroke(colors);
            this.roundCorner = style.value(PName.RoundCorner).asDouble();
            this.back = specificBackColor == null ? style.value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet()) : specificBackColor;
            titleFontConfiguration = style.getFontConfiguration(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            titleHorizontalAlignment = style.getHorizontalAlignment();
        } else {
            this.borderColor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.packageBorder);
            this.shadowing = this.getSkinParam().shadowing(this.getEntity().getStereotype()) ? 3.0 : 0.0;
            this.stroke = GeneralImageBuilder.getForcedStroke(this.getEntity().getStereotype(), this.getSkinParam());
            this.roundCorner = 0.0;
            this.back = Cluster.getBackColor(specificBackColor, skinParam, this.stereotype, styleName, USymbol.PACKAGE);
            titleFontConfiguration = new FontConfiguration(this.getSkinParam(), FontParam.PACKAGE, this.stereotype);
            titleHorizontalAlignment = HorizontalAlignment.CENTER;
        }
        this.desc = entity.getDisplay().create(titleFontConfiguration, titleHorizontalAlignment, skinParam);
        DisplayPositioned legend = ((EntityImpl)entity).getLegend();
        this.stereoBlock = legend != null ? (legendBlock = EntityImageLegend.create(legend.getDisplay(), skinParam)) : (this.stereotype == null || this.stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? TextBlockUtils.empty(0.0, 0.0) : TextBlockUtils.withMargin(Display.create(this.stereotype.getLabels(skinParam.guillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.PACKAGE_STEREOTYPE, this.stereotype), titleHorizontalAlignment, skinParam), 1.0, 0.0));
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        Dimension2D dim = TextBlockUtils.mergeTB(this.desc, this.stereoBlock, HorizontalAlignment.LEFT).calculateDimension(stringBounder);
        dim = Dimension2DDouble.atLeast(dim, 0.0, 2.0 * dimDesc.getHeight());
        return Dimension2DDouble.delta(dim, 20.0, 20.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        ClusterDecoration decoration = new ClusterDecoration(this.getSkinParam().packageStyle(), null, this.desc, this.stereoBlock, 0.0, 0.0, widthTotal, heightTotal, this.stroke);
        HorizontalAlignment horizontalAlignment = this.getSkinParam().getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null);
        HorizontalAlignment stereotypeAlignment = this.getSkinParam().getStereotypeAlignment();
        decoration.drawU(ug, this.back, this.borderColor, this.shadowing, this.roundCorner, horizontalAlignment, stereotypeAlignment);
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

