/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.cucadiagram.dot.Neighborhood;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.Untranslated;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageProtected
extends AbstractTextBlock
implements IEntityImage,
Untranslated,
WithPorts {
    private final IEntityImage orig;
    private final double border;
    private final Bibliotekon bibliotekon;
    private final Neighborhood neighborhood;

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        Rectangle2D result = this.orig.getInnerPosition(member, stringBounder, strategy);
        return new Rectangle2D.Double(result.getMinX() + this.border, result.getMinY() + this.border, result.getWidth(), result.getHeight());
    }

    public EntityImageProtected(IEntityImage orig, double border, Neighborhood neighborhood, Bibliotekon bibliotekon) {
        this.orig = orig;
        this.border = border;
        this.bibliotekon = bibliotekon;
        this.neighborhood = neighborhood;
    }

    @Override
    public boolean isHidden() {
        return this.orig.isHidden();
    }

    @Override
    public HColor getBackcolor() {
        return this.orig.getBackcolor();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return Dimension2DDouble.delta(this.orig.calculateDimension(stringBounder), 2.0 * this.border);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.orig.drawU(ug.apply(new UTranslate(this.border, this.border)));
    }

    @Override
    public void drawUntranslated(UGraphic ug, double minX, double minY) {
        Dimension2D dim = this.orig.calculateDimension(ug.getStringBounder());
        this.neighborhood.drawU(ug, minX + this.border, minY + this.border, this.bibliotekon, dim);
    }

    @Override
    public ShapeType getShapeType() {
        return this.orig.getShapeType();
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return this.orig.getShield(stringBounder);
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return this.orig.getOverscanX(stringBounder);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        return ((WithPorts)((Object)this.orig)).getPorts(stringBounder);
    }
}

