/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.Objects;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class DecorateEntityImage
extends AbstractTextBlock
implements TextBlockBackcolored {
    private final TextBlock original;
    private final HorizontalAlignment horizontal1;
    private final TextBlock text1;
    private final HorizontalAlignment horizontal2;
    private final TextBlock text2;
    private double deltaX;
    private double deltaY;

    public static TextBlock addTop(TextBlock original, TextBlock text, HorizontalAlignment horizontal) {
        return new DecorateEntityImage(original, text, horizontal, null, null);
    }

    public static TextBlock addBottom(TextBlock original, TextBlock text, HorizontalAlignment horizontal) {
        return new DecorateEntityImage(original, null, null, text, horizontal);
    }

    public static TextBlock add(TextBlock original, TextBlock text, HorizontalAlignment horizontal, VerticalAlignment verticalAlignment) {
        if (verticalAlignment == VerticalAlignment.TOP) {
            return DecorateEntityImage.addTop(original, text, horizontal);
        }
        return DecorateEntityImage.addBottom(original, text, horizontal);
    }

    public static TextBlock addTopAndBottom(TextBlock original, TextBlock text1, HorizontalAlignment horizontal1, TextBlock text2, HorizontalAlignment horizontal2) {
        return new DecorateEntityImage(original, text1, horizontal1, text2, horizontal2);
    }

    private DecorateEntityImage(TextBlock original, TextBlock text1, HorizontalAlignment horizontal1, TextBlock text2, HorizontalAlignment horizontal2) {
        this.original = Objects.requireNonNull(original);
        this.horizontal1 = horizontal1;
        this.text1 = text1;
        this.horizontal2 = horizontal2;
        this.text2 = text2;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimOriginal = this.original.calculateDimension(stringBounder);
        Dimension2D dimText1 = this.getTextDim(this.text1, stringBounder);
        Dimension2D dimText2 = this.getTextDim(this.text2, stringBounder);
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        double yImage = dimText1.getHeight();
        double yText2 = yImage + dimOriginal.getHeight();
        double xImage = (dimTotal.getWidth() - dimOriginal.getWidth()) / 2.0;
        if (this.text1 != null) {
            double xText1 = this.getTextX(dimText1, dimTotal, this.horizontal1);
            this.text1.drawU(ug.apply(UTranslate.dx(xText1)));
        }
        this.original.drawU(ug.apply(new UTranslate(xImage, yImage)));
        this.deltaX = xImage;
        this.deltaY = yImage;
        if (this.text2 != null) {
            double xText2 = this.getTextX(dimText2, dimTotal, this.horizontal2);
            this.text2.drawU(ug.apply(new UTranslate(xText2, yText2)));
        }
    }

    private Dimension2D getTextDim(TextBlock text, StringBounder stringBounder) {
        if (text == null) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return text.calculateDimension(stringBounder);
    }

    private double getTextX(Dimension2D dimText, Dimension2D dimTotal, HorizontalAlignment h) {
        if (h == HorizontalAlignment.CENTER) {
            return (dimTotal.getWidth() - dimText.getWidth()) / 2.0;
        }
        if (h == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (h == HorizontalAlignment.RIGHT) {
            return dimTotal.getWidth() - dimText.getWidth();
        }
        throw new IllegalStateException();
    }

    @Override
    public HColor getBackcolor() {
        if (this.original instanceof TextBlockBackcolored) {
            return ((TextBlockBackcolored)this.original).getBackcolor();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimOriginal = this.original.calculateDimension(stringBounder);
        Dimension2D dim1 = this.getTextDim(this.text1, stringBounder);
        Dimension2D dim2 = this.getTextDim(this.text2, stringBounder);
        Dimension2D dimText = Dimension2DDouble.mergeTB(dim1, dim2);
        return Dimension2DDouble.mergeTB(dimOriginal, dimText);
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        return MinMax.fromDim(this.calculateDimension(stringBounder));
    }

    public final double getDeltaX() {
        if (this.original instanceof DecorateEntityImage) {
            return this.deltaX + ((DecorateEntityImage)this.original).deltaX;
        }
        return this.deltaX;
    }

    public final double getDeltaY() {
        if (this.original instanceof DecorateEntityImage) {
            return this.deltaY + ((DecorateEntityImage)this.original).deltaY;
        }
        return this.deltaY;
    }
}

