/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.Value;

public class StyleBuilder
implements AutomaticCounter {
    private final Map<StyleSignature, Style> stylesMap = new LinkedHashMap<StyleSignature, Style>();
    private final Set<StyleSignature> printedForLog;
    private final SkinParam skinParam;
    private int counter;

    public void printMe() {
        for (Map.Entry<StyleSignature, Style> ent : this.stylesMap.entrySet()) {
            ent.getValue().printMe();
        }
    }

    private StyleBuilder(SkinParam skinParam, Set<StyleSignature> printedForLog) {
        this.skinParam = skinParam;
        this.printedForLog = new LinkedHashSet<StyleSignature>();
    }

    public StyleBuilder(SkinParam skinParam) {
        this(skinParam, new LinkedHashSet<StyleSignature>());
    }

    public final SkinParam getSkinParam() {
        return this.skinParam;
    }

    public Style createStyle(String name) {
        if (name.contains("*")) {
            throw new IllegalArgumentException();
        }
        StyleSignature signature = new StyleSignature(name = name.toLowerCase());
        Style result = this.stylesMap.get(signature);
        if (result == null) {
            return new Style(signature, new EnumMap<PName, Value>(PName.class));
        }
        return result;
    }

    public StyleBuilder muteStyle(Style modifiedStyle) {
        LinkedHashMap<StyleSignature, Style> copy = new LinkedHashMap<StyleSignature, Style>(this.stylesMap);
        StyleSignature signature = modifiedStyle.getSignature();
        Style orig = (Style)copy.get(signature);
        if (orig == null) {
            copy.put(signature, modifiedStyle);
        } else {
            Style tmp = orig.mergeWith(modifiedStyle);
            copy.put(signature, tmp);
        }
        StyleBuilder result = new StyleBuilder(this.skinParam, this.printedForLog);
        result.stylesMap.putAll(copy);
        result.counter = this.counter;
        return result;
    }

    public void loadInternal(StyleSignature signature, Style newStyle) {
        if (signature.isStarred()) {
            throw new IllegalArgumentException();
        }
        Style orig = this.stylesMap.get(signature);
        if (orig == null) {
            this.stylesMap.put(signature, newStyle);
        } else {
            Style tmp = orig.mergeWith(newStyle);
            this.stylesMap.put(signature, tmp);
        }
    }

    @Override
    public int getNextInt() {
        return ++this.counter;
    }

    public Style getMergedStyle(StyleSignature signature) {
        boolean added = this.printedForLog.add(signature);
        if (added) {
            Log.info("Using style " + signature);
        }
        Style result = null;
        for (Map.Entry<StyleSignature, Style> ent : this.stylesMap.entrySet()) {
            StyleSignature key = ent.getKey();
            if (!key.matchAll(signature)) continue;
            if (result == null) {
                result = ent.getValue();
                continue;
            }
            result = result.mergeWith(ent.getValue());
        }
        return result;
    }

    public Style getMergedStyleSpecial(StyleSignature signature, int deltaPriority) {
        boolean added = this.printedForLog.add(signature);
        if (added) {
            Log.info("Using style " + signature);
        }
        Style result = null;
        for (Map.Entry<StyleSignature, Style> ent : this.stylesMap.entrySet()) {
            StyleSignature key = ent.getKey();
            if (!key.matchAll(signature)) continue;
            Style tmp = ent.getValue();
            if (key.isStarred()) {
                tmp = tmp.deltaPriority(deltaPriority);
            }
            if (result == null) {
                result = tmp;
                continue;
            }
            result = result.mergeWith(tmp);
        }
        return result;
    }
}

