/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeLine;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.SegmentColored;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class LivingParticipantBox
implements InGroupable {
    private final ParticipantBox participantBox;
    private final LifeLine lifeLine;

    public LivingParticipantBox(ParticipantBox participantBox, LifeLine lifeLine) {
        this.participantBox = participantBox;
        this.lifeLine = lifeLine;
    }

    @Deprecated
    public ParticipantBox getParticipantBox() {
        return this.participantBox;
    }

    @Deprecated
    public LifeLine getLifeLine() {
        return this.lifeLine;
    }

    public SegmentColored getLiveThicknessAt(StringBounder stringBounder, double y) {
        double left = this.lifeLine.getLeftShift(y);
        assert (left >= 0.0);
        double right = this.lifeLine.getRightShift(y);
        assert (right >= 0.0) : "right=" + right;
        double centerX = this.participantBox.getCenterX(stringBounder);
        SymbolContext colors = this.lifeLine.getColors();
        return new SegmentColored(centerX - left, centerX + right, colors, this.lifeLine.shadowing());
    }

    public void drawLineU22(UGraphic ug, double startingY, double endingY, boolean showTail, double myDelta) {
        if (endingY <= startingY) {
            return;
        }
        double destroy = this.lifeLine.getDestroy();
        if (destroy != 0.0 && destroy > startingY && destroy < endingY) {
            endingY = destroy;
        }
        this.participantBox.drawLineU22(ug, startingY, endingY, showTail, myDelta);
    }

    public double magicMargin(StringBounder stringBounder) {
        return this.participantBox.magicMargin(stringBounder);
    }

    public void create(double ypos) {
        this.lifeLine.setCreate(ypos);
    }

    public double getCreate() {
        return this.lifeLine.getCreate();
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        return this.participantBox.getMaxX(stringBounder);
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        return this.participantBox.getStartingX();
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.toString();
    }
}

