/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.mindmap.MindMap;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class MindMapDiagram
extends UmlDiagram {
    private final List<MindMap> mindmaps = new ArrayList<MindMap>();
    private Direction defaultDirection = Direction.RIGHT;
    private String first;

    public final void setDefaultDirection(Direction defaultDirection) {
        this.defaultDirection = defaultDirection;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("MindMap");
    }

    public MindMapDiagram(UmlSource source) {
        super(source, UmlDiagramType.MINDMAP);
        this.mindmaps.add(new MindMap(this.getSkinParam()));
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                for (MindMap mindmap : MindMapDiagram.this.mindmaps) {
                    mindmap.drawU(ug);
                    Dimension2D dim = mindmap.calculateDimension(ug.getStringBounder());
                    ug = ug.apply(UTranslate.dy(dim.getHeight()));
                }
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double width = 0.0;
                double height = 0.0;
                for (MindMap mindmap : MindMapDiagram.this.mindmaps) {
                    Dimension2D dim = mindmap.calculateDimension(stringBounder);
                    height += dim.getHeight();
                    width = Math.max(width, dim.getWidth());
                }
                return new Dimension2DDouble(width, height);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }

    public CommandExecutionResult addIdea(HColor backColor, int level, Display label, IdeaShape shape) {
        return this.addIdea(backColor, level, label, shape, this.defaultDirection);
    }

    private MindMap last() {
        return this.mindmaps.get(this.mindmaps.size() - 1);
    }

    public CommandExecutionResult addIdea(HColor backColor, int level, Display label, IdeaShape shape, Direction direction) {
        String stereotype = label.getEndingStereotype();
        if (stereotype != null) {
            label = label.removeEndingStereotype();
        }
        if (this.last().isFull(level)) {
            this.mindmaps.add(new MindMap(this.getSkinParam()));
        }
        return this.last().addIdeaInternal(stereotype, backColor, level, label, shape, direction);
    }

    public CommandExecutionResult addIdea(String stereotype, HColor backColor, int level, Display label, IdeaShape shape) {
        if (this.last().isFull(level)) {
            this.mindmaps.add(new MindMap(this.getSkinParam()));
        }
        return this.last().addIdeaInternal(stereotype, backColor, level, label, shape, this.defaultDirection);
    }

    public int getSmartLevel(String type) {
        if (this.first == null) {
            this.first = type;
        }
        if (type.endsWith("**")) {
            type = type.replace('\t', ' ').trim();
        }
        if (!(type = type.replace('\t', ' ')).contains(" ")) {
            return type.length() - 1;
        }
        if (type.endsWith(this.first)) {
            return type.length() - this.first.length();
        }
        if (type.trim().length() == 1) {
            return type.length() - 1;
        }
        if (type.startsWith(this.first)) {
            return type.length() - this.first.length();
        }
        throw new UnsupportedOperationException("type=<" + type + ">[" + this.first + "]");
    }
}

