/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.mindmap.Branch;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class MindMap
implements UDrawable {
    private final Branch left = new Branch();
    private final Branch right = new Branch();
    private final ISkinParam skinParam;

    public MindMap(ISkinParam skinParam) {
        this.skinParam = skinParam;
    }

    private void computeFinger() {
        if (!this.left.hasFinger() && !this.right.hasFinger()) {
            if (this.left.hasChildren()) {
                this.left.initFinger(this.skinParam, Direction.LEFT);
            }
            if (!this.left.hasFinger() || this.right.hasChildren()) {
                this.right.initFinger(this.skinParam, Direction.RIGHT);
            }
            if (this.left.hasFinger() && this.right.hasFinger()) {
                this.left.doNotDrawFirstPhalanx();
            }
        }
    }

    Dimension2D calculateDimension(StringBounder stringBounder) {
        this.computeFinger();
        double y1 = this.right.getHalfThickness(stringBounder);
        double y2 = this.left.getHalfThickness(stringBounder);
        double y = Math.max(y1, y2);
        double x = this.left.getFullElongation(stringBounder);
        double width = x + this.right.getFullElongation(stringBounder);
        double height = y + Math.max(this.left.getHalfThickness(stringBounder), this.right.getHalfThickness(stringBounder));
        return new Dimension2DDouble(width, height);
    }

    @Override
    public void drawU(UGraphic ug) {
        if (!this.left.hasRoot() && !this.right.hasRoot()) {
            return;
        }
        this.computeFinger();
        StringBounder stringBounder = ug.getStringBounder();
        double y1 = this.right.getHalfThickness(stringBounder);
        double y2 = this.left.getHalfThickness(stringBounder);
        double y = Math.max(y1, y2);
        double x = this.left.getX12(stringBounder);
        this.right.drawU(ug.apply(new UTranslate(x, y)));
        this.left.drawU(ug.apply(new UTranslate(x, y)));
    }

    CommandExecutionResult addIdeaInternal(String stereotype, HColor backColor, int level, Display label, IdeaShape shape, Direction direction) {
        try {
            if (!this.left.hasRoot() && !this.right.hasRoot()) {
                level = 0;
            }
            if (level == 0) {
                this.right.initRoot(this.skinParam.getCurrentStyleBuilder(), backColor, label, shape, stereotype);
                this.left.initRoot(this.skinParam.getCurrentStyleBuilder(), backColor, label, shape, stereotype);
                return CommandExecutionResult.ok();
            }
            if (direction == Direction.LEFT) {
                return this.left.add(this.skinParam.getCurrentStyleBuilder(), backColor, level, label, shape, stereotype);
            }
            return this.right.add(this.skinParam.getCurrentStyleBuilder(), backColor, level, label, shape, stereotype);
        }
        catch (NoStyleAvailableException e) {
            return CommandExecutionResult.error("General failure: no style available.");
        }
    }

    boolean isFull(int level) {
        return level == 0 && this.right.hasRoot();
    }
}

