/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class USymbolHexagon
extends USymbol {
    private final double marginY = 5.0;

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.HEXAGON;
    }

    @Override
    public SName getSName() {
        return SName.hexagon;
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, SymbolContext symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, stereoAlignment);
                double deltaX = dim.getWidth() / 4.0;
                tb.drawU(ug.apply(new UTranslate(deltaX, 5.0)));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                Dimension2D full = Dimension2DDouble.mergeTB(dimStereo, dimLabel);
                return new Dimension2DDouble(full.getWidth() * 2.0, full.getHeight() + 10.0);
            }
        };
    }

    private void drawRect(UGraphic ug, double width, double height, double shadowing, double roundCorner, double diagonalCorner) {
        UPath shape = new UPath();
        double dx = width / 8.0;
        shape.moveTo(0.0, height / 2.0);
        shape.lineTo(dx, 0.0);
        shape.lineTo(width - dx, 0.0);
        shape.lineTo(width, height / 2.0);
        shape.lineTo(width - dx, height);
        shape.lineTo(dx, height);
        shape.lineTo(0.0, height / 2.0);
        shape.closePath();
        shape.setDeltaShadow(shadowing);
        ug.draw(shape);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asBig(final TextBlock title, final HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                double posStereoY;
                double posStereoX;
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolHexagon.this.drawRect(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner(), 0.0);
                Dimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                if (stereoAlignment == HorizontalAlignment.RIGHT) {
                    posStereoX = width - dimStereo.getWidth() - USymbolHexagon.this.getMargin().getX1() / 2.0;
                    posStereoY = USymbolHexagon.this.getMargin().getY1() / 2.0;
                } else {
                    posStereoX = (width - dimStereo.getWidth()) / 2.0;
                    posStereoY = 2.0;
                }
                stereotype.drawU(ug.apply(new UTranslate(posStereoX, posStereoY)));
                Dimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = labelAlignment == HorizontalAlignment.LEFT ? 3.0 : (labelAlignment == HorizontalAlignment.RIGHT ? width - dimTitle.getWidth() - 3.0 : (width - dimTitle.getWidth()) / 2.0);
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }
}

