/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.StringCompressorNone;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends PlainDiagram {
    private static final int COLS = 6;
    private static final int FREE_LINES = 6;
    public static final String DONORS = "6t4E03mSS7Dt1Og5J5Uh3hcJits4ZufNcNRmsK-DFu8Mfx004WGrllMtt9JI0K46z1ewUipjEptkDz9VH5UwzqqpHgtN9kKCeleWw07lRWljG-b_VH3cB7aHt9aIN40AYEBeOlcHRkGuVL9bI2baDAVOxcLYNg-GIYa-V-KZz1F8fg3pd6aKYPeNE3rg-odslkRdrrnTGomKo_C49L3IPKAwwSFSckbxFssauoVm-wH15OkYBTsMh94s7MFUrxK07TEkrN8c7qrgLiMugaYnZauQLf5CQCl5v7FaHPyq_gWtuIFgaI4PTGLqbjNHzNDlNzyJyoyNVSJ957n3KGCZO3soDj7YFFIWOUA0eMKNnTYgmf4dwP38WnRouH-5AOoKd5q6Dmsp1a1OlGCLH79GcnhETXm6L9bYYxuGRhhKtrWwxyjAgK9N6fv9RCnCr0Ah58aDkg4xSzs-cger0XoHdXAriFKed-FOIp-iw9jUIWJhQ-kqBC5VKSekfQRZzftgTvyIm17IyfqFOufGJg0fWocKyMi56LUXkzQ2BJgkSh2G1b4VjxZfm-R6GoiY79Cf5MeTlupjL2lyeSiMR4p2as1nlwTzARM0Gqssgj82-4AhaXuxNq0o5BmSzFYEl-yThgcK96z8j17EaFJRysn7CnO2T6mPiw6RAR0OTrdLMsn1X7gKZWxGMaW6uMnkbxtP1-aZFm7m5XAYsstYQ0T_VcdAr96BD97GJMci05QVLjHDm-8H36er5TsCAS7qDivnfLjZ7okELSkYJPwt6eo9twZJ51lBPIeotR1I3sykVCUsbtOfxfCnU7MxJ_Qw2cWfzvvouzulCX3dQZ9GAJBTyUvllcMPGLZCuf_h5PIUDNjoyz2TmNOMYvOnivMfXwm01eUILEiZqLX2ZFIsGxR0hute4K1-ZICbU9YH1wyVIwwfvfY6oIQBwDaYHBQrUSNUsPNpW3qlVv8ZeqJAnLUFGa9-nyOYebNMHcd3vdnNu1btYgAyd7VFgYVuLmrJ5r2TAWg2qeArIaBxwlK06RftrhFKaZZZ5ISMbBqk1uO4fLUYQEl13O0fD3D4yC304s4WAsMNDZ4YyDqVTvldBdMenzy-xM8S8jqb2L05X5DUK4qqM4U48-ij_l-vTuET-FD_hMcJKxkzzps4q1D8242u5neoBW0XdW9V7pRC0Pp2aX2T95ovQkrv88h1JiPW5tNxCgDoutUMcv6Rrbu_LEMfAKM5atuW-qKmQAzpIPNkGz2fx77V-KQuoC7O_YMgp4fnxogZxPMHy4aeulYEqyi1pLWOe0Phe8u2_-x-h2pKDDP-HL9vE03vPaDIgPckHTMMriP6OAESsDzRirFEpC_Am3wxrONpgXxQ9Ybkf1XH-DOfBiy84pE9f8a8Ta_9YGSZVED1lgWMIs9fMxkTCLWX_sC_XZSI3jaX3JJgCQKytO0SjadtiLMWFuZt41x8mcATxYmMIoKyaY8fdAjO9ZAaJxGPv_O6CIWAn__t5fGhJ3G_eTcbTdQIkNHhDoaWyg7-pf9Qv6ojoC2-g-QopSjp-zOc4-pO_y2Fdsz_LDry4m4uegiIl6utyk765jKLR45viuJxk2pMpUINSIdQ9Qg1pVlEHWsm6Iga98A81w12U8txDVq9Myu5yktrbxamKiFpU3NqpAUx0ol8DXfU9GsgNcHnR7s_vIRl7CYSU6nmOPMnqyES7YqprBQRDbl8e9AuSyLOps1sZv8gdygOLChGL8qDDKjYwxAp7Ps1yItaYlMzVMjZXfJw1VEPu1H3JKal3MG20Lb4Ke21v2hPhrfnXepCj4gynSfMqZ3LJMfej1iiYZjBMs7pORCrtdviIo40";

    public PSystemDonors(UmlSource source) {
        super(source);
    }

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 6, 6);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(UTranslate.dy(header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(UTranslate.dx(x)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(new PixelImage(PSystemVersion.getPlantumlImage(), AffineTransformType.TYPE_BILINEAR));
                ug.apply(new UTranslate(lastX, y - (double)logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        Transcoder t = TranscoderImpl.utf8(new AsciiEncoder(), new StringCompressorNone(), new CompressionBrotli());
        try {
            String s = t.decode(DONORS).replace('*', '.');
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                lines.add(st.nextToken());
            }
        }
        catch (NoPlantumlCompressionException e) {
            e.printStackTrace();
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create(UmlSource source) {
        return new PSystemDonors(source);
    }
}

