/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.NamespaceStrategy;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandNamespace
extends SingleLineCommand2<ClassDiagram> {
    public CommandNamespace() {
        super(CommandNamespace.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandNamespace.class.getName(), RegexLeaf.start(), new RegexLeaf("namespace"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "([%pLN_][-%pLN_.:\\\\]*)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String color;
        String urlString;
        Display display;
        IGroup currentPackage;
        Code code;
        String idShort = arg.get("NAME", 0);
        Ident idNewLong = diagram.buildLeafIdent(idShort);
        if (diagram.V1972()) {
            code = null;
            currentPackage = null;
            display = Display.getWithNewlines(idNewLong.getName());
        } else {
            code = diagram.buildCode(idShort);
            currentPackage = diagram.getCurrentGroup();
            display = Display.getWithNewlines(code);
        }
        diagram.gotoGroup(idNewLong, code, display, GroupType.PACKAGE, currentPackage, NamespaceStrategy.MULTIPLE);
        IGroup p = diagram.getCurrentGroup();
        String stereotype = arg.get("STEREOTYPE", 0);
        if (stereotype != null) {
            p.setStereotype(Stereotype.build(stereotype));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            p.addUrl(url);
        }
        if ((color = arg.get("COLOR", 0)) != null) {
            p.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(diagram.getSkinParam().getThemeStyle(), color));
        }
        return CommandExecutionResult.ok();
    }
}

