/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.awt.geom.Dimension2D;
import java.util.Set;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.Styleable;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class GtileWithNoteOpale
extends AbstractGtile
implements Stencil,
Styleable {
    private final Gtile tile;
    private final Opale opale;
    private final NotePosition notePosition;
    private final double suppSpace = 20.0;
    private final Swimlane swimlaneNote;
    private final UTranslate positionNote;
    private final UTranslate positionTile;
    private final Dimension2D dimNote;
    private final Dimension2D dimTile;

    @Override
    public StyleSignature getDefaultStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.note);
    }

    @Override
    public Swimlane getSwimlane(String point) {
        return this.tile.getSwimlane(point);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    public GtileWithNoteOpale(Gtile tile, PositionedNote note, ISkinParam skinParam, boolean withLink) {
        super(tile.getStringBounder(), tile.skinParam());
        LineBreakStrategy wrapWidth;
        double shadowing;
        FontConfiguration fc;
        HColor borderColor;
        HColor noteBackgroundColor;
        this.swimlaneNote = note.getSwimlaneNote();
        if (note.getColors() != null) {
            skinParam = note.getColors().mute(skinParam);
        }
        this.tile = tile;
        this.notePosition = note.getNotePosition();
        if (note.getType() == NoteType.FLOATING_NOTE) {
            withLink = false;
        }
        Rose rose = new Rose();
        if (UseStyle.useBetaStyle()) {
            Style style = this.getDefaultStyleDefinition().getMergedStyle(skinParam.getCurrentStyleBuilder()).eventuallyOverride(note.getColors());
            noteBackgroundColor = style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
            borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
            fc = style.getFontConfiguration(skinParam.getThemeStyle(), this.getIHtmlColorSet());
            shadowing = style.value(PName.Shadowing).asDouble();
            wrapWidth = style.wrapWidth();
        } else {
            noteBackgroundColor = rose.getHtmlColor(skinParam, ColorParam.noteBackground);
            borderColor = rose.getHtmlColor(skinParam, ColorParam.noteBorder);
            fc = new FontConfiguration(skinParam, FontParam.NOTE, null);
            shadowing = skinParam.shadowing(null) ? 4.0 : 0.0;
            wrapWidth = skinParam.wrapWidth();
        }
        HorizontalAlignment align = skinParam.getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false, null);
        Sheet sheet = Parser.build(fc, align, skinParam, CreoleMode.FULL).createSheet(note.getDisplay());
        SheetBlock2 text = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, skinParam.getPadding()), this, new UStroke(1.0));
        this.opale = new Opale(shadowing, borderColor, noteBackgroundColor, text, withLink);
        this.dimNote = this.opale.calculateDimension(this.stringBounder);
        this.dimTile = tile.calculateDimension(this.stringBounder);
        Dimension2D dimTotal = this.calculateDimension(this.stringBounder);
        if (note.getNotePosition() == NotePosition.LEFT) {
            this.positionNote = new UTranslate(0.0, (dimTotal.getHeight() - this.dimNote.getHeight()) / 2.0);
            this.positionTile = new UTranslate(this.dimNote.getWidth() + 20.0, (dimTotal.getHeight() - this.dimTile.getHeight()) / 2.0);
        } else {
            this.positionNote = new UTranslate(this.dimTile.getWidth() + 20.0, (dimTotal.getHeight() - this.dimNote.getHeight()) / 2.0);
            this.positionTile = new UTranslate(0.0, (dimTotal.getHeight() - this.dimTile.getHeight()) / 2.0);
        }
    }

    @Override
    protected UTranslate getCoordImpl(String name) {
        return this.tile.getCoord(name).compose(this.positionTile);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double height = Math.max(this.dimNote.getHeight(), this.dimTile.getHeight());
        return new Dimension2DDouble(this.dimTile.getWidth() + this.dimNote.getWidth() + 20.0, height);
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        this.opale.drawU(ug.apply(this.positionNote));
        this.tile.drawU(ug.apply(this.positionTile));
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return -this.opale.getMarginX1();
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.opale.calculateDimension(stringBounder).getWidth() - (double)this.opale.getMarginX1();
    }
}

