/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class GtileColumns
extends AbstractGtile {
    protected final List<Gtile> gtiles;
    private double margin;
    private double dy;

    protected final UTranslate getPosition(int pos) {
        double dx = 0.0;
        for (int i = 0; i < pos; ++i) {
            Dimension2D dim = this.gtiles.get(i).calculateDimension(this.getStringBounder());
            dx += dim.getWidth() + this.margin;
        }
        return new UTranslate(dx, this.dy);
    }

    protected final void setMargin(double margin) {
        if (margin < 0.0) {
            throw new IllegalArgumentException("margin=" + margin);
        }
        this.margin = margin;
    }

    protected final void pushDown(double height) {
        this.dy += height;
    }

    public String toString() {
        return "GtileIfSimple " + this.gtiles;
    }

    public Gtile first() {
        return this.gtiles.get(0);
    }

    public GtileColumns(List<Gtile> gtiles, Swimlane singleSwimlane, double margin) {
        super(gtiles.get(0).getStringBounder(), gtiles.get(0).skinParam(), singleSwimlane);
        this.gtiles = gtiles;
        this.margin = margin;
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        for (int i = 0; i < this.gtiles.size(); ++i) {
            Gtile tile = this.gtiles.get(i);
            UTranslate pos = this.getPosition(i);
            ug.apply(pos).draw(tile);
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D result = new Dimension2DDouble(0.0, 0.0);
        for (int i = 0; i < this.gtiles.size(); ++i) {
            Dimension2D dim = this.gtiles.get(i).calculateDimension(stringBounder);
            UTranslate pos = this.getPosition(i);
            Dimension2D corner = pos.getTranslated(dim);
            result = MathUtils.max(result, corner);
        }
        return result;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        for (Gtile tile : this.gtiles) {
            result.addAll(tile.getSwimlanes());
        }
        return Collections.unmodifiableSet(result);
    }
}

