/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.gtile.GAbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.GPoint;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GConnectionHorizontalThenVerticalDown
extends GAbstractConnection {
    private final TextBlock textBlock;
    private final UTranslate pos1;
    private final UTranslate pos2;

    public GConnectionHorizontalThenVerticalDown(UTranslate pos1, GPoint gpoint1, UTranslate pos2, GPoint gpoint2, TextBlock textBlock) {
        super(gpoint1, gpoint2);
        this.textBlock = textBlock;
        this.pos1 = pos1;
        this.pos2 = pos2;
        if (pos1.getTranslated(gpoint1.getPoint2D()).getX() == pos2.getTranslated(gpoint2.getPoint2D()).getX()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
        Direction newDirection;
        Point2D p1 = this.pos1.getTranslated(this.gpoint1.getPoint2D());
        Point2D p2 = this.pos2.getTranslated(this.gpoint2.getPoint2D());
        Direction originalDirection = Direction.leftOrRight(p1, p2);
        if (originalDirection != (newDirection = Direction.leftOrRight(p1 = translate1.getTranslated(p1), p2 = translate2.getTranslated(p2)))) {
            double delta = (double)(originalDirection == Direction.RIGHT ? -1 : 1) * 12.0;
            Dimension2DDouble dimDiamond1 = new Dimension2DDouble(0.0, 0.0);
            Snake small = Snake.create(this.getInLinkRenderingColor()).withLabel(this.textBlock, HorizontalAlignment.LEFT);
            small.addPoint(p1);
            small.addPoint(p1.getX() + delta, p1.getY());
            small.addPoint(p1.getX() + delta, p1.getY() + ((Dimension2D)dimDiamond1).getHeight() * 0.75);
            ug.draw(small);
            p1 = small.getLast();
        }
        UPolygon usingArrow = Arrows.asToDown();
        Snake snake = Snake.create(this.getInLinkRenderingColor(), usingArrow).withLabel(this.textBlock, HorizontalAlignment.LEFT).withMerge(MergeStrategy.LIMITED);
        snake.addPoint(p1);
        snake.addPoint(p2.getX(), p1.getY());
        snake.addPoint(p2);
        ug.draw(snake);
    }

    @Override
    public void drawU(UGraphic ug) {
        Snake snake = Snake.create(this.getInLinkRenderingColor(), Arrows.asToDown()).withLabel(this.textBlock, HorizontalAlignment.LEFT);
        Point2D p1 = this.pos1.getTranslated(this.gpoint1.getPoint2D());
        Point2D p2 = this.pos2.getTranslated(this.gpoint2.getPoint2D());
        snake.addPoint(p1);
        snake.addPoint(new Point2D.Double(p2.getX(), p1.getY()));
        snake.addPoint(p2);
        ug.draw(snake);
    }
}

