/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondSquare;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

class FtileRepeat
extends AbstractFtile {
    private final Ftile repeat;
    private final Ftile diamond1;
    private final Ftile diamond2;
    private final Ftile backward;
    private final TextBlock tbTest;

    @Override
    public Collection<Ftile> getMyChildren() {
        return Arrays.asList(this.repeat, this.diamond1, this.diamond2);
    }

    private FtileRepeat(Ftile repeat, Ftile diamond1, Ftile diamond2, TextBlock tbTest, Ftile backward) {
        super(repeat.skinParam());
        this.repeat = repeat;
        this.diamond1 = diamond1;
        this.diamond2 = diamond2;
        this.tbTest = tbTest;
        this.backward = backward;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.repeat.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.diamond2.getSwimlaneOut();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>(this.repeat.getSwimlanes());
        result.addAll(this.diamond1.getSwimlanes());
        result.addAll(this.diamond2.getSwimlanes());
        if (this.backward != null) {
            result.addAll(this.backward.getSwimlanes());
        }
        return Collections.unmodifiableSet(result);
    }

    public static Ftile create(Swimlane swimlane, Swimlane swimlaneOut, Ftile entry, Ftile repeat, Display test, Display yes, Display out, HColor borderColor, HColor diamondColor, Rainbow arrowColor, Rainbow endRepeatLinkColor, ConditionStyle conditionStyle, ISkinSimple spriteContainer, FontConfiguration fcDiamond, FontConfiguration fcArrow, Ftile backward, boolean noOut, LinkRendering incoming1, LinkRendering incoming2) {
        FtileRepeat result;
        AbstractFtile diamond2;
        FontConfiguration fontConfiguration1 = conditionStyle == ConditionStyle.INSIDE_HEXAGON ? fcDiamond : fcArrow;
        TextBlock tbTest = Display.isNull(test) || test.isWhite() ? TextBlockUtils.empty(0.0, 0.0) : test.create(fontConfiguration1, repeat.skinParam().getDefaultTextAlignment(HorizontalAlignment.LEFT), spriteContainer);
        TextBlock yesTb = yes.create(fcArrow, HorizontalAlignment.LEFT, spriteContainer);
        TextBlock outTb = out.create(fcArrow, HorizontalAlignment.LEFT, spriteContainer);
        Ftile diamond1 = entry == null ? new FtileDiamond(repeat.skinParam(), diamondColor, borderColor, repeat.getSwimlaneIn()) : entry;
        if (conditionStyle == ConditionStyle.INSIDE_HEXAGON) {
            diamond2 = noOut && Display.isNull(test) ? new FtileEmpty(repeat.skinParam()) : new FtileDiamondInside(tbTest, repeat.skinParam(), diamondColor, borderColor, swimlaneOut).withEast(yesTb).withSouth(outTb);
            result = new FtileRepeat(repeat, diamond1, diamond2, TextBlockUtils.empty(0.0, 0.0), backward);
        } else if (conditionStyle == ConditionStyle.EMPTY_DIAMOND) {
            diamond2 = new FtileDiamond(repeat.skinParam(), diamondColor, borderColor, swimlane).withEast(tbTest);
            result = new FtileRepeat(repeat, diamond1, diamond2, tbTest, backward);
        } else if (conditionStyle == ConditionStyle.INSIDE_DIAMOND) {
            diamond2 = new FtileDiamondSquare(tbTest, repeat.skinParam(), diamondColor, borderColor, swimlane);
            result = new FtileRepeat(repeat, diamond1, diamond2, TextBlockUtils.empty(0.0, 0.0), backward);
        } else {
            throw new IllegalStateException();
        }
        ArrayList<Connection> conns = new ArrayList<Connection>();
        Display in1 = repeat.getInLinkRendering().getDisplay();
        TextBlock tbin1 = in1 == null ? null : in1.create7(fcArrow, HorizontalAlignment.LEFT, spriteContainer, CreoleMode.SIMPLE_LINE);
        FtileRepeat ftileRepeat = result;
        Objects.requireNonNull(ftileRepeat);
        conns.add(ftileRepeat.new ConnectionIn(repeat.getInLinkRendering().getRainbow(arrowColor), tbin1));
        TextBlock incomingText = incoming1 == null || incoming1.getDisplay() == null ? null : incoming1.getDisplay().create7(fcArrow, HorizontalAlignment.LEFT, spriteContainer, CreoleMode.SIMPLE_LINE);
        if (backward != null) {
            Rainbow rainbow1 = incoming1.getRainbow(arrowColor);
            FtileRepeat ftileRepeat2 = result;
            Objects.requireNonNull(ftileRepeat2);
            conns.add(ftileRepeat2.new ConnectionBackBackward1(rainbow1, incomingText));
            TextBlock backArrowLabel = incoming2 == null || incoming2.getDisplay() == null ? null : incoming2.getDisplay().create(fcArrow, HorizontalAlignment.LEFT, spriteContainer);
            Rainbow rainbow2 = incoming2.getRainbow(arrowColor);
            FtileRepeat ftileRepeat3 = result;
            Objects.requireNonNull(ftileRepeat3);
            conns.add(ftileRepeat3.new ConnectionBackBackward2(rainbow2, backArrowLabel));
        } else if (repeat.getSwimlaneIn() == null || repeat.getSwimlaneIn() == swimlaneOut) {
            FtileRepeat ftileRepeat4 = result;
            Objects.requireNonNull(ftileRepeat4);
            conns.add(ftileRepeat4.new ConnectionBackSimple(incoming1.getRainbow(arrowColor), incomingText));
        } else {
            FtileRepeat ftileRepeat5 = result;
            Objects.requireNonNull(ftileRepeat5);
            conns.add(ftileRepeat5.new ConnectionBackComplex1(incoming1.getRainbow(arrowColor)));
        }
        Display out1 = repeat.getOutLinkRendering().getDisplay();
        TextBlock tbout1 = out1 == null ? null : out1.create7(fcArrow, HorizontalAlignment.LEFT, spriteContainer, CreoleMode.SIMPLE_LINE);
        Rainbow tmpColor = endRepeatLinkColor.withDefault(arrowColor);
        FtileRepeat ftileRepeat6 = result;
        Objects.requireNonNull(ftileRepeat6);
        conns.add(ftileRepeat6.new ConnectionOut(tmpColor, tbout1));
        return FtileUtils.addConnection((Ftile)result, conns);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslateForRepeat(stringBounder)).draw(this.repeat);
        ug.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        ug.apply(this.getTranslateDiamond2(stringBounder)).draw(this.diamond2);
        if (this.backward != null) {
            ug.apply(this.getTranslateBackward(stringBounder)).draw(this.backward);
        }
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        return new FtileGeometry(dimTotal, this.getLeft(stringBounder), 0.0, dimTotal.getHeight());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dimDiamond2 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry dimRepeat = this.repeat.calculateDimension(stringBounder);
        double w = this.tbTest.calculateDimension(stringBounder).getWidth();
        double width = this.getLeft(stringBounder) + this.getRight(stringBounder);
        width = Math.max(width, w + 24.0);
        if (this.backward != null) {
            width += this.backward.calculateDimension(stringBounder).getWidth();
        }
        double height = ((Dimension2D)dimDiamond1).getHeight() + ((Dimension2D)dimRepeat).getHeight() + ((Dimension2D)dimDiamond2).getHeight() + 96.0;
        return new Dimension2DDouble(width + 24.0, height);
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.repeat) {
            return this.getTranslateForRepeat(stringBounder);
        }
        if (child == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslateForRepeat(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dimDiamond2 = this.diamond2.calculateDimension(stringBounder);
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimRepeat = this.repeat.calculateDimension(stringBounder);
        double space = dimTotal.getHeight() - ((Dimension2D)dimDiamond1).getHeight() - ((Dimension2D)dimDiamond2).getHeight() - ((Dimension2D)dimRepeat).getHeight();
        double y = ((Dimension2D)dimDiamond1).getHeight() + space / 2.0;
        double left = this.getLeft(stringBounder);
        return new UTranslate(left - this.repeat.calculateDimension(stringBounder).getLeft(), y);
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double left = this.getLeft(stringBounder);
        return UTranslate.dx(left - ((Dimension2D)dimDiamond1).getWidth() / 2.0);
    }

    private UTranslate getTranslateBackward(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimBackward = this.backward.calculateDimension(stringBounder);
        double x = dimTotal.getWidth() - ((Dimension2D)dimBackward).getWidth();
        double y = (dimTotal.getHeight() - ((Dimension2D)dimBackward).getHeight()) / 2.0;
        return new UTranslate(x, y);
    }

    private UTranslate getTranslateDiamond2(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimDiamond2 = this.diamond2.calculateDimension(stringBounder);
        double y2 = dimTotal.getHeight() - ((Dimension2D)dimDiamond2).getHeight();
        double left = this.getLeft(stringBounder);
        return new UTranslate(left - ((Dimension2D)dimDiamond2).getWidth() / 2.0, y2);
    }

    private double getLeft(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dimDiamond2 = this.diamond2.calculateDimension(stringBounder);
        double left1 = this.repeat.calculateDimension(stringBounder).getLeft();
        left1 = Math.max(left1, ((Dimension2D)dimDiamond1).getWidth() / 2.0);
        double left2 = this.repeat.calculateDimension(stringBounder).getLeft();
        left2 = Math.max(left2, ((Dimension2D)dimDiamond2).getWidth() / 2.0);
        return Math.max(left1, left2);
    }

    private double getRight(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dimDiamond2 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry dimRepeat = this.repeat.calculateDimension(stringBounder);
        double right1 = ((Dimension2D)dimRepeat).getWidth() - this.repeat.calculateDimension(stringBounder).getLeft();
        right1 = Math.max(right1, ((Dimension2D)dimDiamond1).getWidth() / 2.0);
        double right2 = ((Dimension2D)dimRepeat).getWidth() - this.repeat.calculateDimension(stringBounder).getLeft();
        right2 = Math.max(right2, ((Dimension2D)dimDiamond2).getWidth() / 2.0);
        return Math.max(right1, right2);
    }

    class ConnectionBackSimple
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow arrowColor;
        private final TextBlock tbback;

        public ConnectionBackSimple(Rainbow arrowColor, TextBlock tbback) {
            super(FtileRepeat.this.diamond2, FtileRepeat.this.repeat);
            this.arrowColor = arrowColor;
            this.tbback = tbback;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond2(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = Snake.create(this.arrowColor, Arrows.asToLeft()).emphasizeDirection(Direction.UP).withLabel(this.tbback, this.arrowHorizontalAlignment());
            Dimension2D dimTotal = FtileRepeat.this.calculateDimensionInternal(stringBounder);
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            FtileGeometry dimDiamond1 = FtileRepeat.this.diamond1.calculateDimension(stringBounder);
            FtileGeometry dimDiamond2 = FtileRepeat.this.diamond2.calculateDimension(stringBounder);
            double x1 = p1.getX() + ((Dimension2D)dimDiamond2).getWidth();
            double y1 = p1.getY() + ((Dimension2D)dimDiamond2).getHeight() / 2.0;
            double x2 = p2.getX() + ((Dimension2D)dimDiamond1).getWidth();
            double y2 = p2.getY() + ((Dimension2D)dimDiamond1).getHeight() / 2.0;
            snake.addPoint(x1, y1);
            double xmax = dimTotal.getWidth() - 12.0;
            snake.addPoint(xmax, y1);
            snake.addPoint(xmax, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = Snake.create(this.arrowColor, Arrows.asToLeft()).emphasizeDirection(Direction.UP).withLabel(this.tbback, this.arrowHorizontalAlignment());
            FtileGeometry dimRepeat = FtileRepeat.this.repeat.calculateDimension(stringBounder);
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            p1 = translate1.getTranslated(p1);
            p2 = translate2.getTranslated(p2);
            FtileGeometry dimDiamond1 = FtileRepeat.this.diamond1.calculateDimension(stringBounder);
            FtileGeometry dimDiamond2 = FtileRepeat.this.diamond2.calculateDimension(stringBounder);
            double x1 = p1.getX() + ((Dimension2D)dimDiamond2).getWidth();
            double y1 = p1.getY() + ((Dimension2D)dimDiamond2).getHeight() / 2.0;
            double x2 = p2.getX() + ((Dimension2D)dimDiamond1).getWidth();
            double y2 = p2.getY() + ((Dimension2D)dimDiamond1).getHeight() / 2.0;
            snake.addPoint(x1, y1);
            double xmax = p1.getX() + ((Dimension2D)dimDiamond2).getWidth() / 2.0 + ((Dimension2D)dimRepeat).getWidth() / 2.0 + 12.0;
            snake.addPoint(xmax, y1);
            snake.addPoint(xmax, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }
    }

    class ConnectionBackBackward2
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow arrowColor;
        private final TextBlock label;

        public ConnectionBackBackward2(Rainbow arrowColor, TextBlock label) {
            super(FtileRepeat.this.backward, FtileRepeat.this.diamond1);
            this.label = label;
            this.arrowColor = arrowColor;
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry dim = FtileRepeat.this.backward.calculateDimension(stringBounder);
            return FtileRepeat.this.getTranslateBackward(stringBounder).getTranslated(new Point2D.Double(dim.getLeft(), dim.getInY()));
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            p1 = translate1.getTranslated(p1);
            p2 = translate2.getTranslated(p2);
            FtileGeometry dimDiamond1 = FtileRepeat.this.diamond1.calculateDimension(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            if (x2 < x1) {
                x2 += ((Dimension2D)dimDiamond1).getWidth();
            }
            double y2 = p2.getY() + ((Dimension2D)dimDiamond1).getHeight() / 2.0;
            Snake snake = Snake.create(this.arrowColor, x2 < x1 ? Arrows.asToLeft() : Arrows.asToRight());
            if (this.label != null) {
                snake = snake.withLabel(this.label, this.arrowHorizontalAlignment());
            }
            snake.addPoint(x1, y1);
            snake.addPoint(x1, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = Snake.create(this.arrowColor, Arrows.asToLeft());
            if (this.label != null) {
                snake = snake.withLabel(this.label, this.arrowHorizontalAlignment());
            }
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            FtileGeometry dimDiamond1 = FtileRepeat.this.diamond1.calculateDimension(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX() + ((Dimension2D)dimDiamond1).getWidth();
            double y2 = p2.getY() + ((Dimension2D)dimDiamond1).getHeight() / 2.0;
            snake.addPoint(x1, y1);
            snake.addPoint(x1, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }
    }

    class ConnectionBackBackward1
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow arrowColor;
        private final TextBlock tbback;

        public ConnectionBackBackward1(Rainbow arrowColor, TextBlock tbback) {
            super(FtileRepeat.this.diamond2, FtileRepeat.this.backward);
            this.arrowColor = arrowColor;
            this.tbback = tbback;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond2(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            FtileGeometry dim = FtileRepeat.this.backward.calculateDimension(stringBounder);
            return FtileRepeat.this.getTranslateBackward(stringBounder).getTranslated(new Point2D.Double(dim.getLeft(), dim.getOutY()));
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            FtileGeometry dimDiamond2 = FtileRepeat.this.diamond2.calculateDimension(stringBounder);
            double x1 = p1.getX() + ((Dimension2D)dimDiamond2).getWidth();
            double y1 = p1.getY() + ((Dimension2D)dimDiamond2).getHeight() / 2.0;
            double x2 = p2.getX();
            double y2 = p2.getY();
            Snake snake = Snake.create(this.arrowColor, Arrows.asToUp()).withLabel(this.tbback, this.arrowHorizontalAlignment());
            snake.addPoint(x1, y1);
            snake.addPoint(x2, y1);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            p1 = translate1.getTranslated(p1);
            p2 = translate2.getTranslated(p2);
            FtileGeometry dimDiamond2 = FtileRepeat.this.diamond2.calculateDimension(stringBounder);
            double x1 = p1.getX() + ((Dimension2D)dimDiamond2).getWidth();
            double y1 = p1.getY() + ((Dimension2D)dimDiamond2).getHeight() / 2.0;
            double x2 = p2.getX();
            double y2 = p2.getY();
            Snake snake = Snake.create(this.arrowColor, Arrows.asToUp()).withLabel(this.tbback, this.arrowHorizontalAlignment());
            snake.addPoint(x1, y1);
            snake.addPoint(x2, y1);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }
    }

    class ConnectionBackComplex1
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow arrowColor;

        public ConnectionBackComplex1(Rainbow arrowColor) {
            super(FtileRepeat.this.diamond2, FtileRepeat.this.repeat);
            this.arrowColor = arrowColor;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond2(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        @Override
        public void drawU(UGraphic ug) {
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            Snake snake;
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry dimRepeat = FtileRepeat.this.repeat.calculateDimension(stringBounder);
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            p1 = translate1.getTranslated(p1);
            p2 = translate2.getTranslated(p2);
            FtileGeometry dimDiamond1 = FtileRepeat.this.diamond1.calculateDimension(stringBounder);
            FtileGeometry dimDiamond2 = FtileRepeat.this.diamond2.calculateDimension(stringBounder);
            double y1 = p1.getY() + ((Dimension2D)dimDiamond2).getHeight() / 2.0;
            double x2 = p2.getX() + ((Dimension2D)dimDiamond1).getWidth();
            double y2 = p2.getY() + ((Dimension2D)dimDiamond1).getHeight() / 2.0;
            double x1_a = p1.getX() + ((Dimension2D)dimDiamond2).getWidth();
            double x1_b = p1.getX() + ((Dimension2D)dimDiamond2).getWidth() / 2.0 + ((Dimension2D)dimRepeat).getWidth() / 2.0 + 12.0;
            if (x2 < x1_a) {
                snake = Snake.create(this.arrowColor, Arrows.asToLeft()).emphasizeDirection(Direction.UP);
                snake.addPoint(x1_a, y1);
                if (x1_a < x1_b) {
                    snake.addPoint(x1_b, y1);
                    snake.addPoint(x1_b, y2);
                } else {
                    snake.addPoint(x1_a + 10.0, y1);
                    snake.addPoint(x1_a + 10.0, y2);
                }
            } else {
                x2 = p2.getX();
                snake = Snake.create(this.arrowColor, Arrows.asToRight()).emphasizeDirection(Direction.UP);
                snake.addPoint(x1_a, y1);
                double middle = x1_a / 4.0 + x2 * 3.0 / 4.0;
                snake.addPoint(middle, y1);
                snake.addPoint(middle, y2);
            }
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }
    }

    class ConnectionOut
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow arrowColor;
        private final TextBlock tbout;

        public ConnectionOut(Rainbow arrowColor, TextBlock tbout) {
            super(FtileRepeat.this.repeat, FtileRepeat.this.diamond2);
            this.arrowColor = arrowColor;
            this.tbout = tbout;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateForRepeat(stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond2(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            if (!this.getFtile1().calculateDimension(stringBounder).hasPointOut()) {
                return;
            }
            Snake snake = Snake.create(this.arrowColor, Arrows.asToDown()).withLabel(this.tbout, this.arrowHorizontalAlignment());
            snake.addPoint(this.getP1(stringBounder));
            snake.addPoint(this.getP2(stringBounder));
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            StringBounder stringBounder = ug.getStringBounder();
            if (!this.getFtile1().calculateDimension(stringBounder).hasPointOut()) {
                return;
            }
            Snake snake = Snake.create(this.arrowColor);
            Point2D mp1a = translate1.getTranslated(this.getP1(stringBounder));
            Point2D mp2b = translate2.getTranslated(this.getP2(stringBounder));
            double middle = (mp1a.getY() + mp2b.getY()) / 2.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            ug.draw(snake);
            Snake small = Snake.create(this.arrowColor, Arrows.asToDown()).withLabel(this.tbout, this.arrowHorizontalAlignment());
            small.addPoint(mp2b.getX(), middle);
            small.addPoint(mp2b);
            ug.draw(small);
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        private final Rainbow arrowColor;
        private final TextBlock tbin;

        public ConnectionIn(Rainbow arrowColor, TextBlock tbin) {
            super(FtileRepeat.this.diamond1, FtileRepeat.this.repeat);
            this.arrowColor = arrowColor;
            this.tbin = tbin;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return this.getFtile1().calculateDimension(stringBounder).translate(FtileRepeat.this.getTranslateDiamond1(stringBounder)).getPointOut();
        }

        private Point2D getP2(StringBounder stringBounder) {
            return this.getFtile2().calculateDimension(stringBounder).translate(FtileRepeat.this.getTranslateForRepeat(stringBounder)).getPointIn();
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = Snake.create(this.arrowColor, Arrows.asToDown()).withLabel(this.tbin, this.arrowHorizontalAlignment());
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            snake.addPoint(p1);
            if (p1.getX() != p2.getX()) {
                double my = (p1.getY() + p2.getY()) / 2.0;
                snake.addPoint(new Point2D.Double(p1.getX(), my));
                snake.addPoint(new Point2D.Double(p2.getX(), my));
            }
            snake.addPoint(p2);
            ug.draw(snake);
        }
    }
}

