# Generated by Django 3.2.12 on 2022-03-02 19:50

import django.contrib.sites.managers
from django.db import migrations, models
import django.db.models.deletion


def migrate_to_new_through(apps, schema_editor):
    Event = apps.get_model("paweljong", "Event")
    EventRegistration = apps.get_model("paweljong", "EventRegistration")
    Through = apps.get_model("paweljong", "EventInfoMailingThrough")

    db_alias = schema_editor.connection.alias

    for through_old in Event.info_mailings.through.objects.all():
        event = through_old.event
        info_mailing = through_old.infomailing

        through = Through.objects.create(event=event, info_mailing=info_mailing)
        for person in info_mailing.sent_to.all():
            if EventRegistration.objects.filter(person_id=person.id, event_id=event.id).exists():
                through.sent_to.add(person)


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0035_preference_model_unique'),
        ('sites', '0002_alter_domain_unique'),
        ('paweljong', '0013_info_mailings'),
    ]

    operations = [
        migrations.CreateModel(
            name='EventInfoMailingThrough',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('event', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='paweljong.event')),
                ('info_mailing', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='paweljong.infomailing')),
                ('sent_to', models.ManyToManyField(blank=True, editable=False, related_name='received_info_mailings', to='core.Person', verbose_name='Sent to persons')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.AddField(
            model_name='event',
            name='info_mailings_new',
            field=models.ManyToManyField(blank=True, related_name='events', through='paweljong.EventInfoMailingThrough', to='paweljong.InfoMailing', verbose_name='Info mailings'),
        ),
        migrations.RunPython(migrate_to_new_through),
        migrations.RemoveField(
            model_name='event',
            name='info_mailings',
        ),
        migrations.RenameField(
            'event',
            'info_mailings_new',
            'info_mailings',
        ),
        migrations.RemoveField(
            model_name='infomailing',
            name='sent_to',
        ),
    ]
