# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class StatementLinesResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "unreconciled_amount_pos": "float",
        "unreconciled_amount_neg": "float",
        "unreconciled_lines": "int",
        "avg_days_unreconciled_pos": "float",
        "avg_days_unreconciled_neg": "float",
        "earliest_unreconciled_transaction": "date",
        "latest_unreconciled_transaction": "date",
        "deleted_amount": "float",
        "total_amount": "float",
        "data_source": "DataSourceResponse",
        "earliest_reconciled_transaction": "date",
        "latest_reconciled_transaction": "date",
        "reconciled_amount_pos": "float",
        "reconciled_amount_neg": "float",
        "reconciled_lines": "int",
        "total_amount_pos": "float",
        "total_amount_neg": "float",
    }

    attribute_map = {
        "unreconciled_amount_pos": "unreconciledAmountPos",
        "unreconciled_amount_neg": "unreconciledAmountNeg",
        "unreconciled_lines": "unreconciledLines",
        "avg_days_unreconciled_pos": "avgDaysUnreconciledPos",
        "avg_days_unreconciled_neg": "avgDaysUnreconciledNeg",
        "earliest_unreconciled_transaction": "earliestUnreconciledTransaction",
        "latest_unreconciled_transaction": "latestUnreconciledTransaction",
        "deleted_amount": "deletedAmount",
        "total_amount": "totalAmount",
        "data_source": "dataSource",
        "earliest_reconciled_transaction": "earliestReconciledTransaction",
        "latest_reconciled_transaction": "latestReconciledTransaction",
        "reconciled_amount_pos": "reconciledAmountPos",
        "reconciled_amount_neg": "reconciledAmountNeg",
        "reconciled_lines": "reconciledLines",
        "total_amount_pos": "totalAmountPos",
        "total_amount_neg": "totalAmountNeg",
    }

    def __init__(
        self,
        unreconciled_amount_pos=None,
        unreconciled_amount_neg=None,
        unreconciled_lines=None,
        avg_days_unreconciled_pos=None,
        avg_days_unreconciled_neg=None,
        earliest_unreconciled_transaction=None,
        latest_unreconciled_transaction=None,
        deleted_amount=None,
        total_amount=None,
        data_source=None,
        earliest_reconciled_transaction=None,
        latest_reconciled_transaction=None,
        reconciled_amount_pos=None,
        reconciled_amount_neg=None,
        reconciled_lines=None,
        total_amount_pos=None,
        total_amount_neg=None,
    ):  # noqa: E501
        """StatementLinesResponse - a model defined in OpenAPI"""  # noqa: E501

        self._unreconciled_amount_pos = None
        self._unreconciled_amount_neg = None
        self._unreconciled_lines = None
        self._avg_days_unreconciled_pos = None
        self._avg_days_unreconciled_neg = None
        self._earliest_unreconciled_transaction = None
        self._latest_unreconciled_transaction = None
        self._deleted_amount = None
        self._total_amount = None
        self._data_source = None
        self._earliest_reconciled_transaction = None
        self._latest_reconciled_transaction = None
        self._reconciled_amount_pos = None
        self._reconciled_amount_neg = None
        self._reconciled_lines = None
        self._total_amount_pos = None
        self._total_amount_neg = None
        self.discriminator = None

        if unreconciled_amount_pos is not None:
            self.unreconciled_amount_pos = unreconciled_amount_pos
        if unreconciled_amount_neg is not None:
            self.unreconciled_amount_neg = unreconciled_amount_neg
        if unreconciled_lines is not None:
            self.unreconciled_lines = unreconciled_lines
        if avg_days_unreconciled_pos is not None:
            self.avg_days_unreconciled_pos = avg_days_unreconciled_pos
        if avg_days_unreconciled_neg is not None:
            self.avg_days_unreconciled_neg = avg_days_unreconciled_neg
        if earliest_unreconciled_transaction is not None:
            self.earliest_unreconciled_transaction = earliest_unreconciled_transaction
        if latest_unreconciled_transaction is not None:
            self.latest_unreconciled_transaction = latest_unreconciled_transaction
        if deleted_amount is not None:
            self.deleted_amount = deleted_amount
        if total_amount is not None:
            self.total_amount = total_amount
        if data_source is not None:
            self.data_source = data_source
        if earliest_reconciled_transaction is not None:
            self.earliest_reconciled_transaction = earliest_reconciled_transaction
        if latest_reconciled_transaction is not None:
            self.latest_reconciled_transaction = latest_reconciled_transaction
        if reconciled_amount_pos is not None:
            self.reconciled_amount_pos = reconciled_amount_pos
        if reconciled_amount_neg is not None:
            self.reconciled_amount_neg = reconciled_amount_neg
        if reconciled_lines is not None:
            self.reconciled_lines = reconciled_lines
        if total_amount_pos is not None:
            self.total_amount_pos = total_amount_pos
        if total_amount_neg is not None:
            self.total_amount_neg = total_amount_neg

    @property
    def unreconciled_amount_pos(self):
        """Gets the unreconciled_amount_pos of this StatementLinesResponse.  # noqa: E501

        Sum of the amounts of all statement lines where both the reconciled flag is set to FALSE, and the amount is positive.  # noqa: E501

        :return: The unreconciled_amount_pos of this StatementLinesResponse.  # noqa: E501
        :rtype: float
        """
        return self._unreconciled_amount_pos

    @unreconciled_amount_pos.setter
    def unreconciled_amount_pos(self, unreconciled_amount_pos):
        """Sets the unreconciled_amount_pos of this StatementLinesResponse.

        Sum of the amounts of all statement lines where both the reconciled flag is set to FALSE, and the amount is positive.  # noqa: E501

        :param unreconciled_amount_pos: The unreconciled_amount_pos of this StatementLinesResponse.  # noqa: E501
        :type: float
        """

        self._unreconciled_amount_pos = unreconciled_amount_pos

    @property
    def unreconciled_amount_neg(self):
        """Gets the unreconciled_amount_neg of this StatementLinesResponse.  # noqa: E501

        Sum of the amounts of all statement lines where both the reconciled flag is set to FALSE, and the amount is negative.  # noqa: E501

        :return: The unreconciled_amount_neg of this StatementLinesResponse.  # noqa: E501
        :rtype: float
        """
        return self._unreconciled_amount_neg

    @unreconciled_amount_neg.setter
    def unreconciled_amount_neg(self, unreconciled_amount_neg):
        """Sets the unreconciled_amount_neg of this StatementLinesResponse.

        Sum of the amounts of all statement lines where both the reconciled flag is set to FALSE, and the amount is negative.  # noqa: E501

        :param unreconciled_amount_neg: The unreconciled_amount_neg of this StatementLinesResponse.  # noqa: E501
        :type: float
        """

        self._unreconciled_amount_neg = unreconciled_amount_neg

    @property
    def unreconciled_lines(self):
        """Gets the unreconciled_lines of this StatementLinesResponse.  # noqa: E501

        Count of all statement lines where the reconciled flag is set to FALSE.  # noqa: E501

        :return: The unreconciled_lines of this StatementLinesResponse.  # noqa: E501
        :rtype: int
        """
        return self._unreconciled_lines

    @unreconciled_lines.setter
    def unreconciled_lines(self, unreconciled_lines):
        """Sets the unreconciled_lines of this StatementLinesResponse.

        Count of all statement lines where the reconciled flag is set to FALSE.  # noqa: E501

        :param unreconciled_lines: The unreconciled_lines of this StatementLinesResponse.  # noqa: E501
        :type: int
        """

        self._unreconciled_lines = unreconciled_lines

    @property
    def avg_days_unreconciled_pos(self):
        """Gets the avg_days_unreconciled_pos of this StatementLinesResponse.  # noqa: E501

        Sum-product of age of statement line in days multiplied by transaction amount, divided by the sum of transaction amount - in for those statement lines in which the reconciled flag is set to FALSE, and the amount is positive. Provides an indication of the age of unreconciled transactions.  # noqa: E501

        :return: The avg_days_unreconciled_pos of this StatementLinesResponse.  # noqa: E501
        :rtype: float
        """
        return self._avg_days_unreconciled_pos

    @avg_days_unreconciled_pos.setter
    def avg_days_unreconciled_pos(self, avg_days_unreconciled_pos):
        """Sets the avg_days_unreconciled_pos of this StatementLinesResponse.

        Sum-product of age of statement line in days multiplied by transaction amount, divided by the sum of transaction amount - in for those statement lines in which the reconciled flag is set to FALSE, and the amount is positive. Provides an indication of the age of unreconciled transactions.  # noqa: E501

        :param avg_days_unreconciled_pos: The avg_days_unreconciled_pos of this StatementLinesResponse.  # noqa: E501
        :type: float
        """

        self._avg_days_unreconciled_pos = avg_days_unreconciled_pos

    @property
    def avg_days_unreconciled_neg(self):
        """Gets the avg_days_unreconciled_neg of this StatementLinesResponse.  # noqa: E501

        Sum-product of age of statement line in days multiplied by transaction amount, divided by the sum of transaction amount - in for those statement lines in which the reconciled flag is set to FALSE, and the amount is negative. Provides an indication of the age of unreconciled transactions.  # noqa: E501

        :return: The avg_days_unreconciled_neg of this StatementLinesResponse.  # noqa: E501
        :rtype: float
        """
        return self._avg_days_unreconciled_neg

    @avg_days_unreconciled_neg.setter
    def avg_days_unreconciled_neg(self, avg_days_unreconciled_neg):
        """Sets the avg_days_unreconciled_neg of this StatementLinesResponse.

        Sum-product of age of statement line in days multiplied by transaction amount, divided by the sum of transaction amount - in for those statement lines in which the reconciled flag is set to FALSE, and the amount is negative. Provides an indication of the age of unreconciled transactions.  # noqa: E501

        :param avg_days_unreconciled_neg: The avg_days_unreconciled_neg of this StatementLinesResponse.  # noqa: E501
        :type: float
        """

        self._avg_days_unreconciled_neg = avg_days_unreconciled_neg

    @property
    def earliest_unreconciled_transaction(self):
        """Gets the earliest_unreconciled_transaction of this StatementLinesResponse.  # noqa: E501

        UTC Date which is the earliest transaction date of a statement line for which the reconciled flag is set to FALSE.  This date is represented in ISO 8601 format.  # noqa: E501

        :return: The earliest_unreconciled_transaction of this StatementLinesResponse.  # noqa: E501
        :rtype: date
        """
        return self._earliest_unreconciled_transaction

    @earliest_unreconciled_transaction.setter
    def earliest_unreconciled_transaction(self, earliest_unreconciled_transaction):
        """Sets the earliest_unreconciled_transaction of this StatementLinesResponse.

        UTC Date which is the earliest transaction date of a statement line for which the reconciled flag is set to FALSE.  This date is represented in ISO 8601 format.  # noqa: E501

        :param earliest_unreconciled_transaction: The earliest_unreconciled_transaction of this StatementLinesResponse.  # noqa: E501
        :type: date
        """

        self._earliest_unreconciled_transaction = earliest_unreconciled_transaction

    @property
    def latest_unreconciled_transaction(self):
        """Gets the latest_unreconciled_transaction of this StatementLinesResponse.  # noqa: E501

        UTC Date which is the latest transaction date of a statement line for which the reconciled flag is set to FALSE.  This date is represented in ISO 8601 format.  # noqa: E501

        :return: The latest_unreconciled_transaction of this StatementLinesResponse.  # noqa: E501
        :rtype: date
        """
        return self._latest_unreconciled_transaction

    @latest_unreconciled_transaction.setter
    def latest_unreconciled_transaction(self, latest_unreconciled_transaction):
        """Sets the latest_unreconciled_transaction of this StatementLinesResponse.

        UTC Date which is the latest transaction date of a statement line for which the reconciled flag is set to FALSE.  This date is represented in ISO 8601 format.  # noqa: E501

        :param latest_unreconciled_transaction: The latest_unreconciled_transaction of this StatementLinesResponse.  # noqa: E501
        :type: date
        """

        self._latest_unreconciled_transaction = latest_unreconciled_transaction

    @property
    def deleted_amount(self):
        """Gets the deleted_amount of this StatementLinesResponse.  # noqa: E501

        Sum of the amounts of all deleted statement lines.  Transactions may be deleted due to duplication or otherwise.  # noqa: E501

        :return: The deleted_amount of this StatementLinesResponse.  # noqa: E501
        :rtype: float
        """
        return self._deleted_amount

    @deleted_amount.setter
    def deleted_amount(self, deleted_amount):
        """Sets the deleted_amount of this StatementLinesResponse.

        Sum of the amounts of all deleted statement lines.  Transactions may be deleted due to duplication or otherwise.  # noqa: E501

        :param deleted_amount: The deleted_amount of this StatementLinesResponse.  # noqa: E501
        :type: float
        """

        self._deleted_amount = deleted_amount

    @property
    def total_amount(self):
        """Gets the total_amount of this StatementLinesResponse.  # noqa: E501

        Sum of the amounts of all statement lines.  This is used as a metric of comparison to the unreconciled figures above.  # noqa: E501

        :return: The total_amount of this StatementLinesResponse.  # noqa: E501
        :rtype: float
        """
        return self._total_amount

    @total_amount.setter
    def total_amount(self, total_amount):
        """Sets the total_amount of this StatementLinesResponse.

        Sum of the amounts of all statement lines.  This is used as a metric of comparison to the unreconciled figures above.  # noqa: E501

        :param total_amount: The total_amount of this StatementLinesResponse.  # noqa: E501
        :type: float
        """

        self._total_amount = total_amount

    @property
    def data_source(self):
        """Gets the data_source of this StatementLinesResponse.  # noqa: E501


        :return: The data_source of this StatementLinesResponse.  # noqa: E501
        :rtype: DataSourceResponse
        """
        return self._data_source

    @data_source.setter
    def data_source(self, data_source):
        """Sets the data_source of this StatementLinesResponse.


        :param data_source: The data_source of this StatementLinesResponse.  # noqa: E501
        :type: DataSourceResponse
        """

        self._data_source = data_source

    @property
    def earliest_reconciled_transaction(self):
        """Gets the earliest_reconciled_transaction of this StatementLinesResponse.  # noqa: E501

        UTC Date which is the earliest transaction date of a statement line for which the reconciled flag is set to TRUE.  This date is represented in ISO 8601 format.  # noqa: E501

        :return: The earliest_reconciled_transaction of this StatementLinesResponse.  # noqa: E501
        :rtype: date
        """
        return self._earliest_reconciled_transaction

    @earliest_reconciled_transaction.setter
    def earliest_reconciled_transaction(self, earliest_reconciled_transaction):
        """Sets the earliest_reconciled_transaction of this StatementLinesResponse.

        UTC Date which is the earliest transaction date of a statement line for which the reconciled flag is set to TRUE.  This date is represented in ISO 8601 format.  # noqa: E501

        :param earliest_reconciled_transaction: The earliest_reconciled_transaction of this StatementLinesResponse.  # noqa: E501
        :type: date
        """

        self._earliest_reconciled_transaction = earliest_reconciled_transaction

    @property
    def latest_reconciled_transaction(self):
        """Gets the latest_reconciled_transaction of this StatementLinesResponse.  # noqa: E501

        UTC Date which is the latest transaction date of a statement line for which the reconciled flag is set to TRUE.  This date is represented in ISO 8601 format.  # noqa: E501

        :return: The latest_reconciled_transaction of this StatementLinesResponse.  # noqa: E501
        :rtype: date
        """
        return self._latest_reconciled_transaction

    @latest_reconciled_transaction.setter
    def latest_reconciled_transaction(self, latest_reconciled_transaction):
        """Sets the latest_reconciled_transaction of this StatementLinesResponse.

        UTC Date which is the latest transaction date of a statement line for which the reconciled flag is set to TRUE.  This date is represented in ISO 8601 format.  # noqa: E501

        :param latest_reconciled_transaction: The latest_reconciled_transaction of this StatementLinesResponse.  # noqa: E501
        :type: date
        """

        self._latest_reconciled_transaction = latest_reconciled_transaction

    @property
    def reconciled_amount_pos(self):
        """Gets the reconciled_amount_pos of this StatementLinesResponse.  # noqa: E501

        Sum of the amounts of all statement lines where both the reconciled flag is set to TRUE, and the amount is positive.  # noqa: E501

        :return: The reconciled_amount_pos of this StatementLinesResponse.  # noqa: E501
        :rtype: float
        """
        return self._reconciled_amount_pos

    @reconciled_amount_pos.setter
    def reconciled_amount_pos(self, reconciled_amount_pos):
        """Sets the reconciled_amount_pos of this StatementLinesResponse.

        Sum of the amounts of all statement lines where both the reconciled flag is set to TRUE, and the amount is positive.  # noqa: E501

        :param reconciled_amount_pos: The reconciled_amount_pos of this StatementLinesResponse.  # noqa: E501
        :type: float
        """

        self._reconciled_amount_pos = reconciled_amount_pos

    @property
    def reconciled_amount_neg(self):
        """Gets the reconciled_amount_neg of this StatementLinesResponse.  # noqa: E501

        Sum of the amounts of all statement lines where both the reconciled flag is set to TRUE, and the amount is negative.  # noqa: E501

        :return: The reconciled_amount_neg of this StatementLinesResponse.  # noqa: E501
        :rtype: float
        """
        return self._reconciled_amount_neg

    @reconciled_amount_neg.setter
    def reconciled_amount_neg(self, reconciled_amount_neg):
        """Sets the reconciled_amount_neg of this StatementLinesResponse.

        Sum of the amounts of all statement lines where both the reconciled flag is set to TRUE, and the amount is negative.  # noqa: E501

        :param reconciled_amount_neg: The reconciled_amount_neg of this StatementLinesResponse.  # noqa: E501
        :type: float
        """

        self._reconciled_amount_neg = reconciled_amount_neg

    @property
    def reconciled_lines(self):
        """Gets the reconciled_lines of this StatementLinesResponse.  # noqa: E501

        Count of all statement lines where the reconciled flag is set to TRUE  # noqa: E501

        :return: The reconciled_lines of this StatementLinesResponse.  # noqa: E501
        :rtype: int
        """
        return self._reconciled_lines

    @reconciled_lines.setter
    def reconciled_lines(self, reconciled_lines):
        """Sets the reconciled_lines of this StatementLinesResponse.

        Count of all statement lines where the reconciled flag is set to TRUE  # noqa: E501

        :param reconciled_lines: The reconciled_lines of this StatementLinesResponse.  # noqa: E501
        :type: int
        """

        self._reconciled_lines = reconciled_lines

    @property
    def total_amount_pos(self):
        """Gets the total_amount_pos of this StatementLinesResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the amount is positive  # noqa: E501

        :return: The total_amount_pos of this StatementLinesResponse.  # noqa: E501
        :rtype: float
        """
        return self._total_amount_pos

    @total_amount_pos.setter
    def total_amount_pos(self, total_amount_pos):
        """Sets the total_amount_pos of this StatementLinesResponse.

        Sum of the amounts of all statement lines where the amount is positive  # noqa: E501

        :param total_amount_pos: The total_amount_pos of this StatementLinesResponse.  # noqa: E501
        :type: float
        """

        self._total_amount_pos = total_amount_pos

    @property
    def total_amount_neg(self):
        """Gets the total_amount_neg of this StatementLinesResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the amount is negative.  # noqa: E501

        :return: The total_amount_neg of this StatementLinesResponse.  # noqa: E501
        :rtype: float
        """
        return self._total_amount_neg

    @total_amount_neg.setter
    def total_amount_neg(self, total_amount_neg):
        """Sets the total_amount_neg of this StatementLinesResponse.

        Sum of the amounts of all statement lines where the amount is negative.  # noqa: E501

        :param total_amount_neg: The total_amount_neg of this StatementLinesResponse.  # noqa: E501
        :type: float
        """

        self._total_amount_neg = total_amount_neg
