#!/usr/bin/env Rscript
# @author: M. Bernt
#
# This is a confidential release. Do not redistribute without 
# permission of the author (bernt@informatik.uni-leipzig.de).
#
# R script to plot the rna.dat generated by mitos
# parameters 
# 1. path to rna.dat
# 2. length of the sequence
# 3. path to pdf 

library(ggplot2)
library(grid)
library(scales)

reverselog_trans <- function(base = exp(1)) {
    trans <- function(x) -log(x, base)
    inv <- function(x) base^(-x)
    trans_new(paste("reverselog-", format(base), sep=""), trans, inv, 
              log_breaks(base = base), 
              domain = c(1e-100, Inf))
}

args<-commandArgs(T)

if( length(args) != 3 ){
	quit(save="no", 2);
}

t <- read.table(args[1], col.names= c("start","stop","strand","name","type","evalue","mode", "priority"))
# return normal if no lines in the input
if ( nrow(t) == 0) {
	print("no lines available in the file")
	quit(save="no", 0);
}
t$mid <- t$start+(t$stop-t$start)/2
t$sname<-sub("trn", "", t$name)

length <- as.integer(args[2])

lmts <- c(min(t$evalue), max(t$evalue))
pdf(args[3], width=16, height=7)
p <- ggplot() 

for ( s in c(-1,+1) ){
	if( s == -1){
		aend <- "first"
	}else{
		aend <- "last"
	}
	as <- subset(t,strand==s)
	if( nrow(as) ){
		p <- p + geom_segment(data = as, aes(x=start,xend=stop,y=evalue,yend=evalue, linetype=factor(mode), color=factor(priority)),arrow = arrow(angle=20, length = unit(0.2,"cm"), type="closed", ends=aend ), size=1) 
	}
#	p <- p +geom_segment(data = subset(t, strand==-1), aes(x=stop,xend=start,y=evalue, yend=evalue, color=factor(priority)),arrow = arrow(angle=20, length = unit(0.2,"cm"), type="closed"), size=1) 
}
p <- p + geom_text(data = t, aes(x=mid,y=evalue,label=sname, angle=0, vjust=1.2)) 
# apply logscale only if there is more than 1 value
if( lmts[1] != lmts[2] ){
	p <- p +scale_y_continuous( expand=c(0,1), trans=reverselog_trans(10), breaks = trans_breaks("log10", function(x) 10^x), labels = trans_format("log10", math_format(10^.x)) ) 
	#p <- p + scale_y_log10( ) 
}
p <- p +scale_x_continuous( limits = c(0,length), name = "position", expand=c(0,50), breaks=(1:(length/1000)*1000), minor_breaks=(1:(length/100)*100)  )
#	coord_polar()+
p <- p + scale_linetype(name="mode")
p <- p + scale_colour_manual(values=c("red", "black"), name="priority")
p <- p + theme(legend.key.width = unit(1.25, "cm"), legend.position="top", legend.box ="horizontal")
p <- p + theme_bw(base_size=20)
if ( length > 20000) {
	p <- p + theme(axis.text.x = element_text(angle = 90))
}

print(p)
dev.off()

