#!/usr/bin/env Rscript
# @author: M. Bernt
#
# This is a confidential release. Do not redistribute without 
# permission of the author (bernt@informatik.uni-leipzig.de).
#
# R script to plot the blast.dat file generated by the mitos webserver
# parameters 
# 1. path to blast.dat
# 2. path to result file
# 3. path to pdf 
# 4. length of the sequence
 
library(ggplot2, quietly = T)
library(grid)
library(scales)
args<-commandArgs(T)

if( length(args) != 4 ){
	quit(save="no", 2);
}

length<-as.integer(args[4])

t <- read.table(args[1], col.names= c("pos","name","rf","score","query", "yreuq")) 

# # get names and number of the genes 
# t$namet<-substr(t$name, 0, 3)
# t$namen<-substr(t$name, 4, 5)

# cob<-(t$name %in% c("cob"))
# t$namen[cob]<- "1"

# atp8<-(t$namen %in% c("8"))
# t$namen[atp8]<- "8/4l"

# fourL<-(t$namen %in% c("4l"))
# t$namen[fourL]<- "8/4l"


# return normal if no lines in the input
if ( nrow(t) == 0) {
	print("no lines available in the file")
	quit(save="no", 0);
}

# get max quality value and length 
mx = max(t$score)*1.5

a<-read.table(args[2], col.names= c("acc","type","name","method","start","stop","strand","score","acodonpos","acodon","part","copy","struct", "bitscore")  )
if( nrow(a)>0 ){
	a$r <- c(1:nrow(a))
	a$mod <- (a$r %% 2) + (a$r %% 2)*0.2 - ((a$r+1) %% 2)*0.2
}


# # choose colors (4 of the )
# RC<-rgb(228,26,28, maxColorValue=255 )
# BC<-rgb(55,126,184, maxColorValue=255 )
# GC<-rgb(77,175,74, maxColorValue=255 )
# OC<-rgb(255,127,0, maxColorValue=255 )

p <- ggplot()
p <- p + geom_path(data=t, aes(x=pos, y=score, colour=name), size=1.2)
#	geom_path(data=t, aes(x=pos, y=score, colour=namet, linetype=namen), size=1)+
#	geom_ribbon(data=t, aes(x=pos, ymax=score, ymin=0, fill=namet, linetype=namen), size=1, alpha=0.5, colour="black")+

for ( s in c(-1,+1) ){
	as <- subset(a,strand==s)
	if( s == -1){
		aend <- "first"
	}else{
		aend <- "last"
	}
	
	if( nrow( as ) ){
		p <- p + geom_segment(data=as, aes(x = start, xend=stop, y=mx, yend=mx), arrow = arrow(angle=20, length = unit(0.2,"cm"), type="closed", ends=aend))
	}
}

if( nrow(a) > 0 ){
	p <- p + geom_text(data=a, aes(x=start+(stop-start)/2, y=mx, label=name, angle=90, hjust=mod) )
} 
p <- p + scale_y_log10( limits=c(1,1.5*mx), name="quality", breaks = trans_breaks("log10", function(x) 10^x), labels = trans_format("log10", math_format(10^.x)) ) 
p <- p + scale_x_continuous( limits=c(0,length), name = "position", expand=c(0,50), breaks=(1:(length/1000)*1000), minor_breaks=(1:(length/100)*100))
# p <- p + facet_wrap( ~ name, ncol=1) 
#	scale_colour_brewer(palette="Set1", name="type") +
#	scale_fill_brewer(palette="Set1", name="type") +
#	scale_colour_manual(name = "type", values = c(RC, BC, GC, OC))+
#	scale_linetype(name="nr")+
#	coord_polar()+
p <- p + theme_bw( base_size = 20 )
p <- p + theme(legend.key.width = unit(1.25, "cm"), legend.position="top", legend.box ="horizontal")
if ( length > 20000) {
	p <- p + theme(axis.text.x = element_text(angle = 90))
}
pdf(args[3], width=50, height=9)
print( p )
dev.off()