# pyrena

API wrapper for interacting with Arena QMS.

Pyrena is not associated with or approved by Arena Solutions or PTC.

## Installation

`pip install pyrena`

## Docs

Documentation generated by Pyrena self-introspecting its own code. This goes into more detail than this readme.

```python
import pyrena
pyrena.docs()
```

## Usage

### Create client

```python
import pyrena

client = pyrena.Arena("username", "password")
```

If you access your account via `app.arenagov.com` instead of `app.bom.com`, then you should add the parameter `base_url="https://api.arenagov.com/v1/v1"` during client creation.

### Change users

```python
client.logout()
client.login("different_username", "different_password")
```

### Search

Define an object type and search parameters to get a list of results. Functions equivalently to top bar search on Arena website; however searching based on custom attributes must use the custom attribute GUID. See Arena help documentation on app.bom.com

```python
search_results = client.Listing(client.QualityProcess, name="name keyword here")
```

### Retrieve specific object by GUID

```python
my_change_order = client.Change("object_guid")
```

### Retrieve specific object by number

This is a search that yields one object in a list, and then you take entry [0] from that list.

```python
my_item = client.Listing(client.Item, number="PART-12345")[0]
```

### Make changes to an object

```python
my_wr = my_item.working_revision
my_wr.update(name = "new name here")
```