# DOSMA: Deep Open-Source MRI Analysis

This repository hosts an open-source Python library for MRI processing techniques. This includes, but is not limited to:
- image processing tasks (denoising, super-resolution, segmentation, etc.)
- relaxation parameter analysis (T1, T1-rho, T2, T2*, etc.)
- anatomical features (patellar tilt, femoral cartilage thickness, etc.)

We hope that this open-source pipeline will be useful for quick anatomy/pathology analysis from MRI and will serve as a 
hub for adding support for analyzing different anatomies and scan sequences.

[Documentation](https://ad12.github.io/DOSMA)

[Questionnaire](https://forms.gle/sprthTC2swyt8dDb6)

## How to Cite
```
@inproceedings{desai2019dosma,
   Title={DOSMA: A deep-learning, open-source framework for musculoskeletal MRI analysis.},
   Author =  {Desai, Arjun D and Barbieri, Marco and Mazzoli, Valentina and Rubin, Elka and Black, Marianne S and Watkins, Lauren E and Gold, Garry E and Hargreaves, Brian A and Chaudhari, Akshay S},
   Booktitle={Proc. Intl. Soc. Mag. Reson. Med},
   Volume={27},
   Number={1106},
   Year={2019}
}
```

In addition to DOSMA, please also consider citing the work that introduced the method used for analysis.