"""
mypy stub for unicorn
"""


class Uc(object):

    def __init__(self, arch, mode): ...

    def emu_start(self, begin, until, timeout=0, count=0): ...

    def emu_stop(self): ...

    def reg_read(self, reg_id, opt=None): ...

    def reg_write(self, reg_id, value): ...

    def msr_read(self, msr_id): ...

    def msr_write(self, msr_id, value): ...

    def mem_read(self, address, size): ...

    def mem_write(self, address, data): ...

    def mem_map(self, address, size, perms: int = ...): ...

    def mem_map_ptr(self, address, size, perms, ptr): ...

    def mem_unmap(self, address, size): ...

    def mem_protect(self, address, size, perms: int = ...): ...

    def query(self, query_mode): ...

    def hook_add(self, htype, callback, user_data=None, begin=1, end=0, arg1=0): ...

    def hook_del(self, h): ...

    def context_save(self): ...

    def context_update(self, context): ...

    def context_restore(self, context): ...

    def mem_regions(self): ...


class UcError(BaseException): ...

# Constants
UC_API_MAJOR: int
UC_API_MINOR: int
UC_VERSION_MAJOR: int
UC_VERSION_MINOR: int
UC_VERSION_EXTRA: int
UC_SECOND_SCALE: int
UC_MILISECOND_SCALE: int
UC_ARCH_ARM: int
UC_ARCH_ARM64: int
UC_ARCH_MIPS: int
UC_ARCH_X86: int
UC_ARCH_PPC: int
UC_ARCH_SPARC: int
UC_ARCH_M68K: int
UC_ARCH_MAX: int
UC_MODE_LITTLE_ENDIAN: int
UC_MODE_BIG_ENDIAN: int
UC_MODE_ARM: int
UC_MODE_THUMB: int
UC_MODE_MCLASS: int
UC_MODE_V8: int
UC_MODE_ARM926: int
UC_MODE_ARM946: int
UC_MODE_ARM1176: int
UC_MODE_MICRO: int
UC_MODE_MIPS3: int
UC_MODE_MIPS32R6: int
UC_MODE_MIPS32: int
UC_MODE_MIPS64: int
UC_MODE_16: int
UC_MODE_32: int
UC_MODE_64: int
UC_MODE_PPC32: int
UC_MODE_PPC64: int
UC_MODE_QPX: int
UC_MODE_SPARC32: int
UC_MODE_SPARC64: int
UC_MODE_V9: int
UC_ERR_OK: int
UC_ERR_NOMEM: int
UC_ERR_ARCH: int
UC_ERR_HANDLE: int
UC_ERR_MODE: int
UC_ERR_VERSION: int
UC_ERR_READ_UNMAPPED: int
UC_ERR_WRITE_UNMAPPED: int
UC_ERR_FETCH_UNMAPPED: int
UC_ERR_HOOK: int
UC_ERR_INSN_INVALID: int
UC_ERR_MAP: int
UC_ERR_WRITE_PROT: int
UC_ERR_READ_PROT: int
UC_ERR_FETCH_PROT: int
UC_ERR_ARG: int
UC_ERR_READ_UNALIGNED: int
UC_ERR_WRITE_UNALIGNED: int
UC_ERR_FETCH_UNALIGNED: int
UC_ERR_HOOK_EXIST: int
UC_ERR_RESOURCE: int
UC_ERR_EXCEPTION: int
UC_MEM_READ: int
UC_MEM_WRITE: int
UC_MEM_FETCH: int
UC_MEM_READ_UNMAPPED: int
UC_MEM_WRITE_UNMAPPED: int
UC_MEM_FETCH_UNMAPPED: int
UC_MEM_WRITE_PROT: int
UC_MEM_READ_PROT: int
UC_MEM_FETCH_PROT: int
UC_MEM_READ_AFTER: int
UC_HOOK_INTR: int
UC_HOOK_INSN: int
UC_HOOK_CODE: int
UC_HOOK_BLOCK: int
UC_HOOK_MEM_READ_UNMAPPED: int
UC_HOOK_MEM_WRITE_UNMAPPED: int
UC_HOOK_MEM_FETCH_UNMAPPED: int
UC_HOOK_MEM_READ_PROT: int
UC_HOOK_MEM_WRITE_PROT: int
UC_HOOK_MEM_FETCH_PROT: int
UC_HOOK_MEM_READ: int
UC_HOOK_MEM_WRITE: int
UC_HOOK_MEM_FETCH: int
UC_HOOK_MEM_READ_AFTER: int
UC_HOOK_INSN_INVALID: int
UC_HOOK_MEM_UNMAPPED: int
UC_HOOK_MEM_PROT: int
UC_HOOK_MEM_READ_INVALID: int
UC_HOOK_MEM_WRITE_INVALID: int
UC_HOOK_MEM_FETCH_INVALID: int
UC_HOOK_MEM_INVALID: int
UC_HOOK_MEM_VALID: int
UC_QUERY_MODE: int
UC_QUERY_PAGE_SIZE: int
UC_QUERY_ARCH: int
UC_QUERY_TIMEOUT: int
UC_PROT_NONE: int
UC_PROT_READ: int
UC_PROT_WRITE: int
UC_PROT_EXEC: int
UC_PROT_ALL: int

# X86 registers
UC_X86_REG_INVALID: int
UC_X86_REG_AH: int
UC_X86_REG_AL: int
UC_X86_REG_AX: int
UC_X86_REG_BH: int
UC_X86_REG_BL: int
UC_X86_REG_BP: int
UC_X86_REG_BPL: int
UC_X86_REG_BX: int
UC_X86_REG_CH: int
UC_X86_REG_CL: int
UC_X86_REG_CS: int
UC_X86_REG_CX: int
UC_X86_REG_DH: int
UC_X86_REG_DI: int
UC_X86_REG_DIL: int
UC_X86_REG_DL: int
UC_X86_REG_DS: int
UC_X86_REG_DX: int
UC_X86_REG_EAX: int
UC_X86_REG_EBP: int
UC_X86_REG_EBX: int
UC_X86_REG_ECX: int
UC_X86_REG_EDI: int
UC_X86_REG_EDX: int
UC_X86_REG_EFLAGS: int
UC_X86_REG_EIP: int
UC_X86_REG_EIZ: int
UC_X86_REG_ES: int
UC_X86_REG_ESI: int
UC_X86_REG_ESP: int
UC_X86_REG_FPSW: int
UC_X86_REG_FS: int
UC_X86_REG_GS: int
UC_X86_REG_IP: int
UC_X86_REG_RAX: int
UC_X86_REG_RBP: int
UC_X86_REG_RBX: int
UC_X86_REG_RCX: int
UC_X86_REG_RDI: int
UC_X86_REG_RDX: int
UC_X86_REG_RIP: int
UC_X86_REG_RIZ: int
UC_X86_REG_RSI: int
UC_X86_REG_RSP: int
UC_X86_REG_SI: int
UC_X86_REG_SIL: int
UC_X86_REG_SP: int
UC_X86_REG_SPL: int
UC_X86_REG_SS: int
UC_X86_REG_CR0: int
UC_X86_REG_CR1: int
UC_X86_REG_CR2: int
UC_X86_REG_CR3: int
UC_X86_REG_CR4: int
UC_X86_REG_CR5: int
UC_X86_REG_CR6: int
UC_X86_REG_CR7: int
UC_X86_REG_CR8: int
UC_X86_REG_CR9: int
UC_X86_REG_CR10: int
UC_X86_REG_CR11: int
UC_X86_REG_CR12: int
UC_X86_REG_CR13: int
UC_X86_REG_CR14: int
UC_X86_REG_CR15: int
UC_X86_REG_DR0: int
UC_X86_REG_DR1: int
UC_X86_REG_DR2: int
UC_X86_REG_DR3: int
UC_X86_REG_DR4: int
UC_X86_REG_DR5: int
UC_X86_REG_DR6: int
UC_X86_REG_DR7: int
UC_X86_REG_DR8: int
UC_X86_REG_DR9: int
UC_X86_REG_DR10: int
UC_X86_REG_DR11: int
UC_X86_REG_DR12: int
UC_X86_REG_DR13: int
UC_X86_REG_DR14: int
UC_X86_REG_DR15: int
UC_X86_REG_FP0: int
UC_X86_REG_FP1: int
UC_X86_REG_FP2: int
UC_X86_REG_FP3: int
UC_X86_REG_FP4: int
UC_X86_REG_FP5: int
UC_X86_REG_FP6: int
UC_X86_REG_FP7: int
UC_X86_REG_K0: int
UC_X86_REG_K1: int
UC_X86_REG_K2: int
UC_X86_REG_K3: int
UC_X86_REG_K4: int
UC_X86_REG_K5: int
UC_X86_REG_K6: int
UC_X86_REG_K7: int
UC_X86_REG_MM0: int
UC_X86_REG_MM1: int
UC_X86_REG_MM2: int
UC_X86_REG_MM3: int
UC_X86_REG_MM4: int
UC_X86_REG_MM5: int
UC_X86_REG_MM6: int
UC_X86_REG_MM7: int
UC_X86_REG_R8: int
UC_X86_REG_R9: int
UC_X86_REG_R10: int
UC_X86_REG_R11: int
UC_X86_REG_R12: int
UC_X86_REG_R13: int
UC_X86_REG_R14: int
UC_X86_REG_R15: int
UC_X86_REG_ST0: int
UC_X86_REG_ST1: int
UC_X86_REG_ST2: int
UC_X86_REG_ST3: int
UC_X86_REG_ST4: int
UC_X86_REG_ST5: int
UC_X86_REG_ST6: int
UC_X86_REG_ST7: int
UC_X86_REG_XMM0: int
UC_X86_REG_XMM1: int
UC_X86_REG_XMM2: int
UC_X86_REG_XMM3: int
UC_X86_REG_XMM4: int
UC_X86_REG_XMM5: int
UC_X86_REG_XMM6: int
UC_X86_REG_XMM7: int
UC_X86_REG_XMM8: int
UC_X86_REG_XMM9: int
UC_X86_REG_XMM10: int
UC_X86_REG_XMM11: int
UC_X86_REG_XMM12: int
UC_X86_REG_XMM13: int
UC_X86_REG_XMM14: int
UC_X86_REG_XMM15: int
UC_X86_REG_XMM16: int
UC_X86_REG_XMM17: int
UC_X86_REG_XMM18: int
UC_X86_REG_XMM19: int
UC_X86_REG_XMM20: int
UC_X86_REG_XMM21: int
UC_X86_REG_XMM22: int
UC_X86_REG_XMM23: int
UC_X86_REG_XMM24: int
UC_X86_REG_XMM25: int
UC_X86_REG_XMM26: int
UC_X86_REG_XMM27: int
UC_X86_REG_XMM28: int
UC_X86_REG_XMM29: int
UC_X86_REG_XMM30: int
UC_X86_REG_XMM31: int
UC_X86_REG_YMM0: int
UC_X86_REG_YMM1: int
UC_X86_REG_YMM2: int
UC_X86_REG_YMM3: int
UC_X86_REG_YMM4: int
UC_X86_REG_YMM5: int
UC_X86_REG_YMM6: int
UC_X86_REG_YMM7: int
UC_X86_REG_YMM8: int
UC_X86_REG_YMM9: int
UC_X86_REG_YMM10: int
UC_X86_REG_YMM11: int
UC_X86_REG_YMM12: int
UC_X86_REG_YMM13: int
UC_X86_REG_YMM14: int
UC_X86_REG_YMM15: int
UC_X86_REG_YMM16: int
UC_X86_REG_YMM17: int
UC_X86_REG_YMM18: int
UC_X86_REG_YMM19: int
UC_X86_REG_YMM20: int
UC_X86_REG_YMM21: int
UC_X86_REG_YMM22: int
UC_X86_REG_YMM23: int
UC_X86_REG_YMM24: int
UC_X86_REG_YMM25: int
UC_X86_REG_YMM26: int
UC_X86_REG_YMM27: int
UC_X86_REG_YMM28: int
UC_X86_REG_YMM29: int
UC_X86_REG_YMM30: int
UC_X86_REG_YMM31: int
UC_X86_REG_ZMM0: int
UC_X86_REG_ZMM1: int
UC_X86_REG_ZMM2: int
UC_X86_REG_ZMM3: int
UC_X86_REG_ZMM4: int
UC_X86_REG_ZMM5: int
UC_X86_REG_ZMM6: int
UC_X86_REG_ZMM7: int
UC_X86_REG_ZMM8: int
UC_X86_REG_ZMM9: int
UC_X86_REG_ZMM10: int
UC_X86_REG_ZMM11: int
UC_X86_REG_ZMM12: int
UC_X86_REG_ZMM13: int
UC_X86_REG_ZMM14: int
UC_X86_REG_ZMM15: int
UC_X86_REG_ZMM16: int
UC_X86_REG_ZMM17: int
UC_X86_REG_ZMM18: int
UC_X86_REG_ZMM19: int
UC_X86_REG_ZMM20: int
UC_X86_REG_ZMM21: int
UC_X86_REG_ZMM22: int
UC_X86_REG_ZMM23: int
UC_X86_REG_ZMM24: int
UC_X86_REG_ZMM25: int
UC_X86_REG_ZMM26: int
UC_X86_REG_ZMM27: int
UC_X86_REG_ZMM28: int
UC_X86_REG_ZMM29: int
UC_X86_REG_ZMM30: int
UC_X86_REG_ZMM31: int
UC_X86_REG_R8B: int
UC_X86_REG_R9B: int
UC_X86_REG_R10B: int
UC_X86_REG_R11B: int
UC_X86_REG_R12B: int
UC_X86_REG_R13B: int
UC_X86_REG_R14B: int
UC_X86_REG_R15B: int
UC_X86_REG_R8D: int
UC_X86_REG_R9D: int
UC_X86_REG_R10D: int
UC_X86_REG_R11D: int
UC_X86_REG_R12D: int
UC_X86_REG_R13D: int
UC_X86_REG_R14D: int
UC_X86_REG_R15D: int
UC_X86_REG_R8W: int
UC_X86_REG_R9W: int
UC_X86_REG_R10W: int
UC_X86_REG_R11W: int
UC_X86_REG_R12W: int
UC_X86_REG_R13W: int
UC_X86_REG_R14W: int
UC_X86_REG_R15W: int
UC_X86_REG_IDTR: int
UC_X86_REG_GDTR: int
UC_X86_REG_LDTR: int
UC_X86_REG_TR: int
UC_X86_REG_FPCW: int
UC_X86_REG_FPTAG: int
UC_X86_REG_MSR: int
UC_X86_REG_MXCSR: int
UC_X86_REG_FS_BASE: int
UC_X86_REG_GS_BASE: int
UC_X86_REG_ENDING: int

# X86 instructions

UC_X86_INS_INVALID: int
UC_X86_INS_AAA: int
UC_X86_INS_AAD: int
UC_X86_INS_AAM: int
UC_X86_INS_AAS: int
UC_X86_INS_FABS: int
UC_X86_INS_ADC: int
UC_X86_INS_ADCX: int
UC_X86_INS_ADD: int
UC_X86_INS_ADDPD: int
UC_X86_INS_ADDPS: int
UC_X86_INS_ADDSD: int
UC_X86_INS_ADDSS: int
UC_X86_INS_ADDSUBPD: int
UC_X86_INS_ADDSUBPS: int
UC_X86_INS_FADD: int
UC_X86_INS_FIADD: int
UC_X86_INS_FADDP: int
UC_X86_INS_ADOX: int
UC_X86_INS_AESDECLAST: int
UC_X86_INS_AESDEC: int
UC_X86_INS_AESENCLAST: int
UC_X86_INS_AESENC: int
UC_X86_INS_AESIMC: int
UC_X86_INS_AESKEYGENASSIST: int
UC_X86_INS_AND: int
UC_X86_INS_ANDN: int
UC_X86_INS_ANDNPD: int
UC_X86_INS_ANDNPS: int
UC_X86_INS_ANDPD: int
UC_X86_INS_ANDPS: int
UC_X86_INS_ARPL: int
UC_X86_INS_BEXTR: int
UC_X86_INS_BLCFILL: int
UC_X86_INS_BLCI: int
UC_X86_INS_BLCIC: int
UC_X86_INS_BLCMSK: int
UC_X86_INS_BLCS: int
UC_X86_INS_BLENDPD: int
UC_X86_INS_BLENDPS: int
UC_X86_INS_BLENDVPD: int
UC_X86_INS_BLENDVPS: int
UC_X86_INS_BLSFILL: int
UC_X86_INS_BLSI: int
UC_X86_INS_BLSIC: int
UC_X86_INS_BLSMSK: int
UC_X86_INS_BLSR: int
UC_X86_INS_BOUND: int
UC_X86_INS_BSF: int
UC_X86_INS_BSR: int
UC_X86_INS_BSWAP: int
UC_X86_INS_BT: int
UC_X86_INS_BTC: int
UC_X86_INS_BTR: int
UC_X86_INS_BTS: int
UC_X86_INS_BZHI: int
UC_X86_INS_CALL: int
UC_X86_INS_CBW: int
UC_X86_INS_CDQ: int
UC_X86_INS_CDQE: int
UC_X86_INS_FCHS: int
UC_X86_INS_CLAC: int
UC_X86_INS_CLC: int
UC_X86_INS_CLD: int
UC_X86_INS_CLFLUSH: int
UC_X86_INS_CLFLUSHOPT: int
UC_X86_INS_CLGI: int
UC_X86_INS_CLI: int
UC_X86_INS_CLTS: int
UC_X86_INS_CLWB: int
UC_X86_INS_CMC: int
UC_X86_INS_CMOVA: int
UC_X86_INS_CMOVAE: int
UC_X86_INS_CMOVB: int
UC_X86_INS_CMOVBE: int
UC_X86_INS_FCMOVBE: int
UC_X86_INS_FCMOVB: int
UC_X86_INS_CMOVE: int
UC_X86_INS_FCMOVE: int
UC_X86_INS_CMOVG: int
UC_X86_INS_CMOVGE: int
UC_X86_INS_CMOVL: int
UC_X86_INS_CMOVLE: int
UC_X86_INS_FCMOVNBE: int
UC_X86_INS_FCMOVNB: int
UC_X86_INS_CMOVNE: int
UC_X86_INS_FCMOVNE: int
UC_X86_INS_CMOVNO: int
UC_X86_INS_CMOVNP: int
UC_X86_INS_FCMOVNU: int
UC_X86_INS_CMOVNS: int
UC_X86_INS_CMOVO: int
UC_X86_INS_CMOVP: int
UC_X86_INS_FCMOVU: int
UC_X86_INS_CMOVS: int
UC_X86_INS_CMP: int
UC_X86_INS_CMPPD: int
UC_X86_INS_CMPPS: int
UC_X86_INS_CMPSB: int
UC_X86_INS_CMPSD: int
UC_X86_INS_CMPSQ: int
UC_X86_INS_CMPSS: int
UC_X86_INS_CMPSW: int
UC_X86_INS_CMPXCHG16B: int
UC_X86_INS_CMPXCHG: int
UC_X86_INS_CMPXCHG8B: int
UC_X86_INS_COMISD: int
UC_X86_INS_COMISS: int
UC_X86_INS_FCOMP: int
UC_X86_INS_FCOMPI: int
UC_X86_INS_FCOMI: int
UC_X86_INS_FCOM: int
UC_X86_INS_FCOS: int
UC_X86_INS_CPUID: int
UC_X86_INS_CQO: int
UC_X86_INS_CRC32: int
UC_X86_INS_CVTDQ2PD: int
UC_X86_INS_CVTDQ2PS: int
UC_X86_INS_CVTPD2DQ: int
UC_X86_INS_CVTPD2PS: int
UC_X86_INS_CVTPS2DQ: int
UC_X86_INS_CVTPS2PD: int
UC_X86_INS_CVTSD2SI: int
UC_X86_INS_CVTSD2SS: int
UC_X86_INS_CVTSI2SD: int
UC_X86_INS_CVTSI2SS: int
UC_X86_INS_CVTSS2SD: int
UC_X86_INS_CVTSS2SI: int
UC_X86_INS_CVTTPD2DQ: int
UC_X86_INS_CVTTPS2DQ: int
UC_X86_INS_CVTTSD2SI: int
UC_X86_INS_CVTTSS2SI: int
UC_X86_INS_CWD: int
UC_X86_INS_CWDE: int
UC_X86_INS_DAA: int
UC_X86_INS_DAS: int
UC_X86_INS_DATA16: int
UC_X86_INS_DEC: int
UC_X86_INS_DIV: int
UC_X86_INS_DIVPD: int
UC_X86_INS_DIVPS: int
UC_X86_INS_FDIVR: int
UC_X86_INS_FIDIVR: int
UC_X86_INS_FDIVRP: int
UC_X86_INS_DIVSD: int
UC_X86_INS_DIVSS: int
UC_X86_INS_FDIV: int
UC_X86_INS_FIDIV: int
UC_X86_INS_FDIVP: int
UC_X86_INS_DPPD: int
UC_X86_INS_DPPS: int
UC_X86_INS_RET: int
UC_X86_INS_ENCLS: int
UC_X86_INS_ENCLU: int
UC_X86_INS_ENTER: int
UC_X86_INS_EXTRACTPS: int
UC_X86_INS_EXTRQ: int
UC_X86_INS_F2XM1: int
UC_X86_INS_LCALL: int
UC_X86_INS_LJMP: int
UC_X86_INS_FBLD: int
UC_X86_INS_FBSTP: int
UC_X86_INS_FCOMPP: int
UC_X86_INS_FDECSTP: int
UC_X86_INS_FEMMS: int
UC_X86_INS_FFREE: int
UC_X86_INS_FICOM: int
UC_X86_INS_FICOMP: int
UC_X86_INS_FINCSTP: int
UC_X86_INS_FLDCW: int
UC_X86_INS_FLDENV: int
UC_X86_INS_FLDL2E: int
UC_X86_INS_FLDL2T: int
UC_X86_INS_FLDLG2: int
UC_X86_INS_FLDLN2: int
UC_X86_INS_FLDPI: int
UC_X86_INS_FNCLEX: int
UC_X86_INS_FNINIT: int
UC_X86_INS_FNOP: int
UC_X86_INS_FNSTCW: int
UC_X86_INS_FNSTSW: int
UC_X86_INS_FPATAN: int
UC_X86_INS_FPREM: int
UC_X86_INS_FPREM1: int
UC_X86_INS_FPTAN: int
UC_X86_INS_FFREEP: int
UC_X86_INS_FRNDINT: int
UC_X86_INS_FRSTOR: int
UC_X86_INS_FNSAVE: int
UC_X86_INS_FSCALE: int
UC_X86_INS_FSETPM: int
UC_X86_INS_FSINCOS: int
UC_X86_INS_FNSTENV: int
UC_X86_INS_FXAM: int
UC_X86_INS_FXRSTOR: int
UC_X86_INS_FXRSTOR64: int
UC_X86_INS_FXSAVE: int
UC_X86_INS_FXSAVE64: int
UC_X86_INS_FXTRACT: int
UC_X86_INS_FYL2X: int
UC_X86_INS_FYL2XP1: int
UC_X86_INS_MOVAPD: int
UC_X86_INS_MOVAPS: int
UC_X86_INS_ORPD: int
UC_X86_INS_ORPS: int
UC_X86_INS_VMOVAPD: int
UC_X86_INS_VMOVAPS: int
UC_X86_INS_XORPD: int
UC_X86_INS_XORPS: int
UC_X86_INS_GETSEC: int
UC_X86_INS_HADDPD: int
UC_X86_INS_HADDPS: int
UC_X86_INS_HLT: int
UC_X86_INS_HSUBPD: int
UC_X86_INS_HSUBPS: int
UC_X86_INS_IDIV: int
UC_X86_INS_FILD: int
UC_X86_INS_IMUL: int
UC_X86_INS_IN: int
UC_X86_INS_INC: int
UC_X86_INS_INSB: int
UC_X86_INS_INSERTPS: int
UC_X86_INS_INSERTQ: int
UC_X86_INS_INSD: int
UC_X86_INS_INSW: int
UC_X86_INS_INT: int
UC_X86_INS_INT1: int
UC_X86_INS_INT3: int
UC_X86_INS_INTO: int
UC_X86_INS_INVD: int
UC_X86_INS_INVEPT: int
UC_X86_INS_INVLPG: int
UC_X86_INS_INVLPGA: int
UC_X86_INS_INVPCID: int
UC_X86_INS_INVVPID: int
UC_X86_INS_IRET: int
UC_X86_INS_IRETD: int
UC_X86_INS_IRETQ: int
UC_X86_INS_FISTTP: int
UC_X86_INS_FIST: int
UC_X86_INS_FISTP: int
UC_X86_INS_UCOMISD: int
UC_X86_INS_UCOMISS: int
UC_X86_INS_VCOMISD: int
UC_X86_INS_VCOMISS: int
UC_X86_INS_VCVTSD2SS: int
UC_X86_INS_VCVTSI2SD: int
UC_X86_INS_VCVTSI2SS: int
UC_X86_INS_VCVTSS2SD: int
UC_X86_INS_VCVTTSD2SI: int
UC_X86_INS_VCVTTSD2USI: int
UC_X86_INS_VCVTTSS2SI: int
UC_X86_INS_VCVTTSS2USI: int
UC_X86_INS_VCVTUSI2SD: int
UC_X86_INS_VCVTUSI2SS: int
UC_X86_INS_VUCOMISD: int
UC_X86_INS_VUCOMISS: int
UC_X86_INS_JAE: int
UC_X86_INS_JA: int
UC_X86_INS_JBE: int
UC_X86_INS_JB: int
UC_X86_INS_JCXZ: int
UC_X86_INS_JECXZ: int
UC_X86_INS_JE: int
UC_X86_INS_JGE: int
UC_X86_INS_JG: int
UC_X86_INS_JLE: int
UC_X86_INS_JL: int
UC_X86_INS_JMP: int
UC_X86_INS_JNE: int
UC_X86_INS_JNO: int
UC_X86_INS_JNP: int
UC_X86_INS_JNS: int
UC_X86_INS_JO: int
UC_X86_INS_JP: int
UC_X86_INS_JRCXZ: int
UC_X86_INS_JS: int
UC_X86_INS_KANDB: int
UC_X86_INS_KANDD: int
UC_X86_INS_KANDNB: int
UC_X86_INS_KANDND: int
UC_X86_INS_KANDNQ: int
UC_X86_INS_KANDNW: int
UC_X86_INS_KANDQ: int
UC_X86_INS_KANDW: int
UC_X86_INS_KMOVB: int
UC_X86_INS_KMOVD: int
UC_X86_INS_KMOVQ: int
UC_X86_INS_KMOVW: int
UC_X86_INS_KNOTB: int
UC_X86_INS_KNOTD: int
UC_X86_INS_KNOTQ: int
UC_X86_INS_KNOTW: int
UC_X86_INS_KORB: int
UC_X86_INS_KORD: int
UC_X86_INS_KORQ: int
UC_X86_INS_KORTESTB: int
UC_X86_INS_KORTESTD: int
UC_X86_INS_KORTESTQ: int
UC_X86_INS_KORTESTW: int
UC_X86_INS_KORW: int
UC_X86_INS_KSHIFTLB: int
UC_X86_INS_KSHIFTLD: int
UC_X86_INS_KSHIFTLQ: int
UC_X86_INS_KSHIFTLW: int
UC_X86_INS_KSHIFTRB: int
UC_X86_INS_KSHIFTRD: int
UC_X86_INS_KSHIFTRQ: int
UC_X86_INS_KSHIFTRW: int
UC_X86_INS_KUNPCKBW: int
UC_X86_INS_KXNORB: int
UC_X86_INS_KXNORD: int
UC_X86_INS_KXNORQ: int
UC_X86_INS_KXNORW: int
UC_X86_INS_KXORB: int
UC_X86_INS_KXORD: int
UC_X86_INS_KXORQ: int
UC_X86_INS_KXORW: int
UC_X86_INS_LAHF: int
UC_X86_INS_LAR: int
UC_X86_INS_LDDQU: int
UC_X86_INS_LDMXCSR: int
UC_X86_INS_LDS: int
UC_X86_INS_FLDZ: int
UC_X86_INS_FLD1: int
UC_X86_INS_FLD: int
UC_X86_INS_LEA: int
UC_X86_INS_LEAVE: int
UC_X86_INS_LES: int
UC_X86_INS_LFENCE: int
UC_X86_INS_LFS: int
UC_X86_INS_LGDT: int
UC_X86_INS_LGS: int
UC_X86_INS_LIDT: int
UC_X86_INS_LLDT: int
UC_X86_INS_LMSW: int
UC_X86_INS_OR: int
UC_X86_INS_SUB: int
UC_X86_INS_XOR: int
UC_X86_INS_LODSB: int
UC_X86_INS_LODSD: int
UC_X86_INS_LODSQ: int
UC_X86_INS_LODSW: int
UC_X86_INS_LOOP: int
UC_X86_INS_LOOPE: int
UC_X86_INS_LOOPNE: int
UC_X86_INS_RETF: int
UC_X86_INS_RETFQ: int
UC_X86_INS_LSL: int
UC_X86_INS_LSS: int
UC_X86_INS_LTR: int
UC_X86_INS_XADD: int
UC_X86_INS_LZCNT: int
UC_X86_INS_MASKMOVDQU: int
UC_X86_INS_MAXPD: int
UC_X86_INS_MAXPS: int
UC_X86_INS_MAXSD: int
UC_X86_INS_MAXSS: int
UC_X86_INS_MFENCE: int
UC_X86_INS_MINPD: int
UC_X86_INS_MINPS: int
UC_X86_INS_MINSD: int
UC_X86_INS_MINSS: int
UC_X86_INS_CVTPD2PI: int
UC_X86_INS_CVTPI2PD: int
UC_X86_INS_CVTPI2PS: int
UC_X86_INS_CVTPS2PI: int
UC_X86_INS_CVTTPD2PI: int
UC_X86_INS_CVTTPS2PI: int
UC_X86_INS_EMMS: int
UC_X86_INS_MASKMOVQ: int
UC_X86_INS_MOVD: int
UC_X86_INS_MOVDQ2Q: int
UC_X86_INS_MOVNTQ: int
UC_X86_INS_MOVQ2DQ: int
UC_X86_INS_MOVQ: int
UC_X86_INS_PABSB: int
UC_X86_INS_PABSD: int
UC_X86_INS_PABSW: int
UC_X86_INS_PACKSSDW: int
UC_X86_INS_PACKSSWB: int
UC_X86_INS_PACKUSWB: int
UC_X86_INS_PADDB: int
UC_X86_INS_PADDD: int
UC_X86_INS_PADDQ: int
UC_X86_INS_PADDSB: int
UC_X86_INS_PADDSW: int
UC_X86_INS_PADDUSB: int
UC_X86_INS_PADDUSW: int
UC_X86_INS_PADDW: int
UC_X86_INS_PALIGNR: int
UC_X86_INS_PANDN: int
UC_X86_INS_PAND: int
UC_X86_INS_PAVGB: int
UC_X86_INS_PAVGW: int
UC_X86_INS_PCMPEQB: int
UC_X86_INS_PCMPEQD: int
UC_X86_INS_PCMPEQW: int
UC_X86_INS_PCMPGTB: int
UC_X86_INS_PCMPGTD: int
UC_X86_INS_PCMPGTW: int
UC_X86_INS_PEXTRW: int
UC_X86_INS_PHADDSW: int
UC_X86_INS_PHADDW: int
UC_X86_INS_PHADDD: int
UC_X86_INS_PHSUBD: int
UC_X86_INS_PHSUBSW: int
UC_X86_INS_PHSUBW: int
UC_X86_INS_PINSRW: int
UC_X86_INS_PMADDUBSW: int
UC_X86_INS_PMADDWD: int
UC_X86_INS_PMAXSW: int
UC_X86_INS_PMAXUB: int
UC_X86_INS_PMINSW: int
UC_X86_INS_PMINUB: int
UC_X86_INS_PMOVMSKB: int
UC_X86_INS_PMULHRSW: int
UC_X86_INS_PMULHUW: int
UC_X86_INS_PMULHW: int
UC_X86_INS_PMULLW: int
UC_X86_INS_PMULUDQ: int
UC_X86_INS_POR: int
UC_X86_INS_PSADBW: int
UC_X86_INS_PSHUFB: int
UC_X86_INS_PSHUFW: int
UC_X86_INS_PSIGNB: int
UC_X86_INS_PSIGND: int
UC_X86_INS_PSIGNW: int
UC_X86_INS_PSLLD: int
UC_X86_INS_PSLLQ: int
UC_X86_INS_PSLLW: int
UC_X86_INS_PSRAD: int
UC_X86_INS_PSRAW: int
UC_X86_INS_PSRLD: int
UC_X86_INS_PSRLQ: int
UC_X86_INS_PSRLW: int
UC_X86_INS_PSUBB: int
UC_X86_INS_PSUBD: int
UC_X86_INS_PSUBQ: int
UC_X86_INS_PSUBSB: int
UC_X86_INS_PSUBSW: int
UC_X86_INS_PSUBUSB: int
UC_X86_INS_PSUBUSW: int
UC_X86_INS_PSUBW: int
UC_X86_INS_PUNPCKHBW: int
UC_X86_INS_PUNPCKHDQ: int
UC_X86_INS_PUNPCKHWD: int
UC_X86_INS_PUNPCKLBW: int
UC_X86_INS_PUNPCKLDQ: int
UC_X86_INS_PUNPCKLWD: int
UC_X86_INS_PXOR: int
UC_X86_INS_MONITOR: int
UC_X86_INS_MONTMUL: int
UC_X86_INS_MOV: int
UC_X86_INS_MOVABS: int
UC_X86_INS_MOVBE: int
UC_X86_INS_MOVDDUP: int
UC_X86_INS_MOVDQA: int
UC_X86_INS_MOVDQU: int
UC_X86_INS_MOVHLPS: int
UC_X86_INS_MOVHPD: int
UC_X86_INS_MOVHPS: int
UC_X86_INS_MOVLHPS: int
UC_X86_INS_MOVLPD: int
UC_X86_INS_MOVLPS: int
UC_X86_INS_MOVMSKPD: int
UC_X86_INS_MOVMSKPS: int
UC_X86_INS_MOVNTDQA: int
UC_X86_INS_MOVNTDQ: int
UC_X86_INS_MOVNTI: int
UC_X86_INS_MOVNTPD: int
UC_X86_INS_MOVNTPS: int
UC_X86_INS_MOVNTSD: int
UC_X86_INS_MOVNTSS: int
UC_X86_INS_MOVSB: int
UC_X86_INS_MOVSD: int
UC_X86_INS_MOVSHDUP: int
UC_X86_INS_MOVSLDUP: int
UC_X86_INS_MOVSQ: int
UC_X86_INS_MOVSS: int
UC_X86_INS_MOVSW: int
UC_X86_INS_MOVSX: int
UC_X86_INS_MOVSXD: int
UC_X86_INS_MOVUPD: int
UC_X86_INS_MOVUPS: int
UC_X86_INS_MOVZX: int
UC_X86_INS_MPSADBW: int
UC_X86_INS_MUL: int
UC_X86_INS_MULPD: int
UC_X86_INS_MULPS: int
UC_X86_INS_MULSD: int
UC_X86_INS_MULSS: int
UC_X86_INS_MULX: int
UC_X86_INS_FMUL: int
UC_X86_INS_FIMUL: int
UC_X86_INS_FMULP: int
UC_X86_INS_MWAIT: int
UC_X86_INS_NEG: int
UC_X86_INS_NOP: int
UC_X86_INS_NOT: int
UC_X86_INS_OUT: int
UC_X86_INS_OUTSB: int
UC_X86_INS_OUTSD: int
UC_X86_INS_OUTSW: int
UC_X86_INS_PACKUSDW: int
UC_X86_INS_PAUSE: int
UC_X86_INS_PAVGUSB: int
UC_X86_INS_PBLENDVB: int
UC_X86_INS_PBLENDW: int
UC_X86_INS_PCLMULQDQ: int
UC_X86_INS_PCMPEQQ: int
UC_X86_INS_PCMPESTRI: int
UC_X86_INS_PCMPESTRM: int
UC_X86_INS_PCMPGTQ: int
UC_X86_INS_PCMPISTRI: int
UC_X86_INS_PCMPISTRM: int
UC_X86_INS_PCOMMIT: int
UC_X86_INS_PDEP: int
UC_X86_INS_PEXT: int
UC_X86_INS_PEXTRB: int
UC_X86_INS_PEXTRD: int
UC_X86_INS_PEXTRQ: int
UC_X86_INS_PF2ID: int
UC_X86_INS_PF2IW: int
UC_X86_INS_PFACC: int
UC_X86_INS_PFADD: int
UC_X86_INS_PFCMPEQ: int
UC_X86_INS_PFCMPGE: int
UC_X86_INS_PFCMPGT: int
UC_X86_INS_PFMAX: int
UC_X86_INS_PFMIN: int
UC_X86_INS_PFMUL: int
UC_X86_INS_PFNACC: int
UC_X86_INS_PFPNACC: int
UC_X86_INS_PFRCPIT1: int
UC_X86_INS_PFRCPIT2: int
UC_X86_INS_PFRCP: int
UC_X86_INS_PFRSQIT1: int
UC_X86_INS_PFRSQRT: int
UC_X86_INS_PFSUBR: int
UC_X86_INS_PFSUB: int
UC_X86_INS_PHMINPOSUW: int
UC_X86_INS_PI2FD: int
UC_X86_INS_PI2FW: int
UC_X86_INS_PINSRB: int
UC_X86_INS_PINSRD: int
UC_X86_INS_PINSRQ: int
UC_X86_INS_PMAXSB: int
UC_X86_INS_PMAXSD: int
UC_X86_INS_PMAXUD: int
UC_X86_INS_PMAXUW: int
UC_X86_INS_PMINSB: int
UC_X86_INS_PMINSD: int
UC_X86_INS_PMINUD: int
UC_X86_INS_PMINUW: int
UC_X86_INS_PMOVSXBD: int
UC_X86_INS_PMOVSXBQ: int
UC_X86_INS_PMOVSXBW: int
UC_X86_INS_PMOVSXDQ: int
UC_X86_INS_PMOVSXWD: int
UC_X86_INS_PMOVSXWQ: int
UC_X86_INS_PMOVZXBD: int
UC_X86_INS_PMOVZXBQ: int
UC_X86_INS_PMOVZXBW: int
UC_X86_INS_PMOVZXDQ: int
UC_X86_INS_PMOVZXWD: int
UC_X86_INS_PMOVZXWQ: int
UC_X86_INS_PMULDQ: int
UC_X86_INS_PMULHRW: int
UC_X86_INS_PMULLD: int
UC_X86_INS_POP: int
UC_X86_INS_POPAW: int
UC_X86_INS_POPAL: int
UC_X86_INS_POPCNT: int
UC_X86_INS_POPF: int
UC_X86_INS_POPFD: int
UC_X86_INS_POPFQ: int
UC_X86_INS_PREFETCH: int
UC_X86_INS_PREFETCHNTA: int
UC_X86_INS_PREFETCHT0: int
UC_X86_INS_PREFETCHT1: int
UC_X86_INS_PREFETCHT2: int
UC_X86_INS_PREFETCHW: int
UC_X86_INS_PSHUFD: int
UC_X86_INS_PSHUFHW: int
UC_X86_INS_PSHUFLW: int
UC_X86_INS_PSLLDQ: int
UC_X86_INS_PSRLDQ: int
UC_X86_INS_PSWAPD: int
UC_X86_INS_PTEST: int
UC_X86_INS_PUNPCKHQDQ: int
UC_X86_INS_PUNPCKLQDQ: int
UC_X86_INS_PUSH: int
UC_X86_INS_PUSHAW: int
UC_X86_INS_PUSHAL: int
UC_X86_INS_PUSHF: int
UC_X86_INS_PUSHFD: int
UC_X86_INS_PUSHFQ: int
UC_X86_INS_RCL: int
UC_X86_INS_RCPPS: int
UC_X86_INS_RCPSS: int
UC_X86_INS_RCR: int
UC_X86_INS_RDFSBASE: int
UC_X86_INS_RDGSBASE: int
UC_X86_INS_RDMSR: int
UC_X86_INS_RDPMC: int
UC_X86_INS_RDRAND: int
UC_X86_INS_RDSEED: int
UC_X86_INS_RDTSC: int
UC_X86_INS_RDTSCP: int
UC_X86_INS_ROL: int
UC_X86_INS_ROR: int
UC_X86_INS_RORX: int
UC_X86_INS_ROUNDPD: int
UC_X86_INS_ROUNDPS: int
UC_X86_INS_ROUNDSD: int
UC_X86_INS_ROUNDSS: int
UC_X86_INS_RSM: int
UC_X86_INS_RSQRTPS: int
UC_X86_INS_RSQRTSS: int
UC_X86_INS_SAHF: int
UC_X86_INS_SAL: int
UC_X86_INS_SALC: int
UC_X86_INS_SAR: int
UC_X86_INS_SARX: int
UC_X86_INS_SBB: int
UC_X86_INS_SCASB: int
UC_X86_INS_SCASD: int
UC_X86_INS_SCASQ: int
UC_X86_INS_SCASW: int
UC_X86_INS_SETAE: int
UC_X86_INS_SETA: int
UC_X86_INS_SETBE: int
UC_X86_INS_SETB: int
UC_X86_INS_SETE: int
UC_X86_INS_SETGE: int
UC_X86_INS_SETG: int
UC_X86_INS_SETLE: int
UC_X86_INS_SETL: int
UC_X86_INS_SETNE: int
UC_X86_INS_SETNO: int
UC_X86_INS_SETNP: int
UC_X86_INS_SETNS: int
UC_X86_INS_SETO: int
UC_X86_INS_SETP: int
UC_X86_INS_SETS: int
UC_X86_INS_SFENCE: int
UC_X86_INS_SGDT: int
UC_X86_INS_SHA1MSG1: int
UC_X86_INS_SHA1MSG2: int
UC_X86_INS_SHA1NEXTE: int
UC_X86_INS_SHA1RNDS4: int
UC_X86_INS_SHA256MSG1: int
UC_X86_INS_SHA256MSG2: int
UC_X86_INS_SHA256RNDS2: int
UC_X86_INS_SHL: int
UC_X86_INS_SHLD: int
UC_X86_INS_SHLX: int
UC_X86_INS_SHR: int
UC_X86_INS_SHRD: int
UC_X86_INS_SHRX: int
UC_X86_INS_SHUFPD: int
UC_X86_INS_SHUFPS: int
UC_X86_INS_SIDT: int
UC_X86_INS_FSIN: int
UC_X86_INS_SKINIT: int
UC_X86_INS_SLDT: int
UC_X86_INS_SMSW: int
UC_X86_INS_SQRTPD: int
UC_X86_INS_SQRTPS: int
UC_X86_INS_SQRTSD: int
UC_X86_INS_SQRTSS: int
UC_X86_INS_FSQRT: int
UC_X86_INS_STAC: int
UC_X86_INS_STC: int
UC_X86_INS_STD: int
UC_X86_INS_STGI: int
UC_X86_INS_STI: int
UC_X86_INS_STMXCSR: int
UC_X86_INS_STOSB: int
UC_X86_INS_STOSD: int
UC_X86_INS_STOSQ: int
UC_X86_INS_STOSW: int
UC_X86_INS_STR: int
UC_X86_INS_FST: int
UC_X86_INS_FSTP: int
UC_X86_INS_FSTPNCE: int
UC_X86_INS_FXCH: int
UC_X86_INS_SUBPD: int
UC_X86_INS_SUBPS: int
UC_X86_INS_FSUBR: int
UC_X86_INS_FISUBR: int
UC_X86_INS_FSUBRP: int
UC_X86_INS_SUBSD: int
UC_X86_INS_SUBSS: int
UC_X86_INS_FSUB: int
UC_X86_INS_FISUB: int
UC_X86_INS_FSUBP: int
UC_X86_INS_SWAPGS: int
UC_X86_INS_SYSCALL: int
UC_X86_INS_SYSENTER: int
UC_X86_INS_SYSEXIT: int
UC_X86_INS_SYSRET: int
UC_X86_INS_T1MSKC: int
UC_X86_INS_TEST: int
UC_X86_INS_UD2: int
UC_X86_INS_FTST: int
UC_X86_INS_TZCNT: int
UC_X86_INS_TZMSK: int
UC_X86_INS_FUCOMPI: int
UC_X86_INS_FUCOMI: int
UC_X86_INS_FUCOMPP: int
UC_X86_INS_FUCOMP: int
UC_X86_INS_FUCOM: int
UC_X86_INS_UD2B: int
UC_X86_INS_UNPCKHPD: int
UC_X86_INS_UNPCKHPS: int
UC_X86_INS_UNPCKLPD: int
UC_X86_INS_UNPCKLPS: int
UC_X86_INS_VADDPD: int
UC_X86_INS_VADDPS: int
UC_X86_INS_VADDSD: int
UC_X86_INS_VADDSS: int
UC_X86_INS_VADDSUBPD: int
UC_X86_INS_VADDSUBPS: int
UC_X86_INS_VAESDECLAST: int
UC_X86_INS_VAESDEC: int
UC_X86_INS_VAESENCLAST: int
UC_X86_INS_VAESENC: int
UC_X86_INS_VAESIMC: int
UC_X86_INS_VAESKEYGENASSIST: int
UC_X86_INS_VALIGND: int
UC_X86_INS_VALIGNQ: int
UC_X86_INS_VANDNPD: int
UC_X86_INS_VANDNPS: int
UC_X86_INS_VANDPD: int
UC_X86_INS_VANDPS: int
UC_X86_INS_VBLENDMPD: int
UC_X86_INS_VBLENDMPS: int
UC_X86_INS_VBLENDPD: int
UC_X86_INS_VBLENDPS: int
UC_X86_INS_VBLENDVPD: int
UC_X86_INS_VBLENDVPS: int
UC_X86_INS_VBROADCASTF128: int
UC_X86_INS_VBROADCASTI32X4: int
UC_X86_INS_VBROADCASTI64X4: int
UC_X86_INS_VBROADCASTSD: int
UC_X86_INS_VBROADCASTSS: int
UC_X86_INS_VCMPPD: int
UC_X86_INS_VCMPPS: int
UC_X86_INS_VCMPSD: int
UC_X86_INS_VCMPSS: int
UC_X86_INS_VCOMPRESSPD: int
UC_X86_INS_VCOMPRESSPS: int
UC_X86_INS_VCVTDQ2PD: int
UC_X86_INS_VCVTDQ2PS: int
UC_X86_INS_VCVTPD2DQX: int
UC_X86_INS_VCVTPD2DQ: int
UC_X86_INS_VCVTPD2PSX: int
UC_X86_INS_VCVTPD2PS: int
UC_X86_INS_VCVTPD2UDQ: int
UC_X86_INS_VCVTPH2PS: int
UC_X86_INS_VCVTPS2DQ: int
UC_X86_INS_VCVTPS2PD: int
UC_X86_INS_VCVTPS2PH: int
UC_X86_INS_VCVTPS2UDQ: int
UC_X86_INS_VCVTSD2SI: int
UC_X86_INS_VCVTSD2USI: int
UC_X86_INS_VCVTSS2SI: int
UC_X86_INS_VCVTSS2USI: int
UC_X86_INS_VCVTTPD2DQX: int
UC_X86_INS_VCVTTPD2DQ: int
UC_X86_INS_VCVTTPD2UDQ: int
UC_X86_INS_VCVTTPS2DQ: int
UC_X86_INS_VCVTTPS2UDQ: int
UC_X86_INS_VCVTUDQ2PD: int
UC_X86_INS_VCVTUDQ2PS: int
UC_X86_INS_VDIVPD: int
UC_X86_INS_VDIVPS: int
UC_X86_INS_VDIVSD: int
UC_X86_INS_VDIVSS: int
UC_X86_INS_VDPPD: int
UC_X86_INS_VDPPS: int
UC_X86_INS_VERR: int
UC_X86_INS_VERW: int
UC_X86_INS_VEXP2PD: int
UC_X86_INS_VEXP2PS: int
UC_X86_INS_VEXPANDPD: int
UC_X86_INS_VEXPANDPS: int
UC_X86_INS_VEXTRACTF128: int
UC_X86_INS_VEXTRACTF32X4: int
UC_X86_INS_VEXTRACTF64X4: int
UC_X86_INS_VEXTRACTI128: int
UC_X86_INS_VEXTRACTI32X4: int
UC_X86_INS_VEXTRACTI64X4: int
UC_X86_INS_VEXTRACTPS: int
UC_X86_INS_VFMADD132PD: int
UC_X86_INS_VFMADD132PS: int
UC_X86_INS_VFMADDPD: int
UC_X86_INS_VFMADD213PD: int
UC_X86_INS_VFMADD231PD: int
UC_X86_INS_VFMADDPS: int
UC_X86_INS_VFMADD213PS: int
UC_X86_INS_VFMADD231PS: int
UC_X86_INS_VFMADDSD: int
UC_X86_INS_VFMADD213SD: int
UC_X86_INS_VFMADD132SD: int
UC_X86_INS_VFMADD231SD: int
UC_X86_INS_VFMADDSS: int
UC_X86_INS_VFMADD213SS: int
UC_X86_INS_VFMADD132SS: int
UC_X86_INS_VFMADD231SS: int
UC_X86_INS_VFMADDSUB132PD: int
UC_X86_INS_VFMADDSUB132PS: int
UC_X86_INS_VFMADDSUBPD: int
UC_X86_INS_VFMADDSUB213PD: int
UC_X86_INS_VFMADDSUB231PD: int
UC_X86_INS_VFMADDSUBPS: int
UC_X86_INS_VFMADDSUB213PS: int
UC_X86_INS_VFMADDSUB231PS: int
UC_X86_INS_VFMSUB132PD: int
UC_X86_INS_VFMSUB132PS: int
UC_X86_INS_VFMSUBADD132PD: int
UC_X86_INS_VFMSUBADD132PS: int
UC_X86_INS_VFMSUBADDPD: int
UC_X86_INS_VFMSUBADD213PD: int
UC_X86_INS_VFMSUBADD231PD: int
UC_X86_INS_VFMSUBADDPS: int
UC_X86_INS_VFMSUBADD213PS: int
UC_X86_INS_VFMSUBADD231PS: int
UC_X86_INS_VFMSUBPD: int
UC_X86_INS_VFMSUB213PD: int
UC_X86_INS_VFMSUB231PD: int
UC_X86_INS_VFMSUBPS: int
UC_X86_INS_VFMSUB213PS: int
UC_X86_INS_VFMSUB231PS: int
UC_X86_INS_VFMSUBSD: int
UC_X86_INS_VFMSUB213SD: int
UC_X86_INS_VFMSUB132SD: int
UC_X86_INS_VFMSUB231SD: int
UC_X86_INS_VFMSUBSS: int
UC_X86_INS_VFMSUB213SS: int
UC_X86_INS_VFMSUB132SS: int
UC_X86_INS_VFMSUB231SS: int
UC_X86_INS_VFNMADD132PD: int
UC_X86_INS_VFNMADD132PS: int
UC_X86_INS_VFNMADDPD: int
UC_X86_INS_VFNMADD213PD: int
UC_X86_INS_VFNMADD231PD: int
UC_X86_INS_VFNMADDPS: int
UC_X86_INS_VFNMADD213PS: int
UC_X86_INS_VFNMADD231PS: int
UC_X86_INS_VFNMADDSD: int
UC_X86_INS_VFNMADD213SD: int
UC_X86_INS_VFNMADD132SD: int
UC_X86_INS_VFNMADD231SD: int
UC_X86_INS_VFNMADDSS: int
UC_X86_INS_VFNMADD213SS: int
UC_X86_INS_VFNMADD132SS: int
UC_X86_INS_VFNMADD231SS: int
UC_X86_INS_VFNMSUB132PD: int
UC_X86_INS_VFNMSUB132PS: int
UC_X86_INS_VFNMSUBPD: int
UC_X86_INS_VFNMSUB213PD: int
UC_X86_INS_VFNMSUB231PD: int
UC_X86_INS_VFNMSUBPS: int
UC_X86_INS_VFNMSUB213PS: int
UC_X86_INS_VFNMSUB231PS: int
UC_X86_INS_VFNMSUBSD: int
UC_X86_INS_VFNMSUB213SD: int
UC_X86_INS_VFNMSUB132SD: int
UC_X86_INS_VFNMSUB231SD: int
UC_X86_INS_VFNMSUBSS: int
UC_X86_INS_VFNMSUB213SS: int
UC_X86_INS_VFNMSUB132SS: int
UC_X86_INS_VFNMSUB231SS: int
UC_X86_INS_VFRCZPD: int
UC_X86_INS_VFRCZPS: int
UC_X86_INS_VFRCZSD: int
UC_X86_INS_VFRCZSS: int
UC_X86_INS_VORPD: int
UC_X86_INS_VORPS: int
UC_X86_INS_VXORPD: int
UC_X86_INS_VXORPS: int
UC_X86_INS_VGATHERDPD: int
UC_X86_INS_VGATHERDPS: int
UC_X86_INS_VGATHERPF0DPD: int
UC_X86_INS_VGATHERPF0DPS: int
UC_X86_INS_VGATHERPF0QPD: int
UC_X86_INS_VGATHERPF0QPS: int
UC_X86_INS_VGATHERPF1DPD: int
UC_X86_INS_VGATHERPF1DPS: int
UC_X86_INS_VGATHERPF1QPD: int
UC_X86_INS_VGATHERPF1QPS: int
UC_X86_INS_VGATHERQPD: int
UC_X86_INS_VGATHERQPS: int
UC_X86_INS_VHADDPD: int
UC_X86_INS_VHADDPS: int
UC_X86_INS_VHSUBPD: int
UC_X86_INS_VHSUBPS: int
UC_X86_INS_VINSERTF128: int
UC_X86_INS_VINSERTF32X4: int
UC_X86_INS_VINSERTF32X8: int
UC_X86_INS_VINSERTF64X2: int
UC_X86_INS_VINSERTF64X4: int
UC_X86_INS_VINSERTI128: int
UC_X86_INS_VINSERTI32X4: int
UC_X86_INS_VINSERTI32X8: int
UC_X86_INS_VINSERTI64X2: int
UC_X86_INS_VINSERTI64X4: int
UC_X86_INS_VINSERTPS: int
UC_X86_INS_VLDDQU: int
UC_X86_INS_VLDMXCSR: int
UC_X86_INS_VMASKMOVDQU: int
UC_X86_INS_VMASKMOVPD: int
UC_X86_INS_VMASKMOVPS: int
UC_X86_INS_VMAXPD: int
UC_X86_INS_VMAXPS: int
UC_X86_INS_VMAXSD: int
UC_X86_INS_VMAXSS: int
UC_X86_INS_VMCALL: int
UC_X86_INS_VMCLEAR: int
UC_X86_INS_VMFUNC: int
UC_X86_INS_VMINPD: int
UC_X86_INS_VMINPS: int
UC_X86_INS_VMINSD: int
UC_X86_INS_VMINSS: int
UC_X86_INS_VMLAUNCH: int
UC_X86_INS_VMLOAD: int
UC_X86_INS_VMMCALL: int
UC_X86_INS_VMOVQ: int
UC_X86_INS_VMOVDDUP: int
UC_X86_INS_VMOVD: int
UC_X86_INS_VMOVDQA32: int
UC_X86_INS_VMOVDQA64: int
UC_X86_INS_VMOVDQA: int
UC_X86_INS_VMOVDQU16: int
UC_X86_INS_VMOVDQU32: int
UC_X86_INS_VMOVDQU64: int
UC_X86_INS_VMOVDQU8: int
UC_X86_INS_VMOVDQU: int
UC_X86_INS_VMOVHLPS: int
UC_X86_INS_VMOVHPD: int
UC_X86_INS_VMOVHPS: int
UC_X86_INS_VMOVLHPS: int
UC_X86_INS_VMOVLPD: int
UC_X86_INS_VMOVLPS: int
UC_X86_INS_VMOVMSKPD: int
UC_X86_INS_VMOVMSKPS: int
UC_X86_INS_VMOVNTDQA: int
UC_X86_INS_VMOVNTDQ: int
UC_X86_INS_VMOVNTPD: int
UC_X86_INS_VMOVNTPS: int
UC_X86_INS_VMOVSD: int
UC_X86_INS_VMOVSHDUP: int
UC_X86_INS_VMOVSLDUP: int
UC_X86_INS_VMOVSS: int
UC_X86_INS_VMOVUPD: int
UC_X86_INS_VMOVUPS: int
UC_X86_INS_VMPSADBW: int
UC_X86_INS_VMPTRLD: int
UC_X86_INS_VMPTRST: int
UC_X86_INS_VMREAD: int
UC_X86_INS_VMRESUME: int
UC_X86_INS_VMRUN: int
UC_X86_INS_VMSAVE: int
UC_X86_INS_VMULPD: int
UC_X86_INS_VMULPS: int
UC_X86_INS_VMULSD: int
UC_X86_INS_VMULSS: int
UC_X86_INS_VMWRITE: int
UC_X86_INS_VMXOFF: int
UC_X86_INS_VMXON: int
UC_X86_INS_VPABSB: int
UC_X86_INS_VPABSD: int
UC_X86_INS_VPABSQ: int
UC_X86_INS_VPABSW: int
UC_X86_INS_VPACKSSDW: int
UC_X86_INS_VPACKSSWB: int
UC_X86_INS_VPACKUSDW: int
UC_X86_INS_VPACKUSWB: int
UC_X86_INS_VPADDB: int
UC_X86_INS_VPADDD: int
UC_X86_INS_VPADDQ: int
UC_X86_INS_VPADDSB: int
UC_X86_INS_VPADDSW: int
UC_X86_INS_VPADDUSB: int
UC_X86_INS_VPADDUSW: int
UC_X86_INS_VPADDW: int
UC_X86_INS_VPALIGNR: int
UC_X86_INS_VPANDD: int
UC_X86_INS_VPANDND: int
UC_X86_INS_VPANDNQ: int
UC_X86_INS_VPANDN: int
UC_X86_INS_VPANDQ: int
UC_X86_INS_VPAND: int
UC_X86_INS_VPAVGB: int
UC_X86_INS_VPAVGW: int
UC_X86_INS_VPBLENDD: int
UC_X86_INS_VPBLENDMB: int
UC_X86_INS_VPBLENDMD: int
UC_X86_INS_VPBLENDMQ: int
UC_X86_INS_VPBLENDMW: int
UC_X86_INS_VPBLENDVB: int
UC_X86_INS_VPBLENDW: int
UC_X86_INS_VPBROADCASTB: int
UC_X86_INS_VPBROADCASTD: int
UC_X86_INS_VPBROADCASTMB2Q: int
UC_X86_INS_VPBROADCASTMW2D: int
UC_X86_INS_VPBROADCASTQ: int
UC_X86_INS_VPBROADCASTW: int
UC_X86_INS_VPCLMULQDQ: int
UC_X86_INS_VPCMOV: int
UC_X86_INS_VPCMPB: int
UC_X86_INS_VPCMPD: int
UC_X86_INS_VPCMPEQB: int
UC_X86_INS_VPCMPEQD: int
UC_X86_INS_VPCMPEQQ: int
UC_X86_INS_VPCMPEQW: int
UC_X86_INS_VPCMPESTRI: int
UC_X86_INS_VPCMPESTRM: int
UC_X86_INS_VPCMPGTB: int
UC_X86_INS_VPCMPGTD: int
UC_X86_INS_VPCMPGTQ: int
UC_X86_INS_VPCMPGTW: int
UC_X86_INS_VPCMPISTRI: int
UC_X86_INS_VPCMPISTRM: int
UC_X86_INS_VPCMPQ: int
UC_X86_INS_VPCMPUB: int
UC_X86_INS_VPCMPUD: int
UC_X86_INS_VPCMPUQ: int
UC_X86_INS_VPCMPUW: int
UC_X86_INS_VPCMPW: int
UC_X86_INS_VPCOMB: int
UC_X86_INS_VPCOMD: int
UC_X86_INS_VPCOMPRESSD: int
UC_X86_INS_VPCOMPRESSQ: int
UC_X86_INS_VPCOMQ: int
UC_X86_INS_VPCOMUB: int
UC_X86_INS_VPCOMUD: int
UC_X86_INS_VPCOMUQ: int
UC_X86_INS_VPCOMUW: int
UC_X86_INS_VPCOMW: int
UC_X86_INS_VPCONFLICTD: int
UC_X86_INS_VPCONFLICTQ: int
UC_X86_INS_VPERM2F128: int
UC_X86_INS_VPERM2I128: int
UC_X86_INS_VPERMD: int
UC_X86_INS_VPERMI2D: int
UC_X86_INS_VPERMI2PD: int
UC_X86_INS_VPERMI2PS: int
UC_X86_INS_VPERMI2Q: int
UC_X86_INS_VPERMIL2PD: int
UC_X86_INS_VPERMIL2PS: int
UC_X86_INS_VPERMILPD: int
UC_X86_INS_VPERMILPS: int
UC_X86_INS_VPERMPD: int
UC_X86_INS_VPERMPS: int
UC_X86_INS_VPERMQ: int
UC_X86_INS_VPERMT2D: int
UC_X86_INS_VPERMT2PD: int
UC_X86_INS_VPERMT2PS: int
UC_X86_INS_VPERMT2Q: int
UC_X86_INS_VPEXPANDD: int
UC_X86_INS_VPEXPANDQ: int
UC_X86_INS_VPEXTRB: int
UC_X86_INS_VPEXTRD: int
UC_X86_INS_VPEXTRQ: int
UC_X86_INS_VPEXTRW: int
UC_X86_INS_VPGATHERDD: int
UC_X86_INS_VPGATHERDQ: int
UC_X86_INS_VPGATHERQD: int
UC_X86_INS_VPGATHERQQ: int
UC_X86_INS_VPHADDBD: int
UC_X86_INS_VPHADDBQ: int
UC_X86_INS_VPHADDBW: int
UC_X86_INS_VPHADDDQ: int
UC_X86_INS_VPHADDD: int
UC_X86_INS_VPHADDSW: int
UC_X86_INS_VPHADDUBD: int
UC_X86_INS_VPHADDUBQ: int
UC_X86_INS_VPHADDUBW: int
UC_X86_INS_VPHADDUDQ: int
UC_X86_INS_VPHADDUWD: int
UC_X86_INS_VPHADDUWQ: int
UC_X86_INS_VPHADDWD: int
UC_X86_INS_VPHADDWQ: int
UC_X86_INS_VPHADDW: int
UC_X86_INS_VPHMINPOSUW: int
UC_X86_INS_VPHSUBBW: int
UC_X86_INS_VPHSUBDQ: int
UC_X86_INS_VPHSUBD: int
UC_X86_INS_VPHSUBSW: int
UC_X86_INS_VPHSUBWD: int
UC_X86_INS_VPHSUBW: int
UC_X86_INS_VPINSRB: int
UC_X86_INS_VPINSRD: int
UC_X86_INS_VPINSRQ: int
UC_X86_INS_VPINSRW: int
UC_X86_INS_VPLZCNTD: int
UC_X86_INS_VPLZCNTQ: int
UC_X86_INS_VPMACSDD: int
UC_X86_INS_VPMACSDQH: int
UC_X86_INS_VPMACSDQL: int
UC_X86_INS_VPMACSSDD: int
UC_X86_INS_VPMACSSDQH: int
UC_X86_INS_VPMACSSDQL: int
UC_X86_INS_VPMACSSWD: int
UC_X86_INS_VPMACSSWW: int
UC_X86_INS_VPMACSWD: int
UC_X86_INS_VPMACSWW: int
UC_X86_INS_VPMADCSSWD: int
UC_X86_INS_VPMADCSWD: int
UC_X86_INS_VPMADDUBSW: int
UC_X86_INS_VPMADDWD: int
UC_X86_INS_VPMASKMOVD: int
UC_X86_INS_VPMASKMOVQ: int
UC_X86_INS_VPMAXSB: int
UC_X86_INS_VPMAXSD: int
UC_X86_INS_VPMAXSQ: int
UC_X86_INS_VPMAXSW: int
UC_X86_INS_VPMAXUB: int
UC_X86_INS_VPMAXUD: int
UC_X86_INS_VPMAXUQ: int
UC_X86_INS_VPMAXUW: int
UC_X86_INS_VPMINSB: int
UC_X86_INS_VPMINSD: int
UC_X86_INS_VPMINSQ: int
UC_X86_INS_VPMINSW: int
UC_X86_INS_VPMINUB: int
UC_X86_INS_VPMINUD: int
UC_X86_INS_VPMINUQ: int
UC_X86_INS_VPMINUW: int
UC_X86_INS_VPMOVDB: int
UC_X86_INS_VPMOVDW: int
UC_X86_INS_VPMOVM2B: int
UC_X86_INS_VPMOVM2D: int
UC_X86_INS_VPMOVM2Q: int
UC_X86_INS_VPMOVM2W: int
UC_X86_INS_VPMOVMSKB: int
UC_X86_INS_VPMOVQB: int
UC_X86_INS_VPMOVQD: int
UC_X86_INS_VPMOVQW: int
UC_X86_INS_VPMOVSDB: int
UC_X86_INS_VPMOVSDW: int
UC_X86_INS_VPMOVSQB: int
UC_X86_INS_VPMOVSQD: int
UC_X86_INS_VPMOVSQW: int
UC_X86_INS_VPMOVSXBD: int
UC_X86_INS_VPMOVSXBQ: int
UC_X86_INS_VPMOVSXBW: int
UC_X86_INS_VPMOVSXDQ: int
UC_X86_INS_VPMOVSXWD: int
UC_X86_INS_VPMOVSXWQ: int
UC_X86_INS_VPMOVUSDB: int
UC_X86_INS_VPMOVUSDW: int
UC_X86_INS_VPMOVUSQB: int
UC_X86_INS_VPMOVUSQD: int
UC_X86_INS_VPMOVUSQW: int
UC_X86_INS_VPMOVZXBD: int
UC_X86_INS_VPMOVZXBQ: int
UC_X86_INS_VPMOVZXBW: int
UC_X86_INS_VPMOVZXDQ: int
UC_X86_INS_VPMOVZXWD: int
UC_X86_INS_VPMOVZXWQ: int
UC_X86_INS_VPMULDQ: int
UC_X86_INS_VPMULHRSW: int
UC_X86_INS_VPMULHUW: int
UC_X86_INS_VPMULHW: int
UC_X86_INS_VPMULLD: int
UC_X86_INS_VPMULLQ: int
UC_X86_INS_VPMULLW: int
UC_X86_INS_VPMULUDQ: int
UC_X86_INS_VPORD: int
UC_X86_INS_VPORQ: int
UC_X86_INS_VPOR: int
UC_X86_INS_VPPERM: int
UC_X86_INS_VPROTB: int
UC_X86_INS_VPROTD: int
UC_X86_INS_VPROTQ: int
UC_X86_INS_VPROTW: int
UC_X86_INS_VPSADBW: int
UC_X86_INS_VPSCATTERDD: int
UC_X86_INS_VPSCATTERDQ: int
UC_X86_INS_VPSCATTERQD: int
UC_X86_INS_VPSCATTERQQ: int
UC_X86_INS_VPSHAB: int
UC_X86_INS_VPSHAD: int
UC_X86_INS_VPSHAQ: int
UC_X86_INS_VPSHAW: int
UC_X86_INS_VPSHLB: int
UC_X86_INS_VPSHLD: int
UC_X86_INS_VPSHLQ: int
UC_X86_INS_VPSHLW: int
UC_X86_INS_VPSHUFB: int
UC_X86_INS_VPSHUFD: int
UC_X86_INS_VPSHUFHW: int
UC_X86_INS_VPSHUFLW: int
UC_X86_INS_VPSIGNB: int
UC_X86_INS_VPSIGND: int
UC_X86_INS_VPSIGNW: int
UC_X86_INS_VPSLLDQ: int
UC_X86_INS_VPSLLD: int
UC_X86_INS_VPSLLQ: int
UC_X86_INS_VPSLLVD: int
UC_X86_INS_VPSLLVQ: int
UC_X86_INS_VPSLLW: int
UC_X86_INS_VPSRAD: int
UC_X86_INS_VPSRAQ: int
UC_X86_INS_VPSRAVD: int
UC_X86_INS_VPSRAVQ: int
UC_X86_INS_VPSRAW: int
UC_X86_INS_VPSRLDQ: int
UC_X86_INS_VPSRLD: int
UC_X86_INS_VPSRLQ: int
UC_X86_INS_VPSRLVD: int
UC_X86_INS_VPSRLVQ: int
UC_X86_INS_VPSRLW: int
UC_X86_INS_VPSUBB: int
UC_X86_INS_VPSUBD: int
UC_X86_INS_VPSUBQ: int
UC_X86_INS_VPSUBSB: int
UC_X86_INS_VPSUBSW: int
UC_X86_INS_VPSUBUSB: int
UC_X86_INS_VPSUBUSW: int
UC_X86_INS_VPSUBW: int
UC_X86_INS_VPTESTMD: int
UC_X86_INS_VPTESTMQ: int
UC_X86_INS_VPTESTNMD: int
UC_X86_INS_VPTESTNMQ: int
UC_X86_INS_VPTEST: int
UC_X86_INS_VPUNPCKHBW: int
UC_X86_INS_VPUNPCKHDQ: int
UC_X86_INS_VPUNPCKHQDQ: int
UC_X86_INS_VPUNPCKHWD: int
UC_X86_INS_VPUNPCKLBW: int
UC_X86_INS_VPUNPCKLDQ: int
UC_X86_INS_VPUNPCKLQDQ: int
UC_X86_INS_VPUNPCKLWD: int
UC_X86_INS_VPXORD: int
UC_X86_INS_VPXORQ: int
UC_X86_INS_VPXOR: int
UC_X86_INS_VRCP14PD: int
UC_X86_INS_VRCP14PS: int
UC_X86_INS_VRCP14SD: int
UC_X86_INS_VRCP14SS: int
UC_X86_INS_VRCP28PD: int
UC_X86_INS_VRCP28PS: int
UC_X86_INS_VRCP28SD: int
UC_X86_INS_VRCP28SS: int
UC_X86_INS_VRCPPS: int
UC_X86_INS_VRCPSS: int
UC_X86_INS_VRNDSCALEPD: int
UC_X86_INS_VRNDSCALEPS: int
UC_X86_INS_VRNDSCALESD: int
UC_X86_INS_VRNDSCALESS: int
UC_X86_INS_VROUNDPD: int
UC_X86_INS_VROUNDPS: int
UC_X86_INS_VROUNDSD: int
UC_X86_INS_VROUNDSS: int
UC_X86_INS_VRSQRT14PD: int
UC_X86_INS_VRSQRT14PS: int
UC_X86_INS_VRSQRT14SD: int
UC_X86_INS_VRSQRT14SS: int
UC_X86_INS_VRSQRT28PD: int
UC_X86_INS_VRSQRT28PS: int
UC_X86_INS_VRSQRT28SD: int
UC_X86_INS_VRSQRT28SS: int
UC_X86_INS_VRSQRTPS: int
UC_X86_INS_VRSQRTSS: int
UC_X86_INS_VSCATTERDPD: int
UC_X86_INS_VSCATTERDPS: int
UC_X86_INS_VSCATTERPF0DPD: int
UC_X86_INS_VSCATTERPF0DPS: int
UC_X86_INS_VSCATTERPF0QPD: int
UC_X86_INS_VSCATTERPF0QPS: int
UC_X86_INS_VSCATTERPF1DPD: int
UC_X86_INS_VSCATTERPF1DPS: int
UC_X86_INS_VSCATTERPF1QPD: int
UC_X86_INS_VSCATTERPF1QPS: int
UC_X86_INS_VSCATTERQPD: int
UC_X86_INS_VSCATTERQPS: int
UC_X86_INS_VSHUFPD: int
UC_X86_INS_VSHUFPS: int
UC_X86_INS_VSQRTPD: int
UC_X86_INS_VSQRTPS: int
UC_X86_INS_VSQRTSD: int
UC_X86_INS_VSQRTSS: int
UC_X86_INS_VSTMXCSR: int
UC_X86_INS_VSUBPD: int
UC_X86_INS_VSUBPS: int
UC_X86_INS_VSUBSD: int
UC_X86_INS_VSUBSS: int
UC_X86_INS_VTESTPD: int
UC_X86_INS_VTESTPS: int
UC_X86_INS_VUNPCKHPD: int
UC_X86_INS_VUNPCKHPS: int
UC_X86_INS_VUNPCKLPD: int
UC_X86_INS_VUNPCKLPS: int
UC_X86_INS_VZEROALL: int
UC_X86_INS_VZEROUPPER: int
UC_X86_INS_WAIT: int
UC_X86_INS_WBINVD: int
UC_X86_INS_WRFSBASE: int
UC_X86_INS_WRGSBASE: int
UC_X86_INS_WRMSR: int
UC_X86_INS_XABORT: int
UC_X86_INS_XACQUIRE: int
UC_X86_INS_XBEGIN: int
UC_X86_INS_XCHG: int
UC_X86_INS_XCRYPTCBC: int
UC_X86_INS_XCRYPTCFB: int
UC_X86_INS_XCRYPTCTR: int
UC_X86_INS_XCRYPTECB: int
UC_X86_INS_XCRYPTOFB: int
UC_X86_INS_XEND: int
UC_X86_INS_XGETBV: int
UC_X86_INS_XLATB: int
UC_X86_INS_XRELEASE: int
UC_X86_INS_XRSTOR: int
UC_X86_INS_XRSTOR64: int
UC_X86_INS_XRSTORS: int
UC_X86_INS_XRSTORS64: int
UC_X86_INS_XSAVE: int
UC_X86_INS_XSAVE64: int
UC_X86_INS_XSAVEC: int
UC_X86_INS_XSAVEC64: int
UC_X86_INS_XSAVEOPT: int
UC_X86_INS_XSAVEOPT64: int
UC_X86_INS_XSAVES: int
UC_X86_INS_XSAVES64: int
UC_X86_INS_XSETBV: int
UC_X86_INS_XSHA1: int
UC_X86_INS_XSHA256: int
UC_X86_INS_XSTORE: int
UC_X86_INS_XTEST: int
UC_X86_INS_FDISI8087_NOP: int
UC_X86_INS_FENI8087_NOP: int
UC_X86_INS_ENDING: int
