import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type AWSQS::Iridium::CloudConnectQS::MODULE
 *
 * @schema CfnCloudConnectQsModuleProps
 */
export interface CfnCloudConnectQsModuleProps {
    /**
     * @schema CfnCloudConnectQsModuleProps#Parameters
     */
    readonly parameters?: CfnCloudConnectQsModulePropsParameters;
    /**
     * @schema CfnCloudConnectQsModuleProps#Resources
     */
    readonly resources?: CfnCloudConnectQsModulePropsResources;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModuleProps' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModuleProps(obj: CfnCloudConnectQsModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudConnectQsModulePropsParameters
 */
export interface CfnCloudConnectQsModulePropsParameters {
    /**
     * Amazon Resource Number (ARN) of the role in the Iridium AWS account.
     *
     * @schema CfnCloudConnectQsModulePropsParameters#IridiumRoleARN
     */
    readonly iridiumRoleArn?: CfnCloudConnectQsModulePropsParametersIridiumRoleArn;
    /**
     * Name of the mobile-originated queue in Amazon SQS.
     *
     * @schema CfnCloudConnectQsModulePropsParameters#MobileOriginatedQueueName
     */
    readonly mobileOriginatedQueueName?: CfnCloudConnectQsModulePropsParametersMobileOriginatedQueueName;
    /**
     * Name of the mobile-terminated queue in Amazon SQS.
     *
     * @schema CfnCloudConnectQsModulePropsParameters#MobileTerminatedQueueName
     */
    readonly mobileTerminatedQueueName?: CfnCloudConnectQsModulePropsParametersMobileTerminatedQueueName;
    /**
     * Name of the mobile-terminated confirmation queue in Amazon SQS.
     *
     * @schema CfnCloudConnectQsModulePropsParameters#MobileTerminatedConfirmationQueueName
     */
    readonly mobileTerminatedConfirmationQueueName?: CfnCloudConnectQsModulePropsParametersMobileTerminatedConfirmationQueueName;
    /**
     * Name of the mobile-terminated error queue in Amazon SQS.
     *
     * @schema CfnCloudConnectQsModulePropsParameters#MobileTerminatedErrorQueueName
     */
    readonly mobileTerminatedErrorQueueName?: CfnCloudConnectQsModulePropsParametersMobileTerminatedErrorQueueName;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModulePropsParameters(obj: CfnCloudConnectQsModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudConnectQsModulePropsResources
 */
export interface CfnCloudConnectQsModulePropsResources {
    /**
     * @schema CfnCloudConnectQsModulePropsResources#MobileOriginatedSQSQueue
     */
    readonly mobileOriginatedSqsQueue?: CfnCloudConnectQsModulePropsResourcesMobileOriginatedSqsQueue;
    /**
     * @schema CfnCloudConnectQsModulePropsResources#MobileTerminatedSQSQueue
     */
    readonly mobileTerminatedSqsQueue?: CfnCloudConnectQsModulePropsResourcesMobileTerminatedSqsQueue;
    /**
     * @schema CfnCloudConnectQsModulePropsResources#MobileTerminatedConfirmationSQSQueue
     */
    readonly mobileTerminatedConfirmationSqsQueue?: CfnCloudConnectQsModulePropsResourcesMobileTerminatedConfirmationSqsQueue;
    /**
     * @schema CfnCloudConnectQsModulePropsResources#MobileTerminatedErrorSQSQueue
     */
    readonly mobileTerminatedErrorSqsQueue?: CfnCloudConnectQsModulePropsResourcesMobileTerminatedErrorSqsQueue;
    /**
     * @schema CfnCloudConnectQsModulePropsResources#SQSQueueCrossAccountPolicy
     */
    readonly sqsQueueCrossAccountPolicy?: CfnCloudConnectQsModulePropsResourcesSqsQueueCrossAccountPolicy;
    /**
     * @schema CfnCloudConnectQsModulePropsResources#SQSCrossAccountRole
     */
    readonly sqsCrossAccountRole?: CfnCloudConnectQsModulePropsResourcesSqsCrossAccountRole;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModulePropsResources(obj: CfnCloudConnectQsModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * Amazon Resource Number (ARN) of the role in the Iridium AWS account.
 *
 * @schema CfnCloudConnectQsModulePropsParametersIridiumRoleArn
 */
export interface CfnCloudConnectQsModulePropsParametersIridiumRoleArn {
    /**
     * @schema CfnCloudConnectQsModulePropsParametersIridiumRoleArn#Type
     */
    readonly type: string;
    /**
     * @schema CfnCloudConnectQsModulePropsParametersIridiumRoleArn#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModulePropsParametersIridiumRoleArn' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModulePropsParametersIridiumRoleArn(obj: CfnCloudConnectQsModulePropsParametersIridiumRoleArn | undefined): Record<string, any> | undefined;
/**
 * Name of the mobile-originated queue in Amazon SQS.
 *
 * @schema CfnCloudConnectQsModulePropsParametersMobileOriginatedQueueName
 */
export interface CfnCloudConnectQsModulePropsParametersMobileOriginatedQueueName {
    /**
     * @schema CfnCloudConnectQsModulePropsParametersMobileOriginatedQueueName#Type
     */
    readonly type: string;
    /**
     * @schema CfnCloudConnectQsModulePropsParametersMobileOriginatedQueueName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModulePropsParametersMobileOriginatedQueueName' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModulePropsParametersMobileOriginatedQueueName(obj: CfnCloudConnectQsModulePropsParametersMobileOriginatedQueueName | undefined): Record<string, any> | undefined;
/**
 * Name of the mobile-terminated queue in Amazon SQS.
 *
 * @schema CfnCloudConnectQsModulePropsParametersMobileTerminatedQueueName
 */
export interface CfnCloudConnectQsModulePropsParametersMobileTerminatedQueueName {
    /**
     * @schema CfnCloudConnectQsModulePropsParametersMobileTerminatedQueueName#Type
     */
    readonly type: string;
    /**
     * @schema CfnCloudConnectQsModulePropsParametersMobileTerminatedQueueName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModulePropsParametersMobileTerminatedQueueName' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModulePropsParametersMobileTerminatedQueueName(obj: CfnCloudConnectQsModulePropsParametersMobileTerminatedQueueName | undefined): Record<string, any> | undefined;
/**
 * Name of the mobile-terminated confirmation queue in Amazon SQS.
 *
 * @schema CfnCloudConnectQsModulePropsParametersMobileTerminatedConfirmationQueueName
 */
export interface CfnCloudConnectQsModulePropsParametersMobileTerminatedConfirmationQueueName {
    /**
     * @schema CfnCloudConnectQsModulePropsParametersMobileTerminatedConfirmationQueueName#Type
     */
    readonly type: string;
    /**
     * @schema CfnCloudConnectQsModulePropsParametersMobileTerminatedConfirmationQueueName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModulePropsParametersMobileTerminatedConfirmationQueueName' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModulePropsParametersMobileTerminatedConfirmationQueueName(obj: CfnCloudConnectQsModulePropsParametersMobileTerminatedConfirmationQueueName | undefined): Record<string, any> | undefined;
/**
 * Name of the mobile-terminated error queue in Amazon SQS.
 *
 * @schema CfnCloudConnectQsModulePropsParametersMobileTerminatedErrorQueueName
 */
export interface CfnCloudConnectQsModulePropsParametersMobileTerminatedErrorQueueName {
    /**
     * @schema CfnCloudConnectQsModulePropsParametersMobileTerminatedErrorQueueName#Type
     */
    readonly type: string;
    /**
     * @schema CfnCloudConnectQsModulePropsParametersMobileTerminatedErrorQueueName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModulePropsParametersMobileTerminatedErrorQueueName' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModulePropsParametersMobileTerminatedErrorQueueName(obj: CfnCloudConnectQsModulePropsParametersMobileTerminatedErrorQueueName | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudConnectQsModulePropsResourcesMobileOriginatedSqsQueue
 */
export interface CfnCloudConnectQsModulePropsResourcesMobileOriginatedSqsQueue {
    /**
     * @schema CfnCloudConnectQsModulePropsResourcesMobileOriginatedSqsQueue#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCloudConnectQsModulePropsResourcesMobileOriginatedSqsQueue#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModulePropsResourcesMobileOriginatedSqsQueue' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModulePropsResourcesMobileOriginatedSqsQueue(obj: CfnCloudConnectQsModulePropsResourcesMobileOriginatedSqsQueue | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudConnectQsModulePropsResourcesMobileTerminatedSqsQueue
 */
export interface CfnCloudConnectQsModulePropsResourcesMobileTerminatedSqsQueue {
    /**
     * @schema CfnCloudConnectQsModulePropsResourcesMobileTerminatedSqsQueue#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCloudConnectQsModulePropsResourcesMobileTerminatedSqsQueue#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModulePropsResourcesMobileTerminatedSqsQueue' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModulePropsResourcesMobileTerminatedSqsQueue(obj: CfnCloudConnectQsModulePropsResourcesMobileTerminatedSqsQueue | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudConnectQsModulePropsResourcesMobileTerminatedConfirmationSqsQueue
 */
export interface CfnCloudConnectQsModulePropsResourcesMobileTerminatedConfirmationSqsQueue {
    /**
     * @schema CfnCloudConnectQsModulePropsResourcesMobileTerminatedConfirmationSqsQueue#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCloudConnectQsModulePropsResourcesMobileTerminatedConfirmationSqsQueue#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModulePropsResourcesMobileTerminatedConfirmationSqsQueue' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModulePropsResourcesMobileTerminatedConfirmationSqsQueue(obj: CfnCloudConnectQsModulePropsResourcesMobileTerminatedConfirmationSqsQueue | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudConnectQsModulePropsResourcesMobileTerminatedErrorSqsQueue
 */
export interface CfnCloudConnectQsModulePropsResourcesMobileTerminatedErrorSqsQueue {
    /**
     * @schema CfnCloudConnectQsModulePropsResourcesMobileTerminatedErrorSqsQueue#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCloudConnectQsModulePropsResourcesMobileTerminatedErrorSqsQueue#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModulePropsResourcesMobileTerminatedErrorSqsQueue' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModulePropsResourcesMobileTerminatedErrorSqsQueue(obj: CfnCloudConnectQsModulePropsResourcesMobileTerminatedErrorSqsQueue | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudConnectQsModulePropsResourcesSqsQueueCrossAccountPolicy
 */
export interface CfnCloudConnectQsModulePropsResourcesSqsQueueCrossAccountPolicy {
    /**
     * @schema CfnCloudConnectQsModulePropsResourcesSqsQueueCrossAccountPolicy#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCloudConnectQsModulePropsResourcesSqsQueueCrossAccountPolicy#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModulePropsResourcesSqsQueueCrossAccountPolicy' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModulePropsResourcesSqsQueueCrossAccountPolicy(obj: CfnCloudConnectQsModulePropsResourcesSqsQueueCrossAccountPolicy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudConnectQsModulePropsResourcesSqsCrossAccountRole
 */
export interface CfnCloudConnectQsModulePropsResourcesSqsCrossAccountRole {
    /**
     * @schema CfnCloudConnectQsModulePropsResourcesSqsCrossAccountRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCloudConnectQsModulePropsResourcesSqsCrossAccountRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCloudConnectQsModulePropsResourcesSqsCrossAccountRole' to JSON representation.
 */
export declare function toJson_CfnCloudConnectQsModulePropsResourcesSqsCrossAccountRole(obj: CfnCloudConnectQsModulePropsResourcesSqsCrossAccountRole | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AWSQS::Iridium::CloudConnectQS::MODULE`
 *
 * @cloudformationResource AWSQS::Iridium::CloudConnectQS::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnCloudConnectQsModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWSQS::Iridium::CloudConnectQS::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnCloudConnectQsModuleProps;
    /**
     * Create a new `AWSQS::Iridium::CloudConnectQS::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnCloudConnectQsModuleProps);
}
