# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from obp_python.configuration import Configuration


class CardAttributeCommons(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'card_id': 'str',
        'attribute_type': 'str',
        'bank_id': 'BankId',
        'value': 'str',
        'card_attribute_id': 'str'
    }

    attribute_map = {
        'name': 'name',
        'card_id': 'card_id',
        'attribute_type': 'attribute_type',
        'bank_id': 'bank_id',
        'value': 'value',
        'card_attribute_id': 'card_attribute_id'
    }

    def __init__(self, name=None, card_id=None, attribute_type=None, bank_id=None, value=None, card_attribute_id=None, _configuration=None):  # noqa: E501
        """CardAttributeCommons - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._name = None
        self._card_id = None
        self._attribute_type = None
        self._bank_id = None
        self._value = None
        self._card_attribute_id = None
        self.discriminator = None

        self.name = name
        if card_id is not None:
            self.card_id = card_id
        self.attribute_type = attribute_type
        if bank_id is not None:
            self.bank_id = bank_id
        self.value = value
        if card_attribute_id is not None:
            self.card_attribute_id = card_attribute_id

    @property
    def name(self):
        """Gets the name of this CardAttributeCommons.  # noqa: E501


        :return: The name of this CardAttributeCommons.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CardAttributeCommons.


        :param name: The name of this CardAttributeCommons.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def card_id(self):
        """Gets the card_id of this CardAttributeCommons.  # noqa: E501


        :return: The card_id of this CardAttributeCommons.  # noqa: E501
        :rtype: str
        """
        return self._card_id

    @card_id.setter
    def card_id(self, card_id):
        """Sets the card_id of this CardAttributeCommons.


        :param card_id: The card_id of this CardAttributeCommons.  # noqa: E501
        :type: str
        """

        self._card_id = card_id

    @property
    def attribute_type(self):
        """Gets the attribute_type of this CardAttributeCommons.  # noqa: E501


        :return: The attribute_type of this CardAttributeCommons.  # noqa: E501
        :rtype: str
        """
        return self._attribute_type

    @attribute_type.setter
    def attribute_type(self, attribute_type):
        """Sets the attribute_type of this CardAttributeCommons.


        :param attribute_type: The attribute_type of this CardAttributeCommons.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and attribute_type is None:
            raise ValueError("Invalid value for `attribute_type`, must not be `None`")  # noqa: E501
        allowed_values = ["STRING", "INTEGER", "DOUBLE", "DATE_WITH_DAY"]  # noqa: E501
        if (self._configuration.client_side_validation and
                attribute_type not in allowed_values):
            raise ValueError(
                "Invalid value for `attribute_type` ({0}), must be one of {1}"  # noqa: E501
                .format(attribute_type, allowed_values)
            )

        self._attribute_type = attribute_type

    @property
    def bank_id(self):
        """Gets the bank_id of this CardAttributeCommons.  # noqa: E501


        :return: The bank_id of this CardAttributeCommons.  # noqa: E501
        :rtype: BankId
        """
        return self._bank_id

    @bank_id.setter
    def bank_id(self, bank_id):
        """Sets the bank_id of this CardAttributeCommons.


        :param bank_id: The bank_id of this CardAttributeCommons.  # noqa: E501
        :type: BankId
        """

        self._bank_id = bank_id

    @property
    def value(self):
        """Gets the value of this CardAttributeCommons.  # noqa: E501


        :return: The value of this CardAttributeCommons.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this CardAttributeCommons.


        :param value: The value of this CardAttributeCommons.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and value is None:
            raise ValueError("Invalid value for `value`, must not be `None`")  # noqa: E501

        self._value = value

    @property
    def card_attribute_id(self):
        """Gets the card_attribute_id of this CardAttributeCommons.  # noqa: E501


        :return: The card_attribute_id of this CardAttributeCommons.  # noqa: E501
        :rtype: str
        """
        return self._card_attribute_id

    @card_attribute_id.setter
    def card_attribute_id(self, card_attribute_id):
        """Sets the card_attribute_id of this CardAttributeCommons.


        :param card_attribute_id: The card_attribute_id of this CardAttributeCommons.  # noqa: E501
        :type: str
        """

        self._card_attribute_id = card_attribute_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CardAttributeCommons, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CardAttributeCommons):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CardAttributeCommons):
            return True

        return self.to_dict() != other.to_dict()
