# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class TransactionMetadataApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_comment_for_view_on_transaction(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add a Transaction Comment  # noqa: E501

        <p>Posts a comment about a transaction TRANSACTION_ID on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> VIEW_ID.</p><p>${authenticationRequiredMessage(false)}</p><p>Authentication is required since the comment is linked with the user.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_comment_for_view_on_transaction(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTransactionCommentJSON body: PostTransactionCommentJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionCommentJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_comment_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_comment_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_comment_for_view_on_transaction_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add a Transaction Comment  # noqa: E501

        <p>Posts a comment about a transaction TRANSACTION_ID on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> VIEW_ID.</p><p>${authenticationRequiredMessage(false)}</p><p>Authentication is required since the comment is linked with the user.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_comment_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTransactionCommentJSON body: PostTransactionCommentJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionCommentJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_comment_for_view_on_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_comment_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `add_comment_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_comment_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_comment_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_comment_for_view_on_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/comments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionCommentJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_image_for_view_on_transaction(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add a Transaction Image  # noqa: E501

        <p>Posts an image about a transaction TRANSACTION_ID on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> VIEW_ID.</p><p>Authentication is Mandatory</p><p>The image is linked with the user.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_image_for_view_on_transaction(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTransactionImageJSON body: PostTransactionImageJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionImageJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_image_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_image_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_image_for_view_on_transaction_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add a Transaction Image  # noqa: E501

        <p>Posts an image about a transaction TRANSACTION_ID on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> VIEW_ID.</p><p>Authentication is Mandatory</p><p>The image is linked with the user.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_image_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTransactionImageJSON body: PostTransactionImageJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionImageJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_image_for_view_on_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_image_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `add_image_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_image_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_image_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_image_for_view_on_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/images', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionImageJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_tag_for_view_on_transaction(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add a Transaction Tag  # noqa: E501

        <p>Posts a tag about a transaction TRANSACTION_ID on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> VIEW_ID.</p><p>Authentication is Mandatory</p><p>Authentication is required as the tag is linked with the user.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_tag_for_view_on_transaction(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTransactionTagJSON body: PostTransactionTagJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionTagJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_tag_for_view_on_transaction_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add a Transaction Tag  # noqa: E501

        <p>Posts a tag about a transaction TRANSACTION_ID on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> VIEW_ID.</p><p>Authentication is Mandatory</p><p>Authentication is required as the tag is linked with the user.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTransactionTagJSON body: PostTransactionTagJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionTagJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_tag_for_view_on_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `add_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_tag_for_view_on_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionTagJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_transaction_narrative(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add a Transaction Narrative  # noqa: E501

        <p>Creates a description of the transaction TRANSACTION_ID.</p><p>Note: Unlike other items of metadata, there is only one &quot;narrative&quot; per transaction accross all views.<br />If you set narrative via a view e.g. view-x it will be seen via view-y (as long as view-y has permission to see the narrative).</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_transaction_narrative(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionNarrativeJSON body: TransactionNarrativeJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_transaction_narrative_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_transaction_narrative_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_transaction_narrative_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add a Transaction Narrative  # noqa: E501

        <p>Creates a description of the transaction TRANSACTION_ID.</p><p>Note: Unlike other items of metadata, there is only one &quot;narrative&quot; per transaction accross all views.<br />If you set narrative via a view e.g. view-x it will be seen via view-y (as long as view-y has permission to see the narrative).</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_transaction_narrative_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionNarrativeJSON body: TransactionNarrativeJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_transaction_narrative" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `add_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_transaction_narrative`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/narrative', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_where_tag_for_view_on_transaction(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add a Transaction where Tag  # noqa: E501

        <p>Creates a &quot;where&quot; Geo tag on a transaction TRANSACTION_ID in a <a href=\"#1_2_1-getViewsForBankAccount\">view</a>.</p><p>Authentication is Mandatory</p><p>The geo tag is linked with the user.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_where_tag_for_view_on_transaction(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTransactionWhereJSON body: PostTransactionWhereJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_where_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_where_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_where_tag_for_view_on_transaction_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add a Transaction where Tag  # noqa: E501

        <p>Creates a &quot;where&quot; Geo tag on a transaction TRANSACTION_ID in a <a href=\"#1_2_1-getViewsForBankAccount\">view</a>.</p><p>Authentication is Mandatory</p><p>The geo tag is linked with the user.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_where_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTransactionWhereJSON body: PostTransactionWhereJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_where_tag_for_view_on_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `add_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_where_tag_for_view_on_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/where', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_comment_for_view_on_transaction(self, body, comment_id, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete a Transaction Comment  # noqa: E501

        <p>Delete the comment COMMENT_ID about the transaction TRANSACTION_ID made on <a href=\"#1_2_1-getViewsForBankAccount\">view</a>.</p><p>Authentication via OAuth is required. The user must either have owner privileges for this account, or must be the user that posted the comment.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_comment_for_view_on_transaction(body, comment_id, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str comment_id: The comment id (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_comment_for_view_on_transaction_with_http_info(body, comment_id, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_comment_for_view_on_transaction_with_http_info(body, comment_id, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_comment_for_view_on_transaction_with_http_info(self, body, comment_id, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete a Transaction Comment  # noqa: E501

        <p>Delete the comment COMMENT_ID about the transaction TRANSACTION_ID made on <a href=\"#1_2_1-getViewsForBankAccount\">view</a>.</p><p>Authentication via OAuth is required. The user must either have owner privileges for this account, or must be the user that posted the comment.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_comment_for_view_on_transaction_with_http_info(body, comment_id, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str comment_id: The comment id (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'comment_id', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_comment_for_view_on_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_comment_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'comment_id' is set
        if self.api_client.client_side_validation and ('comment_id' not in params or
                                                       params['comment_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `comment_id` when calling `delete_comment_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `delete_comment_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_comment_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_comment_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_comment_for_view_on_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'comment_id' in params:
            path_params['COMMENT_ID'] = params['comment_id']  # noqa: E501
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/comments/{COMMENT_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_image_for_view_on_transaction(self, body, image_id, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete a Transaction Image  # noqa: E501

        <p>Deletes the image IMAGE_ID about the transaction TRANSACTION_ID made on <a href=\"#1_2_1-getViewsForBankAccount\">view</a>.</p><p>Authentication via OAuth is required. The user must either have owner privileges for this account, or must be the user that posted the image.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_image_for_view_on_transaction(body, image_id, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str image_id: The image id (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_image_for_view_on_transaction_with_http_info(body, image_id, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_image_for_view_on_transaction_with_http_info(body, image_id, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_image_for_view_on_transaction_with_http_info(self, body, image_id, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete a Transaction Image  # noqa: E501

        <p>Deletes the image IMAGE_ID about the transaction TRANSACTION_ID made on <a href=\"#1_2_1-getViewsForBankAccount\">view</a>.</p><p>Authentication via OAuth is required. The user must either have owner privileges for this account, or must be the user that posted the image.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_image_for_view_on_transaction_with_http_info(body, image_id, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str image_id: The image id (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'image_id', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_image_for_view_on_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_image_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'image_id' is set
        if self.api_client.client_side_validation and ('image_id' not in params or
                                                       params['image_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `image_id` when calling `delete_image_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `delete_image_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_image_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_image_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_image_for_view_on_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'image_id' in params:
            path_params['IMAGE_ID'] = params['image_id']  # noqa: E501
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/images/{IMAGE_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tag_for_view_on_transaction(self, body, tag_id, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete a Transaction Tag  # noqa: E501

        <p>Deletes the tag TAG_ID about the transaction TRANSACTION_ID made on <a href=\"#1_2_1-getViewsForBankAccount\">view</a>.<br />Authentication via OAuth is required. The user must either have owner privileges for this account,<br />or must be the user that posted the tag.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tag_for_view_on_transaction(body, tag_id, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str tag_id: The tag id (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tag_for_view_on_transaction_with_http_info(body, tag_id, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tag_for_view_on_transaction_with_http_info(body, tag_id, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_tag_for_view_on_transaction_with_http_info(self, body, tag_id, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete a Transaction Tag  # noqa: E501

        <p>Deletes the tag TAG_ID about the transaction TRANSACTION_ID made on <a href=\"#1_2_1-getViewsForBankAccount\">view</a>.<br />Authentication via OAuth is required. The user must either have owner privileges for this account,<br />or must be the user that posted the tag.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tag_for_view_on_transaction_with_http_info(body, tag_id, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str tag_id: The tag id (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tag_id', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tag_for_view_on_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'tag_id' is set
        if self.api_client.client_side_validation and ('tag_id' not in params or
                                                       params['tag_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tag_id` when calling `delete_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `delete_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_tag_for_view_on_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tag_id' in params:
            path_params['TAG_ID'] = params['tag_id']  # noqa: E501
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/tags/{TAG_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_transaction_narrative(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete a Transaction Narrative  # noqa: E501

        <p>Deletes the description of the transaction TRANSACTION_ID.</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_transaction_narrative(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_transaction_narrative_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_transaction_narrative_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_transaction_narrative_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete a Transaction Narrative  # noqa: E501

        <p>Deletes the description of the transaction TRANSACTION_ID.</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_transaction_narrative_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_transaction_narrative" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `delete_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_transaction_narrative`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/narrative', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_where_tag_for_view_on_transaction(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete a Transaction Tag  # noqa: E501

        <p>Deletes the where tag of the transaction TRANSACTION_ID made on <a href=\"#1_2_1-getViewsForBankAccount\">view</a>.</p><p>Authentication is Mandatory</p><p>The user must either have owner privileges for this account, or must be the user that posted the geo tag.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_where_tag_for_view_on_transaction(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_where_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_where_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_where_tag_for_view_on_transaction_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete a Transaction Tag  # noqa: E501

        <p>Deletes the where tag of the transaction TRANSACTION_ID made on <a href=\"#1_2_1-getViewsForBankAccount\">view</a>.</p><p>Authentication is Mandatory</p><p>The user must either have owner privileges for this account, or must be the user that posted the geo tag.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_where_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_where_tag_for_view_on_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `delete_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_where_tag_for_view_on_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/where', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_comments_for_view_on_transaction(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Transaction Comments  # noqa: E501

        <p>Returns the transaction TRANSACTION_ID comments made on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> (VIEW_ID).</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_comments_for_view_on_transaction(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionCommentsJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_comments_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_comments_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_comments_for_view_on_transaction_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Transaction Comments  # noqa: E501

        <p>Returns the transaction TRANSACTION_ID comments made on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> (VIEW_ID).</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_comments_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionCommentsJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_comments_for_view_on_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_comments_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `get_comments_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_comments_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_comments_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_comments_for_view_on_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/comments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionCommentsJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_images_for_view_on_transaction(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Transaction Images  # noqa: E501

        <p>Returns the transaction TRANSACTION_ID images made on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> (VIEW_ID).<br />Authentication via OAuth is required if the view is not public.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_images_for_view_on_transaction(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionImagesJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_images_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_images_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_images_for_view_on_transaction_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Transaction Images  # noqa: E501

        <p>Returns the transaction TRANSACTION_ID images made on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> (VIEW_ID).<br />Authentication via OAuth is required if the view is not public.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_images_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionImagesJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_images_for_view_on_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_images_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `get_images_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_images_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_images_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_images_for_view_on_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/images', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionImagesJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tags_for_view_on_transaction(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Transaction Tags  # noqa: E501

        <p>Returns the transaction TRANSACTION_ID tags made on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> (VIEW_ID).<br />Authentication via OAuth is required if the view is not public.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tags_for_view_on_transaction(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionTagJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tags_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tags_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_tags_for_view_on_transaction_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Transaction Tags  # noqa: E501

        <p>Returns the transaction TRANSACTION_ID tags made on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> (VIEW_ID).<br />Authentication via OAuth is required if the view is not public.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tags_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionTagJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tags_for_view_on_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_tags_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `get_tags_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_tags_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_tags_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_tags_for_view_on_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionTagJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transaction_narrative(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get a Transaction Narrative  # noqa: E501

        <p>Returns the account owner description of the transaction <a href=\"#1_2_1-getViewsForBankAccount\">moderated</a> by the view.</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_narrative(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionNarrativeJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transaction_narrative_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_transaction_narrative_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_transaction_narrative_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get a Transaction Narrative  # noqa: E501

        <p>Returns the account owner description of the transaction <a href=\"#1_2_1-getViewsForBankAccount\">moderated</a> by the view.</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_narrative_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionNarrativeJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction_narrative" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `get_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_transaction_narrative`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/narrative', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionNarrativeJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_where_tag_for_view_on_transaction(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get a Transaction where Tag  # noqa: E501

        <p>Returns the &quot;where&quot; Geo tag added to the transaction TRANSACTION_ID made on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> (VIEW_ID).<br />It represents the location where the transaction has been initiated.</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_where_tag_for_view_on_transaction(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionWhereJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_where_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_where_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_where_tag_for_view_on_transaction_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get a Transaction where Tag  # noqa: E501

        <p>Returns the &quot;where&quot; Geo tag added to the transaction TRANSACTION_ID made on a <a href=\"#1_2_1-getViewsForBankAccount\">view</a> (VIEW_ID).<br />It represents the location where the transaction has been initiated.</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_where_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: TransactionWhereJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_where_tag_for_view_on_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `get_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_where_tag_for_view_on_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/where', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionWhereJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_transaction_narrative(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update a Transaction Narrative  # noqa: E501

        <p>Updates the description of the transaction TRANSACTION_ID.</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_transaction_narrative(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionNarrativeJSON body: TransactionNarrativeJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_transaction_narrative_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_transaction_narrative_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_transaction_narrative_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update a Transaction Narrative  # noqa: E501

        <p>Updates the description of the transaction TRANSACTION_ID.</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_transaction_narrative_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionNarrativeJSON body: TransactionNarrativeJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_transaction_narrative" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `update_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_transaction_narrative`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_transaction_narrative`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/narrative', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_where_tag_for_view_on_transaction(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update a Transaction where Tag  # noqa: E501

        <p>Updates the &quot;where&quot; Geo tag on a transaction TRANSACTION_ID in a <a href=\"#1_2_1-getViewsForBankAccount\">view</a>.</p><p>Authentication is Mandatory</p><p>The geo tag is linked with the user.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_where_tag_for_view_on_transaction(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTransactionWhereJSON body: PostTransactionWhereJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_where_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_where_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_where_tag_for_view_on_transaction_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update a Transaction where Tag  # noqa: E501

        <p>Updates the &quot;where&quot; Geo tag on a transaction TRANSACTION_ID in a <a href=\"#1_2_1-getViewsForBankAccount\">view</a>.</p><p>Authentication is Mandatory</p><p>The geo tag is linked with the user.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_where_tag_for_view_on_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTransactionWhereJSON body: PostTransactionWhereJSON object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_where_tag_for_view_on_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `update_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_where_tag_for_view_on_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_where_tag_for_view_on_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/metadata/where', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
