# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class ScopeApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_scope(self, body, consumer_id, **kwargs):  # noqa: E501
        """Create Scope for a Consumer  # noqa: E501

        <p>Create Scope. Grant Role to Consumer.</p><p>Scopes are used to grant System or Bank level roles to the Consumer (App). (For Account level privileges, see Views)</p><p>For a System level Role (.e.g CanGetAnyUser), set bank_id to an empty string i.e. &quot;bank_id&quot;:&quot;&quot;</p><p>For a Bank level Role (e.g. CanCreateAccount), set bank_id to a valid value e.g. &quot;bank_id&quot;:&quot;my-bank-id&quot;</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_scope(body, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateScopeJson body: CreateScopeJson object that needs to be added. (required)
        :param str consumer_id: new consumer id (required)
        :return: ScopeJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_scope_with_http_info(body, consumer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_scope_with_http_info(body, consumer_id, **kwargs)  # noqa: E501
            return data

    def add_scope_with_http_info(self, body, consumer_id, **kwargs):  # noqa: E501
        """Create Scope for a Consumer  # noqa: E501

        <p>Create Scope. Grant Role to Consumer.</p><p>Scopes are used to grant System or Bank level roles to the Consumer (App). (For Account level privileges, see Views)</p><p>For a System level Role (.e.g CanGetAnyUser), set bank_id to an empty string i.e. &quot;bank_id&quot;:&quot;&quot;</p><p>For a Bank level Role (e.g. CanCreateAccount), set bank_id to a valid value e.g. &quot;bank_id&quot;:&quot;my-bank-id&quot;</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_scope_with_http_info(body, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateScopeJson body: CreateScopeJson object that needs to be added. (required)
        :param str consumer_id: new consumer id (required)
        :return: ScopeJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'consumer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_scope" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_scope`")  # noqa: E501
        # verify the required parameter 'consumer_id' is set
        if self.api_client.client_side_validation and ('consumer_id' not in params or
                                                       params['consumer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `consumer_id` when calling `add_scope`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'consumer_id' in params:
            path_params['CONSUMER_ID'] = params['consumer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/consumers/{CONSUMER_ID}/scopes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScopeJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_scope(self, scope_id, consumer_id, **kwargs):  # noqa: E501
        """Delete Consumer Scope  # noqa: E501

        <p>Delete Consumer Scope specified by SCOPE_ID for an consumer specified by CONSUMER_ID</p><p>Authentication is required and the user needs to be a Super Admin.<br />Super Admins are listed in the Props file.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scope(scope_id, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope_id: the scope id (required)
        :param str consumer_id: new consumer id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scope_with_http_info(scope_id, consumer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scope_with_http_info(scope_id, consumer_id, **kwargs)  # noqa: E501
            return data

    def delete_scope_with_http_info(self, scope_id, consumer_id, **kwargs):  # noqa: E501
        """Delete Consumer Scope  # noqa: E501

        <p>Delete Consumer Scope specified by SCOPE_ID for an consumer specified by CONSUMER_ID</p><p>Authentication is required and the user needs to be a Super Admin.<br />Super Admins are listed in the Props file.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scope_with_http_info(scope_id, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope_id: the scope id (required)
        :param str consumer_id: new consumer id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope_id', 'consumer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_scope" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'scope_id' is set
        if self.api_client.client_side_validation and ('scope_id' not in params or
                                                       params['scope_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `scope_id` when calling `delete_scope`")  # noqa: E501
        # verify the required parameter 'consumer_id' is set
        if self.api_client.client_side_validation and ('consumer_id' not in params or
                                                       params['consumer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `consumer_id` when calling `delete_scope`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scope_id' in params:
            path_params['SCOPE_ID'] = params['scope_id']  # noqa: E501
        if 'consumer_id' in params:
            path_params['CONSUMER_ID'] = params['consumer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/consumers/{CONSUMER_ID}/scope/{SCOPE_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scopes(self, consumer_id, **kwargs):  # noqa: E501
        """Get Scopes for Consumer  # noqa: E501

        <p>Get all the scopes for an consumer specified by CONSUMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scopes(consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str consumer_id: new consumer id (required)
        :return: ScopeJsons
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scopes_with_http_info(consumer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scopes_with_http_info(consumer_id, **kwargs)  # noqa: E501
            return data

    def get_scopes_with_http_info(self, consumer_id, **kwargs):  # noqa: E501
        """Get Scopes for Consumer  # noqa: E501

        <p>Get all the scopes for an consumer specified by CONSUMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scopes_with_http_info(consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str consumer_id: new consumer id (required)
        :return: ScopeJsons
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['consumer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scopes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'consumer_id' is set
        if self.api_client.client_side_validation and ('consumer_id' not in params or
                                                       params['consumer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `consumer_id` when calling `get_scopes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'consumer_id' in params:
            path_params['CONSUMER_ID'] = params['consumer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/consumers/{CONSUMER_ID}/scopes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScopeJsons',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
