# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class MetricApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def elastic_search_metrics(self, body, **kwargs):  # noqa: E501
        """Search API Metrics via Elasticsearch  # noqa: E501

        <p>Search the API calls made to this API instance via Elastic Search.</p><p>Login is required.</p><p>CanSearchMetrics entitlement is required to search metrics data.</p><p>parameters:</p><p>esType  - elasticsearch type</p><p>simple query:</p><p>q       - plain_text_query</p><p>df      - default field to search</p><p>sort    - field to sort on</p><p>size    - number of hits returned, default 10</p><p>from    - show hits starting from</p><p>json query:</p><p>source  - JSON_query_(URL-escaped)</p><p>example usage:</p><p>/search/metrics/q=findThis</p><p>or:</p><p>/search/metrics/source={&quot;query&quot;:{&quot;query_string&quot;:{&quot;query&quot;:&quot;findThis&quot;}}}</p><p>Note!!</p><p>The whole JSON query string MUST be URL-encoded:</p><ul><li>For {  use %7B</li><li>For }  use %7D</li><li>For : use %3A</li><li>For &quot; use %22</li></ul><p>etc..</p><p>Only q, source and esType are passed to Elastic</p><p>Elastic simple query: <a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/search-uri-request.html\">https://www.elastic.co/guide/en/elasticsearch/reference/current/search-uri-request.html</a></p><p>Elastic JSON query: <a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-filter-context.html\">https://www.elastic.co/guide/en/elasticsearch/reference/current/query-filter-context.html</a></p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elastic_search_metrics(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.elastic_search_metrics_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.elastic_search_metrics_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def elastic_search_metrics_with_http_info(self, body, **kwargs):  # noqa: E501
        """Search API Metrics via Elasticsearch  # noqa: E501

        <p>Search the API calls made to this API instance via Elastic Search.</p><p>Login is required.</p><p>CanSearchMetrics entitlement is required to search metrics data.</p><p>parameters:</p><p>esType  - elasticsearch type</p><p>simple query:</p><p>q       - plain_text_query</p><p>df      - default field to search</p><p>sort    - field to sort on</p><p>size    - number of hits returned, default 10</p><p>from    - show hits starting from</p><p>json query:</p><p>source  - JSON_query_(URL-escaped)</p><p>example usage:</p><p>/search/metrics/q=findThis</p><p>or:</p><p>/search/metrics/source={&quot;query&quot;:{&quot;query_string&quot;:{&quot;query&quot;:&quot;findThis&quot;}}}</p><p>Note!!</p><p>The whole JSON query string MUST be URL-encoded:</p><ul><li>For {  use %7B</li><li>For }  use %7D</li><li>For : use %3A</li><li>For &quot; use %22</li></ul><p>etc..</p><p>Only q, source and esType are passed to Elastic</p><p>Elastic simple query: <a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/search-uri-request.html\">https://www.elastic.co/guide/en/elasticsearch/reference/current/search-uri-request.html</a></p><p>Elastic JSON query: <a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-filter-context.html\">https://www.elastic.co/guide/en/elasticsearch/reference/current/query-filter-context.html</a></p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elastic_search_metrics_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method elastic_search_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `elastic_search_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/search/metrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_aggregate_metrics(self, **kwargs):  # noqa: E501
        """Get Aggregate Metrics  # noqa: E501

        <p>Returns aggregate metrics on api usage eg. total count, response time (in ms), etc.</p><p>Should be able to filter on the following fields</p><p>eg: /management/aggregate-metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;consumer_id=5<br />&amp;user_id=66214b8e-259e-44ad-8868-3eb47be70646&amp;implemented_by_partial_function=getTransactionsForBankAccount<br />&amp;implemented_in_version=v3.0.0&amp;url=/obp/v3.0.0/banks/gh.29.uk/accounts/8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0/owner/transactions<br />&amp;verb=GET&amp;anon=false&amp;app_name=MapperPostman<br />&amp;exclude_app_names=API-EXPLORER,API-Manager,SOFI,null</p><p>1 from_date (defaults to the day before the current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to the current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 consumer_id  (if null ignore)</p><p>4 user_id (if null ignore)</p><p>5 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>6 url (if null ignore), note: can not contain '&amp;'.</p><p>7 app_name (if null ignore)</p><p>8 implemented_by_partial_function (if null ignore),</p><p>9 implemented_in_version (if null ignore)</p><p>10 verb (if null ignore)</p><p>11 correlation_id (if null ignore)</p><p>12 duration (if null ignore) non digit chars will be silently omitted</p><p>13 exclude_app_names (if null ignore).eg: &amp;exclude_app_names=API-EXPLORER,API-Manager,SOFI,null</p><p>14 exclude_url_patterns (if null ignore).you can design you own SQL NOT LIKE pattern. eg: &amp;exclude_url_patterns=%management/metrics%,%management/aggregate-metrics%</p><p>15 exclude_implemented_by_partial_functions (if null ignore).eg: &amp;exclude_implemented_by_partial_functions=getMetrics,getConnectorMetrics,getAggregateMetrics</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aggregate_metrics(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AggregateMetricJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_aggregate_metrics_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_aggregate_metrics_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_aggregate_metrics_with_http_info(self, **kwargs):  # noqa: E501
        """Get Aggregate Metrics  # noqa: E501

        <p>Returns aggregate metrics on api usage eg. total count, response time (in ms), etc.</p><p>Should be able to filter on the following fields</p><p>eg: /management/aggregate-metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;consumer_id=5<br />&amp;user_id=66214b8e-259e-44ad-8868-3eb47be70646&amp;implemented_by_partial_function=getTransactionsForBankAccount<br />&amp;implemented_in_version=v3.0.0&amp;url=/obp/v3.0.0/banks/gh.29.uk/accounts/8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0/owner/transactions<br />&amp;verb=GET&amp;anon=false&amp;app_name=MapperPostman<br />&amp;exclude_app_names=API-EXPLORER,API-Manager,SOFI,null</p><p>1 from_date (defaults to the day before the current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to the current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 consumer_id  (if null ignore)</p><p>4 user_id (if null ignore)</p><p>5 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>6 url (if null ignore), note: can not contain '&amp;'.</p><p>7 app_name (if null ignore)</p><p>8 implemented_by_partial_function (if null ignore),</p><p>9 implemented_in_version (if null ignore)</p><p>10 verb (if null ignore)</p><p>11 correlation_id (if null ignore)</p><p>12 duration (if null ignore) non digit chars will be silently omitted</p><p>13 exclude_app_names (if null ignore).eg: &amp;exclude_app_names=API-EXPLORER,API-Manager,SOFI,null</p><p>14 exclude_url_patterns (if null ignore).you can design you own SQL NOT LIKE pattern. eg: &amp;exclude_url_patterns=%management/metrics%,%management/aggregate-metrics%</p><p>15 exclude_implemented_by_partial_functions (if null ignore).eg: &amp;exclude_implemented_by_partial_functions=getMetrics,getConnectorMetrics,getAggregateMetrics</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aggregate_metrics_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AggregateMetricJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_aggregate_metrics" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/aggregate-metrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AggregateMetricJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_connector_metrics(self, body, **kwargs):  # noqa: E501
        """Get Connector Metrics  # noqa: E501

        <p>Get the all metrics</p><p>require CanGetConnectorMetrics role</p><p>Filters Part 1.<em>filtering</em> (no wilde cards etc.) parameters to GET /management/connector/metrics</p><p>Should be able to filter on the following metrics fields</p><p>eg: /management/connector/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=50&amp;offset=2</p><p>1 from_date (defaults to one week before current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 limit (for pagination: defaults to 1000)  eg:limit=2000</p><p>4 offset (for pagination: zero index, defaults to 0) eg: offset=10</p><p>eg: /management/connector/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=100&amp;offset=300</p><p>Other filters:</p><p>5 connector_name  (if null ignore)</p><p>6 function_name (if null ignore)</p><p>7 correlation_id (if null ignore)</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connector_metrics(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: ConnectorMetricsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_connector_metrics_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_connector_metrics_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_connector_metrics_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get Connector Metrics  # noqa: E501

        <p>Get the all metrics</p><p>require CanGetConnectorMetrics role</p><p>Filters Part 1.<em>filtering</em> (no wilde cards etc.) parameters to GET /management/connector/metrics</p><p>Should be able to filter on the following metrics fields</p><p>eg: /management/connector/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=50&amp;offset=2</p><p>1 from_date (defaults to one week before current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 limit (for pagination: defaults to 1000)  eg:limit=2000</p><p>4 offset (for pagination: zero index, defaults to 0) eg: offset=10</p><p>eg: /management/connector/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=100&amp;offset=300</p><p>Other filters:</p><p>5 connector_name  (if null ignore)</p><p>6 function_name (if null ignore)</p><p>7 correlation_id (if null ignore)</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connector_metrics_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: ConnectorMetricsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connector_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_connector_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/connector/metrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConnectorMetricsJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metrics(self, body, **kwargs):  # noqa: E501
        """Get Metrics  # noqa: E501

        <p>Get the all metrics</p><p>require CanReadMetrics role</p><p>Filters Part 1.<em>filtering</em> (no wilde cards etc.) parameters to GET /management/metrics</p><p>Should be able to filter on the following metrics fields</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=50&amp;offset=2</p><p>1 from_date (defaults to one week before current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 limit (for pagination: defaults to 50)  eg:limit=200</p><p>4 offset (for pagination: zero index, defaults to 0) eg: offset=10</p><p>5 sort_by (defaults to date field) eg: sort_by=date<br />possible values:<br />&quot;url&quot;,<br />&quot;date&quot;,<br />&quot;user_name&quot;,<br />&quot;app_name&quot;,<br />&quot;developer_email&quot;,<br />&quot;implemented_by_partial_function&quot;,<br />&quot;implemented_in_version&quot;,<br />&quot;consumer_id&quot;,<br />&quot;verb&quot;</p><p>6 direction (defaults to date desc) eg: direction=desc</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:<a href=\"m&#97;&#x69;&#108;&#x74;&#111;:&#48;&#49;&#x2e;&#x30;&#x30;&#x30;&#x5a;&#38;&#x6c;&#105;&#x6d;&#x69;&#x74;&#x3d;&#49;&#48;&#48;0&#48;&#38;&#111;&#x66;&#102;&#115;&#101;t&#x3d;&#x30;&amp;&#x61;&#110;&#111;&#x6e;&#x3d;&#x66;a&#x6c;&#x73;&#x65;&#38;&#x61;&#x70;&#x70;&#95;&#x6e;&#x61;&#x6d;e=&#84;&#101;&#x61;&#x74;&#x41;&#112;&#x70;&#x26;&#x69;&#x6d;p&#x6c;&#101;&#x6d;&#x65;&#x6e;&#116;&#x65;&#100;_i&#x6e;&#95;&#118;e&#114;&#x73;&#105;&#x6f;&#110;&#x3d;&#x76;&#x32;&#x2e;&#x31;.&#48;&#x26;v&#101;&#x72;&#x62;&#61;&#x50;OS&#84;&amp;&#x75;&#x73;&#101;&#x72;&#x5f;&#x69;&#x64;&#x3d;&#99;&#x37;&#98;&#54;c&#x62;&#x34;&#x37;&#45;&#x63;&#98;&#57;&#54;&#x2d;&#x34;&#52;&#52;1&#45;&#x38;&#56;&#x30;1&#x2d;&#x33;&#53;&#98;&#53;&#x37;&#x34;&#x35;&#54;&#x37;&#x35;&#51;&#x61;&amp;&#x75;&#115;e&#x72;&#95;&#110;a&#109;e&#x3d;&#115;&#117;&#x73;&#x61;&#110;&#x2e;&#x75;&#x6b;&#46;&#x32;&#57;@&#x65;&#120;&#97;&#109;p&#108;&#x65;.&#99;&#x6f;&#109;\">&#x30;1&#x2e;&#x30;&#x30;&#x30;&#90;&#38;l&#x69;&#x6d;&#105;&#x74;=&#x31;&#48;&#x30;0&#48;&amp;&#111;&#x66;&#x66;&#115;&#101;t=&#48;&#x26;a&#x6e;o&#110;&#x3d;&#102;&#97;&#108;&#115;&#101;&#38;&#x61;p&#x70;&#x5f;&#110;&#x61;&#x6d;&#101;=&#84;&#101;a&#x74;&#x41;&#112;&#x70;&#38;i&#109;p&#x6c;&#x65;&#x6d;&#x65;&#110;&#116;&#x65;d&#95;i&#x6e;&#95;&#x76;&#101;&#114;s&#105;o&#x6e;=&#x76;&#x32;&#x2e;1&#46;&#48;&#x26;v&#x65;&#x72;&#98;&#x3d;&#x50;&#x4f;&#83;&#84;&#x26;&#117;&#x73;&#x65;r&#95;&#105;d=&#99;&#x37;&#x62;&#x36;&#99;&#x62;&#x34;&#x37;&#45;&#99;&#98;&#x39;&#54;-&#52;&#x34;&#52;&#x31;-&#56;&#56;&#48;1&#45;&#x33;5&#x62;5&#x37;&#x34;&#53;&#54;&#x37;&#53;&#x33;&#97;&#x26;u&#115;&#x65;&#x72;&#95;n&#x61;me&#61;&#115;&#117;s&#97;&#110;&#46;&#117;&#107;&#x2e;&#x32;9&#x40;&#x65;&#x78;&#97;&#x6d;p&#x6c;e&#x2e;co&#109;</a>&amp;consumer_id=78</p><p>Other filters:</p><p>7 consumer_id  (if null ignore)</p><p>8 user_id (if null ignore)</p><p>9 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>10 url (if null ignore), note: can not contain '&amp;'.</p><p>11 app_name (if null ignore)</p><p>12 implemented_by_partial_function (if null ignore),</p><p>13 implemented_in_version (if null ignore)</p><p>14 verb (if null ignore)</p><p>15 correlation_id (if null ignore)</p><p>16 duration (if null ignore) non digit chars will be silently omitted</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metrics(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: MetricsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_metrics_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_metrics_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_metrics_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get Metrics  # noqa: E501

        <p>Get the all metrics</p><p>require CanReadMetrics role</p><p>Filters Part 1.<em>filtering</em> (no wilde cards etc.) parameters to GET /management/metrics</p><p>Should be able to filter on the following metrics fields</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=50&amp;offset=2</p><p>1 from_date (defaults to one week before current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 limit (for pagination: defaults to 50)  eg:limit=200</p><p>4 offset (for pagination: zero index, defaults to 0) eg: offset=10</p><p>5 sort_by (defaults to date field) eg: sort_by=date<br />possible values:<br />&quot;url&quot;,<br />&quot;date&quot;,<br />&quot;user_name&quot;,<br />&quot;app_name&quot;,<br />&quot;developer_email&quot;,<br />&quot;implemented_by_partial_function&quot;,<br />&quot;implemented_in_version&quot;,<br />&quot;consumer_id&quot;,<br />&quot;verb&quot;</p><p>6 direction (defaults to date desc) eg: direction=desc</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:<a href=\"m&#97;&#x69;&#108;&#x74;&#111;:&#48;&#49;&#x2e;&#x30;&#x30;&#x30;&#x5a;&#38;&#x6c;&#105;&#x6d;&#x69;&#x74;&#x3d;&#49;&#48;&#48;0&#48;&#38;&#111;&#x66;&#102;&#115;&#101;t&#x3d;&#x30;&amp;&#x61;&#110;&#111;&#x6e;&#x3d;&#x66;a&#x6c;&#x73;&#x65;&#38;&#x61;&#x70;&#x70;&#95;&#x6e;&#x61;&#x6d;e=&#84;&#101;&#x61;&#x74;&#x41;&#112;&#x70;&#x26;&#x69;&#x6d;p&#x6c;&#101;&#x6d;&#x65;&#x6e;&#116;&#x65;&#100;_i&#x6e;&#95;&#118;e&#114;&#x73;&#105;&#x6f;&#110;&#x3d;&#x76;&#x32;&#x2e;&#x31;.&#48;&#x26;v&#101;&#x72;&#x62;&#61;&#x50;OS&#84;&amp;&#x75;&#x73;&#101;&#x72;&#x5f;&#x69;&#x64;&#x3d;&#99;&#x37;&#98;&#54;c&#x62;&#x34;&#x37;&#45;&#x63;&#98;&#57;&#54;&#x2d;&#x34;&#52;&#52;1&#45;&#x38;&#56;&#x30;1&#x2d;&#x33;&#53;&#98;&#53;&#x37;&#x34;&#x35;&#54;&#x37;&#x35;&#51;&#x61;&amp;&#x75;&#115;e&#x72;&#95;&#110;a&#109;e&#x3d;&#115;&#117;&#x73;&#x61;&#110;&#x2e;&#x75;&#x6b;&#46;&#x32;&#57;@&#x65;&#120;&#97;&#109;p&#108;&#x65;.&#99;&#x6f;&#109;\">&#x30;1&#x2e;&#x30;&#x30;&#x30;&#90;&#38;l&#x69;&#x6d;&#105;&#x74;=&#x31;&#48;&#x30;0&#48;&amp;&#111;&#x66;&#x66;&#115;&#101;t=&#48;&#x26;a&#x6e;o&#110;&#x3d;&#102;&#97;&#108;&#115;&#101;&#38;&#x61;p&#x70;&#x5f;&#110;&#x61;&#x6d;&#101;=&#84;&#101;a&#x74;&#x41;&#112;&#x70;&#38;i&#109;p&#x6c;&#x65;&#x6d;&#x65;&#110;&#116;&#x65;d&#95;i&#x6e;&#95;&#x76;&#101;&#114;s&#105;o&#x6e;=&#x76;&#x32;&#x2e;1&#46;&#48;&#x26;v&#x65;&#x72;&#98;&#x3d;&#x50;&#x4f;&#83;&#84;&#x26;&#117;&#x73;&#x65;r&#95;&#105;d=&#99;&#x37;&#x62;&#x36;&#99;&#x62;&#x34;&#x37;&#45;&#99;&#98;&#x39;&#54;-&#52;&#x34;&#52;&#x31;-&#56;&#56;&#48;1&#45;&#x33;5&#x62;5&#x37;&#x34;&#53;&#54;&#x37;&#53;&#x33;&#97;&#x26;u&#115;&#x65;&#x72;&#95;n&#x61;me&#61;&#115;&#117;s&#97;&#110;&#46;&#117;&#107;&#x2e;&#x32;9&#x40;&#x65;&#x78;&#97;&#x6d;p&#x6c;e&#x2e;co&#109;</a>&amp;consumer_id=78</p><p>Other filters:</p><p>7 consumer_id  (if null ignore)</p><p>8 user_id (if null ignore)</p><p>9 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>10 url (if null ignore), note: can not contain '&amp;'.</p><p>11 app_name (if null ignore)</p><p>12 implemented_by_partial_function (if null ignore),</p><p>13 implemented_in_version (if null ignore)</p><p>14 verb (if null ignore)</p><p>15 correlation_id (if null ignore)</p><p>16 duration (if null ignore) non digit chars will be silently omitted</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metrics_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: MetricsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/metrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetricsJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metrics_at_bank(self, bank_id, **kwargs):  # noqa: E501
        """Get Metrics at Bank  # noqa: E501

        <p>Get the all metrics at the Bank specified by BANK_ID</p><p>require CanReadMetrics role</p><p>Filters Part 1.<em>filtering</em> (no wilde cards etc.) parameters to GET /management/metrics</p><p>Should be able to filter on the following metrics fields</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=50&amp;offset=2</p><p>1 from_date (defaults to one week before current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 limit (for pagination: defaults to 50)  eg:limit=200</p><p>4 offset (for pagination: zero index, defaults to 0) eg: offset=10</p><p>5 sort_by (defaults to date field) eg: sort_by=date<br />possible values:<br />&quot;url&quot;,<br />&quot;date&quot;,<br />&quot;user_name&quot;,<br />&quot;app_name&quot;,<br />&quot;developer_email&quot;,<br />&quot;implemented_by_partial_function&quot;,<br />&quot;implemented_in_version&quot;,<br />&quot;consumer_id&quot;,<br />&quot;verb&quot;</p><p>6 direction (defaults to date desc) eg: direction=desc</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:<a href=\"&#109;&#97;&#x69;&#108;&#116;&#111;&#58;&#x30;&#x31;&#x2e;&#x30;&#48;&#x30;&#90;&amp;l&#x69;&#x6d;&#x69;&#x74;&#61;&#x31;0&#x30;&#x30;&#48;&#38;&#x6f;&#x66;&#x66;&#x73;&#101;t=0&#x26;&#97;&#110;&#111;&#x6e;&#x3d;&#102;&#x61;&#x6c;&#x73;&#101;&#38;&#x61;p&#x70;&#x5f;&#x6e;a&#109;&#101;&#x3d;&#x54;&#x65;a&#116;&#x41;&#x70;&#x70;&#x26;&#x69;&#x6d;&#112;l&#101;&#109;e&#x6e;&#x74;&#x65;&#x64;&#x5f;i&#110;&#95;&#118;&#101;&#114;s&#x69;o&#x6e;&#61;&#x76;&#50;&#x2e;&#49;.&#x30;&amp;&#118;&#x65;r&#x62;&#61;&#x50;&#79;&#x53;&#84;&#38;&#117;&#x73;&#101;&#114;&#95;&#x69;&#x64;=&#x63;&#x37;&#98;&#54;cb&#52;7&#x2d;cb&#x39;6&#45;&#x34;&#52;&#x34;1&#x2d;&#x38;&#56;&#x30;&#x31;&#x2d;&#51;&#x35;&#x62;&#x35;&#55;&#x34;5&#54;&#55;&#x35;3&#97;&#38;&#117;&#115;&#x65;&#x72;&#95;n&#x61;&#x6d;&#101;&#61;&#x73;&#117;&#115;&#97;&#x6e;&#x2e;&#x75;&#x6b;&#46;&#x32;&#x39;&#64;&#101;&#x78;&#97;&#109;&#x70;l&#x65;&#46;c&#111;&#109;\">&#x30;&#49;.&#48;&#x30;&#x30;&#90;&#x26;&#108;&#105;&#109;&#105;&#x74;=10&#x30;&#x30;&#x30;&#38;&#x6f;&#102;&#102;&#115;e&#116;&#61;&#x30;&#38;&#97;n&#111;&#x6e;&#61;&#x66;&#97;&#x6c;&#115;&#101;&amp;&#x61;&#x70;&#x70;&#x5f;&#x6e;a&#109;&#101;&#x3d;&#84;&#101;&#x61;&#116;&#x41;&#112;&#x70;&#x26;i&#x6d;&#x70;&#x6c;&#101;&#109;&#x65;&#110;&#x74;&#x65;&#x64;&#95;&#105;&#x6e;&#95;&#118;&#101;&#114;&#x73;&#x69;&#111;&#110;&#61;v&#50;&#x2e;&#x31;&#x2e;0&#x26;&#118;&#101;&#114;&#98;=&#80;&#x4f;S&#x54;&#x26;&#x75;&#x73;&#x65;&#x72;&#95;&#105;&#x64;&#x3d;&#99;&#55;&#x62;&#54;&#x63;&#98;&#x34;&#x37;-c&#x62;&#57;&#x36;-&#x34;44&#x31;&#45;&#56;8&#x30;&#49;&#45;&#x33;&#53;b&#53;&#x37;&#52;&#x35;&#54;&#55;5&#51;&#97;&#38;&#x75;&#115;&#101;&#x72;&#x5f;&#110;&#97;&#x6d;&#101;&#61;&#115;&#117;&#115;a&#x6e;&#46;u&#107;&#46;&#x32;&#x39;&#x40;&#101;x&#x61;&#109;&#112;&#x6c;&#101;&#46;&#99;&#x6f;&#109;</a>&amp;consumer_id=78</p><p>Other filters:</p><p>7 consumer_id  (if null ignore)</p><p>8 user_id (if null ignore)</p><p>9 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>10 url (if null ignore), note: can not contain '&amp;'.</p><p>11 app_name (if null ignore)</p><p>12 implemented_by_partial_function (if null ignore),</p><p>13 implemented_in_version (if null ignore)</p><p>14 verb (if null ignore)</p><p>15 correlation_id (if null ignore)</p><p>16 duration (if null ignore) non digit chars will be silently omitted</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metrics_at_bank(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: MetricsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_metrics_at_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_metrics_at_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_metrics_at_bank_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Metrics at Bank  # noqa: E501

        <p>Get the all metrics at the Bank specified by BANK_ID</p><p>require CanReadMetrics role</p><p>Filters Part 1.<em>filtering</em> (no wilde cards etc.) parameters to GET /management/metrics</p><p>Should be able to filter on the following metrics fields</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=50&amp;offset=2</p><p>1 from_date (defaults to one week before current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 limit (for pagination: defaults to 50)  eg:limit=200</p><p>4 offset (for pagination: zero index, defaults to 0) eg: offset=10</p><p>5 sort_by (defaults to date field) eg: sort_by=date<br />possible values:<br />&quot;url&quot;,<br />&quot;date&quot;,<br />&quot;user_name&quot;,<br />&quot;app_name&quot;,<br />&quot;developer_email&quot;,<br />&quot;implemented_by_partial_function&quot;,<br />&quot;implemented_in_version&quot;,<br />&quot;consumer_id&quot;,<br />&quot;verb&quot;</p><p>6 direction (defaults to date desc) eg: direction=desc</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:<a href=\"&#109;&#97;&#x69;&#108;&#116;&#111;&#58;&#x30;&#x31;&#x2e;&#x30;&#48;&#x30;&#90;&amp;l&#x69;&#x6d;&#x69;&#x74;&#61;&#x31;0&#x30;&#x30;&#48;&#38;&#x6f;&#x66;&#x66;&#x73;&#101;t=0&#x26;&#97;&#110;&#111;&#x6e;&#x3d;&#102;&#x61;&#x6c;&#x73;&#101;&#38;&#x61;p&#x70;&#x5f;&#x6e;a&#109;&#101;&#x3d;&#x54;&#x65;a&#116;&#x41;&#x70;&#x70;&#x26;&#x69;&#x6d;&#112;l&#101;&#109;e&#x6e;&#x74;&#x65;&#x64;&#x5f;i&#110;&#95;&#118;&#101;&#114;s&#x69;o&#x6e;&#61;&#x76;&#50;&#x2e;&#49;.&#x30;&amp;&#118;&#x65;r&#x62;&#61;&#x50;&#79;&#x53;&#84;&#38;&#117;&#x73;&#101;&#114;&#95;&#x69;&#x64;=&#x63;&#x37;&#98;&#54;cb&#52;7&#x2d;cb&#x39;6&#45;&#x34;&#52;&#x34;1&#x2d;&#x38;&#56;&#x30;&#x31;&#x2d;&#51;&#x35;&#x62;&#x35;&#55;&#x34;5&#54;&#55;&#x35;3&#97;&#38;&#117;&#115;&#x65;&#x72;&#95;n&#x61;&#x6d;&#101;&#61;&#x73;&#117;&#115;&#97;&#x6e;&#x2e;&#x75;&#x6b;&#46;&#x32;&#x39;&#64;&#101;&#x78;&#97;&#109;&#x70;l&#x65;&#46;c&#111;&#109;\">&#x30;&#49;.&#48;&#x30;&#x30;&#90;&#x26;&#108;&#105;&#109;&#105;&#x74;=10&#x30;&#x30;&#x30;&#38;&#x6f;&#102;&#102;&#115;e&#116;&#61;&#x30;&#38;&#97;n&#111;&#x6e;&#61;&#x66;&#97;&#x6c;&#115;&#101;&amp;&#x61;&#x70;&#x70;&#x5f;&#x6e;a&#109;&#101;&#x3d;&#84;&#101;&#x61;&#116;&#x41;&#112;&#x70;&#x26;i&#x6d;&#x70;&#x6c;&#101;&#109;&#x65;&#110;&#x74;&#x65;&#x64;&#95;&#105;&#x6e;&#95;&#118;&#101;&#114;&#x73;&#x69;&#111;&#110;&#61;v&#50;&#x2e;&#x31;&#x2e;0&#x26;&#118;&#101;&#114;&#98;=&#80;&#x4f;S&#x54;&#x26;&#x75;&#x73;&#x65;&#x72;&#95;&#105;&#x64;&#x3d;&#99;&#55;&#x62;&#54;&#x63;&#98;&#x34;&#x37;-c&#x62;&#57;&#x36;-&#x34;44&#x31;&#45;&#56;8&#x30;&#49;&#45;&#x33;&#53;b&#53;&#x37;&#52;&#x35;&#54;&#55;5&#51;&#97;&#38;&#x75;&#115;&#101;&#x72;&#x5f;&#110;&#97;&#x6d;&#101;&#61;&#115;&#117;&#115;a&#x6e;&#46;u&#107;&#46;&#x32;&#x39;&#x40;&#101;x&#x61;&#109;&#112;&#x6c;&#101;&#46;&#99;&#x6f;&#109;</a>&amp;consumer_id=78</p><p>Other filters:</p><p>7 consumer_id  (if null ignore)</p><p>8 user_id (if null ignore)</p><p>9 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>10 url (if null ignore), note: can not contain '&amp;'.</p><p>11 app_name (if null ignore)</p><p>12 implemented_by_partial_function (if null ignore),</p><p>13 implemented_in_version (if null ignore)</p><p>14 verb (if null ignore)</p><p>15 correlation_id (if null ignore)</p><p>16 duration (if null ignore) non digit chars will be silently omitted</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metrics_at_bank_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: MetricsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metrics_at_bank" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_metrics_at_bank`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/metrics/banks/{BANK_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetricsJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metrics_top_consumers(self, **kwargs):  # noqa: E501
        """Get Top Consumers  # noqa: E501

        <p>Get metrics about the top consumers of the API usage e.g. total count, consumer_id and app_name.</p><p>Should be able to filter on the following fields</p><p>e.g.: /management/metrics/top-consumers?from_date=1970-01-01T00:00:00.000Z&amp;to_date=2023-03-29T11:38:53.813Z&amp;consumer_id=5<br />&amp;user_id=66214b8e-259e-44ad-8868-3eb47be70646&amp;implemented_by_partial_function=getTransactionsForBankAccount<br />&amp;implemented_in_version=v3.0.0&amp;url=/obp/v3.0.0/banks/gh.29.uk/accounts/8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0/owner/transactions<br />&amp;verb=GET&amp;anon=false&amp;app_name=MapperPostman<br />&amp;exclude_app_names=API-EXPLORER,API-Manager,SOFI,null<br />&amp;limit=100</p><p>1 from_date (defaults to the one year ago): eg:from_date=1970-01-01T00:00:00.000Z</p><p>2 to_date (defaults to the current date) eg:to_date=2023-03-29T11:38:53.814Z</p><p>3 consumer_id  (if null ignore)</p><p>4 user_id (if null ignore)</p><p>5 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>6 url (if null ignore), note: can not contain '&amp;'.</p><p>7 app_name (if null ignore)</p><p>8 implemented_by_partial_function (if null ignore),</p><p>9 implemented_in_version (if null ignore)</p><p>10 verb (if null ignore)</p><p>11 correlation_id (if null ignore)</p><p>12 duration (if null ignore) non digit chars will be silently omitted</p><p>13 exclude_app_names (if null ignore).eg: &amp;exclude_app_names=API-EXPLORER,API-Manager,SOFI,null</p><p>14 exclude_url_patterns (if null ignore).you can design you own SQL NOT LIKE pattern. eg: &amp;exclude_url_patterns=%management/metrics%,%management/aggregate-metrics%</p><p>15 exclude_implemented_by_partial_functions (if null ignore).eg: &amp;exclude_implemented_by_partial_functions=getMetrics,getConnectorMetrics,getAggregateMetrics</p><p>16 limit (for pagination: defaults to 50)  eg:limit=200</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metrics_top_consumers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TopConsumersJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_metrics_top_consumers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_metrics_top_consumers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_metrics_top_consumers_with_http_info(self, **kwargs):  # noqa: E501
        """Get Top Consumers  # noqa: E501

        <p>Get metrics about the top consumers of the API usage e.g. total count, consumer_id and app_name.</p><p>Should be able to filter on the following fields</p><p>e.g.: /management/metrics/top-consumers?from_date=1970-01-01T00:00:00.000Z&amp;to_date=2023-03-29T11:38:53.813Z&amp;consumer_id=5<br />&amp;user_id=66214b8e-259e-44ad-8868-3eb47be70646&amp;implemented_by_partial_function=getTransactionsForBankAccount<br />&amp;implemented_in_version=v3.0.0&amp;url=/obp/v3.0.0/banks/gh.29.uk/accounts/8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0/owner/transactions<br />&amp;verb=GET&amp;anon=false&amp;app_name=MapperPostman<br />&amp;exclude_app_names=API-EXPLORER,API-Manager,SOFI,null<br />&amp;limit=100</p><p>1 from_date (defaults to the one year ago): eg:from_date=1970-01-01T00:00:00.000Z</p><p>2 to_date (defaults to the current date) eg:to_date=2023-03-29T11:38:53.814Z</p><p>3 consumer_id  (if null ignore)</p><p>4 user_id (if null ignore)</p><p>5 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>6 url (if null ignore), note: can not contain '&amp;'.</p><p>7 app_name (if null ignore)</p><p>8 implemented_by_partial_function (if null ignore),</p><p>9 implemented_in_version (if null ignore)</p><p>10 verb (if null ignore)</p><p>11 correlation_id (if null ignore)</p><p>12 duration (if null ignore) non digit chars will be silently omitted</p><p>13 exclude_app_names (if null ignore).eg: &amp;exclude_app_names=API-EXPLORER,API-Manager,SOFI,null</p><p>14 exclude_url_patterns (if null ignore).you can design you own SQL NOT LIKE pattern. eg: &amp;exclude_url_patterns=%management/metrics%,%management/aggregate-metrics%</p><p>15 exclude_implemented_by_partial_functions (if null ignore).eg: &amp;exclude_implemented_by_partial_functions=getMetrics,getConnectorMetrics,getAggregateMetrics</p><p>16 limit (for pagination: defaults to 50)  eg:limit=200</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metrics_top_consumers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TopConsumersJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metrics_top_consumers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/metrics/top-consumers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TopConsumersJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_top_apis(self, **kwargs):  # noqa: E501
        """Get Top APIs  # noqa: E501

        <p>Get metrics about the most popular APIs. e.g.: total count, response time (in ms), etc.</p><p>Should be able to filter on the following fields</p><p>eg: /management/metrics/top-apis?from_date=1970-01-01T00:00:00.000Z&amp;to_date=2023-03-29T11:38:53.812Z&amp;consumer_id=5<br />&amp;user_id=66214b8e-259e-44ad-8868-3eb47be70646&amp;implemented_by_partial_function=getTransactionsForBankAccount<br />&amp;implemented_in_version=v3.0.0&amp;url=/obp/v3.0.0/banks/gh.29.uk/accounts/8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0/owner/transactions<br />&amp;verb=GET&amp;anon=false&amp;app_name=MapperPostman<br />&amp;exclude_app_names=API-EXPLORER,API-Manager,SOFI,null</p><p>1 from_date (defaults to the one year ago): eg:from_date=1970-01-01T00:00:00.000Z</p><p>2 to_date (defaults to the current date) eg:to_date=2023-03-29T11:38:53.812Z</p><p>3 consumer_id  (if null ignore)</p><p>4 user_id (if null ignore)</p><p>5 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>6 url (if null ignore), note: can not contain '&amp;'.</p><p>7 app_name (if null ignore)</p><p>8 implemented_by_partial_function (if null ignore),</p><p>9 implemented_in_version (if null ignore)</p><p>10 verb (if null ignore)</p><p>11 correlation_id (if null ignore)</p><p>12 duration (if null ignore) non digit chars will be silently omitted</p><p>13 exclude_app_names (if null ignore).eg: &amp;exclude_app_names=API-EXPLORER,API-Manager,SOFI,null</p><p>14 exclude_url_patterns (if null ignore).you can design you own SQL NOT LIKE pattern. eg: &amp;exclude_url_patterns=%management/metrics%,%management/aggregate-metrics%</p><p>15 exclude_implemented_by_partial_functions (if null ignore).eg: &amp;exclude_implemented_by_partial_functions=getMetrics,getConnectorMetrics,getAggregateMetrics</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_top_apis(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TopApisJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_top_apis_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_top_apis_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_top_apis_with_http_info(self, **kwargs):  # noqa: E501
        """Get Top APIs  # noqa: E501

        <p>Get metrics about the most popular APIs. e.g.: total count, response time (in ms), etc.</p><p>Should be able to filter on the following fields</p><p>eg: /management/metrics/top-apis?from_date=1970-01-01T00:00:00.000Z&amp;to_date=2023-03-29T11:38:53.812Z&amp;consumer_id=5<br />&amp;user_id=66214b8e-259e-44ad-8868-3eb47be70646&amp;implemented_by_partial_function=getTransactionsForBankAccount<br />&amp;implemented_in_version=v3.0.0&amp;url=/obp/v3.0.0/banks/gh.29.uk/accounts/8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0/owner/transactions<br />&amp;verb=GET&amp;anon=false&amp;app_name=MapperPostman<br />&amp;exclude_app_names=API-EXPLORER,API-Manager,SOFI,null</p><p>1 from_date (defaults to the one year ago): eg:from_date=1970-01-01T00:00:00.000Z</p><p>2 to_date (defaults to the current date) eg:to_date=2023-03-29T11:38:53.812Z</p><p>3 consumer_id  (if null ignore)</p><p>4 user_id (if null ignore)</p><p>5 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>6 url (if null ignore), note: can not contain '&amp;'.</p><p>7 app_name (if null ignore)</p><p>8 implemented_by_partial_function (if null ignore),</p><p>9 implemented_in_version (if null ignore)</p><p>10 verb (if null ignore)</p><p>11 correlation_id (if null ignore)</p><p>12 duration (if null ignore) non digit chars will be silently omitted</p><p>13 exclude_app_names (if null ignore).eg: &amp;exclude_app_names=API-EXPLORER,API-Manager,SOFI,null</p><p>14 exclude_url_patterns (if null ignore).you can design you own SQL NOT LIKE pattern. eg: &amp;exclude_url_patterns=%management/metrics%,%management/aggregate-metrics%</p><p>15 exclude_implemented_by_partial_functions (if null ignore).eg: &amp;exclude_implemented_by_partial_functions=getMetrics,getConnectorMetrics,getAggregateMetrics</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_top_apis_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TopApisJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_top_apis" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/metrics/top-apis', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TopApisJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
