# Sample data sets

These files are used as sample data in Harmonica:

* `gravity-earth-0.5deg.nc.xz`: Global gravity of the Earth at 0.5 degree grid spacing.
  The file contains the magnitude of the gradient of the gravity potential of the Earth
  (including the centrifugal component) on a regular grid of points at a constant
  geometric (ellipsoidal) height of 10 km. The grid was generated from the EIGEN-6C4
  gravity field model using the [ICGEM Calculation Service](http://icgem.gfz-potsdam.de)
  and the WGS84 Reference System. The data are stored in a netCDF file and then `xz`
  compressed.
* `etopo1-0.5deg.nc.xz`: Global relief (topography and bathymetry) of the Earth based on
  the ETOPO1 model at 0.5 degree grid spacing. The grid was generated by the [ICGEM
  Calculation Service](http://icgem.gfz-potsdam.de). The data are stored in a netCDF
  file and then `xz` compressed.
* `britain-magnetic.csv.xz`: Total-field magnetic anomaly data from Great
  Britain. Complete airborne survey of the entire Great Britain conducted
  between 1955 and 1965. The data are made available by the British Geological
  Survey (BGS) through their [geophysical data
  portal](https://www.bgs.ac.uk/products/geophysics/aeromagneticRegional.html)
  under an [Open Government
  License](http://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/).
* `south-africa-gravity.ast.xz`:
  Land gravity survey performed in January 1986 within the boundaries of the Republic of
  South Africa. Columns are longitude, latitude, elevation (above sea level) and gravity
  (mGal). The observed gravity values are referenced to the International Gravity
  Standardization Net 1971 (IGSN 71). The data was made available by the [National
  Centers for Environmental Information (NCEI)](https://www.ngdc.noaa.gov/) (formerly
  NGDC) and are in the [public
  domain](https://www.ngdc.noaa.gov/ngdcinfo/privacy.html#copyright-notice). Original
  data files can be found at:
  https://www.ngdc.noaa.gov/mgg/gravity/1999/data/regional/africa/ The data are stored
  in a netCDF file and then `xz` compressed.
