# yellowbrick.text
# Visualizers for text feature analysis and diagnostics.
#
# Author:   Rebecca Bilbro
# Created:  2017-01-20 14:42
#
# Copyright (C) 2017 The scikit-yb developers
# For license information, see LICENSE.txt
#
# ID: __init__.py [75d9b20] rebecca.bilbro@bytecubed.com $

"""
Visualizers for text feature analysis and diagnostics.
"""

##########################################################################
## Imports
##########################################################################

from .tsne import TSNEVisualizer, tsne
from .umap_vis import UMAPVisualizer, umap
from .freqdist import FreqDistVisualizer, freqdist
from .postag import PosTagVisualizer
from .dispersion import DispersionPlot, dispersion
from .correlation import WordCorrelationPlot, word_correlation
