from pathlib import Path

from pywintypes import IID

from koapy.utils.pywin32 import (
    BuildOleItems,
    GetLatestTypelibSpec,
    GetTypelibSpecs,
    LoadTypeLib,
)

CONTROL_PROGID = "KHOPENAPI.KHOpenApiCtrl.1"

CONTROL_CLSID = IID("{A1574A0D-6BFA-4BD7-9020-DED88711818D}")
DISPATCH_CLSID = IID("{CF20FBB6-EDD4-4BE5-A473-FEF91977DEB6}")
EVENT_CLSID = IID("{7335F12D-8973-4BD5-B7F0-12DF03D175B7}")
MODULE_CLSID = IID("{6D8C2B4D-EF41-4750-8AD4-C299033833FB}")

TYPELIB_SPECS = GetTypelibSpecs(MODULE_CLSID)
TYPELIB_SPEC = GetLatestTypelibSpec(TYPELIB_SPECS)
TYPELIB = LoadTypeLib(TYPELIB_SPEC)

TYPELIB_DLL_PATH = TYPELIB_SPEC and TYPELIB_SPEC.dll and Path(TYPELIB_SPEC.dll)

API_MODULE_PATH_FROM_DEFAULT_INSTALLATION = Path("C:\\OpenAPI")
API_MODULE_PATH_FROM_TYPELIB_DLL = TYPELIB_DLL_PATH and TYPELIB_DLL_PATH.parent
API_MODULE_PATH = (
    API_MODULE_PATH_FROM_TYPELIB_DLL or API_MODULE_PATH_FROM_DEFAULT_INSTALLATION
)

OLE_ITEMS, ENUM_ITEMS, RECORD_ITEMS, VTABLE_ITEMS = BuildOleItems(TYPELIB_SPEC, TYPELIB)

DISPATCH_OLE_ITEM = OLE_ITEMS.get(DISPATCH_CLSID)
EVENT_OLE_ITEM = OLE_ITEMS.get(EVENT_CLSID)
