def get_lut():
    cmap = {'Unknown': [ 0., 0., 0.],
    'Left-Cerebral-Exterior': [70., 130., 180.],
    'Left-Cerebral-White-Matter': [245., 245., 245.],
    'Left-Cerebral-Cortex': [205., 62., 78.],
    'Left-Lateral-Ventricle': [120., 18., 134.],
    'Left-Inf-Lat-Vent': [196., 58., 250.],
    'Left-Cerebellum-Exterior': [0., 148., 0.],
    'Left-Cerebellum-White-Matter': [220., 248., 164.],
    'Left-Cerebellum-Cortex': [230., 148., 34.],
    'Left-Thalamus': [0., 118., 14.],
    'Left-Thalamus-Proper': [0., 118., 14.],
    'Left-Caudate': [122., 186., 220.],
    'Left-Putamen': [236., 13., 176.],
    'Left-Pallidum': [12., 48., 255.],
    '3rd-Ventricle': [204., 182., 142.],
    '4th-Ventricle': [42., 204., 164.],
    'Brain-Stem': [119., 159., 176.],
    'Left-Hippocampus': [220., 216., 20.],
    'Left-Amygdala': [103., 255., 255.],
    'Left-Insula': [80., 196., 98.],
    'Left-Operculum': [60., 58., 210.],
    'Line-1': [60., 58., 210.],
    'Line-2': [60., 58., 210.],
    'Line-3': [60., 58., 210.],
    'CSF': [60., 60., 60.],
    'Left-Lesion': [255., 165., 0.],
    'Left-Accumbens-area': [255., 165., 0.],
    'Left-Substancia-Nigra': [0., 255., 127.],
    'Left-VentralDC': [165., 42., 42.],
    'Left-undetermined': [135., 206., 235.],
    'Left-vessel': [160., 32., 240.],
    'Left-choroid-plexus': [0., 200., 200.],
    'Left-F3orb': [100., 50., 100.],
    'Left-lOg': [135., 50., 74.],
    'Left-aOg': [122., 135., 50.],
    'Left-mOg': [51., 50., 135.],
    'Left-pOg': [74., 155., 60.],
    'Left-Stellate': [120., 62., 43.],
    'Left-Porg': [74., 155., 60.],
    'Left-Aorg': [122., 135., 50.],
    'Right-Cerebral-Exterior': [70., 130., 180.],
    'Right-Cerebral-White-Matter': [0., 225., 0.],
    'Right-Cerebral-Cortex': [205., 62., 78.],
    'Right-Lateral-Ventricle': [120., 18., 134.],
    'Right-Inf-Lat-Vent': [196., 58., 250.],
    'Right-Cerebellum-Exterior': [0., 148., 0.],
    'Right-Cerebellum-White-Matter': [220., 248., 164.],
    'Right-Cerebellum-Cortex': [230., 148., 34.],
    'Right-Thalamus': [0., 118., 14.],
    'Right-Thalamus-Proper': [0., 118., 14.],
    'Right-Caudate': [122., 186., 220.],
    'Right-Putamen': [236., 13., 176.],
    'Right-Pallidum': [13., 48., 255.],
    'Right-Hippocampus': [220., 216., 20.],
    'Right-Amygdala': [103., 255., 255.],
    'Right-Insula': [80., 196., 98.],
    'Right-Operculum': [60., 58., 210.],
    'Right-Lesion': [255., 165., 0.],
    'Right-Accumbens-area': [255., 165., 0.],
    'Right-Substancia-Nigra': [0., 255., 127.],
    'Right-VentralDC': [165., 42., 42.],
    'Right-undetermined': [135., 206., 235.],
    'Right-vessel': [160., 32., 240.],
    'Right-choroid-plexus': [0., 200., 221.],
    'Right-F3orb': [100., 50., 100.],
    'Right-lOg': [135., 50., 74.],
    'Right-aOg': [122., 135., 50.],
    'Right-mOg': [51., 50., 135.],
    'Right-pOg': [74., 155., 60.],
    'Right-Stellate': [120., 62., 43.],
    'Right-Porg': [74., 155., 60.],
    'Right-Aorg': [122., 135., 50.],
    '5th-Ventricle': [120., 190., 150.],
    'Left-Interior': [122., 135., 50.],
    'Right-Interior': [122., 135., 50.],
    'WM-hypointensities': [200., 70., 255.],
    'Left-WM-hypointensities': [255., 148., 10.],
    'Right-WM-hypointensities': [255., 148., 10.],
    'non-WM-hypointensities': [164., 108., 226.],
    'Left-non-WM-hypointensities': [164., 108., 226.],
    'Right-non-WM-hypointensities': [164., 108., 226.],
    'Left-F1': [255., 218., 185.],
    'Right-F1': [255., 218., 185.],
    'Optic-Chiasm': [234., 169., 30.],
    'Corpus_Callosum': [250., 255., 50.],
    'Left_future_WMSA': [200., 120., 255.],
    'Right_future_WMSA': [200., 121., 255.],
    'future_WMSA': [200., 122., 255.],
    'Left-Amygdala-Anterior': [205., 10., 125.],
    'Right-Amygdala-Anterior': [205., 10., 125.],
    'Dura': [160., 32., 240.],
    'Left-wm-intensity-abnormality': [124., 140., 178.],
    'Left-caudate-intensity-abnormality': [125., 140., 178.],
    'Left-putamen-intensity-abnormality': [126., 140., 178.],
    'Left-accumbens-intensity-abnormality': [127., 140., 178.],
    'Left-pallidum-intensity-abnormality': [124., 141., 178.],
    'Left-amygdala-intensity-abnormality': [124., 142., 178.],
    'Left-hippocampus-intensity-abnormality': [124., 143., 178.],
    'Left-thalamus-intensity-abnormality': [124., 144., 178.],
    'Left-VDC-intensity-abnormality': [124., 140., 179.],
    'Right-wm-intensity-abnormality': [124., 140., 178.],
    'Right-caudate-intensity-abnormality': [125., 140., 178.],
    'Right-putamen-intensity-abnormality': [126., 140., 178.],
    'Right-accumbens-intensity-abnormality': [127., 140., 178.],
    'Right-pallidum-intensity-abnormality': [124., 141., 178.],
    'Right-amygdala-intensity-abnormality': [124., 142., 178.],
    'Right-hippocampus-intensity-abnormality': [124., 143., 178.],
    'Right-thalamus-intensity-abnormality': [124., 144., 178.],
    'Right-VDC-intensity-abnormality': [124., 140., 179.],
    'Epidermis': [255., 20., 147.],
    'Conn-Tissue': [205., 179., 139.],
    'SC-Fat-Muscle': [238., 238., 209.],
    'Cranium': [200., 200., 200.],
    'CSF-SA': [74., 255., 74.],
    'Muscle': [238., 0., 0.],
    'Ear': [0., 0., 139.],
    'Adipose': [173., 255., 47.],
    'Spinal-Cord': [133., 203., 229.],
    'Soft-Tissue': [26., 237., 57.],
    'Nerve': [34., 139., 34.],
    'Bone': [30., 144., 255.],
    'Air': [147., 19., 173.],
    'Orbital-Fat': [238., 59., 59.],
    'Tongue': [221., 39., 200.],
    'Nasal-Structures': [238., 174., 238.],
    'Globe': [255., 0., 0.],
    'Teeth': [72., 61., 139.],
    'Left-Caudate-Putamen': [21., 39., 132.],
    'Right-Caudate-Putamen': [21., 39., 132.],
    'Left-Claustrum': [65., 135., 20.],
    'Right-Claustrum': [65., 135., 20.],
    'Cornea': [134., 4., 160.],
    'Diploe': [221., 226., 68.],
    'Vitreous-Humor': [255., 255., 254.],
    'Lens': [52., 209., 226.],
    'Aqueous-Humor': [239., 160., 223.],
    'Outer-Table': [70., 130., 180.],
    'Inner-Table': [70., 130., 181.],
    'Periosteum': [139., 121., 94.],
    'Endosteum': [224., 224., 224.],
    'R-C-S': [255., 0., 0.],
    'Iris': [205., 205., 0.],
    'SC-Adipose-Muscle': [238., 238., 209.],
    'SC-Tissue': [139., 121., 94.],
    'Orbital-Adipose': [238., 59., 59.],
    'Left-IntCapsule-Ant': [238., 59., 59.],
    'Right-IntCapsule-Ant': [238., 59., 59.],
    'Left-IntCapsule-Pos': [62., 10., 205.],
    'Right-IntCapsule-Pos': [62., 10., 205.],
    'Left-Cerebral-WM-unmyelinated': [0., 118., 14.],
    'Right-Cerebral-WM-unmyelinated': [0., 118., 14.],
    'Left-Cerebral-WM-myelinated': [220., 216., 21.],
    'Right-Cerebral-WM-myelinated': [220., 216., 21.],
    'Left-Subcortical-Gray-Matter': [122., 186., 220.],
    'Right-Subcortical-Gray-Matter': [122., 186., 220.],
    'Skull': [255., 165., 0.],
    'Posterior-fossa': [14., 48., 255.],
    'Scalp': [166., 42., 42.],
    'Hematoma': [121., 18., 134.],
    'Left-Basal-Ganglia': [236., 13., 127.],
    'Right-Basal-Ganglia': [236., 13., 126.],
    'brainstem': [119., 159., 176.],
    'DCG': [119., 0., 176.],
    'Vermis': [119., 100., 176.],
    'Midbrain': [119., 200., 176.],
    'Pons': [119., 159., 100.],
    'Medulla': [119., 159., 200.],
    'Left-Cortical-Dysplasia': [73., 61., 139.],
    'Right-Cortical-Dysplasia': [73., 62., 139.],
    'Left-hippocampal_fissure': [0., 196., 255.],
    'Left-CADG-head': [255., 164., 164.],
    'Left-subiculum': [196., 196., 0.],
    'Left-fimbria': [0., 100., 255.],
    'Right-hippocampal_fissure': [128., 196., 164.],
    'Right-CADG-head': [0., 126., 75.],
    'Right-subiculum': [128., 96., 64.],
    'Right-fimbria': [0., 50., 128.],
    'alveus': [255., 204., 153.],
    'perforant_pathway': [255., 128., 128.],
    'parasubiculum': [255., 255., 0.],
    'presubiculum': [64., 0., 64.],
    'subiculum': [0., 0., 255.],
    'CA1': [255., 0., 0.],
    'CA2': [128., 128., 255.],
    'CA3': [0., 128., 0.],
    'CA4': [196., 160., 128.],
    'GC-ML-DG': [32., 200., 255.],
    'HATA': [128., 255., 128.],
    'fimbria': [204., 153., 204.],
    'lateral_ventricle': [121., 17., 136.],
    'molecular_layer_HP': [128., 0., 0.],
    'hippocampal_fissure': [128., 32., 255.],
    'entorhinal_cortex': [255., 204., 102.],
    'molecular_layer_subiculum': [128., 128., 128.],
    'Amygdala': [104., 255., 255.],
    'Cerebral_White_Matter': [0., 226., 0.],
    'Cerebral_Cortex': [205., 63., 78.],
    'Inf_Lat_Vent': [197., 58., 250.],
    'Perirhinal': [33., 150., 250.],
    'Cerebral_White_Matter_Edge': [226., 0., 0.],
    'Background': [100., 100., 100.],
    'Ectorhinal': [197., 150., 250.],
    'HP_tail': [170., 170., 255.],
    'Fornix': [255., 0., 0.],
    'CC_Posterior': [0., 0., 64.],
    'CC_Mid_Posterior': [0., 0., 112.],
    'CC_Central': [0., 0., 160.],
    'CC_Mid_Anterior': [0., 0., 208.],
    'CC_Anterior': [0., 0., 255.],
    'Voxel-Unchanged': [0., 0., 0.],
    'Aorta': [255., 0., 0.],
    'Left-Common-IliacA': [255., 80., 0.],
    'Right-Common-IliacA': [255., 160., 0.],
    'Left-External-IliacA': [255., 255., 0.],
    'Right-External-IliacA': [0., 255., 0.],
    'Left-Internal-IliacA': [255., 0., 160.],
    'Right-Internal-IliacA': [255., 0., 255.],
    'Left-Lateral-SacralA': [255., 50., 80.],
    'Right-Lateral-SacralA': [80., 255., 50.],
    'Left-ObturatorA': [160., 255., 50.],
    'Right-ObturatorA': [160., 200., 255.],
    'Left-Internal-PudendalA': [0., 255., 160.],
    'Right-Internal-PudendalA': [0., 0., 255.],
    'Left-UmbilicalA': [80., 50., 255.],
    'Right-UmbilicalA': [160., 0., 255.],
    'Left-Inf-RectalA': [255., 210., 0.],
    'Right-Inf-RectalA': [0., 160., 255.],
    'Left-Common-IliacV': [255., 200., 80.],
    'Right-Common-IliacV': [255., 200., 160.],
    'Left-External-IliacV': [255., 80., 200.],
    'Right-External-IliacV': [255., 160., 200.],
    'Left-Internal-IliacV': [30., 255., 80.],
    'Right-Internal-IliacV': [80., 200., 255.],
    'Left-ObturatorV': [80., 255., 200.],
    'Right-ObturatorV': [195., 255., 200.],
    'Left-Internal-PudendalV': [120., 200., 20.],
    'Right-Internal-PudendalV': [170., 10., 200.],
    'Pos-Lymph': [20., 130., 180.],
    'Neg-Lymph': [20., 180., 130.],
    'V1': [206., 62., 78.],
    'V2': [121., 18., 134.],
    'BA44': [199., 58., 250.],
    'BA45': [1., 148., 0.],
    'BA4a': [221., 248., 164.],
    'BA4p': [231., 148., 34.],
    'BA6': [1., 118., 14.],
    'BA2': [120., 118., 14.],
    'BA1_old': [123., 186., 221.],
    'BAun2': [238., 13., 177.],
    'BA1': [123., 186., 220.],
    'BA2b': [138., 13., 206.],
    'BA3a': [238., 130., 176.],
    'BA3b': [218., 230., 76.],
    'MT': [38., 213., 176.],
    'AIPS_AIP_l': [1., 225., 176.],
    'AIPS_AIP_r': [1., 225., 176.],
    'AIPS_VIP_l': [200., 2., 100.],
    'AIPS_VIP_r': [200., 2., 100.],
    'IPL_PFcm_l': [5., 200., 90.],
    'IPL_PFcm_r': [5., 200., 90.],
    'IPL_PF_l': [100., 5., 200.],
    'IPL_PFm_l': [25., 255., 100.],
    'IPL_PFm_r': [25., 255., 100.],
    'IPL_PFop_l': [230., 7., 100.],
    'IPL_PFop_r': [230., 7., 100.],
    'IPL_PF_r': [100., 5., 200.],
    'IPL_PFt_l': [150., 10., 200.],
    'IPL_PFt_r': [150., 10., 200.],
    'IPL_PGa_l': [175., 10., 176.],
    'IPL_PGa_r': [175., 10., 176.],
    'IPL_PGp_l': [10., 100., 255.],
    'IPL_PGp_r': [10., 100., 255.],
    'Visual_V3d_l': [150., 45., 70.],
    'Visual_V3d_r': [150., 45., 70.],
    'Visual_V4_l': [45., 200., 15.],
    'Visual_V4_r': [45., 200., 15.],
    'Visual_V5_b': [227., 45., 100.],
    'Visual_VP_l': [227., 45., 100.],
    'Visual_VP_r': [227., 45., 100.],
    'wmsa': [143., 188., 143.],
    'other_wmsa': [255., 248., 220.],
    'right_CA2_3': [17., 85., 136.],
    'right_alveus': [119., 187., 102.],
    'right_CA1': [204., 68., 34.],
    'right_fimbria': [204., 0., 255.],
    'right_presubiculum': [221., 187., 17.],
    'right_hippocampal_fissure': [153., 221., 238.],
    'right_CA4_DG': [51., 17., 17.],
    'right_subiculum': [0., 119., 85.],
    'right_fornix': [20., 100., 200.],
    'left_CA2_3': [17., 85., 137.],
    'left_alveus': [119., 187., 103.],
    'left_CA1': [204., 68., 35.],
    'left_fimbria': [204., 0., 254.],
    'left_presubiculum': [221., 187., 16.],
    'left_hippocampal_fissure': [153., 221., 239.],
    'left_CA4_DG': [51., 17., 18.],
    'left_subiculum': [0., 119., 86.],
    'left_fornix': [20., 100., 201.],
    'Tumor': [254., 254., 254.],
    'Cbm_Left_I_IV': [70., 130., 180.],
    'Cbm_Right_I_IV': [245., 245., 245.],
    'Cbm_Left_V': [205., 62., 78.],
    'Cbm_Right_V': [120., 18., 134.],
    'Cbm_Left_VI': [196., 58., 250.],
    'Cbm_Vermis_VI': [0., 148., 0.],
    'Cbm_Right_VI': [220., 248., 164.],
    'Cbm_Left_CrusI': [230., 148., 34.],
    'Cbm_Vermis_CrusI': [0., 118., 14.],
    'Cbm_Right_CrusI': [0., 118., 14.],
    'Cbm_Left_CrusII': [122., 186., 220.],
    'Cbm_Vermis_CrusII': [236., 13., 176.],
    'Cbm_Right_CrusII': [12., 48., 255.],
    'Cbm_Left_VIIb': [204., 182., 142.],
    'Cbm_Vermis_VIIb': [42., 204., 164.],
    'Cbm_Right_VIIb': [119., 159., 176.],
    'Cbm_Left_VIIIa': [220., 216., 20.],
    'Cbm_Vermis_VIIIa': [103., 255., 255.],
    'Cbm_Right_VIIIa': [80., 196., 98.],
    'Cbm_Left_VIIIb': [60., 58., 210.],
    'Cbm_Vermis_VIIIb': [60., 58., 210.],
    'Cbm_Right_VIIIb': [60., 58., 210.],
    'Cbm_Left_IX': [60., 58., 210.],
    'Cbm_Vermis_IX': [60., 60., 60.],
    'Cbm_Right_IX': [255., 165., 0.],
    'Cbm_Left_X': [255., 165., 0.],
    'Cbm_Vermis_X': [0., 255., 127.],
    'Cbm_Right_X': [165., 42., 42.],
    'Cbm_Right_I_V_med': [204., 0., 0.],
    'Cbm_Right_I_V_mid': [255., 0., 0.],
    'Cbm_Right_VI_med': [0., 0., 255.],
    'Cbm_Right_VI_mid': [30., 144., 255.],
    'Cbm_Right_VI_lat': [100., 212., 237.],
    'Cbm_Right_CrusI_med': [218., 165., 32.],
    'Cbm_Right_CrusI_mid': [255., 215., 0.],
    'Cbm_Right_CrusI_lat': [255., 255., 166.],
    'Cbm_Right_CrusII_med': [153., 0., 204.],
    'Cbm_Right_CrusII_mid': [153., 141., 209.],
    'Cbm_Right_CrusII_lat': [204., 204., 255.],
    'Cbm_Right_7med': [31., 212., 194.],
    'Cbm_Right_7mid': [3., 255., 237.],
    'Cbm_Right_7lat': [204., 255., 255.],
    'Cbm_Right_8med': [86., 74., 147.],
    'Cbm_Right_8mid': [114., 114., 190.],
    'Cbm_Right_8lat': [184., 178., 255.],
    'Cbm_Right_PUNs': [126., 138., 37.],
    'Cbm_Right_TONs': [189., 197., 117.],
    'Cbm_Right_FLOs': [240., 230., 140.],
    'Cbm_Left_I_V_med': [204., 0., 0.],
    'Cbm_Left_I_V_mid': [255., 0., 0.],
    'Cbm_Left_VI_med': [0., 0., 255.],
    'Cbm_Left_VI_mid': [30., 144., 255.],
    'Cbm_Left_VI_lat': [100., 212., 237.],
    'Cbm_Left_CrusI_med': [218., 165., 32.],
    'Cbm_Left_CrusI_mid': [255., 215., 0.],
    'Cbm_Left_CrusI_lat': [255., 255., 166.],
    'Cbm_Left_CrusII_med': [153., 0., 204.],
    'Cbm_Left_CrusII_mid': [153., 141., 209.],
    'Cbm_Left_CrusII_lat': [204., 204., 255.],
    'Cbm_Left_7med': [31., 212., 194.],
    'Cbm_Left_7mid': [3., 255., 237.],
    'Cbm_Left_7lat': [204., 255., 255.],
    'Cbm_Left_8med': [86., 74., 147.],
    'Cbm_Left_8mid': [114., 114., 190.],
    'Cbm_Left_8lat': [184., 178., 255.],
    'Cbm_Left_PUNs': [126., 138., 37.],
    'Cbm_Left_TONs': [189., 197., 117.],
    'Cbm_Left_FLOs': [240., 230., 140.],
    'CSF-FSL-FAST': [120., 18., 134.],
    'GrayMatter-FSL-FAST': [205., 62., 78.],
    'WhiteMatter-FSL-FAST': [0., 225., 0.],
    'SUSPICIOUS': [255., 100., 100.],
    'ctx-lh-unknown': [25., 5., 25.],
    'ctx-lh-bankssts': [25., 100., 40.],
    'ctx-lh-caudalanteriorcingulate': [125., 100., 160.],
    'ctx-lh-caudalmiddlefrontal': [100., 25., 0.],
    'ctx-lh-corpuscallosum': [120., 70., 50.],
    'ctx-lh-cuneus': [220., 20., 100.],
    'ctx-lh-entorhinal': [220., 20., 10.],
    'ctx-lh-fusiform': [180., 220., 140.],
    'ctx-lh-inferiorparietal': [220., 60., 220.],
    'ctx-lh-inferiortemporal': [180., 40., 120.],
    'ctx-lh-isthmuscingulate': [140., 20., 140.],
    'ctx-lh-lateraloccipital': [20., 30., 140.],
    'ctx-lh-lateralorbitofrontal': [35., 75., 50.],
    'ctx-lh-lingual': [225., 140., 140.],
    'ctx-lh-medialorbitofrontal': [200., 35., 75.],
    'ctx-lh-middletemporal': [160., 100., 50.],
    'ctx-lh-parahippocampal': [20., 220., 60.],
    'ctx-lh-paracentral': [60., 220., 60.],
    'ctx-lh-parsopercularis': [220., 180., 140.],
    'ctx-lh-parsorbitalis': [20., 100., 50.],
    'ctx-lh-parstriangularis': [220., 60., 20.],
    'ctx-lh-pericalcarine': [120., 100., 60.],
    'ctx-lh-postcentral': [220., 20., 20.],
    'ctx-lh-posteriorcingulate': [220., 180., 220.],
    'ctx-lh-precentral': [60., 20., 220.],
    'ctx-lh-precuneus': [160., 140., 180.],
    'ctx-lh-rostralanteriorcingulate': [80., 20., 140.],
    'ctx-lh-rostralmiddlefrontal': [75., 50., 125.],
    'ctx-lh-superiorfrontal': [20., 220., 160.],
    'ctx-lh-superiorparietal': [20., 180., 140.],
    'ctx-lh-superiortemporal': [140., 220., 220.],
    'ctx-lh-supramarginal': [80., 160., 20.],
    'ctx-lh-frontalpole': [100., 0., 100.],
    'ctx-lh-temporalpole': [70., 70., 70.],
    'ctx-lh-transversetemporal': [150., 150., 200.],
    'ctx-lh-insula': [255., 192., 32.],
    'ctx-rh-unknown': [25., 5., 25.],
    'ctx-rh-bankssts': [25., 100., 40.],
    'ctx-rh-caudalanteriorcingulate': [125., 100., 160.],
    'ctx-rh-caudalmiddlefrontal': [100., 25., 0.],
    'ctx-rh-corpuscallosum': [120., 70., 50.],
    'ctx-rh-cuneus': [220., 20., 100.],
    'ctx-rh-entorhinal': [220., 20., 10.],
    'ctx-rh-fusiform': [180., 220., 140.],
    'ctx-rh-inferiorparietal': [220., 60., 220.],
    'ctx-rh-inferiortemporal': [180., 40., 120.],
    'ctx-rh-isthmuscingulate': [140., 20., 140.],
    'ctx-rh-lateraloccipital': [20., 30., 140.],
    'ctx-rh-lateralorbitofrontal': [35., 75., 50.],
    'ctx-rh-lingual': [225., 140., 140.],
    'ctx-rh-medialorbitofrontal': [200., 35., 75.],
    'ctx-rh-middletemporal': [160., 100., 50.],
    'ctx-rh-parahippocampal': [20., 220., 60.],
    'ctx-rh-paracentral': [60., 220., 60.],
    'ctx-rh-parsopercularis': [220., 180., 140.],
    'ctx-rh-parsorbitalis': [20., 100., 50.],
    'ctx-rh-parstriangularis': [220., 60., 20.],
    'ctx-rh-pericalcarine': [120., 100., 60.],
    'ctx-rh-postcentral': [220., 20., 20.],
    'ctx-rh-posteriorcingulate': [220., 180., 220.],
    'ctx-rh-precentral': [60., 20., 220.],
    'ctx-rh-precuneus': [160., 140., 180.],
    'ctx-rh-rostralanteriorcingulate': [80., 20., 140.],
    'ctx-rh-rostralmiddlefrontal': [75., 50., 125.],
    'ctx-rh-superiorfrontal': [20., 220., 160.],
    'ctx-rh-superiorparietal': [20., 180., 140.],
    'ctx-rh-superiortemporal': [140., 220., 220.],
    'ctx-rh-supramarginal': [80., 160., 20.],
    'ctx-rh-frontalpole': [100., 0., 100.],
    'ctx-rh-temporalpole': [70., 70., 70.],
    'ctx-rh-transversetemporal': [150., 150., 200.],
    'ctx-rh-insula': [255., 192., 32.],
    'wm-lh-unknown': [230., 250., 230.],
    'wm-lh-bankssts': [230., 155., 215.],
    'wm-lh-caudalanteriorcingulate': [130., 155., 95.],
    'wm-lh-caudalmiddlefrontal': [155., 230., 255.],
    'wm-lh-corpuscallosum': [135., 185., 205.],
    'wm-lh-cuneus': [35., 235., 155.],
    'wm-lh-entorhinal': [35., 235., 245.],
    'wm-lh-fusiform': [75., 35., 115.],
    'wm-lh-inferiorparietal': [35., 195., 35.],
    'wm-lh-inferiortemporal': [75., 215., 135.],
    'wm-lh-isthmuscingulate': [115., 235., 115.],
    'wm-lh-lateraloccipital': [235., 225., 115.],
    'wm-lh-lateralorbitofrontal': [220., 180., 205.],
    'wm-lh-lingual': [30., 115., 115.],
    'wm-lh-medialorbitofrontal': [55., 220., 180.],
    'wm-lh-middletemporal': [95., 155., 205.],
    'wm-lh-parahippocampal': [235., 35., 195.],
    'wm-lh-paracentral': [195., 35., 195.],
    'wm-lh-parsopercularis': [35., 75., 115.],
    'wm-lh-parsorbitalis': [235., 155., 205.],
    'wm-lh-parstriangularis': [35., 195., 235.],
    'wm-lh-pericalcarine': [135., 155., 195.],
    'wm-lh-postcentral': [35., 235., 235.],
    'wm-lh-posteriorcingulate': [35., 75., 35.],
    'wm-lh-precentral': [195., 235., 35.],
    'wm-lh-precuneus': [95., 115., 75.],
    'wm-lh-rostralanteriorcingulate': [175., 235., 115.],
    'wm-lh-rostralmiddlefrontal': [180., 205., 130.],
    'wm-lh-superiorfrontal': [235., 35., 95.],
    'wm-lh-superiorparietal': [235., 75., 115.],
    'wm-lh-superiortemporal': [115., 35., 35.],
    'wm-lh-supramarginal': [175., 95., 235.],
    'wm-lh-frontalpole': [155., 255., 155.],
    'wm-lh-temporalpole': [185., 185., 185.],
    'wm-lh-transversetemporal': [105., 105., 55.],
    'wm-lh-insula': [254., 191., 31.],
    'wm-rh-unknown': [230., 250., 230.],
    'wm-rh-bankssts': [230., 155., 215.],
    'wm-rh-caudalanteriorcingulate': [130., 155., 95.],
    'wm-rh-caudalmiddlefrontal': [155., 230., 255.],
    'wm-rh-corpuscallosum': [135., 185., 205.],
    'wm-rh-cuneus': [35., 235., 155.],
    'wm-rh-entorhinal': [35., 235., 245.],
    'wm-rh-fusiform': [75., 35., 115.],
    'wm-rh-inferiorparietal': [35., 195., 35.],
    'wm-rh-inferiortemporal': [75., 215., 135.],
    'wm-rh-isthmuscingulate': [115., 235., 115.],
    'wm-rh-lateraloccipital': [235., 225., 115.],
    'wm-rh-lateralorbitofrontal': [220., 180., 205.],
    'wm-rh-lingual': [30., 115., 115.],
    'wm-rh-medialorbitofrontal': [55., 220., 180.],
    'wm-rh-middletemporal': [95., 155., 205.],
    'wm-rh-parahippocampal': [235., 35., 195.],
    'wm-rh-paracentral': [195., 35., 195.],
    'wm-rh-parsopercularis': [35., 75., 115.],
    'wm-rh-parsorbitalis': [235., 155., 205.],
    'wm-rh-parstriangularis': [35., 195., 235.],
    'wm-rh-pericalcarine': [135., 155., 195.],
    'wm-rh-postcentral': [35., 235., 235.],
    'wm-rh-posteriorcingulate': [35., 75., 35.],
    'wm-rh-precentral': [195., 235., 35.],
    'wm-rh-precuneus': [95., 115., 75.],
    'wm-rh-rostralanteriorcingulate': [175., 235., 115.],
    'wm-rh-rostralmiddlefrontal': [180., 205., 130.],
    'wm-rh-superiorfrontal': [235., 35., 95.],
    'wm-rh-superiorparietal': [235., 75., 115.],
    'wm-rh-superiortemporal': [115., 35., 35.],
    'wm-rh-supramarginal': [175., 95., 235.],
    'wm-rh-frontalpole': [155., 255., 155.],
    'wm-rh-temporalpole': [185., 185., 185.],
    'wm-rh-transversetemporal': [105., 105., 55.],
    'wm-rh-insula': [254., 191., 31.],
    'ctx-lh-Unknown': [0., 0., 0.],
    'ctx-lh-Corpus_callosum': [50., 50., 50.],
    'ctx-lh-G_and_S_Insula_ONLY_AVERAGE': [180., 20., 30.],
    'ctx-lh-G_cingulate-Isthmus': [60., 25., 25.],
    'ctx-lh-G_cingulate-Main_part': [25., 60., 60.],
    'ctx-lh-G_cingulate-caudal_ACC': [25., 60., 61.],
    'ctx-lh-G_cingulate-rostral_ACC': [25., 90., 60.],
    'ctx-lh-G_cingulate-posterior': [25., 120., 60.],
    'ctx-lh-S_cingulate-caudal_ACC': [25., 150., 60.],
    'ctx-lh-S_cingulate-rostral_ACC': [25., 180., 60.],
    'ctx-lh-S_cingulate-posterior': [25., 210., 60.],
    'ctx-lh-S_pericallosal-caudal': [25., 150., 90.],
    'ctx-lh-S_pericallosal-rostral': [25., 180., 90.],
    'ctx-lh-S_pericallosal-posterior': [25., 210., 90.],
    'ctx-lh-G_cuneus': [180., 20., 20.],
    'ctx-lh-G_frontal_inf-Opercular_part': [220., 20., 100.],
    'ctx-lh-G_frontal_inf-Orbital_part': [140., 60., 60.],
    'ctx-lh-G_frontal_inf-Triangular_part': [180., 220., 140.],
    'ctx-lh-G_frontal_middle': [140., 100., 180.],
    'ctx-lh-G_frontal_superior': [180., 20., 140.],
    'ctx-lh-G_frontomarginal': [140., 20., 140.],
    'ctx-lh-G_insular_long': [21., 10., 10.],
    'ctx-lh-G_insular_short': [225., 140., 140.],
    'ctx-lh-G_and_S_occipital_inferior': [23., 60., 180.],
    'ctx-lh-G_occipital_middle': [180., 60., 180.],
    'ctx-lh-G_occipital_superior': [20., 220., 60.],
    'ctx-lh-G_occipit-temp_lat-Or_fusiform': [60., 20., 140.],
    'ctx-lh-G_occipit-temp_med-Lingual_part': [220., 180., 140.],
    'ctx-lh-G_occipit-temp_med-Parahippocampal_part': [65., 100., 20.],
    'ctx-lh-G_orbital': [220., 60., 20.],
    'ctx-lh-G_paracentral': [60., 100., 60.],
    'ctx-lh-G_parietal_inferior-Angular_part': [20., 60., 220.],
    'ctx-lh-G_parietal_inferior-Supramarginal_part': [100., 100., 60.],
    'ctx-lh-G_parietal_superior': [220., 180., 220.],
    'ctx-lh-G_postcentral': [20., 180., 140.],
    'ctx-lh-G_precentral': [60., 140., 180.],
    'ctx-lh-G_precuneus': [25., 20., 140.],
    'ctx-lh-G_rectus': [20., 60., 100.],
    'ctx-lh-G_subcallosal': [60., 220., 20.],
    'ctx-lh-G_subcentral': [60., 20., 220.],
    'ctx-lh-G_temporal_inferior': [220., 220., 100.],
    'ctx-lh-G_temporal_middle': [180., 60., 60.],
    'ctx-lh-G_temp_sup-G_temp_transv_and_interm_S': [60., 60., 220.],
    'ctx-lh-G_temp_sup-Lateral_aspect': [220., 60., 220.],
    'ctx-lh-G_temp_sup-Planum_polare': [65., 220., 60.],
    'ctx-lh-G_temp_sup-Planum_tempolare': [25., 140., 20.],
    'ctx-lh-G_and_S_transverse_frontopolar': [13., 0., 250.],
    'ctx-lh-Lat_Fissure-ant_sgt-ramus_horizontal': [61., 20., 220.],
    'ctx-lh-Lat_Fissure-ant_sgt-ramus_vertical': [61., 20., 60.],
    'ctx-lh-Lat_Fissure-post_sgt': [61., 60., 100.],
    'ctx-lh-Medial_wall': [25., 25., 25.],
    'ctx-lh-Pole_occipital': [140., 20., 60.],
    'ctx-lh-Pole_temporal': [220., 180., 20.],
    'ctx-lh-S_calcarine': [63., 180., 180.],
    'ctx-lh-S_central': [221., 20., 10.],
    'ctx-lh-S_central_insula': [21., 220., 20.],
    'ctx-lh-S_cingulate-Main_part_and_Intracingulate': [183., 100., 20.],
    'ctx-lh-S_cingulate-Marginalis_part': [221., 20., 100.],
    'ctx-lh-S_circular_insula_anterior': [221., 60., 140.],
    'ctx-lh-S_circular_insula_inferior': [221., 20., 220.],
    'ctx-lh-S_circular_insula_superior': [61., 220., 220.],
    'ctx-lh-S_collateral_transverse_ant': [100., 200., 200.],
    'ctx-lh-S_collateral_transverse_post': [10., 200., 200.],
    'ctx-lh-S_frontal_inferior': [221., 220., 20.],
    'ctx-lh-S_frontal_middle': [141., 20., 100.],
    'ctx-lh-S_frontal_superior': [61., 220., 100.],
    'ctx-lh-S_frontomarginal': [21., 220., 60.],
    'ctx-lh-S_intermedius_primus-Jensen': [141., 60., 20.],
    'ctx-lh-S_intraparietal-and_Parietal_transverse': [143., 20., 220.],
    'ctx-lh-S_occipital_anterior': [61., 20., 180.],
    'ctx-lh-S_occipital_middle_and_Lunatus': [101., 60., 220.],
    'ctx-lh-S_occipital_superior_and_transversalis': [21., 20., 140.],
    'ctx-lh-S_occipito-temporal_lateral': [221., 140., 20.],
    'ctx-lh-S_occipito-temporal_medial_and_S_Lingual': [141., 100., 220.],
    'ctx-lh-S_orbital-H_shapped': [101., 20., 20.],
    'ctx-lh-S_orbital_lateral': [221., 100., 20.],
    'ctx-lh-S_orbital_medial-Or_olfactory': [181., 200., 20.],
    'ctx-lh-S_paracentral': [21., 180., 140.],
    'ctx-lh-S_parieto_occipital': [101., 100., 180.],
    'ctx-lh-S_pericallosal': [181., 220., 20.],
    'ctx-lh-S_postcentral': [21., 140., 200.],
    'ctx-lh-S_precentral-Inferior-part': [21., 20., 240.],
    'ctx-lh-S_precentral-Superior-part': [21., 20., 200.],
    'ctx-lh-S_subcentral_ant': [61., 180., 60.],
    'ctx-lh-S_subcentral_post': [61., 180., 250.],
    'ctx-lh-S_suborbital': [21., 20., 60.],
    'ctx-lh-S_subparietal': [101., 60., 60.],
    'ctx-lh-S_supracingulate': [21., 220., 220.],
    'ctx-lh-S_temporal_inferior': [21., 180., 180.],
    'ctx-lh-S_temporal_superior': [223., 220., 60.],
    'ctx-lh-S_temporal_transverse': [221., 60., 60.],
    'ctx-rh-Unknown': [0., 0., 0.],
    'ctx-rh-Corpus_callosum': [50., 50., 50.],
    'ctx-rh-G_and_S_Insula_ONLY_AVERAGE': [180., 20., 30.],
    'ctx-rh-G_cingulate-Isthmus': [60., 25., 25.],
    'ctx-rh-G_cingulate-Main_part': [25., 60., 60.],
    'ctx-rh-G_cuneus': [180., 20., 20.],
    'ctx-rh-G_frontal_inf-Opercular_part': [220., 20., 100.],
    'ctx-rh-G_frontal_inf-Orbital_part': [140., 60., 60.],
    'ctx-rh-G_frontal_inf-Triangular_part': [180., 220., 140.],
    'ctx-rh-G_frontal_middle': [140., 100., 180.],
    'ctx-rh-G_frontal_superior': [180., 20., 140.],
    'ctx-rh-G_frontomarginal': [140., 20., 140.],
    'ctx-rh-G_insular_long': [21., 10., 10.],
    'ctx-rh-G_insular_short': [225., 140., 140.],
    'ctx-rh-G_and_S_occipital_inferior': [23., 60., 180.],
    'ctx-rh-G_occipital_middle': [180., 60., 180.],
    'ctx-rh-G_occipital_superior': [20., 220., 60.],
    'ctx-rh-G_occipit-temp_lat-Or_fusiform': [60., 20., 140.],
    'ctx-rh-G_occipit-temp_med-Lingual_part': [220., 180., 140.],
    'ctx-rh-G_occipit-temp_med-Parahippocampal_part': [65., 100., 20.],
    'ctx-rh-G_orbital': [220., 60., 20.],
    'ctx-rh-G_paracentral': [60., 100., 60.],
    'ctx-rh-G_parietal_inferior-Angular_part': [20., 60., 220.],
    'ctx-rh-G_parietal_inferior-Supramarginal_part': [100., 100., 60.],
    'ctx-rh-G_parietal_superior': [220., 180., 220.],
    'ctx-rh-G_postcentral': [20., 180., 140.],
    'ctx-rh-G_precentral': [60., 140., 180.],
    'ctx-rh-G_precuneus': [25., 20., 140.],
    'ctx-rh-G_rectus': [20., 60., 100.],
    'ctx-rh-G_subcallosal': [60., 220., 20.],
    'ctx-rh-G_subcentral': [60., 20., 220.],
    'ctx-rh-G_temporal_inferior': [220., 220., 100.],
    'ctx-rh-G_temporal_middle': [180., 60., 60.],
    'ctx-rh-G_temp_sup-G_temp_transv_and_interm_S': [60., 60., 220.],
    'ctx-rh-G_temp_sup-Lateral_aspect': [220., 60., 220.],
    'ctx-rh-G_temp_sup-Planum_polare': [65., 220., 60.],
    'ctx-rh-G_temp_sup-Planum_tempolare': [25., 140., 20.],
    'ctx-rh-G_and_S_transverse_frontopolar': [13., 0., 250.],
    'ctx-rh-Lat_Fissure-ant_sgt-ramus_horizontal': [61., 20., 220.],
    'ctx-rh-Lat_Fissure-ant_sgt-ramus_vertical': [61., 20., 60.],
    'ctx-rh-Lat_Fissure-post_sgt': [61., 60., 100.],
    'ctx-rh-Medial_wall': [25., 25., 25.],
    'ctx-rh-Pole_occipital': [140., 20., 60.],
    'ctx-rh-Pole_temporal': [220., 180., 20.],
    'ctx-rh-S_calcarine': [63., 180., 180.],
    'ctx-rh-S_central': [221., 20., 10.],
    'ctx-rh-S_central_insula': [21., 220., 20.],
    'ctx-rh-S_cingulate-Main_part_and_Intracingulate': [183., 100., 20.],
    'ctx-rh-S_cingulate-Marginalis_part': [221., 20., 100.],
    'ctx-rh-S_circular_insula_anterior': [221., 60., 140.],
    'ctx-rh-S_circular_insula_inferior': [221., 20., 220.],
    'ctx-rh-S_circular_insula_superior': [61., 220., 220.],
    'ctx-rh-S_collateral_transverse_ant': [100., 200., 200.],
    'ctx-rh-S_collateral_transverse_post': [10., 200., 200.],
    'ctx-rh-S_frontal_inferior': [221., 220., 20.],
    'ctx-rh-S_frontal_middle': [141., 20., 100.],
    'ctx-rh-S_frontal_superior': [61., 220., 100.],
    'ctx-rh-S_frontomarginal': [21., 220., 60.],
    'ctx-rh-S_intermedius_primus-Jensen': [141., 60., 20.],
    'ctx-rh-S_intraparietal-and_Parietal_transverse': [143., 20., 220.],
    'ctx-rh-S_occipital_anterior': [61., 20., 180.],
    'ctx-rh-S_occipital_middle_and_Lunatus': [101., 60., 220.],
    'ctx-rh-S_occipital_superior_and_transversalis': [21., 20., 140.],
    'ctx-rh-S_occipito-temporal_lateral': [221., 140., 20.],
    'ctx-rh-S_occipito-temporal_medial_and_S_Lingual': [141., 100., 220.],
    'ctx-rh-S_orbital-H_shapped': [101., 20., 20.],
    'ctx-rh-S_orbital_lateral': [221., 100., 20.],
    'ctx-rh-S_orbital_medial-Or_olfactory': [181., 200., 20.],
    'ctx-rh-S_paracentral': [21., 180., 140.],
    'ctx-rh-S_parieto_occipital': [101., 100., 180.],
    'ctx-rh-S_pericallosal': [181., 220., 20.],
    'ctx-rh-S_postcentral': [21., 140., 200.],
    'ctx-rh-S_precentral-Inferior-part': [21., 20., 240.],
    'ctx-rh-S_precentral-Superior-part': [21., 20., 200.],
    'ctx-rh-S_subcentral_ant': [61., 180., 60.],
    'ctx-rh-S_subcentral_post': [61., 180., 250.],
    'ctx-rh-S_suborbital': [21., 20., 60.],
    'ctx-rh-S_subparietal': [101., 60., 60.],
    'ctx-rh-S_supracingulate': [21., 220., 220.],
    'ctx-rh-S_temporal_inferior': [21., 180., 180.],
    'ctx-rh-S_temporal_superior': [223., 220., 60.],
    'ctx-rh-S_temporal_transverse': [221., 60., 60.],
    'ctx-rh-G_cingulate-caudal_ACC': [25., 60., 61.],
    'ctx-rh-G_cingulate-rostral_ACC': [25., 90., 60.],
    'ctx-rh-G_cingulate-posterior': [25., 120., 60.],
    'ctx-rh-S_cingulate-caudal_ACC': [25., 150., 60.],
    'ctx-rh-S_cingulate-rostral_ACC': [25., 180., 60.],
    'ctx-rh-S_cingulate-posterior': [25., 210., 60.],
    'ctx-rh-S_pericallosal-caudal': [25., 150., 90.],
    'ctx-rh-S_pericallosal-rostral': [25., 180., 90.],
    'ctx-rh-S_pericallosal-posterior': [25., 210., 90.],
    'wm-lh-Unknown': [0., 0., 0.],
    'wm-lh-Corpus_callosum': [50., 50., 50.],
    'wm-lh-G_and_S_Insula_ONLY_AVERAGE': [180., 20., 30.],
    'wm-lh-G_cingulate-Isthmus': [60., 25., 25.],
    'wm-lh-G_cingulate-Main_part': [25., 60., 60.],
    'wm-lh-G_cuneus': [180., 20., 20.],
    'wm-lh-G_frontal_inf-Opercular_part': [220., 20., 100.],
    'wm-lh-G_frontal_inf-Orbital_part': [140., 60., 60.],
    'wm-lh-G_frontal_inf-Triangular_part': [180., 220., 140.],
    'wm-lh-G_frontal_middle': [140., 100., 180.],
    'wm-lh-G_frontal_superior': [180., 20., 140.],
    'wm-lh-G_frontomarginal': [140., 20., 140.],
    'wm-lh-G_insular_long': [21., 10., 10.],
    'wm-lh-G_insular_short': [225., 140., 140.],
    'wm-lh-G_and_S_occipital_inferior': [23., 60., 180.],
    'wm-lh-G_occipital_middle': [180., 60., 180.],
    'wm-lh-G_occipital_superior': [20., 220., 60.],
    'wm-lh-G_occipit-temp_lat-Or_fusiform': [60., 20., 140.],
    'wm-lh-G_occipit-temp_med-Lingual_part': [220., 180., 140.],
    'wm-lh-G_occipit-temp_med-Parahippocampal_part': [65., 100., 20.],
    'wm-lh-G_orbital': [220., 60., 20.],
    'wm-lh-G_paracentral': [60., 100., 60.],
    'wm-lh-G_parietal_inferior-Angular_part': [20., 60., 220.],
    'wm-lh-G_parietal_inferior-Supramarginal_part': [100., 100., 60.],
    'wm-lh-G_parietal_superior': [220., 180., 220.],
    'wm-lh-G_postcentral': [20., 180., 140.],
    'wm-lh-G_precentral': [60., 140., 180.],
    'wm-lh-G_precuneus': [25., 20., 140.],
    'wm-lh-G_rectus': [20., 60., 100.],
    'wm-lh-G_subcallosal': [60., 220., 20.],
    'wm-lh-G_subcentral': [60., 20., 220.],
    'wm-lh-G_temporal_inferior': [220., 220., 100.],
    'wm-lh-G_temporal_middle': [180., 60., 60.],
    'wm-lh-G_temp_sup-G_temp_transv_and_interm_S': [60., 60., 220.],
    'wm-lh-G_temp_sup-Lateral_aspect': [220., 60., 220.],
    'wm-lh-G_temp_sup-Planum_polare': [65., 220., 60.],
    'wm-lh-G_temp_sup-Planum_tempolare': [25., 140., 20.],
    'wm-lh-G_and_S_transverse_frontopolar': [13., 0., 250.],
    'wm-lh-Lat_Fissure-ant_sgt-ramus_horizontal': [61., 20., 220.],
    'wm-lh-Lat_Fissure-ant_sgt-ramus_vertical': [61., 20., 60.],
    'wm-lh-Lat_Fissure-post_sgt': [61., 60., 100.],
    'wm-lh-Medial_wall': [25., 25., 25.],
    'wm-lh-Pole_occipital': [140., 20., 60.],
    'wm-lh-Pole_temporal': [220., 180., 20.],
    'wm-lh-S_calcarine': [63., 180., 180.],
    'wm-lh-S_central': [221., 20., 10.],
    'wm-lh-S_central_insula': [21., 220., 20.],
    'wm-lh-S_cingulate-Main_part_and_Intracingulate': [183., 100., 20.],
    'wm-lh-S_cingulate-Marginalis_part': [221., 20., 100.],
    'wm-lh-S_circular_insula_anterior': [221., 60., 140.],
    'wm-lh-S_circular_insula_inferior': [221., 20., 220.],
    'wm-lh-S_circular_insula_superior': [61., 220., 220.],
    'wm-lh-S_collateral_transverse_ant': [100., 200., 200.],
    'wm-lh-S_collateral_transverse_post': [10., 200., 200.],
    'wm-lh-S_frontal_inferior': [221., 220., 20.],
    'wm-lh-S_frontal_middle': [141., 20., 100.],
    'wm-lh-S_frontal_superior': [61., 220., 100.],
    'wm-lh-S_frontomarginal': [21., 220., 60.],
    'wm-lh-S_intermedius_primus-Jensen': [141., 60., 20.],
    'wm-lh-S_intraparietal-and_Parietal_transverse': [143., 20., 220.],
    'wm-lh-S_occipital_anterior': [61., 20., 180.],
    'wm-lh-S_occipital_middle_and_Lunatus': [101., 60., 220.],
    'wm-lh-S_occipital_superior_and_transversalis': [21., 20., 140.],
    'wm-lh-S_occipito-temporal_lateral': [221., 140., 20.],
    'wm-lh-S_occipito-temporal_medial_and_S_Lingual': [141., 100., 220.],
    'wm-lh-S_orbital-H_shapped': [101., 20., 20.],
    'wm-lh-S_orbital_lateral': [221., 100., 20.],
    'wm-lh-S_orbital_medial-Or_olfactory': [181., 200., 20.],
    'wm-lh-S_paracentral': [21., 180., 140.],
    'wm-lh-S_parieto_occipital': [101., 100., 180.],
    'wm-lh-S_pericallosal': [181., 220., 20.],
    'wm-lh-S_postcentral': [21., 140., 200.],
    'wm-lh-S_precentral-Inferior-part': [21., 20., 240.],
    'wm-lh-S_precentral-Superior-part': [21., 20., 200.],
    'wm-lh-S_subcentral_ant': [61., 180., 60.],
    'wm-lh-S_subcentral_post': [61., 180., 250.],
    'wm-lh-S_suborbital': [21., 20., 60.],
    'wm-lh-S_subparietal': [101., 60., 60.],
    'wm-lh-S_supracingulate': [21., 220., 220.],
    'wm-lh-S_temporal_inferior': [21., 180., 180.],
    'wm-lh-S_temporal_superior': [223., 220., 60.],
    'wm-lh-S_temporal_transverse': [221., 60., 60.],
    'wm-rh-Unknown': [0., 0., 0.],
    'wm-rh-Corpus_callosum': [50., 50., 50.],
    'wm-rh-G_and_S_Insula_ONLY_AVERAGE': [180., 20., 30.],
    'wm-rh-G_cingulate-Isthmus': [60., 25., 25.],
    'wm-rh-G_cingulate-Main_part': [25., 60., 60.],
    'wm-rh-G_cuneus': [180., 20., 20.],
    'wm-rh-G_frontal_inf-Opercular_part': [220., 20., 100.],
    'wm-rh-G_frontal_inf-Orbital_part': [140., 60., 60.],
    'wm-rh-G_frontal_inf-Triangular_part': [180., 220., 140.],
    'wm-rh-G_frontal_middle': [140., 100., 180.],
    'wm-rh-G_frontal_superior': [180., 20., 140.],
    'wm-rh-G_frontomarginal': [140., 20., 140.],
    'wm-rh-G_insular_long': [21., 10., 10.],
    'wm-rh-G_insular_short': [225., 140., 140.],
    'wm-rh-G_and_S_occipital_inferior': [23., 60., 180.],
    'wm-rh-G_occipital_middle': [180., 60., 180.],
    'wm-rh-G_occipital_superior': [20., 220., 60.],
    'wm-rh-G_occipit-temp_lat-Or_fusiform': [60., 20., 140.],
    'wm-rh-G_occipit-temp_med-Lingual_part': [220., 180., 140.],
    'wm-rh-G_occipit-temp_med-Parahippocampal_part': [65., 100., 20.],
    'wm-rh-G_orbital': [220., 60., 20.],
    'wm-rh-G_paracentral': [60., 100., 60.],
    'wm-rh-G_parietal_inferior-Angular_part': [20., 60., 220.],
    'wm-rh-G_parietal_inferior-Supramarginal_part': [100., 100., 60.],
    'wm-rh-G_parietal_superior': [220., 180., 220.],
    'wm-rh-G_postcentral': [20., 180., 140.],
    'wm-rh-G_precentral': [60., 140., 180.],
    'wm-rh-G_precuneus': [25., 20., 140.],
    'wm-rh-G_rectus': [20., 60., 100.],
    'wm-rh-G_subcallosal': [60., 220., 20.],
    'wm-rh-G_subcentral': [60., 20., 220.],
    'wm-rh-G_temporal_inferior': [220., 220., 100.],
    'wm-rh-G_temporal_middle': [180., 60., 60.],
    'wm-rh-G_temp_sup-G_temp_transv_and_interm_S': [60., 60., 220.],
    'wm-rh-G_temp_sup-Lateral_aspect': [220., 60., 220.],
    'wm-rh-G_temp_sup-Planum_polare': [65., 220., 60.],
    'wm-rh-G_temp_sup-Planum_tempolare': [25., 140., 20.],
    'wm-rh-G_and_S_transverse_frontopolar': [13., 0., 250.],
    'wm-rh-Lat_Fissure-ant_sgt-ramus_horizontal': [61., 20., 220.],
    'wm-rh-Lat_Fissure-ant_sgt-ramus_vertical': [61., 20., 60.],
    'wm-rh-Lat_Fissure-post_sgt': [61., 60., 100.],
    'wm-rh-Medial_wall': [25., 25., 25.],
    'wm-rh-Pole_occipital': [140., 20., 60.],
    'wm-rh-Pole_temporal': [220., 180., 20.],
    'wm-rh-S_calcarine': [63., 180., 180.],
    'wm-rh-S_central': [221., 20., 10.],
    'wm-rh-S_central_insula': [21., 220., 20.],
    'wm-rh-S_cingulate-Main_part_and_Intracingulate': [183., 100., 20.],
    'wm-rh-S_cingulate-Marginalis_part': [221., 20., 100.],
    'wm-rh-S_circular_insula_anterior': [221., 60., 140.],
    'wm-rh-S_circular_insula_inferior': [221., 20., 220.],
    'wm-rh-S_circular_insula_superior': [61., 220., 220.],
    'wm-rh-S_collateral_transverse_ant': [100., 200., 200.],
    'wm-rh-S_collateral_transverse_post': [10., 200., 200.],
    'wm-rh-S_frontal_inferior': [221., 220., 20.],
    'wm-rh-S_frontal_middle': [141., 20., 100.],
    'wm-rh-S_frontal_superior': [61., 220., 100.],
    'wm-rh-S_frontomarginal': [21., 220., 60.],
    'wm-rh-S_intermedius_primus-Jensen': [141., 60., 20.],
    'wm-rh-S_intraparietal-and_Parietal_transverse': [143., 20., 220.],
    'wm-rh-S_occipital_anterior': [61., 20., 180.],
    'wm-rh-S_occipital_middle_and_Lunatus': [101., 60., 220.],
    'wm-rh-S_occipital_superior_and_transversalis': [21., 20., 140.],
    'wm-rh-S_occipito-temporal_lateral': [221., 140., 20.],
    'wm-rh-S_occipito-temporal_medial_and_S_Lingual': [141., 100., 220.],
    'wm-rh-S_orbital-H_shapped': [101., 20., 20.],
    'wm-rh-S_orbital_lateral': [221., 100., 20.],
    'wm-rh-S_orbital_medial-Or_olfactory': [181., 200., 20.],
    'wm-rh-S_paracentral': [21., 180., 140.],
    'wm-rh-S_parieto_occipital': [101., 100., 180.],
    'wm-rh-S_pericallosal': [181., 220., 20.],
    'wm-rh-S_postcentral': [21., 140., 200.],
    'wm-rh-S_precentral-Inferior-part': [21., 20., 240.],
    'wm-rh-S_precentral-Superior-part': [21., 20., 200.],
    'wm-rh-S_subcentral_ant': [61., 180., 60.],
    'wm-rh-S_subcentral_post': [61., 180., 250.],
    'wm-rh-S_suborbital': [21., 20., 60.],
    'wm-rh-S_subparietal': [101., 60., 60.],
    'wm-rh-S_supracingulate': [21., 220., 220.],
    'wm-rh-S_temporal_inferior': [21., 180., 180.],
    'wm-rh-S_temporal_superior': [223., 220., 60.],
    'wm-rh-S_temporal_transverse': [221., 60., 60.],
    'Left-UnsegmentedWhiteMatter': [20., 30., 40.],
    'Right-UnsegmentedWhiteMatter': [20., 30., 40.],
    'fmajor': [204., 102., 102.],
    'fminor': [204., 102., 102.],
    'lh.atr': [255., 255., 102.],
    'lh.cab': [153., 204., 0.],
    'lh.ccg': [0., 153., 153.],
    'lh.cst': [204., 153., 255.],
    'lh.ilf': [255., 153., 51.],
    'lh.slfp': [204., 204., 204.],
    'lh.slft': [153., 255., 255.],
    'lh.unc': [102., 153., 255.],
    'rh.atr': [255., 255., 102.],
    'rh.cab': [153., 204., 0.],
    'rh.ccg': [0., 153., 153.],
    'rh.cst': [204., 153., 255.],
    'rh.ilf': [255., 153., 51.],
    'rh.slfp': [204., 204., 204.],
    'rh.slft': [153., 255., 255.],
    'rh.unc': [102., 153., 255.],
    'CC-ForcepsMajor': [204., 102., 102.],
    'CC-ForcepsMinor': [204., 102., 102.],
    'LAntThalRadiation': [255., 255., 102.],
    'LCingulumAngBundle': [153., 204., 0.],
    'LCingulumCingGyrus': [0., 153., 153.],
    'LCorticospinalTract': [204., 153., 255.],
    'LInfLongFas': [255., 153., 51.],
    'LSupLongFasParietal': [204., 204., 204.],
    'LSupLongFasTemporal': [153., 255., 255.],
    'LUncinateFas': [102., 153., 255.],
    'RAntThalRadiation': [255., 255., 102.],
    'RCingulumAngBundle': [153., 204., 0.],
    'RCingulumCingGyrus': [0., 153., 153.],
    'RCorticospinalTract': [204., 153., 255.],
    'RInfLongFas': [255., 153., 51.],
    'RSupLongFasParietal': [204., 204., 204.],
    'RSupLongFasTemporal': [153., 255., 255.],
    'RUncinateFas': [102., 153., 255.],
    'CST-orig': [0., 255., 0.],
    'CST-hammer': [255., 255., 0.],
    'CST-CVS': [0., 255., 255.],
    'CST-flirt': [0., 0., 255.],
    'Left-SLF1': [236., 16., 231.],
    'Right-SLF1': [237., 18., 232.],
    'Left-SLF3': [236., 13., 227.],
    'Right-SLF3': [236., 17., 228.],
    'Left-CST': [1., 255., 1.],
    'Right-CST': [2., 255., 1.],
    'Left-SLF2': [236., 14., 230.],
    'Right-SLF2': [237., 14., 230.],
    'Lateral-nucleus': [72., 132., 181.],
    'Basolateral-nucleus': [243., 243., 243.],
    'Basal-nucleus': [207., 63., 79.],
    'Centromedial-nucleus': [121., 20., 135.],
    'Central-nucleus': [197., 60., 248.],
    'Medial-nucleus': [2., 149., 2.],
    'Cortical-nucleus': [221., 249., 166.],
    'Accessory-Basal-nucleus': [232., 146., 35.],
    'Corticoamygdaloid-transitio': [20., 60., 120.],
    'Anterior-amygdaloid-area-AAA': [250., 250., 0.],
    'Fusion-amygdala-HP-FAH': [122., 187., 222.],
    'Hippocampal-amygdala-transition-HATA': [237., 12., 177.],
    'Endopiriform-nucleus': [10., 49., 255.],
    'Lateral-nucleus-olfactory-tract': [205., 184., 144.],
    'Paralaminar-nucleus': [45., 205., 165.],
    'Intercalated-nucleus': [117., 160., 175.],
    'Prepiriform-cortex': [221., 217., 21.],
    'Periamygdaloid-cortex': [20., 60., 120.],
    'Envelope-Amygdala': [141., 21., 100.],
    'Extranuclear-Amydala': [225., 140., 141.],
    'Brainstem-inferior-colliculus': [42., 201., 168.],
    'Brainstem-cochlear-nucleus': [168., 104., 162.],
    'Thalamus-Anterior': [74., 130., 181.],
    'Thalamus-Ventral-anterior': [242., 241., 240.],
    'Thalamus-Lateral-dorsal': [206., 65., 78.],
    'Thalamus-Lateral-posterior': [120., 21., 133.],
    'Thalamus-Ventral-lateral': [195., 61., 246.],
    'Thalamus-Ventral-posterior-medial': [3., 147., 6.],
    'Thalamus-Ventral-posterior-lateral': [220., 251., 163.],
    'Thalamus-intralaminar': [232., 146., 33.],
    'Thalamus-centromedian': [4., 114., 14.],
    'Thalamus-mediodorsal': [121., 184., 220.],
    'Thalamus-medial': [235., 11., 175.],
    'Thalamus-pulvinar': [12., 46., 250.],
    'Thalamus-lateral-geniculate': [203., 182., 143.],
    'Thalamus-medial-geniculate': [42., 204., 167.],
    'ctx-lh-prefrontal': [30., 5., 30.],
    'ctx-lh-primary-motor': [30., 100., 45.],
    'ctx-lh-premotor': [130., 100., 165.],
    'ctx-lh-temporal': [105., 25., 5.],
    'ctx-lh-posterior-parietal': [125., 70., 55.],
    'ctx-lh-prim-sec-somatosensory': [225., 20., 105.],
    'ctx-lh-occipital': [225., 20., 15.],
    'ctx-rh-prefrontal': [30., 55., 30.],
    'ctx-rh-primary-motor': [30., 150., 45.],
    'ctx-rh-premotor': [130., 150., 165.],
    'ctx-rh-temporal': [105., 75., 5.],
    'ctx-rh-posterior-parietal': [125., 120., 55.],
    'ctx-rh-prim-sec-somatosensory': [225., 70., 105.],
    'ctx-rh-occipital': [225., 70., 15.],
    'ctx_lh_Unknown': [0., 0., 0.],
    'ctx_lh_G_and_S_frontomargin': [23., 220., 60.],
    'ctx_lh_G_and_S_occipital_inf': [23., 60., 180.],
    'ctx_lh_G_and_S_paracentral': [63., 100., 60.],
    'ctx_lh_G_and_S_subcentral': [63., 20., 220.],
    'ctx_lh_G_and_S_transv_frontopol': [13., 0., 250.],
    'ctx_lh_G_and_S_cingul-Ant': [26., 60., 0.],
    'ctx_lh_G_and_S_cingul-Mid-Ant': [26., 60., 75.],
    'ctx_lh_G_and_S_cingul-Mid-Post': [26., 60., 150.],
    'ctx_lh_G_cingul-Post-dorsal': [25., 60., 250.],
    'ctx_lh_G_cingul-Post-ventral': [60., 25., 25.],
    'ctx_lh_G_cuneus': [180., 20., 20.],
    'ctx_lh_G_front_inf-Opercular': [220., 20., 100.],
    'ctx_lh_G_front_inf-Orbital': [140., 60., 60.],
    'ctx_lh_G_front_inf-Triangul': [180., 220., 140.],
    'ctx_lh_G_front_middle': [140., 100., 180.],
    'ctx_lh_G_front_sup': [180., 20., 140.],
    'ctx_lh_G_Ins_lg_and_S_cent_ins': [23., 10., 10.],
    'ctx_lh_G_insular_short': [225., 140., 140.],
    'ctx_lh_G_occipital_middle': [180., 60., 180.],
    'ctx_lh_G_occipital_sup': [20., 220., 60.],
    'ctx_lh_G_oc-temp_lat-fusifor': [60., 20., 140.],
    'ctx_lh_G_oc-temp_med-Lingual': [220., 180., 140.],
    'ctx_lh_G_oc-temp_med-Parahip': [65., 100., 20.],
    'ctx_lh_G_orbital': [220., 60., 20.],
    'ctx_lh_G_pariet_inf-Angular': [20., 60., 220.],
    'ctx_lh_G_pariet_inf-Supramar': [100., 100., 60.],
    'ctx_lh_G_parietal_sup': [220., 180., 220.],
    'ctx_lh_G_postcentral': [20., 180., 140.],
    'ctx_lh_G_precentral': [60., 140., 180.],
    'ctx_lh_G_precuneus': [25., 20., 140.],
    'ctx_lh_G_rectus': [20., 60., 100.],
    'ctx_lh_G_subcallosal': [60., 220., 20.],
    'ctx_lh_G_temp_sup-G_T_transv': [60., 60., 220.],
    'ctx_lh_G_temp_sup-Lateral': [220., 60., 220.],
    'ctx_lh_G_temp_sup-Plan_polar': [65., 220., 60.],
    'ctx_lh_G_temp_sup-Plan_tempo': [25., 140., 20.],
    'ctx_lh_G_temporal_inf': [220., 220., 100.],
    'ctx_lh_G_temporal_middle': [180., 60., 60.],
    'ctx_lh_Lat_Fis-ant-Horizont': [61., 20., 220.],
    'ctx_lh_Lat_Fis-ant-Vertical': [61., 20., 60.],
    'ctx_lh_Lat_Fis-post': [61., 60., 100.],
    'ctx_lh_Medial_wall': [25., 25., 25.],
    'ctx_lh_Pole_occipital': [140., 20., 60.],
    'ctx_lh_Pole_temporal': [220., 180., 20.],
    'ctx_lh_S_calcarine': [63., 180., 180.],
    'ctx_lh_S_central': [221., 20., 10.],
    'ctx_lh_S_cingul-Marginalis': [221., 20., 100.],
    'ctx_lh_S_circular_insula_ant': [221., 60., 140.],
    'ctx_lh_S_circular_insula_inf': [221., 20., 220.],
    'ctx_lh_S_circular_insula_sup': [61., 220., 220.],
    'ctx_lh_S_collat_transv_ant': [100., 200., 200.],
    'ctx_lh_S_collat_transv_post': [10., 200., 200.],
    'ctx_lh_S_front_inf': [221., 220., 20.],
    'ctx_lh_S_front_middle': [141., 20., 100.],
    'ctx_lh_S_front_sup': [61., 220., 100.],
    'ctx_lh_S_interm_prim-Jensen': [141., 60., 20.],
    'ctx_lh_S_intrapariet_and_P_trans': [143., 20., 220.],
    'ctx_lh_S_oc_middle_and_Lunatus': [101., 60., 220.],
    'ctx_lh_S_oc_sup_and_transversal': [21., 20., 140.],
    'ctx_lh_S_occipital_ant': [61., 20., 180.],
    'ctx_lh_S_oc-temp_lat': [221., 140., 20.],
    'ctx_lh_S_oc-temp_med_and_Lingual': [141., 100., 220.],
    'ctx_lh_S_orbital_lateral': [221., 100., 20.],
    'ctx_lh_S_orbital_med-olfact': [181., 200., 20.],
    'ctx_lh_S_orbital-H_Shaped': [101., 20., 20.],
    'ctx_lh_S_parieto_occipital': [101., 100., 180.],
    'ctx_lh_S_pericallosal': [181., 220., 20.],
    'ctx_lh_S_postcentral': [21., 140., 200.],
    'ctx_lh_S_precentral-inf-part': [21., 20., 240.],
    'ctx_lh_S_precentral-sup-part': [21., 20., 200.],
    'ctx_lh_S_suborbital': [21., 20., 60.],
    'ctx_lh_S_subparietal': [101., 60., 60.],
    'ctx_lh_S_temporal_inf': [21., 180., 180.],
    'ctx_lh_S_temporal_sup': [223., 220., 60.],
    'ctx_lh_S_temporal_transverse': [221., 60., 60.],
    'ctx_rh_Unknown': [0., 0., 0.],
    'ctx_rh_G_and_S_frontomargin': [23., 220., 60.],
    'ctx_rh_G_and_S_occipital_inf': [23., 60., 180.],
    'ctx_rh_G_and_S_paracentral': [63., 100., 60.],
    'ctx_rh_G_and_S_subcentral': [63., 20., 220.],
    'ctx_rh_G_and_S_transv_frontopol': [13., 0., 250.],
    'ctx_rh_G_and_S_cingul-Ant': [26., 60., 0.],
    'ctx_rh_G_and_S_cingul-Mid-Ant': [26., 60., 75.],
    'ctx_rh_G_and_S_cingul-Mid-Post': [26., 60., 150.],
    'ctx_rh_G_cingul-Post-dorsal': [25., 60., 250.],
    'ctx_rh_G_cingul-Post-ventral': [60., 25., 25.],
    'ctx_rh_G_cuneus': [180., 20., 20.],
    'ctx_rh_G_front_inf-Opercular': [220., 20., 100.],
    'ctx_rh_G_front_inf-Orbital': [140., 60., 60.],
    'ctx_rh_G_front_inf-Triangul': [180., 220., 140.],
    'ctx_rh_G_front_middle': [140., 100., 180.],
    'ctx_rh_G_front_sup': [180., 20., 140.],
    'ctx_rh_G_Ins_lg_and_S_cent_ins': [23., 10., 10.],
    'ctx_rh_G_insular_short': [225., 140., 140.],
    'ctx_rh_G_occipital_middle': [180., 60., 180.],
    'ctx_rh_G_occipital_sup': [20., 220., 60.],
    'ctx_rh_G_oc-temp_lat-fusifor': [60., 20., 140.],
    'ctx_rh_G_oc-temp_med-Lingual': [220., 180., 140.],
    'ctx_rh_G_oc-temp_med-Parahip': [65., 100., 20.],
    'ctx_rh_G_orbital': [220., 60., 20.],
    'ctx_rh_G_pariet_inf-Angular': [20., 60., 220.],
    'ctx_rh_G_pariet_inf-Supramar': [100., 100., 60.],
    'ctx_rh_G_parietal_sup': [220., 180., 220.],
    'ctx_rh_G_postcentral': [20., 180., 140.],
    'ctx_rh_G_precentral': [60., 140., 180.],
    'ctx_rh_G_precuneus': [25., 20., 140.],
    'ctx_rh_G_rectus': [20., 60., 100.],
    'ctx_rh_G_subcallosal': [60., 220., 20.],
    'ctx_rh_G_temp_sup-G_T_transv': [60., 60., 220.],
    'ctx_rh_G_temp_sup-Lateral': [220., 60., 220.],
    'ctx_rh_G_temp_sup-Plan_polar': [65., 220., 60.],
    'ctx_rh_G_temp_sup-Plan_tempo': [25., 140., 20.],
    'ctx_rh_G_temporal_inf': [220., 220., 100.],
    'ctx_rh_G_temporal_middle': [180., 60., 60.],
    'ctx_rh_Lat_Fis-ant-Horizont': [61., 20., 220.],
    'ctx_rh_Lat_Fis-ant-Vertical': [61., 20., 60.],
    'ctx_rh_Lat_Fis-post': [61., 60., 100.],
    'ctx_rh_Medial_wall': [25., 25., 25.],
    'ctx_rh_Pole_occipital': [140., 20., 60.],
    'ctx_rh_Pole_temporal': [220., 180., 20.],
    'ctx_rh_S_calcarine': [63., 180., 180.],
    'ctx_rh_S_central': [221., 20., 10.],
    'ctx_rh_S_cingul-Marginalis': [221., 20., 100.],
    'ctx_rh_S_circular_insula_ant': [221., 60., 140.],
    'ctx_rh_S_circular_insula_inf': [221., 20., 220.],
    'ctx_rh_S_circular_insula_sup': [61., 220., 220.],
    'ctx_rh_S_collat_transv_ant': [100., 200., 200.],
    'ctx_rh_S_collat_transv_post': [10., 200., 200.],
    'ctx_rh_S_front_inf': [221., 220., 20.],
    'ctx_rh_S_front_middle': [141., 20., 100.],
    'ctx_rh_S_front_sup': [61., 220., 100.],
    'ctx_rh_S_interm_prim-Jensen': [141., 60., 20.],
    'ctx_rh_S_intrapariet_and_P_trans': [143., 20., 220.],
    'ctx_rh_S_oc_middle_and_Lunatus': [101., 60., 220.],
    'ctx_rh_S_oc_sup_and_transversal': [21., 20., 140.],
    'ctx_rh_S_occipital_ant': [61., 20., 180.],
    'ctx_rh_S_oc-temp_lat': [221., 140., 20.],
    'ctx_rh_S_oc-temp_med_and_Lingual': [141., 100., 220.],
    'ctx_rh_S_orbital_lateral': [221., 100., 20.],
    'ctx_rh_S_orbital_med-olfact': [181., 200., 20.],
    'ctx_rh_S_orbital-H_Shaped': [101., 20., 20.],
    'ctx_rh_S_parieto_occipital': [101., 100., 180.],
    'ctx_rh_S_pericallosal': [181., 220., 20.],
    'ctx_rh_S_postcentral': [21., 140., 200.],
    'ctx_rh_S_precentral-inf-part': [21., 20., 240.],
    'ctx_rh_S_precentral-sup-part': [21., 20., 200.],
    'ctx_rh_S_suborbital': [21., 20., 60.],
    'ctx_rh_S_subparietal': [101., 60., 60.],
    'ctx_rh_S_temporal_inf': [21., 180., 180.],
    'ctx_rh_S_temporal_sup': [223., 220., 60.],
    'ctx_rh_S_temporal_transverse': [221., 60., 60.],
    'wm_lh_Unknown': [0., 0., 0.],
    'wm_lh_G_and_S_frontomargin': [23., 220., 60.],
    'wm_lh_G_and_S_occipital_inf': [23., 60., 180.],
    'wm_lh_G_and_S_paracentral': [63., 100., 60.],
    'wm_lh_G_and_S_subcentral': [63., 20., 220.],
    'wm_lh_G_and_S_transv_frontopol': [13., 0., 250.],
    'wm_lh_G_and_S_cingul-Ant': [26., 60., 0.],
    'wm_lh_G_and_S_cingul-Mid-Ant': [26., 60., 75.],
    'wm_lh_G_and_S_cingul-Mid-Post': [26., 60., 150.],
    'wm_lh_G_cingul-Post-dorsal': [25., 60., 250.],
    'wm_lh_G_cingul-Post-ventral': [60., 25., 25.],
    'wm_lh_G_cuneus': [180., 20., 20.],
    'wm_lh_G_front_inf-Opercular': [220., 20., 100.],
    'wm_lh_G_front_inf-Orbital': [140., 60., 60.],
    'wm_lh_G_front_inf-Triangul': [180., 220., 140.],
    'wm_lh_G_front_middle': [140., 100., 180.],
    'wm_lh_G_front_sup': [180., 20., 140.],
    'wm_lh_G_Ins_lg_and_S_cent_ins': [23., 10., 10.],
    'wm_lh_G_insular_short': [225., 140., 140.],
    'wm_lh_G_occipital_middle': [180., 60., 180.],
    'wm_lh_G_occipital_sup': [20., 220., 60.],
    'wm_lh_G_oc-temp_lat-fusifor': [60., 20., 140.],
    'wm_lh_G_oc-temp_med-Lingual': [220., 180., 140.],
    'wm_lh_G_oc-temp_med-Parahip': [65., 100., 20.],
    'wm_lh_G_orbital': [220., 60., 20.],
    'wm_lh_G_pariet_inf-Angular': [20., 60., 220.],
    'wm_lh_G_pariet_inf-Supramar': [100., 100., 60.],
    'wm_lh_G_parietal_sup': [220., 180., 220.],
    'wm_lh_G_postcentral': [20., 180., 140.],
    'wm_lh_G_precentral': [60., 140., 180.],
    'wm_lh_G_precuneus': [25., 20., 140.],
    'wm_lh_G_rectus': [20., 60., 100.],
    'wm_lh_G_subcallosal': [60., 220., 20.],
    'wm_lh_G_temp_sup-G_T_transv': [60., 60., 220.],
    'wm_lh_G_temp_sup-Lateral': [220., 60., 220.],
    'wm_lh_G_temp_sup-Plan_polar': [65., 220., 60.],
    'wm_lh_G_temp_sup-Plan_tempo': [25., 140., 20.],
    'wm_lh_G_temporal_inf': [220., 220., 100.],
    'wm_lh_G_temporal_middle': [180., 60., 60.],
    'wm_lh_Lat_Fis-ant-Horizont': [61., 20., 220.],
    'wm_lh_Lat_Fis-ant-Vertical': [61., 20., 60.],
    'wm_lh_Lat_Fis-post': [61., 60., 100.],
    'wm_lh_Medial_wall': [25., 25., 25.],
    'wm_lh_Pole_occipital': [140., 20., 60.],
    'wm_lh_Pole_temporal': [220., 180., 20.],
    'wm_lh_S_calcarine': [63., 180., 180.],
    'wm_lh_S_central': [221., 20., 10.],
    'wm_lh_S_cingul-Marginalis': [221., 20., 100.],
    'wm_lh_S_circular_insula_ant': [221., 60., 140.],
    'wm_lh_S_circular_insula_inf': [221., 20., 220.],
    'wm_lh_S_circular_insula_sup': [61., 220., 220.],
    'wm_lh_S_collat_transv_ant': [100., 200., 200.],
    'wm_lh_S_collat_transv_post': [10., 200., 200.],
    'wm_lh_S_front_inf': [221., 220., 20.],
    'wm_lh_S_front_middle': [141., 20., 100.],
    'wm_lh_S_front_sup': [61., 220., 100.],
    'wm_lh_S_interm_prim-Jensen': [141., 60., 20.],
    'wm_lh_S_intrapariet_and_P_trans': [143., 20., 220.],
    'wm_lh_S_oc_middle_and_Lunatus': [101., 60., 220.],
    'wm_lh_S_oc_sup_and_transversal': [21., 20., 140.],
    'wm_lh_S_occipital_ant': [61., 20., 180.],
    'wm_lh_S_oc-temp_lat': [221., 140., 20.],
    'wm_lh_S_oc-temp_med_and_Lingual': [141., 100., 220.],
    'wm_lh_S_orbital_lateral': [221., 100., 20.],
    'wm_lh_S_orbital_med-olfact': [181., 200., 20.],
    'wm_lh_S_orbital-H_Shaped': [101., 20., 20.],
    'wm_lh_S_parieto_occipital': [101., 100., 180.],
    'wm_lh_S_pericallosal': [181., 220., 20.],
    'wm_lh_S_postcentral': [21., 140., 200.],
    'wm_lh_S_precentral-inf-part': [21., 20., 240.],
    'wm_lh_S_precentral-sup-part': [21., 20., 200.],
    'wm_lh_S_suborbital': [21., 20., 60.],
    'wm_lh_S_subparietal': [101., 60., 60.],
    'wm_lh_S_temporal_inf': [21., 180., 180.],
    'wm_lh_S_temporal_sup': [223., 220., 60.],
    'wm_lh_S_temporal_transverse': [221., 60., 60.],
    'wm_rh_Unknown': [0., 0., 0.],
    'wm_rh_G_and_S_frontomargin': [23., 220., 60.],
    'wm_rh_G_and_S_occipital_inf': [23., 60., 180.],
    'wm_rh_G_and_S_paracentral': [63., 100., 60.],
    'wm_rh_G_and_S_subcentral': [63., 20., 220.],
    'wm_rh_G_and_S_transv_frontopol': [13., 0., 250.],
    'wm_rh_G_and_S_cingul-Ant': [26., 60., 0.],
    'wm_rh_G_and_S_cingul-Mid-Ant': [26., 60., 75.],
    'wm_rh_G_and_S_cingul-Mid-Post': [26., 60., 150.],
    'wm_rh_G_cingul-Post-dorsal': [25., 60., 250.],
    'wm_rh_G_cingul-Post-ventral': [60., 25., 25.],
    'wm_rh_G_cuneus': [180., 20., 20.],
    'wm_rh_G_front_inf-Opercular': [220., 20., 100.],
    'wm_rh_G_front_inf-Orbital': [140., 60., 60.],
    'wm_rh_G_front_inf-Triangul': [180., 220., 140.],
    'wm_rh_G_front_middle': [140., 100., 180.],
    'wm_rh_G_front_sup': [180., 20., 140.],
    'wm_rh_G_Ins_lg_and_S_cent_ins': [23., 10., 10.],
    'wm_rh_G_insular_short': [225., 140., 140.],
    'wm_rh_G_occipital_middle': [180., 60., 180.],
    'wm_rh_G_occipital_sup': [20., 220., 60.],
    'wm_rh_G_oc-temp_lat-fusifor': [60., 20., 140.],
    'wm_rh_G_oc-temp_med-Lingual': [220., 180., 140.],
    'wm_rh_G_oc-temp_med-Parahip': [65., 100., 20.],
    'wm_rh_G_orbital': [220., 60., 20.],
    'wm_rh_G_pariet_inf-Angular': [20., 60., 220.],
    'wm_rh_G_pariet_inf-Supramar': [100., 100., 60.],
    'wm_rh_G_parietal_sup': [220., 180., 220.],
    'wm_rh_G_postcentral': [20., 180., 140.],
    'wm_rh_G_precentral': [60., 140., 180.],
    'wm_rh_G_precuneus': [25., 20., 140.],
    'wm_rh_G_rectus': [20., 60., 100.],
    'wm_rh_G_subcallosal': [60., 220., 20.],
    'wm_rh_G_temp_sup-G_T_transv': [60., 60., 220.],
    'wm_rh_G_temp_sup-Lateral': [220., 60., 220.],
    'wm_rh_G_temp_sup-Plan_polar': [65., 220., 60.],
    'wm_rh_G_temp_sup-Plan_tempo': [25., 140., 20.],
    'wm_rh_G_temporal_inf': [220., 220., 100.],
    'wm_rh_G_temporal_middle': [180., 60., 60.],
    'wm_rh_Lat_Fis-ant-Horizont': [61., 20., 220.],
    'wm_rh_Lat_Fis-ant-Vertical': [61., 20., 60.],
    'wm_rh_Lat_Fis-post': [61., 60., 100.],
    'wm_rh_Medial_wall': [25., 25., 25.],
    'wm_rh_Pole_occipital': [140., 20., 60.],
    'wm_rh_Pole_temporal': [220., 180., 20.],
    'wm_rh_S_calcarine': [63., 180., 180.],
    'wm_rh_S_central': [221., 20., 10.],
    'wm_rh_S_cingul-Marginalis': [221., 20., 100.],
    'wm_rh_S_circular_insula_ant': [221., 60., 140.],
    'wm_rh_S_circular_insula_inf': [221., 20., 220.],
    'wm_rh_S_circular_insula_sup': [61., 220., 220.],
    'wm_rh_S_collat_transv_ant': [100., 200., 200.],
    'wm_rh_S_collat_transv_post': [10., 200., 200.],
    'wm_rh_S_front_inf': [221., 220., 20.],
    'wm_rh_S_front_middle': [141., 20., 100.],
    'wm_rh_S_front_sup': [61., 220., 100.],
    'wm_rh_S_interm_prim-Jensen': [141., 60., 20.],
    'wm_rh_S_intrapariet_and_P_trans': [143., 20., 220.],
    'wm_rh_S_oc_middle_and_Lunatus': [101., 60., 220.],
    'wm_rh_S_oc_sup_and_transversal': [21., 20., 140.],
    'wm_rh_S_occipital_ant': [61., 20., 180.],
    'wm_rh_S_oc-temp_lat': [221., 140., 20.],
    'wm_rh_S_oc-temp_med_and_Lingual': [141., 100., 220.],
    'wm_rh_S_orbital_lateral': [221., 100., 20.],
    'wm_rh_S_orbital_med-olfact': [181., 200., 20.],
    'wm_rh_S_orbital-H_Shaped': [101., 20., 20.],
    'wm_rh_S_parieto_occipital': [101., 100., 180.],
    'wm_rh_S_pericallosal': [181., 220., 20.],
    'wm_rh_S_postcentral': [21., 140., 200.],
    'wm_rh_S_precentral-inf-part': [21., 20., 240.],
    'wm_rh_S_precentral-sup-part': [21., 20., 200.],
    'wm_rh_S_suborbital': [21., 20., 60.],
    'wm_rh_S_subparietal': [101., 60., 60.],
    'wm_rh_S_temporal_inf': [21., 180., 180.],
    'wm_rh_S_temporal_sup': [223., 220., 60.],
    'wm_rh_S_temporal_transverse': [221., 60., 60.],
    }
    return cmap
