# coding: utf-8

"""
    Seldon Deploy API

    API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.  # noqa: E501

    OpenAPI spec version: v1alpha1
    Contact: hello@seldon.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SeldonDeploymentSpec(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'annotations': 'dict(str, str)',
        'name': 'str',
        'oauth_key': 'str',
        'oauth_secret': 'str',
        'predictors': 'list[PredictorSpec]',
        'protocol': 'Protocol',
        'replicas': 'int',
        'server_type': 'ServerType',
        'transport': 'Transport'
    }

    attribute_map = {
        'annotations': 'annotations',
        'name': 'name',
        'oauth_key': 'oauth_key',
        'oauth_secret': 'oauth_secret',
        'predictors': 'predictors',
        'protocol': 'protocol',
        'replicas': 'replicas',
        'server_type': 'serverType',
        'transport': 'transport'
    }

    def __init__(self, annotations=None, name=None, oauth_key=None, oauth_secret=None, predictors=None, protocol=None, replicas=None, server_type=None, transport=None):  # noqa: E501
        """SeldonDeploymentSpec - a model defined in Swagger"""  # noqa: E501

        self._annotations = None
        self._name = None
        self._oauth_key = None
        self._oauth_secret = None
        self._predictors = None
        self._protocol = None
        self._replicas = None
        self._server_type = None
        self._transport = None
        self.discriminator = None

        if annotations is not None:
            self.annotations = annotations
        if name is not None:
            self.name = name
        if oauth_key is not None:
            self.oauth_key = oauth_key
        if oauth_secret is not None:
            self.oauth_secret = oauth_secret
        if predictors is not None:
            self.predictors = predictors
        if protocol is not None:
            self.protocol = protocol
        if replicas is not None:
            self.replicas = replicas
        if server_type is not None:
            self.server_type = server_type
        if transport is not None:
            self.transport = transport

    @property
    def annotations(self):
        """Gets the annotations of this SeldonDeploymentSpec.  # noqa: E501


        :return: The annotations of this SeldonDeploymentSpec.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this SeldonDeploymentSpec.


        :param annotations: The annotations of this SeldonDeploymentSpec.  # noqa: E501
        :type: dict(str, str)
        """

        self._annotations = annotations

    @property
    def name(self):
        """Gets the name of this SeldonDeploymentSpec.  # noqa: E501

        Name is Deprecated will be removed in future  # noqa: E501

        :return: The name of this SeldonDeploymentSpec.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SeldonDeploymentSpec.

        Name is Deprecated will be removed in future  # noqa: E501

        :param name: The name of this SeldonDeploymentSpec.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def oauth_key(self):
        """Gets the oauth_key of this SeldonDeploymentSpec.  # noqa: E501


        :return: The oauth_key of this SeldonDeploymentSpec.  # noqa: E501
        :rtype: str
        """
        return self._oauth_key

    @oauth_key.setter
    def oauth_key(self, oauth_key):
        """Sets the oauth_key of this SeldonDeploymentSpec.


        :param oauth_key: The oauth_key of this SeldonDeploymentSpec.  # noqa: E501
        :type: str
        """

        self._oauth_key = oauth_key

    @property
    def oauth_secret(self):
        """Gets the oauth_secret of this SeldonDeploymentSpec.  # noqa: E501


        :return: The oauth_secret of this SeldonDeploymentSpec.  # noqa: E501
        :rtype: str
        """
        return self._oauth_secret

    @oauth_secret.setter
    def oauth_secret(self, oauth_secret):
        """Sets the oauth_secret of this SeldonDeploymentSpec.


        :param oauth_secret: The oauth_secret of this SeldonDeploymentSpec.  # noqa: E501
        :type: str
        """

        self._oauth_secret = oauth_secret

    @property
    def predictors(self):
        """Gets the predictors of this SeldonDeploymentSpec.  # noqa: E501


        :return: The predictors of this SeldonDeploymentSpec.  # noqa: E501
        :rtype: list[PredictorSpec]
        """
        return self._predictors

    @predictors.setter
    def predictors(self, predictors):
        """Sets the predictors of this SeldonDeploymentSpec.


        :param predictors: The predictors of this SeldonDeploymentSpec.  # noqa: E501
        :type: list[PredictorSpec]
        """

        self._predictors = predictors

    @property
    def protocol(self):
        """Gets the protocol of this SeldonDeploymentSpec.  # noqa: E501


        :return: The protocol of this SeldonDeploymentSpec.  # noqa: E501
        :rtype: Protocol
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this SeldonDeploymentSpec.


        :param protocol: The protocol of this SeldonDeploymentSpec.  # noqa: E501
        :type: Protocol
        """

        self._protocol = protocol

    @property
    def replicas(self):
        """Gets the replicas of this SeldonDeploymentSpec.  # noqa: E501


        :return: The replicas of this SeldonDeploymentSpec.  # noqa: E501
        :rtype: int
        """
        return self._replicas

    @replicas.setter
    def replicas(self, replicas):
        """Sets the replicas of this SeldonDeploymentSpec.


        :param replicas: The replicas of this SeldonDeploymentSpec.  # noqa: E501
        :type: int
        """

        self._replicas = replicas

    @property
    def server_type(self):
        """Gets the server_type of this SeldonDeploymentSpec.  # noqa: E501


        :return: The server_type of this SeldonDeploymentSpec.  # noqa: E501
        :rtype: ServerType
        """
        return self._server_type

    @server_type.setter
    def server_type(self, server_type):
        """Sets the server_type of this SeldonDeploymentSpec.


        :param server_type: The server_type of this SeldonDeploymentSpec.  # noqa: E501
        :type: ServerType
        """

        self._server_type = server_type

    @property
    def transport(self):
        """Gets the transport of this SeldonDeploymentSpec.  # noqa: E501


        :return: The transport of this SeldonDeploymentSpec.  # noqa: E501
        :rtype: Transport
        """
        return self._transport

    @transport.setter
    def transport(self, transport):
        """Sets the transport of this SeldonDeploymentSpec.


        :param transport: The transport of this SeldonDeploymentSpec.  # noqa: E501
        :type: Transport
        """

        self._transport = transport

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SeldonDeploymentSpec, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SeldonDeploymentSpec):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
