/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.v0_6;

import java.io.File;
import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.replication.common.FileReplicationStore;
import org.openstreetmap.osmosis.replication.common.ReplicationState;
import org.openstreetmap.osmosis.replication.common.ReplicationStore;
import org.openstreetmap.osmosis.replication.v0_6.ReplicationStateWriter;
import org.openstreetmap.osmosis.xml.v0_6.XmlChangeWriter;

public class ReplicationWriter
implements ChangeSink {
    private ReplicationStore replicationStore;
    private ReplicationStateWriter stateWriter;
    private ReplicationState state;
    private XmlChangeWriter changeWriter;

    public ReplicationWriter(File workingDirectory) {
        this.replicationStore = new FileReplicationStore(workingDirectory, false);
        this.stateWriter = new ReplicationStateWriter(workingDirectory);
    }

    public void initialize(Map<String, Object> metaData) {
        this.stateWriter.initialize(metaData);
        this.state = (ReplicationState)metaData.get("replication.state");
        if (this.state.getSequenceNumber() > 0L) {
            this.changeWriter = this.replicationStore.saveData(this.state.getSequenceNumber());
        }
    }

    public void process(ChangeContainer change) {
        this.changeWriter.process(change);
    }

    public void complete() {
        if (this.state.getSequenceNumber() > 0L) {
            this.changeWriter.complete();
            this.changeWriter.close();
            this.changeWriter = null;
        }
        this.replicationStore.saveState(this.state);
        this.stateWriter.complete();
    }

    public void close() {
        if (this.changeWriter != null) {
            this.changeWriter.close();
            this.changeWriter = null;
        }
        this.stateWriter.close();
    }
}

