/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.v0_6;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSinkChangeSource;
import org.openstreetmap.osmosis.replication.common.ReplicationState;
import org.openstreetmap.osmosis.replication.v0_6.ReplicationStateWriter;

public class ReplicationToChangeWriter
implements ChangeSinkChangeSource {
    private ReplicationStateWriter stateWriter;
    private ReplicationState state;
    private ChangeSink changeSink;

    public ReplicationToChangeWriter(File workingDirectory) {
        this.stateWriter = new ReplicationStateWriter(workingDirectory);
    }

    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }

    public void initialize(Map<String, Object> metaData) {
        this.stateWriter.initialize(metaData);
        this.state = (ReplicationState)metaData.get("replication.state");
        if (this.state.getSequenceNumber() > 0L) {
            HashMap<String, Object> downstreamMetaData = new HashMap<String, Object>(metaData);
            downstreamMetaData.remove("replication.state");
            this.changeSink.initialize(downstreamMetaData);
        }
    }

    public void process(ChangeContainer change) {
        this.stateWriter.process(change);
        this.changeSink.process(change);
    }

    public void complete() {
        if (this.state.getSequenceNumber() > 0L) {
            this.changeSink.complete();
        }
        this.stateWriter.complete();
    }

    public void close() {
        this.changeSink.close();
        this.stateWriter.close();
    }
}

