/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.pipeline.common;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.pipeline.common.PipeTasks;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactoryRegister;

public class Pipeline {
    private static final Logger LOG = Logger.getLogger(Pipeline.class.getName());
    private TaskManagerFactoryRegister factoryRegister;
    private List<TaskManager> taskManagers;

    public Pipeline(TaskManagerFactoryRegister factoryRegister) {
        this.factoryRegister = factoryRegister;
        this.taskManagers = new ArrayList<TaskManager>();
    }

    private void buildTasks(List<TaskConfiguration> taskInfoList) {
        for (TaskConfiguration taskConfig : taskInfoList) {
            this.taskManagers.add(this.factoryRegister.getInstance(taskConfig.getType()).createTaskManager(taskConfig));
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Created task \"" + taskConfig.getId() + "\"");
        }
    }

    private void connectTasks() {
        PipeTasks pipeTasks = new PipeTasks();
        for (TaskManager taskManager : this.taskManagers) {
            taskManager.connect(pipeTasks);
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Connected task \"" + taskManager.getTaskId() + "\"");
        }
        if (pipeTasks.size() > 0) {
            StringBuilder namedPipes = new StringBuilder();
            for (String pipeName : pipeTasks.getPipeNames()) {
                if (namedPipes.length() > 0) {
                    namedPipes.append(", ");
                }
                namedPipes.append(pipeName);
            }
            throw new OsmosisRuntimeException("The following named pipes (" + namedPipes + ") and " + pipeTasks.defaultTaskSize() + " default pipes have not been terminated with appropriate output sinks.");
        }
    }

    public void prepare(List<TaskConfiguration> taskInfoList) {
        LOG.fine("Building tasks.");
        this.buildTasks(taskInfoList);
        LOG.fine("Connecting tasks.");
        this.connectTasks();
    }

    public void execute() {
        for (TaskManager taskManager : this.taskManagers) {
            taskManager.execute();
        }
    }

    public void waitForCompletion() {
        boolean successful = true;
        for (TaskManager taskManager : this.taskManagers) {
            if (taskManager.waitForCompletion()) continue;
            successful = false;
        }
        if (!successful) {
            throw new OsmosisRuntimeException("One or more tasks failed.");
        }
    }
}

