/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.dataset.v0_6;

import java.util.Collections;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.Dataset;
import org.openstreetmap.osmosis.core.container.v0_6.DatasetContext;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.task.v0_6.DatasetSinkSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;

public class DatasetBoundingBoxFilter
implements DatasetSinkSource {
    private Sink sink;
    private double left;
    private double right;
    private double top;
    private double bottom;
    private boolean completeWays;
    private DatasetContext datasetReader;

    public DatasetBoundingBoxFilter(double left, double right, double top, double bottom, boolean completeWays) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
        this.completeWays = completeWays;
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public void process(Dataset dataset) {
        if (this.datasetReader != null) {
            throw new OsmosisRuntimeException("process may only be invoked once.");
        }
        this.datasetReader = dataset.createReader();
        try (ReleasableIterator bboxData = this.datasetReader.iterateBoundingBox(this.left, this.right, this.top, this.bottom, this.completeWays);){
            this.sink.initialize(Collections.emptyMap());
            while (bboxData.hasNext()) {
                this.sink.process((EntityContainer)bboxData.next());
            }
            this.sink.complete();
        }
    }

    public void close() {
        this.sink.close();
        if (this.datasetReader != null) {
            this.datasetReader.close();
        }
    }
}

