/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.extract.apidb.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.database.DatabaseType;

public class Configuration {
    private static final String KEY_HOST = "host";
    private static final String KEY_DATABASE = "database";
    private static final String KEY_USER = "user";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_DB_TYPE = "dbType";
    private static final String KEY_INTERVAL_LENGTH = "intervalLength";
    private static final String KEY_LAG_LENGTH = "lagLength";
    private static final String KEY_CHANGE_FILE_BEGIN_FORMAT = "changeFileBeginFormat";
    private static final String KEY_CHANGE_FILE_END_FORMAT = "changeFileEndFormat";
    private static final String KEY_READ_FULL_HISTORY = "readFullHistory";
    private static final String KEY_VALIDATE_SCHEMA_VERSION = "validateSchemaVersion";
    private static final String KEY_ALLOW_INCORRECT_SCHEMA_VERSION = "allowIncorrectSchemaVersion";
    private Properties properties;

    public Configuration(File configFile) {
        this.properties = this.loadProperties(configFile);
    }

    private Properties loadProperties(File configFile) {
        this.properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(configFile);){
            this.properties.load(fileInputStream);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to load properties from config file " + configFile);
        }
        return this.properties;
    }

    private String getProperty(String propertyName) {
        String value = this.properties.getProperty(propertyName);
        if (value == null) {
            throw new OsmosisRuntimeException("Property " + propertyName + " cannot be found.");
        }
        return value;
    }

    public String getHost() {
        return this.getProperty(KEY_HOST);
    }

    public String getDatabase() {
        return this.getProperty(KEY_DATABASE);
    }

    public String getUser() {
        return this.getProperty(KEY_USER);
    }

    public String getPassword() {
        return this.properties.getProperty(KEY_PASSWORD);
    }

    public DatabaseType getDbType() {
        return DatabaseType.fromString((String)this.getProperty(KEY_DB_TYPE));
    }

    public int getIntervalLength() {
        return Integer.parseInt(this.getProperty(KEY_INTERVAL_LENGTH)) * 1000;
    }

    public int getLagLength() {
        return Integer.parseInt(this.getProperty(KEY_LAG_LENGTH)) * 1000;
    }

    public String getChangeFileBeginFormat() {
        return this.getProperty(KEY_CHANGE_FILE_BEGIN_FORMAT);
    }

    public String getChangeFileEndFormat() {
        return this.getProperty(KEY_CHANGE_FILE_END_FORMAT);
    }

    public boolean getReadFullHistory() {
        return Boolean.valueOf(this.getProperty(KEY_READ_FULL_HISTORY));
    }

    public boolean getValidateSchemaVersion() {
        return Boolean.valueOf(this.getProperty(KEY_VALIDATE_SCHEMA_VERSION));
    }

    public boolean getAllowIncorrectSchemaVersion() {
        return Boolean.valueOf(this.getProperty(KEY_ALLOW_INCORRECT_SCHEMA_VERSION));
    }

    public DatabaseLoginCredentials getDatabaseLoginCredentials() {
        return new DatabaseLoginCredentials(this.getHost(), this.getDatabase(), this.getUser(), this.getPassword(), false, false, this.getDbType());
    }

    public DatabasePreferences getDatabasePreferences() {
        return new DatabasePreferences(this.getValidateSchemaVersion(), this.getAllowIncorrectSchemaVersion());
    }
}

