/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6;

import org.openstreetmap.osmosis.core.container.v0_6.Dataset;
import org.openstreetmap.osmosis.core.container.v0_6.DatasetContext;
import org.openstreetmap.osmosis.core.database.DatabaseLocker;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.task.v0_6.DatasetSink;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableDatasetSource;
import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.PostgreSqlDatasetContext;

public class PostgreSqlDatasetReader
implements RunnableDatasetSource,
Dataset {
    private DatasetSink datasetSink;
    private DatabaseLoginCredentials loginCredentials;
    private DatabasePreferences preferences;

    public PostgreSqlDatasetReader(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences) {
        this.loginCredentials = loginCredentials;
        this.preferences = preferences;
    }

    public void setDatasetSink(DatasetSink datasetSink) {
        this.datasetSink = datasetSink;
    }

    public void run() {
        try (DatabaseContext context = new DatabaseContext(this.loginCredentials);
             DatabaseLocker locker = new DatabaseLocker(context.getDataSource(), false);){
            locker.lockDatabase(this.getClass().getSimpleName());
            this.datasetSink.process((Dataset)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.datasetSink.close();
        }
    }

    public DatasetContext createReader() {
        return new PostgreSqlDatasetContext(this.loginCredentials, this.preferences, false);
    }
}

