/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.model;

import java.util.ArrayList;
import java.util.List;
import org.mapsforge.core.model.LineSegment;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;

public class LineString {
    public final List<LineSegment> segments = new ArrayList<LineSegment>();

    public void LineString() {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LineString)) {
            return false;
        }
        LineString other = (LineString)obj;
        if (other.segments.size() != this.segments.size()) {
            return false;
        }
        for (int i = 0; i < this.segments.size(); ++i) {
            if (this.segments.get(i).equals(other.segments.get(i))) continue;
            return false;
        }
        return true;
    }

    public LineString extractPart(double startDistance, double endDistance) {
        LineString result = new LineString();
        for (int i = 0; i < this.segments.size(); ++i) {
            LineSegment segment = this.segments.get(i);
            double length = segment.length();
            if (!(length < startDistance)) {
                Point startPoint = null;
                Point endPoint = null;
                if (startDistance >= 0.0) {
                    startPoint = segment.pointAlongLineSegment(startDistance);
                }
                if (endDistance < length) {
                    endPoint = segment.pointAlongLineSegment(endDistance);
                }
                if (startPoint != null && endPoint == null) {
                    result.segments.add(new LineSegment(startPoint, segment.end));
                } else if (startPoint == null && endPoint == null) {
                    result.segments.add(segment);
                } else if (startPoint == null && endPoint != null) {
                    result.segments.add(new LineSegment(segment.start, endPoint));
                } else if (startPoint != null && endPoint != null) {
                    result.segments.add(new LineSegment(startPoint, endPoint));
                }
                if (endPoint != null) break;
            }
            startDistance -= this.segments.get(i).length();
            endDistance -= this.segments.get(i).length();
        }
        return result;
    }

    public Rectangle getBounds() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (LineSegment segment : this.segments) {
            minX = Math.min(minX, Math.min(segment.start.x, segment.end.x));
            minY = Math.min(minY, Math.min(segment.start.y, segment.end.y));
            maxX = Math.max(maxX, Math.max(segment.start.x, segment.end.x));
            maxY = Math.max(maxY, Math.max(segment.start.y, segment.end.y));
        }
        return new Rectangle(minX, minY, maxX, maxY);
    }

    public Point interpolate(double distance) {
        if (distance < 0.0) {
            return null;
        }
        for (LineSegment segment : this.segments) {
            double length = segment.length();
            if (distance <= length) {
                return segment.pointAlongLineSegment(distance);
            }
            distance -= length;
        }
        return null;
    }

    public double length() {
        double result = 0.0;
        for (LineSegment segment : this.segments) {
            result += segment.length();
        }
        return result;
    }
}

