import sys
from tiler.tiler import Tiler
from tiler.merger import Merger


from pkg_resources import get_distribution, DistributionNotFound

try:
    VERSION = get_distribution(__name__).version
except DistributionNotFound:  # pragma: no cover
    try:
        from .version import version as VERSION  # noqa
    except ImportError:  # pragma: no cover
        raise ImportError(
            "Failed to find (autogenerated) version.py. "
            "This might be because you are installing from GitHub's tarballs, "
            "use the PyPI ones."
        )
__version__ = VERSION

__all__ = ["Tiler", "Merger"]

# Import README file as a module general docstring, only when generating documentation
# We also modify it to make it prettier
if "pdoc" in sys.modules:  # pragma: no cover
    with open("README.md", "r") as f:
        _readme = f.read()

        # remove baby logo and header
        _readme = _readme.split("\n", 2)[2]

        # replace teaser image path
        _readme = _readme.replace("misc/teaser/tiler_teaser.png", "tiler_teaser.png")
        _readme = _readme.replace("misc/baby_logo.png", "baby_logo.png")
        __doc__ = _readme
