/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileFinder {
    private static final String SEPARATOR = System.getProperty("path.separator");
    private static final String[] PATHS_PROPERTIES = new String[]{"java.class.path", "java.library.path"};
    public static List<File> fileDir = new ArrayList<File>();

    public static File find(String lastPath) {
        return FileFinder.find(lastPath, Integer.MAX_VALUE);
    }

    public static File find(String lastPath, int deep) {
        for (File file : fileDir) {
            if (!file.exists() || !file.canRead() || (file = FileFinder.findByFile(file, lastPath, deep)) == null) continue;
            return file;
        }
        for (String pathProperties : PATHS_PROPERTIES) {
            String[] propertyPath;
            for (String path : propertyPath = System.getProperty(pathProperties).split(SEPARATOR)) {
                File file = new File(path);
                if (!file.exists() || !file.canRead() || (file = FileFinder.findByFile(file, lastPath, deep)) == null) continue;
                return file;
            }
        }
        return null;
    }

    public static File findByFile(File file, String lastPath) {
        return FileFinder.findByFile(file, lastPath, Integer.MAX_VALUE);
    }

    public static File findByFile(File file, String lastPath, int deep) {
        File[] listFiles;
        if (deep == 0 || !file.exists() || !file.canRead()) {
            return null;
        }
        if (file.getAbsolutePath().endsWith(lastPath)) {
            return file;
        }
        if (file.isDirectory() && (listFiles = file.listFiles()) != null && listFiles.length > 0) {
            for (File file2 : listFiles) {
                File temp = FileFinder.findByFile(file2, lastPath, deep - 1);
                if (temp == null) continue;
                return temp;
            }
        }
        return null;
    }

    static {
        fileDir.add(new File("").getAbsoluteFile());
    }
}

