#!/usr/bin/python3
# -*- coding: utf8 -*-

__all__=["c_oracle","c_database"]

import time,base64,sys,json,urllib.request,ssl,os,datetime
import libsw3 as sw3

class c_database(object):
    def __init__(self,sconn=""):
        self.sconn=sconn
        self.connected=False
    def convconn(self,ljc):
        if ljc.find("/")>0 or ljc.find("}")>0:
            return ljc
        dh,_=os.path.splitdrive(os.getcwd())
        fn1=os.path.join(dh,"/etc","dbconn.cfg")
        fn2=os.path.join(dh,"/etc","oraconn.cfg")
        if os.path.isfile(fn1):
            f=open(fn1)
        elif os.path.isfile(fn2):
            f=open(fn2)
        else:
            sw3.swexit(-1,"无法打开连接串配置文件%s或者%s" %(fn1,fn2))
        wjnr=f.readlines()
        f.close()
        for i in wjnr:
            s=i.split()
            if len(s)<2:
                continue
            if s[0]==ljc:
                return s[1]
        return ""

class c_mysql(c_database):
    def __init__(self,sconn=""):
        pass

class c_oracle(c_database):
    def __init__(self,sconn="",yslj=False,autocommit=False,raiseExp=True):
        global cx_Oracle
        import cx_Oracle
        self.BLOB=cx_Oracle.BLOB
        self.sconn=sconn
        self.connected=False
        self.autocommit=autocommit
        self.raiseExp = raiseExp
        (not yslj) and self.connect()
    def commit(self):
        try:
            self.conn.commit()
        except cx_Oracle.DatabaseError as e:
            print("commit异常：%s" % (e))
            error, = e.args
            if error.code==28 or error.code==1012:  #未登录或者被踢出
                self.connected=False
            if self.raiseExp:
                raise  # 往上层抛
    def connect(self,sconn=""):
        if sconn!="":
            self.sconn=sconn
            self.connected=False
        if self.connected:
            c=self.conn.cursor()
            try:
                c.execute("select 1 from dual")
            except cx_Oracle.DatabaseError as e:
                self.connected=False
                print("连接数据库异常：%s" % (e))
                if self.raiseExp:
                    raise  # 往上层抛
            else:
                return
        try:
            self.conn=cx_Oracle.connect(self.convconn(self.sconn))
        except cx_Oracle.DatabaseError as e:
            sw3.swexit(1,"数据库连接%s不成功" %(self.sconn))
            error, = e.args
            if self.raiseExp:
                raise  # 往上层抛
        else:
            self.c=self.conn.cursor()
            self.connected=True
    def droptable(self,tablename):
        if self.jg1("select count(1) from user_tables where table_name = upper('%s')" %(tablename))==1:
            self.c.execute("drop table %s purge" %(tablename))
    def execute(self,ssql,*args,**kwargs):
        (not self.connected) and self.connect()
        if not self.connected:
            return
        try:
            c=self.conn.cursor()
            c.execute(ssql,*args,**kwargs)
        except cx_Oracle.DatabaseError as e:
            self.connected=False
            print("oracle执行异常：%s" % (e))
            if self.raiseExp:
                raise  # 往上层抛
            return
        return c
    def execute2(self,ssql,**kwargs):
        (not self.connected) and self.connect()
        if not self.connected:
            return
        try:
            list = []
            c = self.conn.cursor()
            c.execute(ssql, kwargs)
            col = c.description
            for item in c.fetchall():
                dict = {}
                for i in range(len(col)):
                    dict[col[i][0]] = item[i]
                list.append(dict)
        except cx_Oracle.DatabaseError as e:
            self.connected = False
            print("oracle执行异常：%s" % (e))
            if self.raiseExp:
                raise  # 往上层抛
            return
        return list
    def dp(self,open参数,目录名,文件名,parameter=[],remap=[],ft=[]):    #类似impdp导入数据
        '''
使用DBMS_DATAPUMP包操作impdp和expdp的文档可参考 https://docs.oracle.com/database/121/ARPLS/d_datpmp.htm#ARPLS631
调用示例如 xxx.dp(['IMPORT','FULL'],"oracle数据目录","导入文件名（会自动加上.dmp)", parameter=[["TABLE_EXISTS_ACTION","REPLACE"]], remap=[["REMAP_SCHEMA","导出用户","导入用户"]], ft=[[]])

open参数实际上是提交到DBMS_DATAPUMP.open的参数，详情请参考oracle参数（下同），常用的是：
参数1选择 EXPORT 或者 IMPORT 表示导出或者导入
参数2可选择 FULL SCHEMA TABLE TABLESPACE

parameter参数用于处理dbms_datapump.set_parameter，常用的是：
TABLE_EXISTS_ACTION     用于处理表已经存在时，可选择的参数是：TRUNCATE, REPLACE, APPEND, 和 SKIP.

remap参数用于处理dbms_datapump.METADATA_REMAP，常用的是：
REMAP_SCHEMA    用于导出和导入非同一用户时
REMAP_TABLESPACE    用于导出和导入非同一表空间时

ft参数用于处理DBMS_DATAPUMP.METADATA_FILTER，常用的是：

'''
        (not self.connected) and self.connect()
        目录名=目录名.upper()
        c=self.conn.cursor()
        dp号=c.var(cx_Oracle.NUMBER)
        c.callfunc('DBMS_DATAPUMP.open',dp号,open参数)
        dp=int(dp号.getvalue())
        c.execute("BEGIN DBMS_DATAPUMP.add_file(handle=> %d,filename=>'%s.dmp',directory=>'%s',filetype=>DBMS_DATAPUMP.KU$_FILE_TYPE_DUMP_FILE); END;" %(dp,文件名,目录名))
        c.execute("BEGIN DBMS_DATAPUMP.add_file(handle=> %d,filename=>'%s_%s.log',directory=>'%s',filetype=>DBMS_DATAPUMP.KU$_FILE_TYPE_LOG_FILE); END;" %(dp,文件名,open参数[0].lower(),目录名))
        for 项目,内容 in ft:
            c.callproc("dbms_datapump.METADATA_FILTER",[dp,项目,内容])
        for 项目,内容 in parameter:
            c.callproc("dbms_datapump.set_parameter",[dp,项目,内容])
        for 项目,旧值,新值 in remap:
            c.callproc("dbms_datapump.METADATA_REMAP",[dp,项目,旧值,新值])
        try:
            c.callproc("DBMS_DATAPUMP.start_job",[dp])
        except cx_Oracle.DatabaseError as e:
            sql_getstatus='''
DECLARE
    job_state VARCHAR2(2000);
    status  ku$_Status;
BEGIN
    DBMS_DATAPUMP.GET_STATUS(%d,DBMS_DATAPUMP.KU$_STATUS_JOB_STATUS,0,job_state,status);
    DBMS_OUTPUT.put_line(job_state);
END;''' %(dp)
            print(sql_getstatus)
            c.callproc("dbms_output.enable")
            c.execute(sql_getstatus)
            self.dbms_output(c)
        job_state=c.var(cx_Oracle.STRING)
        c.callproc("DBMS_DATAPUMP.WAIT_FOR_JOB",[dp,job_state])
    def dbms_output(self,cursor,n=100):
        '''打印dbms_output数据，注意要预先 callproc("dbms_output.enable") '''
        lines = cursor.arrayvar(cx_Oracle.STRING, n)
        numlines = cursor.var(cx_Oracle.NUMBER)
        numlines.setvalue(0,n)  # fetch 'n' lines at a time
        while True:
            cursor.callproc("dbms_output.get_lines",(lines, numlines))
            num_of_lines = int(numlines.getvalue())
            if num_of_lines != 0:
                for line in lines.getvalue()[:num_of_lines]:
                    print(line)
            else:
                break        
    def inslist(self,tablename,data,collist=""):
        '''在表中直接插入数据'''
        (not self.connected) and self.connect()
        if collist=="":
            ssql="insert into %s values(" %(tablename)
        else:
            ssql="insert into %s (%s) values(" %(tablename,collist)
        for i in range(len(data)):
            ssql="%s:%d," %(ssql,i)
        ssql="%s)" %(ssql[:-1])
        c=self.conn.cursor()
        c.execute(ssql,data)
    def jg1(self,ssql,*args,**kwargs):
        '''根据sql返回1条结果'''
        (not self.connected) and self.connect()
        if not self.connected:
            return
        try:
            c=self.conn.cursor()
            c.execute(ssql,*args,**kwargs)
            jg=c.fetchone()
        except cx_Oracle.DatabaseError as e:
            self.connected=False
            print("oracle执行异常：%s" % (e))
            if self.raiseExp:
                raise  # 往上层抛
            return
        c.close()
        if jg==None:
            return
        if len(jg)==1:
            return jg[0]
        else:
            return jg
    def tablecreatesql(self,tablename): #获取表的生成脚本
        c=self.conn.cursor()
        sql='''
BEGIN
    DBMS_METADATA.SET_TRANSFORM_PARAM(-1,'TABLESPACE',false);
    DBMS_METADATA.SET_TRANSFORM_PARAM(-1,'STORAGE',false);
    DBMS_METADATA.SET_TRANSFORM_PARAM(-1,'SEGMENT_ATTRIBUTES',false);
    DBMS_METADATA.SET_TRANSFORM_PARAM(-1,'PRETTY',false);
END;
'''
        c.execute(sql)
        ssql=self.jg1("SELECT dbms_metadata.get_ddl('TABLE','%s') FROM DUAL" %(tablename.upper())).read()
        ssql='create table "%s" %s' %(tablename.upper(),ssql[ssql.find("("):])
        return ssql
    def xg(self,ssql,**kwargs): #对数据库进行修改，可自动commit
        (not self.connected) and self.connect()
        if not self.connected:
            return
        try:
            c=self.conn.cursor()
            c.execute(ssql,kwargs)
            self.autocommit and self.commit()
        except cx_Oracle.DatabaseError as e:
            self.connected=False
            print("oracle执行异常：%s" %(e))
            if self.raiseExp:
                raise  # 往上层抛
            return
        return True
