#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['mentormatch',
 'mentormatch.api',
 'mentormatch.api.applicant',
 'mentormatch.api.compatibility',
 'mentormatch.api.matcher',
 'mentormatch.api.sorter',
 'mentormatch.api.summarize',
 'mentormatch.exporter',
 'mentormatch.importer',
 'mentormatch.utils']

package_data = \
{'': ['*'],
 'mentormatch': ['ui/*'],
 'mentormatch.api': ['app/*', 'initializer/*', 'pair/*']}

install_requires = \
['click', 'fuzzytable==0.*', 'toml', 'pandas']

extras_require = \
{'test': ['pytest', 'pytest-cov', 'tox']}

entry_points = \
{'console_scripts': ['mentormatch = mentormatch.ui.cli:cli_main']}

setup(name='mentormatch',
      version='1.0.2',
      description='Pair mentors with mentees.',
      author='Jonathan Chukinas',
      author_email='chukinas@gmail.com',
      url='https://github.com/jonathanchukinas/mentormatch',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.6.3',
     )
